/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies.assistant;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.HeadlessDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.View;

public class PreviewFigure
extends Figure {
    private boolean myValid;
    private IFigure myActualFigure;
    private double myScale;
    private int myHorizontalShift;
    private int myVerticalShift;

    public PreviewFigure(View view, HeadlessDiagramGraphicalViewer viewer) {
        this.myActualFigure = viewer.addChild(view);
        this.myValid = this.myActualFigure != null;
    }

    public boolean isPreviewValid() {
        return this.myValid;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void invalidateTree() {
        super.invalidateTree();
        this.myActualFigure.invalidateTree();
    }

    public void validate() {
        super.validate();
        this.myActualFigure.validate();
    }

    public void setPreferredSize(Dimension size) {
        Dimension figurePreferredSize = this.myActualFigure.getPreferredSize();
        if (figurePreferredSize.width == 0 || figurePreferredSize.height == 0) {
            figurePreferredSize = this.myActualFigure.getLayoutManager().getPreferredSize(this.myActualFigure, -1, -1);
        }
        if (figurePreferredSize.width == 0 && figurePreferredSize.height == 0) {
            figurePreferredSize.height = 15;
            figurePreferredSize.width = 15;
        } else if (figurePreferredSize.width == 0) {
            figurePreferredSize.width = figurePreferredSize.height;
        } else if (figurePreferredSize.height == 0) {
            figurePreferredSize.height = figurePreferredSize.width;
        }
        this.myActualFigure.setSize(figurePreferredSize);
        this.myActualFigure.setLocation(new Point(0, 0));
        this.myScale = Math.min((double)size.width / (double)figurePreferredSize.width, (double)size.height / (double)figurePreferredSize.height);
        this.myHorizontalShift = (int)(((double)size.width - (double)figurePreferredSize.width * this.myScale) / 2.0);
        this.myVerticalShift = (int)(((double)size.height - (double)figurePreferredSize.height * this.myScale) / 2.0);
        super.setPreferredSize(size);
    }

    public void translateFromParent(Translatable t) {
        super.translateFromParent(t);
        t.performScale(1.0 / this.myScale);
    }

    public void translateToParent(Translatable t) {
        t.performScale(this.myScale);
        super.translateFromParent(t);
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.pushState();
        boolean optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
        graphics.translate(this.getBounds().x + this.getInsets().left + this.myHorizontalShift, this.getBounds().y + this.getInsets().top + this.myVerticalShift);
        if (!optimizeClip) {
            graphics.clipRect(this.getClientArea(Rectangle.SINGLETON));
        }
        if (this.myScale == 1.0) {
            this.myActualFigure.paint(graphics);
        } else {
            ScaledGraphics g = new ScaledGraphics(graphics);
            g.scale(this.myScale);
            g.pushState();
            this.myActualFigure.paint((Graphics)g);
            g.dispose();
            graphics.restoreState();
        }
        graphics.popState();
    }
}

