/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.strategy;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Hierarchy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Strategy;

public class NameFilterStrategy
implements Strategy {
    private final Pattern[] myPatterns;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.wizards.strategy.NameFilterStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public NameFilterStrategy(String[] namePatterns) {
        if (!($assertionsDisabled || namePatterns != null && namePatterns.length > 1)) {
            throw new AssertionError();
        }
        this.myPatterns = new Pattern[namePatterns.length];
        try {
            int i = 0;
            while (i < namePatterns.length) {
                this.myPatterns[i] = Pattern.compile(namePatterns[i]);
                ++i;
            }
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public String getID() {
        return "nameFilter";
    }

    public void filter(Collection soFar, Hierarchy hierarchy) {
        Iterator it = soFar.iterator();
        while (it.hasNext()) {
            ENamedElement next = (ENamedElement)it.next();
            if (this.match(next.getName())) continue;
            it.remove();
        }
    }

    protected boolean match(String name) {
        if (name == null) {
            int i = 0;
            while (i < this.myPatterns.length) {
                if (this.myPatterns[i].matcher(name).matches()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

