/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.rt.AbstractCanvasTest;
import org.eclipse.gmf.tests.setup.GeneratedDiagramPlugin;
import org.eclipse.gmf.tests.setup.ViewerConfiguration;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractDiagramEditorTest
extends AbstractCanvasTest {
    private IProject myProject;
    private IEditorPart myEditor;
    private IFile myDiagramFile;
    private Boolean mySameModelAndDiagramFile = null;
    private final ViewerConfiguration.Factory myViewerConfigFactory;

    public AbstractDiagramEditorTest(String name, ViewerConfiguration.Factory viewerConfigFactory) {
        super(name);
        assert (viewerConfigFactory != null);
        this.myViewerConfigFactory = viewerConfigFactory;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myProject = this.createProject();
        this.mySameModelAndDiagramFile = null;
    }

    protected IProject getProject() {
        return this.myProject;
    }

    protected IEditorPart getEditor() {
        if (this.myEditor == null) {
            this.myEditor = this.openEditor(this.getDiagramFile());
            AbstractDiagramEditorTest.assertNotNull((Object)this.myEditor);
            AbstractDiagramEditorTest.assertFalse((String)"Fail fast if not diagram editor is associated with diagram file", (boolean)"org.eclipse.ui.DefaultTextEditor".equals(this.myEditor.getEditorSite().getId()));
        }
        return this.myEditor;
    }

    private IFile getDiagramFile() {
        if (this.myDiagramFile == null) {
            this.myDiagramFile = this.createDiagramFile();
        }
        return this.myDiagramFile;
    }

    protected ViewerConfiguration createViewerConfiguration() {
        IEditorPart editorPart = this.getEditor();
        GraphicalViewer viewer = (GraphicalViewer)editorPart.getAdapter(GraphicalViewer.class);
        return this.getViewerConfigurationFactory().createViewerConfiguration((EditPartViewer)viewer, this.getSetup());
    }

    protected final ViewerConfiguration.Factory getViewerConfigurationFactory() {
        return this.myViewerConfigFactory;
    }

    protected void tearDown() throws Exception {
        if (this.myEditor != null) {
            AbstractDiagramEditorTest.closeEditor(this.myEditor);
        }
        this.myProject = null;
        this.myDiagramFile = null;
        super.tearDown();
    }

    protected static void closeEditor(IEditorPart editor) {
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        Utils.assertDispatchDisplayMessages(3);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, true);
    }

    protected IProject createProject() {
        String projectName = this.getUniqueString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        AbstractDiagramEditorTest.assertFalse((String)("Project with this name already present in the workspace: " + projectName), (boolean)project.exists());
        try {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            AbstractDiagramEditorTest.fail((String)e.getMessage());
        }
        AbstractDiagramEditorTest.assertTrue((String)("Project was not created: " + projectName), (boolean)project.exists());
        return project;
    }

    protected void deleteProject() throws CoreException {
        if (this.myProject != null) {
            if (this.getProject().isOpen()) {
                this.getProject().close((IProgressMonitor)new NullProgressMonitor());
            }
            if (this.getProject().exists()) {
                this.getProject().delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected final void useSameFileForDiagramAndModel(boolean sameFile) {
        AbstractDiagramEditorTest.assertNull((String)"Can't use this method after diagram file has been created", (Object)this.myDiagramFile);
        this.mySameModelAndDiagramFile = sameFile;
    }

    private IFile createDiagramFile() {
        boolean sameFileForDiagramAndModel = this.mySameModelAndDiagramFile != null ? this.mySameModelAndDiagramFile.booleanValue() : this.getSetup().getGenDiagram().getEditorGen().isSameFileForDiagramAndModel();
        EObject domainElement = AbstractDiagramEditorTest.createDiagramDomainObject(this.getSetup());
        Diagram diagramView = this.createDiagramView(domainElement, this.getSetup());
        AbstractDiagramEditorTest.assertNotNull((String)"Diagram was not created", (Object)diagramView);
        AbstractDiagramEditorTest.assertSame((Object)domainElement, (Object)diagramView.getElement());
        return AbstractDiagramEditorTest.createDiagramFile(this.getProject(), this.getName(), this.getSetup().getGenDiagram(), domainElement, diagramView, sameFileForDiagramAndModel);
    }

    protected abstract Diagram createDiagramView(EObject var1, GeneratedDiagramPlugin var2);

    private static IFile createDiagramFile(IProject where, String fileNameStem, GenDiagram genDiagram, EObject domainElement, Diagram diagramView, boolean storeModelInDiagramFile) {
        Resource modelResource;
        String diagramFileName = String.valueOf(fileNameStem) + "." + genDiagram.getEditorGen().getDiagramFileExtension();
        IFile diagramFile = where.getFile(diagramFileName);
        AbstractDiagramEditorTest.assertFalse((String)"Diagram file was already created", (boolean)diagramFile.exists());
        IFile modelFile = null;
        if (!storeModelInDiagramFile) {
            IPath diagramFilePath = diagramFile.getProjectRelativePath();
            IPath modelFilePath = diagramFilePath.removeFileExtension().addFileExtension(genDiagram.getEditorGen().getDomainFileExtension());
            modelFile = where.getFile(modelFilePath);
            AbstractDiagramEditorTest.assertFalse((String)"Model file was already created", (boolean)modelFile.exists());
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource diagramResource = resourceSet.createResource(URI.createPlatformResourceURI((String)diagramFile.getFullPath().toOSString(), (boolean)true), "");
        Resource resource = modelResource = modelFile != null ? resourceSet.createResource(URI.createPlatformResourceURI((String)modelFile.getFullPath().toOSString(), (boolean)true), "") : null;
        if (modelResource != null) {
            modelResource.getContents().add((Object)domainElement);
        } else {
            diagramResource.getContents().add((Object)domainElement);
        }
        AbstractDiagramEditorTest.assertSame((String)"[sanity]", (Object)domainElement, (Object)diagramView.getElement());
        diagramResource.getContents().add((Object)diagramView);
        diagramView.setName(fileNameStem);
        try {
            if (modelResource != null) {
                modelResource.save(Collections.EMPTY_MAP);
            }
            diagramResource.save(Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            AbstractDiagramEditorTest.fail((String)e.toString());
        }
        return diagramFile;
    }

    protected static EObject createDiagramDomainObject(GeneratedDiagramPlugin genPlugin) {
        try {
            GenClass diagramElementGenClass = genPlugin.getGenDiagram().getDomainDiagramElement();
            GenPackage domainGenPackage = diagramElementGenClass.getGenPackage();
            Class<?> factoryInterface = genPlugin.loadGeneratedClass(domainGenPackage.getQualifiedFactoryInterfaceName());
            AbstractDiagramEditorTest.assertNotNull((String)"Factory interface not found", factoryInterface);
            Field accessor = null;
            accessor = factoryInterface.getField(domainGenPackage.getFactoryInstanceName());
            AbstractDiagramEditorTest.assertNotNull((String)"Accessor field not found", (Object)accessor);
            Object factory = null;
            factory = accessor.get(null);
            AbstractDiagramEditorTest.assertNotNull((String)"Factory unavailable", (Object)factory);
            Method createMethod = null;
            createMethod = factory.getClass().getMethod("create" + diagramElementGenClass.getName(), new Class[0]);
            AbstractDiagramEditorTest.assertNotNull((String)"Create method unavailable", (Object)createMethod);
            EObject domainDiagramElement = null;
            domainDiagramElement = (EObject)createMethod.invoke(factory, new Object[0]);
            AbstractDiagramEditorTest.assertNotNull((String)"Domain diagram element was not created", (Object)domainDiagramElement);
            return domainDiagramElement;
        }
        catch (Exception ex) {
            AbstractDiagramEditorTest.fail((String)ex.toString());
            return null;
        }
    }

    protected IEditorPart openEditor(IFile diagramFile) {
        try {
            IEditorDescriptor editorDesc = IDE.getEditorDescriptor((IFile)diagramFile, (boolean)true);
            IEditorPart result = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(diagramFile), editorDesc.getId(), true);
            return result;
        }
        catch (PartInitException e) {
            AbstractDiagramEditorTest.fail((String)e.getMessage());
            return null;
        }
    }

    protected final String getUniqueString() {
        return "AbstractDiagramEditorTest_" + String.valueOf(System.currentTimeMillis());
    }
}

