/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.util.CodegenEmitters;
import org.eclipse.gmf.codegen.util.Generator;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.setup.AbstractGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.osgi.framework.Bundle;

public class RuntimeBasedGeneratorConfiguration
extends AbstractGeneratorConfiguration {
    public GeneratorBase createGenerator(GenDiagram diagram) {
        GenEditorGenerator editorGen;
        return new Generator(editorGen, new CodegenEmitters(!(editorGen = diagram.getEditorGen()).isDynamicTemplates(), editorGen.getTemplateDirectory(), editorGen.getModelAccess() != null));
    }

    public GeneratorConfiguration.ViewerConfiguration createViewerConfiguration(EditPartViewer viewer, GenDiagram model, Bundle genPlugin) throws Exception {
        return new DefaultViewerConfiguration(viewer, model, genPlugin);
    }

    protected EditPartViewer createViewerInstance() {
        return new FakeViewer();
    }

    public Diagram createDiagram(EObject domainElement, SessionSetup sessionSetup) throws Exception {
        String pluginClassName = sessionSetup.getGenModel().getGenDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
        Class pluginClass = sessionSetup.getGenProject().getBundle().loadClass(pluginClassName);
        Field field = pluginClass.getField("DIAGRAM_PREFERENCES_HINT");
        PreferencesHint hint = (PreferencesHint)field.get(null);
        return ViewService.createDiagram((EObject)domainElement, (String)sessionSetup.getGenModel().getGenDiagram().getEditorGen().getModelID(), (PreferencesHint)hint);
    }

    protected static class DefaultViewerConfiguration
    extends AbstractGeneratorConfiguration.AbstractViewerConfiguration {
        public DefaultViewerConfiguration(EditPartViewer viewer, GenDiagram model, Bundle genPlugin) throws Exception {
            super(viewer, model, genPlugin);
        }

        public Command getSetBusinessElementStructuralFeatureCommand(View view, String featureName, Object value) {
            EObject instance = view.getElement();
            Assert.assertNotNull((String)"No business element bound to notation element", (Object)instance);
            EStructuralFeature feature = instance.eClass().getEStructuralFeature(featureName);
            if (feature == null) {
                throw new IllegalArgumentException("Not existing feature: " + featureName);
            }
            SetRequest setReq = new SetRequest(instance, feature, value);
            EditPart editPart = this.findEditPart(view);
            TransactionalEditingDomain txEditDomain = this.getEditDomain(editPart);
            CompositeTransactionalCommand modelCmd = new CompositeTransactionalCommand(txEditDomain, "Set feature");
            modelCmd.compose((IUndoableOperation)new SetValueCommand(setReq));
            return new ICommandProxy((ICommand)modelCmd);
        }

        public Command getSetNotationalElementStructuralFeature(View view, final EStructuralFeature feature, final Object value) {
            Assert.assertNotNull((String)"Null view", (Object)view);
            Assert.assertNotNull((String)"Null feature", (Object)feature);
            final EditPart editPart = this.findEditPart(view);
            Assert.assertNotNull((String)"Cannot find edit part", (Object)editPart);
            TransactionalEditingDomain ed = this.getEditDomain(editPart);
            Assert.assertNotNull((String)"No TransactionalEditingDomain found", (Object)ed);
            return new ICommandProxy((ICommand)new AbstractTransactionalCommand(ed, "ChangeColor", Collections.EMPTY_LIST){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    IGraphicalEditPart ep = (IGraphicalEditPart)editPart;
                    ep.setStructuralFeatureValue(feature, value);
                    return null;
                }
            });
        }

        protected TransactionalEditingDomain getEditDomain(EditPart editPart) {
            Assert.assertTrue((String)"IGraphicalEditPart expected", (boolean)(editPart instanceof IGraphicalEditPart));
            return ((IGraphicalEditPart)editPart).getEditingDomain();
        }

        public Command getCreateNodeCommand(View parentView, GenCommonBase nodeType) {
            IElementType metamodelType = this.getElementType(nodeType);
            CreateUnspecifiedTypeRequest req = new CreateUnspecifiedTypeRequest(Arrays.asList(metamodelType), this.getDefaultPreferencesHint());
            return this.findEditPart(parentView).getCommand((Request)req);
        }

        public Command getStartLinkCommand(View source, GenCommonBase linkType) {
            IElementType metamodelType = this.getElementType(linkType);
            CreateRelationshipRequest req = new CreateRelationshipRequest(source.getElement(), null, metamodelType);
            EditCommandRequestWrapper wrapper = new EditCommandRequestWrapper((IEditCommandRequest)req);
            return this.findEditPart(source).getCommand((Request)wrapper);
        }

        public Command getCreateLinkCommand(View source, View target, GenCommonBase linkType) {
            EditPart targetEditPart;
            IElementType metamodelType = this.getElementType(linkType);
            CreateRelationshipRequest relationShipReq = new CreateRelationshipRequest(metamodelType);
            CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor desc = new CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor(new CreateElementRequestAdapter((CreateElementRequest)relationShipReq), metamodelType instanceof IHintedType ? ((IHintedType)metamodelType).getSemanticHint() : "", this.getDefaultPreferencesHint());
            CreateConnectionViewAndElementRequest req = new CreateConnectionViewAndElementRequest(desc);
            req.setType((Object)"connection start");
            EditPart sourceEditPart = this.findEditPart(source);
            req.setSourceEditPart(sourceEditPart);
            Command sourceCmd = sourceEditPart.getCommand((Request)req);
            if (sourceCmd == null || !sourceCmd.canExecute()) {
                return null;
            }
            EditPart editPart = targetEditPart = target != null ? this.findEditPart(target) : null;
            if (targetEditPart != null) {
                req.setType((Object)"connection end");
                req.setTargetEditPart(targetEditPart);
                req.setLocation(new Point(0, 0));
                sourceEditPart.getCommand((Request)req);
                Command targetCmd = targetEditPart.getCommand((Request)req);
                return targetCmd;
            }
            return null;
        }

        public RGB getDefaultLinkColor() {
            return PreferenceConverter.getColor((IPreferenceStore)this.getDefaultPreferences(), (String)"Appearance.lineColor");
        }

        private IElementType getElementType(GenCommonBase genElement) {
            Class<?> clazz = null;
            try {
                clazz = this.loadGeneratedClass(this.getGenModel().getElementTypesQualifiedClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("ElementTypes class not loaded. " + e.getLocalizedMessage()));
            }
            String identifier = genElement.getUniqueIdentifier();
            try {
                Object type = clazz.getField(identifier).get(null);
                assert (type != null) : "Metatype field in the ElementTypes class should be initialized: " + identifier + " in " + this.getGenModel().getEditorGen().getPlugin().getID();
                assert (type instanceof IElementType) : String.valueOf(IElementType.class.getName()) + ": metamodel type class required";
                return (IElementType)type;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Assert.fail((String)("Metamodel type " + identifier + " is not registered"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Can't access metamodel type " + identifier));
            }
            return null;
        }
    }

    private static final class FakeViewer
    extends AbstractGeneratorConfiguration.AbstractFakeViewer
    implements IDiagramGraphicalViewer {
        private FakeViewer() {
        }

        public void setContents(Object contents) {
            GraphicalEditPart epart = (GraphicalEditPart)this.getEditPartFactory().createEditPart(null, contents);
            DiagramEventBroker.startListening((TransactionalEditingDomain)epart.getEditingDomain());
            super.setContents((EditPart)epart);
        }

        public IDiagramEditDomain getDiagramEditDomain() {
            return (IDiagramEditDomain)super.getEditDomain();
        }

        public List findEditPartsForElement(String elementIdStr, Class editPartClass) {
            return Collections.EMPTY_LIST;
        }

        public void registerEditPartForElement(String elementIdStr, EditPart ep) {
        }

        public void unregisterEditPartForElement(String elementIdStr, EditPart ep) {
        }
    }
}

