/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.render.internal.svg;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class RenderMultipleSVGTest
extends TestCase {
    private Bundle bundle;

    public RenderMultipleSVGTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RenderMultipleSVGTest.suite());
    }

    public static Test suite() {
        return new TestSuite(RenderMultipleSVGTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bundle = Platform.getBundle((String)"org.eclipse.gmf.tests.runtime.draw2d.ui.render");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRenderFromSVG() throws Exception {
        String rootDir = "resources/metafiles/";
        Enumeration enumFiles = this.bundle.getEntryPaths(rootDir);
        long startTime = System.currentTimeMillis();
        Vector<String> failures = new Vector<String>();
        while (enumFiles.hasMoreElements()) {
            String metafileName = (String)enumFiles.nextElement();
            Path filePath = new Path(metafileName);
            if (filePath == null || !metafileName.endsWith("svg") && !metafileName.endsWith("emf") && !metafileName.endsWith("wmf")) continue;
            try {
                URL url = FileLocator.find((Bundle)this.bundle, (IPath)filePath, null);
                RenderedImage directSWTRender = RenderedImageFactory.getInstance((URL)url);
                BufferedImage bufImg = (BufferedImage)directSWTRender.getAdapter(BufferedImage.class);
                Image swtImgOriginal = ImageConverter.convert((BufferedImage)bufImg);
                if (swtImgOriginal != null) continue;
                failures.add(metafileName);
            }
            catch (Exception e) {
                String errorMessage = "Caught exception while processing file " + metafileName + "\n" + e.toString();
                failures.add(errorMessage);
            }
        }
        enumFiles = this.bundle.getEntryPaths(rootDir);
        long awtTime = System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        while (enumFiles.hasMoreElements()) {
            String metafileName = (String)enumFiles.nextElement();
            Path filePath = new Path(metafileName);
            if (filePath == null || !metafileName.endsWith("svg") && !metafileName.endsWith("emf") && !metafileName.endsWith("wmf")) continue;
            try {
                URL url = FileLocator.find((Bundle)this.bundle, (IPath)filePath, null);
                RenderedImage directSWTRender = RenderedImageFactory.getInstance((URL)url);
                Image swtImgNew = directSWTRender.getSWTImage();
                if (swtImgNew != null) continue;
                failures.add(metafileName);
            }
            catch (Exception e) {
                String errorMessage = "Caught exception while processing file " + metafileName + "\n" + e.toString();
                failures.add(errorMessage);
            }
        }
        long swtTime = System.currentTimeMillis() - startTime;
        System.out.println("AWT rendering time was: " + awtTime);
        System.out.println("SWT rendering time was: " + swtTime);
        System.out.println("Percentage difference: " + (float)(swtTime - awtTime) / (float)awtTime * 100.0f + "%");
        RenderMultipleSVGTest.assertTrue((swtTime < awtTime ? 1 : 0) != 0);
        if (failures.size() > 0) {
            String failureString = "";
            int index = 0;
            while (index < failures.size()) {
                failureString = String.valueOf(failureString) + (String)failures.get(index);
                ++index;
            }
            Assert.assertEquals((String)("Found failures:\n" + failureString), (int)0, (int)failures.size());
        }
    }
}

