/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.labels;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.lite.edit.parts.labels.AbstractFeatureBasedLabelTextDisplayer;

public class MessageFormatLabelTextDisplayer
extends AbstractFeatureBasedLabelTextDisplayer {
    private final String myViewPattern;
    private final String myEditPattern;
    private final String myEditorPattern;
    private MessageFormat myViewProcessor;
    private MessageFormat myEditProcessor;
    private MessageFormat myEditorProcessor;

    public MessageFormatLabelTextDisplayer(String viewPattern, EStructuralFeature ... features) {
        this(viewPattern, (String)null, features);
    }

    public MessageFormatLabelTextDisplayer(String viewPattern, String editorPattern, EStructuralFeature ... features) {
        this(viewPattern, editorPattern, (String)null, features);
    }

    public MessageFormatLabelTextDisplayer(String viewPattern, String editorPattern, String editPattern, EStructuralFeature ... features) {
        super(features);
        this.myViewPattern = viewPattern;
        this.myEditPattern = editPattern;
        this.myEditorPattern = editorPattern;
    }

    protected final MessageFormat getViewPatternProcessor() {
        if (this.myViewProcessor == null) {
            this.myViewProcessor = this.createViewPatternProcessor(this.adjustPattern(this.myViewPattern));
        }
        return this.myViewProcessor;
    }

    protected MessageFormat createViewPatternProcessor(String viewPattern) {
        return new MessageFormat(viewPattern);
    }

    protected final MessageFormat getEditPatternProcessor() {
        if (this.myEditProcessor == null) {
            this.myEditProcessor = this.createEditPatternProcessor(this.adjustPattern(this.myEditPattern));
        }
        return this.myEditProcessor;
    }

    protected MessageFormat createEditPatternProcessor(String editPattern) {
        return new MessageFormat(editPattern);
    }

    protected final MessageFormat getEditorPatternProcessor() {
        if (this.myEditorProcessor == null) {
            this.myEditorProcessor = this.createEditorPatternProcessor(this.adjustPattern(this.myEditorPattern));
        }
        return this.myEditorProcessor;
    }

    protected MessageFormat createEditorPatternProcessor(String editorPattern) {
        return new MessageFormat(editorPattern);
    }

    protected String adjustPattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.getFeatures().length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(i);
                sb.append('}');
                ++i;
            }
            return sb.toString();
        }
        return pattern;
    }

    protected String buildDisplayText(Object[] featureValues) {
        return this.buildTextByPattern(featureValues, this.getViewPatternProcessor());
    }

    protected String buildEditText(Object[] featureValues) {
        return this.buildTextByPattern(featureValues, this.getEditorPatternProcessor());
    }

    protected Object[] parseEditedValues(String newValue) throws IllegalArgumentException {
        if (this.getEditPatternProcessor() == null) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        if (this.getFeatures().length == 1 && "".equals(newValue)) {
            return new Object[1];
        }
        return this.getEditPatternProcessor().parse(newValue, pos);
    }

    protected String buildTextByPattern(Object[] featureValues, MessageFormat format) {
        if (format == null) {
            return null;
        }
        return format.format(featureValues, new StringBuffer(), new FieldPosition(0)).toString();
    }
}

