/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.lite.commands.RemoveNotationalEdgeCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class RemoveNotationalElementCommand
extends AbstractCommand {
    private final View childView;
    private final View parentView;
    private EObject domainElement;
    private CompoundCommand removeEdgeCommands;

    public RemoveNotationalElementCommand(View parentView, View childView) {
        this.parentView = parentView;
        this.childView = childView;
    }

    protected boolean prepare() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getParent());
        if (domain != null && domain.isReadOnly(this.getParent().eResource())) {
            return false;
        }
        if (!this.parentView.getChildren().contains((Object)this.childView)) {
            return false;
        }
        this.removeEdgeCommands = new CompoundCommand();
        for (Edge next : this.childView.getSourceEdges()) {
            this.removeEdgeCommands.append((Command)new RemoveNotationalEdgeCommand((View)this.childView.getDiagram(), (View)next));
        }
        for (Edge next : this.childView.getTargetEdges()) {
            this.removeEdgeCommands.append((Command)new RemoveNotationalEdgeCommand((View)this.childView.getDiagram(), (View)next));
        }
        if (this.removeEdgeCommands.isEmpty()) {
            return true;
        }
        return this.removeEdgeCommands.canExecute();
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.parentView.removeChild(this.childView);
        if (!this.removeEdgeCommands.isEmpty()) {
            this.removeEdgeCommands.execute();
        }
        this.sweepElement();
    }

    protected void sweepElement() {
        if (this.childView.isSetElement()) {
            this.domainElement = this.childView.getElement();
            this.childView.setElement(null);
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.restoreElement();
        this.removeEdgeCommands.undo();
        this.parentView.insertChild(this.childView);
    }

    protected void restoreElement() {
        if (this.childView.isSetElement()) {
            this.childView.setElement(this.domainElement);
        }
    }

    protected final View getChildView() {
        return this.childView;
    }

    protected final View getParent() {
        return this.parentView;
    }
}

