/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;
import org.eclipse.gmf.internal.xpand.util.TypeNameUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.ocl.expressions.CollectionKind;

public class CompositeResourcesTest
extends TestCase {
    private ExecutionContext myContext;
    private StringBuilder myBuffer;
    private TestResourceManager myResourceManager;
    private EClassifier oclStringType;

    protected void setUp() throws Exception {
        super.setUp();
        this.myBuffer = new StringBuilder();
        this.myResourceManager = new TestResourceManager();
        this.myContext = new ExecutionContextImpl(new Scope((ResourceManager)this.myResourceManager, null, (Output)new BufferOutput(this.myBuffer)));
        this.oclStringType = (EClassifier)this.myContext.getOCLEnvironment().getOCLStandardLibrary().getString();
        this.myContext = this.myContext.cloneWithVariable(new Variable[]{new Variable("this", this.oclStringType, (Object)"")});
    }

    public void testRedefineInAspect() throws AmbiguousDefinitionException {
        this.myResourceManager.setPrefixes(new String[]{null});
        XpandDefinition definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::testRedefineInAspect"), this.oclStringType, new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"testRedefineOriginal", (String)this.myBuffer.toString());
        this.myBuffer.delete(0, this.myBuffer.length());
        this.myResourceManager.setPrefixes("override2", null);
        definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::testRedefineInAspect"), this.oclStringType, new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"testRedefineRedefined", (String)this.myBuffer.toString());
    }

    public void testOverrideXpand() throws AmbiguousDefinitionException {
        this.myResourceManager.setPrefixes(new String[]{null});
        XpandDefinition definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test2"), this.oclStringType, new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"<test4>", (String)this.myBuffer.toString());
        this.myBuffer.delete(0, this.myBuffer.length());
        this.myResourceManager.setPrefixes("override3", null);
        definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test2"), this.oclStringType, new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"<test3>", (String)this.myBuffer.toString());
    }

    public void testOverrideXpandWithComplexTypeParameter() throws AmbiguousDefinitionException {
        this.myResourceManager.setPrefixes(new String[]{null});
        EClassifier stringType = (EClassifier)this.myContext.getOCLEnvironment().getOCLStandardLibrary().getString();
        EClassifier[] parameterTypes = new EClassifier[]{(EClassifier)this.myContext.getOCLEnvironment().getTypeResolver().resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)stringType)};
        ExecutionContext executionContext = this.myContext.cloneWithVariable(new Variable[]{new Variable("p", stringType, (Object)"")});
        XpandDefinition definition = executionContext.findDefinition(CompositeResourcesTest.qualify("Overridable::testRedefineWithParameters"), this.oclStringType, parameterTypes);
        definition.evaluate(executionContext);
        CompositeResourcesTest.assertEquals((String)"testRedefineOriginal", (String)this.myBuffer.toString());
        this.myBuffer.delete(0, this.myBuffer.length());
        this.myResourceManager.setPrefixes("override3", null);
        definition = executionContext.findDefinition(CompositeResourcesTest.qualify("Overridable::testRedefineWithParameters"), this.oclStringType, parameterTypes);
        definition.evaluate(executionContext);
        CompositeResourcesTest.assertEquals((String)"testRedefineRedefined", (String)this.myBuffer.toString());
    }

    private static String qualify(String unqualified) {
        return "org::eclipse::gmf::tests::xpand::evaluate::" + unqualified;
    }

    private static class TestResourceManager
    extends ResourceManagerImpl {
        private String[] mySuffixes;

        private TestResourceManager() {
        }

        public void setPrefixes(String ... prefixes) {
            this.mySuffixes = prefixes;
            this.forgetAll();
        }

        protected boolean shouldCache() {
            return true;
        }

        protected String getAspectsTemplateName(String fullyQualifiedName) {
            return String.valueOf(fullyQualifiedName) + "_Aspects";
        }

        protected Reader[] resolveMultiple(String fullyQualifiedName, String extension) throws IOException {
            ArrayList<Reader> result = new ArrayList<Reader>(this.mySuffixes.length);
            int i = 0;
            while (i < this.mySuffixes.length) {
                Reader reader;
                String templateName = String.valueOf(TypeNameUtil.getLastSegment((String)fullyQualifiedName)) + "." + extension;
                String path = TypeNameUtil.withoutLastSegment((String)fullyQualifiedName).replaceAll("::", "/");
                if (this.mySuffixes[i] != null && this.mySuffixes[i].length() > 0) {
                    path = String.valueOf(path) + "/" + this.mySuffixes[i];
                }
                if ((reader = this.getReader(path = String.valueOf(path) + "/" + templateName)) != null) {
                    result.add(reader);
                }
                ++i;
            }
            if (result.isEmpty()) {
                throw new FileNotFoundException();
            }
            return result.toArray(new Reader[result.size()]);
        }

        protected Reader getReader(String path) {
            InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            if (resourceAsStream == null) {
                return null;
            }
            return new InputStreamReader(resourceAsStream, Charset.forName("ISO-8859-1"));
        }

        protected void handleParserException(ParserException ex) {
            CompositeResourcesTest.fail((String)ex.getClass().getName());
        }

        protected String resolveCFileFullPath(String fullyQualifiedName, String fileExtension) {
            return String.valueOf(fullyQualifiedName) + "." + fileExtension;
        }

        protected UnitResolver getQVTUnitResolver() {
            return new UnitResolver(){

                public UnitProxy resolveUnit(String qualifiedName) {
                    return null;
                }
            };
        }
    }
}

