/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update.canonical;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.commands.ReconnectNotationalEdgeSourceCommand;
import org.eclipse.gmf.runtime.lite.commands.ReconnectNotationalEdgeTargetCommand;
import org.eclipse.gmf.runtime.lite.commands.RemoveNotationalEdgeCommand;
import org.eclipse.gmf.runtime.lite.commands.ReplaceNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.AbstractNotationModelRefresher;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.IViewService;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.LinkDescriptor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public abstract class OwnedLinksNotationModelRefresher
extends AbstractNotationModelRefresher {
    private final IViewService myViewService;

    public OwnedLinksNotationModelRefresher(IViewService viewService) {
        this.myViewService = viewService;
    }

    public Command buildRefreshNotationModelCommand() {
        List semanticChildLinks = this.getSemanticChildLinks();
        List notationalChildLinks = this.getNotationalChildLinks();
        if (semanticChildLinks.isEmpty() && notationalChildLinks.isEmpty()) {
            return null;
        }
        HashMap<EObject, Edge> semanticToNotationalTypeBasedLinks = new HashMap<EObject, Edge>();
        HashMap<EObject, LinkedList<Edge>> semanticToNotationalFeatureBasedLinks = new HashMap<EObject, LinkedList<Edge>>();
        for (Edge next : notationalChildLinks) {
            EObject nextSemantic = next.getElement();
            if (nextSemantic != null) {
                semanticToNotationalTypeBasedLinks.put(nextSemantic, next);
                continue;
            }
            LinkedList<Edge> featureBasedLinksForSource = (LinkedList<Edge>)semanticToNotationalFeatureBasedLinks.get(next.getSource().getElement());
            if (featureBasedLinksForSource == null) {
                featureBasedLinksForSource = new LinkedList<Edge>();
                semanticToNotationalFeatureBasedLinks.put(next.getSource().getElement(), featureBasedLinksForSource);
            }
            featureBasedLinksForSource.add(next);
        }
        Diagram parentView = this.getHost().getDiagram();
        CompoundCommand command = new CompoundCommand();
        for (LinkDescriptor next : semanticChildLinks) {
            boolean changedVID;
            List featureBasedLinksForSource;
            EObject nextLinkElement = next.getElement();
            Object currentEdge = nextLinkElement != null ? (Edge)semanticToNotationalTypeBasedLinks.remove(nextLinkElement) : ((featureBasedLinksForSource = (List)semanticToNotationalFeatureBasedLinks.get(next.getSource())) == null || featureBasedLinksForSource.isEmpty() ? null : (Edge)featureBasedLinksForSource.remove(0));
            int linkVisualID = next.getVisualID();
            if (currentEdge == null) {
                if (nextLinkElement != null && !this.shouldCreateView(next)) continue;
                command.appendIfCanExecute((Command)this.getCreateNotationalElementCommand(next));
                continue;
            }
            boolean changedSource = currentEdge.getSource().getElement() != next.getSource();
            boolean changedTarget = currentEdge.getTarget().getElement() != next.getDestination();
            boolean bl = changedVID = linkVisualID != this.getVisualID((View)currentEdge);
            if (!changedSource && !changedTarget) {
                if (!changedVID) continue;
                CreateNotationalElementCommand notationalCommand = this.getCreateNotationalElementCommand(next);
                if (notationalCommand != null) {
                    command.appendIfCanExecute((Command)new ReplaceNotationalElementCommand((View)parentView, notationalCommand, (View)currentEdge));
                    continue;
                }
                command.appendIfCanExecute((Command)new RemoveNotationalEdgeCommand((View)parentView, (View)currentEdge));
                continue;
            }
            if (changedVID) {
                command.appendIfCanExecute((Command)new RemoveNotationalEdgeCommand((View)parentView, (View)currentEdge));
                command.appendIfCanExecute((Command)this.getCreateNotationalElementCommand(next));
                continue;
            }
            View newSourceView = this.myViewService.findView(next.getSource());
            if (changedSource) {
                if (newSourceView != null && this.isValidLinkSource(newSourceView, next)) {
                    command.appendIfCanExecute((Command)new ReconnectNotationalEdgeSourceCommand((Edge)currentEdge, newSourceView));
                } else {
                    command.appendIfCanExecute((Command)new RemoveNotationalEdgeCommand((View)currentEdge.getDiagram(), (View)currentEdge));
                }
            }
            View newTargetView = this.myViewService.findView(next.getDestination());
            if (!changedTarget) continue;
            if (newTargetView != null && this.isValidLinkTarget(newTargetView, next)) {
                command.appendIfCanExecute((Command)new ReconnectNotationalEdgeTargetCommand((Edge)currentEdge, newTargetView));
                continue;
            }
            command.appendIfCanExecute((Command)new RemoveNotationalEdgeCommand((View)currentEdge.getDiagram(), (View)currentEdge));
        }
        for (View obsoleteView : semanticToNotationalTypeBasedLinks.values()) {
            command.appendIfCanExecute((Command)new RemoveNotationalEdgeCommand((View)parentView, obsoleteView));
        }
        for (List obsoleteViews : semanticToNotationalFeatureBasedLinks.values()) {
            for (View obsoleteView : obsoleteViews) {
                command.appendIfCanExecute((Command)new RemoveNotationalEdgeCommand((View)parentView, obsoleteView));
            }
        }
        return command.getCommandList().isEmpty() ? null : command;
    }

    protected abstract List getSemanticChildLinks();

    protected abstract List getNotationalChildLinks();

    protected boolean isValidLinkSource(View sourceCandidate, LinkDescriptor linkDescriptor) {
        return true;
    }

    protected boolean isValidLinkTarget(View targetCandidate, LinkDescriptor linkDescriptor) {
        return true;
    }
}

