/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.ClipboardManager;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.common.ui.util.CustomDataTransfer;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.dnd.Transfer;

public abstract class ClipboardCommand
extends AbstractTransactionalCommand {
    public static final String DRAWING_SURFACE = "Drawing Surface";
    private final View viewContext;

    public ClipboardCommand(TransactionalEditingDomain editingDomain, View viewContext) {
        this(editingDomain, null, viewContext);
    }

    public ClipboardCommand(TransactionalEditingDomain editingDomain, String label, View viewContext) {
        super(editingDomain, label, ClipboardCommand.getWorkspaceFiles((EObject)viewContext));
        Assert.isNotNull((Object)viewContext);
        this.viewContext = viewContext;
    }

    protected void copyToClipboard(List source) {
        if (source == null || source.size() == 0) {
            return;
        }
        CustomData data = new CustomData(DRAWING_SURFACE, ClipboardCommand.copyViewsToString(source).getBytes());
        if (data != null) {
            ClipboardManager.getInstance().addToCache((Object)new ICustomData[]{data}, (Transfer)CustomDataTransfer.getInstance());
        }
    }

    protected View getViewContext() {
        return this.viewContext;
    }

    public static String copyViewsToString(List views) {
        Assert.isNotNull((Object)views);
        Assert.isTrue((views.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> selection = new ArrayList<Object>();
        for (View viewElement : views) {
            if (viewElement == null) continue;
            selection.add(viewElement);
        }
        HashSet allInnerEdges = new HashSet();
        Iterator itr = views.iterator();
        while (itr.hasNext()) {
            ViewUtil.getAllRelatedEdgesFromViews((List)((View)itr.next()).getChildren(), allInnerEdges);
        }
        selection.addAll(allInnerEdges);
        View firstView = (View)views.get(0);
        Diagram dgrm = firstView.getDiagram();
        EAnnotation measureUnitAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        measureUnitAnnotation.setSource(dgrm.getMeasurementUnit().getName());
        selection.add(measureUnitAnnotation);
        return ClipboardUtil.copyElementsToString(selection, new HashMap(), (IProgressMonitor)new NullProgressMonitor());
    }
}

