/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.strategy;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Hierarchy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Strategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFilterStrategy
implements Strategy<ENamedElement> {
    private final Pattern[] myPatterns;

    public NameFilterStrategy(String[] namePatterns) {
        assert (namePatterns != null && namePatterns.length > 1);
        this.myPatterns = new Pattern[namePatterns.length];
        try {
            int i = 0;
            while (i < namePatterns.length) {
                this.myPatterns[i] = Pattern.compile(namePatterns[i]);
                ++i;
            }
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    @Override
    public String getID() {
        return "nameFilter";
    }

    @Override
    public void filter(Collection<ENamedElement> soFar, Hierarchy hierarchy) {
        Iterator<ENamedElement> it = soFar.iterator();
        while (it.hasNext()) {
            if (this.match(it.next().getName())) continue;
            it.remove();
        }
    }

    protected boolean match(String name) {
        if (name == null) {
            int i = 0;
            while (i < this.myPatterns.length) {
                if (this.myPatterns[i].matcher(name).matches()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

