/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.services.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;

public abstract class CreateViewOperation
implements IOperation {
    private final IAdaptable semanticAdapter;
    private final String semanticHint;
    private final PreferencesHint preferencesHint;
    private String cachingKey;
    private static final String dummyHiny = "dummy";

    protected CreateViewOperation(IAdaptable semanticAdapter, String semanticHint, PreferencesHint preferencesHint) {
        this.semanticAdapter = semanticAdapter;
        this.semanticHint = semanticHint;
        this.preferencesHint = preferencesHint;
    }

    public final IAdaptable getSemanticAdapter() {
        return this.semanticAdapter;
    }

    public abstract Class getViewKind();

    static final View extractContainerView(View view) {
        EObject container = view.eContainer();
        if (container instanceof View) {
            return (View)container;
        }
        return null;
    }

    static final String extractSemanticHint(View view) {
        return view.getType();
    }

    static final IAdaptable extractSemanticAdapter(View view) {
        EObject element = view.getElement();
        if (element != null) {
            return new EObjectAdapter(element);
        }
        return null;
    }

    public final String getSemanticHint() {
        return this.semanticHint;
    }

    public final PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    public String getCachingKey() {
        if (this.cachingKey == null) {
            this.cachingKey = this.determineCachingKey();
        }
        return this.cachingKey;
    }

    private String determineCachingKey() {
        String type = this.getSemanticHint();
        if (type != null && type.length() > 0) {
            return type;
        }
        String classId = this.getSemanticEClassId();
        if (classId != null) {
            return classId;
        }
        return dummyHiny;
    }

    private String getSemanticEClassId() {
        if (this.semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)this.semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return PackageUtil.getID((ENamedElement)EMFCoreUtil.getProxyClass((EObject)eObject));
        }
        IElementType type = (IElementType)this.semanticAdapter.getAdapter(IElementType.class);
        if (type != null) {
            PackageUtil.getID((ENamedElement)type.getEClass());
        }
        return null;
    }
}

