/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelTransformer;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.tr.AbstractMappingTransformerTest;

public class RunTimeModelTransformerTest
extends AbstractMappingTransformerTest {
    public RunTimeModelTransformerTest(String name) {
        super(name);
    }

    protected DiaDefSetup createDiaDefSetup() {
        return new DiaDefSetup(){

            protected void setupNodeDef(org.eclipse.gmf.gmfgraph.Node nodeDef) {
                super.setupNodeDef(nodeDef);
            }
        };
    }

    public void testRunTimeModelTransform() {
        DiagramRunTimeModelTransformer drtModelTransformer = new DiagramRunTimeModelTransformer("pack11", "uri://eclipse/gmf/tests");
        RunTimeModelTransformerTest.assertNotNull((String)"Mapping is initialized", (Object)this.getMapping());
        drtModelTransformer.transform(this.getMapping());
        EPackage drtModel = drtModelTransformer.getResult();
        EClass c = RunTimeModelTransformerTest.findEClass(drtModel, this.getCanvasDef().getName());
        RunTimeModelTransformerTest.assertNotNull((String)"There's no rt model class for canvas definition", (Object)c);
        RunTimeModelTransformerTest.assertTrue((String)"rt model class for canvas definition should extend appropiate class from basic RT model", (boolean)RunTimeModelTransformerTest.checkSuperclass(c, NotationPackage.eINSTANCE.getDiagram()));
        c = RunTimeModelTransformerTest.findEClass(drtModel, this.getNodeDef().getName());
        RunTimeModelTransformerTest.assertNotNull((String)"There's no rt model class for node definition", (Object)c);
        RunTimeModelTransformerTest.assertTrue((String)"rt model class for node definition should extend appropiate class from basic RT model", (boolean)RunTimeModelTransformerTest.checkSuperclass(c, NotationPackage.eINSTANCE.getNode()));
        this.doTestRunTimeModelPropertiesTransform(c);
        c = RunTimeModelTransformerTest.findEClass(drtModel, this.getLinkDef().getName());
        RunTimeModelTransformerTest.assertNotNull((String)"There's no rt model class for link definition", (Object)c);
        RunTimeModelTransformerTest.assertTrue((String)"rt model class for link definition should extend appropiate class from basic RT model", (boolean)RunTimeModelTransformerTest.checkSuperclass(c, NotationPackage.eINSTANCE.getEdge()));
    }

    private void doTestRunTimeModelPropertiesTransform(EClass nodeRTClass) {
        EStructuralFeature sf = nodeRTClass.getEStructuralFeature("prop1");
        RunTimeModelTransformerTest.assertNotNull((String)"There should be 'prop1' structural feature in generated diagramNode EClass", (Object)sf);
        RunTimeModelTransformerTest.assertTrue((String)"StructuralFeature 'prop1' should be attribute", (boolean)(sf instanceof EAttribute));
        Node rtInstance = (Node)nodeRTClass.getEPackage().getEFactoryInstance().create(nodeRTClass);
        rtInstance.eSet(sf, (Object)"abc");
        RunTimeModelTransformerTest.assertEquals((String)"Not possible to access rtProperty in EMF way", (Object)rtInstance.eGet(sf), (Object)"abc");
        RunTimeModelTransformerTest.fail((String)"Fix runtime properties in new runtime/notation model");
    }

    private static EClass findEClass(EPackage model, String name) {
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof EClassifier)) continue;
            if (name.equals(((EClassifier)next).getName()) && next instanceof EClass) {
                return (EClass)next;
            }
            it.prune();
        }
        return null;
    }

    private static boolean checkSuperclass(EClass eClass, EClass eSuperClass) {
        return eSuperClass.isSuperTypeOf(eClass) || EcoreUtil.equals((EObject)eClass, (EObject)eSuperClass);
    }
}

