/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapDefWithReuseSetup;
import org.eclipse.gmf.tests.tr.AbstractMappingTransformerTest;

public class GenModelTransformerSimpleTest
extends AbstractMappingTransformerTest {
    private GenEditorGenerator transformationResult;

    public GenModelTransformerSimpleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DiagramGenModelTransformer t = new DiagramGenModelTransformer((DiagramRunTimeModelHelper)new BasicDiagramRunTimeModelHelper(), (GenModelNamingMediator)new GenModelNamingMediator.Empty());
        t.setEMFGenModel(Utils.createGenModel(this.getCanvasMapping().getDomainModel(), Utils.createUniquePluginID()));
        t.transform(this.getMapping());
        this.transformationResult = t.getResult();
        GenModelTransformerSimpleTest.assertNotNull((Object)this.transformationResult);
    }

    protected MapDefSource initMapModel(DiaDefSource graphDef) {
        return new MapDefWithReuseSetup().init(graphDef);
    }

    public void testNoReuseForTopLevelReference() {
        GenNode nodeA = this.getGenNodeA();
        GenChildNode childA = (GenChildNode)nodeA.getChildNodes().get(0);
        GenModelTransformerSimpleTest.assertEquals((Object)nodeA.getDomainMetaClass(), (Object)childA.getDomainMetaClass());
        GenModelTransformerSimpleTest.assertEquals((Object)nodeA.getDiagramRunTimeClass(), (Object)childA.getDiagramRunTimeClass());
        GenModelTransformerSimpleTest.assertTrue((boolean)childA.getChildNodes().contains((Object)childA));
    }

    public void testReuseForChildReference() {
        GenNode nodeB = this.getGenNodeB();
        GenChildNode bFirstLevelChild = (GenChildNode)nodeB.getChildNodes().get(0);
        GenChildNode bSecondLevelChild = (GenChildNode)bFirstLevelChild.getChildNodes().get(0);
        GenModelTransformerSimpleTest.assertFalse((String)"B2 can't be the same as Btop", (bFirstLevelChild == nodeB ? 1 : 0) != 0);
        GenModelTransformerSimpleTest.assertTrue((String)"Actually, B2 should be the same as B1", (bFirstLevelChild == bSecondLevelChild ? 1 : 0) != 0);
        GenModelTransformerSimpleTest.assertTrue((String)"B1 is child of B2 (and, of course, itself)", (boolean)bSecondLevelChild.getChildNodes().contains((Object)bFirstLevelChild));
    }

    public void testNoChildReferenceReuseWithDistinctContainments() {
        GenNode nodeB = this.getGenNodeB();
        GenChildNode cFirstLevelChild = (GenChildNode)nodeB.getChildNodes().get(1);
        GenChildNode cSecondLevelChild = (GenChildNode)cFirstLevelChild.getChildNodes().get(0);
        GenModelTransformerSimpleTest.assertFalse((String)"C2 should not reuse C1 because of different containment", (boolean)cSecondLevelChild.getChildNodes().contains((Object)cFirstLevelChild));
        GenModelTransformerSimpleTest.assertTrue((String)"C2 IS a child of itself", (boolean)cSecondLevelChild.getChildNodes().contains((Object)cSecondLevelChild));
    }

    public void testNoChildReferenceReuseWithDistinctChildrenFeature() {
        GenNode nodeB = this.getGenNodeB();
        GenChildNode c1FirstLevelChild = (GenChildNode)nodeB.getChildNodes().get(1);
        GenModelTransformerSimpleTest.assertSame((Object)c1FirstLevelChild.getModelFacet().getContainmentMetaFeature(), (Object)c1FirstLevelChild.getModelFacet().getChildMetaFeature());
        GenChildNode c2FirstLevelChild = (GenChildNode)nodeB.getChildNodes().get(2);
        GenModelTransformerSimpleTest.assertNotSame((Object)c2FirstLevelChild.getModelFacet().getContainmentMetaFeature(), (Object)c2FirstLevelChild.getModelFacet().getChildMetaFeature());
        GenModelTransformerSimpleTest.assertSame((Object)c1FirstLevelChild.getModelFacet().getContainmentMetaFeature(), (Object)c2FirstLevelChild.getModelFacet().getContainmentMetaFeature());
        GenModelTransformerSimpleTest.assertFalse((String)"Just [in]sanity check", (c1FirstLevelChild == c2FirstLevelChild ? 1 : 0) != 0);
        GenChildNode c2SecondLevelChild = (GenChildNode)c2FirstLevelChild.getChildNodes().get(0);
        GenModelTransformerSimpleTest.assertFalse((String)"Although we referenced c1 mapping, childrenFeature was different, hence distinct child", (boolean)c2FirstLevelChild.getChildNodes().contains((Object)c1FirstLevelChild));
        GenModelTransformerSimpleTest.assertTrue((String)"... with its own cycle to itself", (boolean)c2SecondLevelChild.getChildNodes().contains((Object)c2SecondLevelChild));
    }

    private GenNode getGenNodeA() {
        GenNode rv = this.findTopNode(this.getNodeDomainElement(0));
        GenModelTransformerSimpleTest.assertNotNull((Object)rv);
        return rv;
    }

    private GenNode getGenNodeB() {
        GenNode rv = this.findTopNode(this.getNodeDomainElement(1));
        GenModelTransformerSimpleTest.assertNotNull((Object)rv);
        return rv;
    }

    private EClass getNodeDomainElement(int idx) {
        return ((TopNodeReference)this.getMapping().getNodes().get(idx)).getOwnedChild().getDomainMetaElement();
    }

    private GenNode findTopNode(EClass eClass) {
        Iterator it = this.transformationResult.getDiagram().getTopLevelNodes().iterator();
        while (it.hasNext()) {
            GenTopLevelNode next = (GenTopLevelNode)it.next();
            if (next.getDomainMetaClass().getEcoreClass() != eClass) continue;
            return next;
        }
        return null;
    }
}

