/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.AuditedMetricTarget;
import org.eclipse.gmf.mappings.DiagramElementTarget;
import org.eclipse.gmf.mappings.DomainAttributeTarget;
import org.eclipse.gmf.mappings.DomainElementTarget;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NotationElementTarget;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;
import org.eclipse.gmf.tests.setup.MapDefSource;

public class AuditRulesTest
extends RuntimeDiagramTestBase {
    private AuditContainer audits;
    private AuditAssert auditAssert;
    private EList targetedPackages;

    public AuditRulesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        MapDefSource mapSource = this.getSetup().getMapModel();
        AuditRulesTest.assertNotNull((String)"Requires MapDefSource in setup", (Object)mapSource);
        Mapping mapping = mapSource.getMapping();
        this.audits = mapping.getAudits();
        AuditRulesTest.assertNotNull((String)"Requires mapping with audit rules", (Object)this.audits);
        GenDiagram genDiagram = this.getSetup().getGenModel().getGenDiagram();
        this.targetedPackages = genDiagram.getEditorGen().getAudits().getAllTargetedModelPackages();
        this.auditAssert = new AuditAssert(genDiagram.getEditorGen().getPlugin().getID());
    }

    public void testNestedPackageAuditTarget() throws Exception {
        GenModel domainGenModel = this.getSetup().getGenModel().getGenDiagram().getDomainDiagramElement().getGenPackage().getGenModel();
        GenClass genClass = null;
        String qualifiedClassName = null;
        Iterator it = domainGenModel.getAllGenPackagesWithClassifiers().iterator();
        while (it.hasNext()) {
            GenPackage nextPackage = (GenPackage)it.next();
            if (nextPackage.getSuperGenPackage() == null) continue;
            AuditRulesTest.assertFalse((boolean)nextPackage.getGenClasses().isEmpty());
            genClass = (GenClass)nextPackage.getGenClasses().get(0);
            qualifiedClassName = String.valueOf(nextPackage.getSuperGenPackage().getPackageName()) + "." + nextPackage.getPackageName() + "." + genClass.getName();
        }
        AuditRulesTest.assertNotNull((String)"Test requires EClass in a nested package", genClass);
        GenDomainElementTarget domainElementTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
        domainElementTarget.setElement(genClass);
        AuditRulesTest.assertEquals(qualifiedClassName, (String)domainElementTarget.getTargetClassModelQualifiedName());
    }

    public void testAuditConstraints() throws Exception {
        this.auditAssert.assertAuditContainer(this.audits);
        AuditRulesTest.assertTrue((String)"Tests requires at least one audit with LIVE constraint", (boolean)this.auditAssert.liveConstraintTested);
    }

    EClass findCanonicalEClass(EClass eClass) {
        String nsURI = eClass.getEPackage().getNsURI();
        GenPackage genPackage = null;
        Iterator it = this.targetedPackages.iterator();
        while (it.hasNext()) {
            GenPackage nextPackage = (GenPackage)it.next();
            if (!nsURI.equals(nextPackage.getNSURI())) continue;
            genPackage = nextPackage;
            break;
        }
        AuditRulesTest.assertNotNull((String)"GenPackage for EClass target not found", genPackage);
        try {
            Class packageInterfaceClass = this.getSetup().getGenProject().getBundle().loadClass(genPackage.getQualifiedPackageInterfaceName());
            Field instanceField = packageInterfaceClass.getField("eINSTANCE");
            Object packageInstance = instanceField.get(packageInterfaceClass);
            AuditRulesTest.assertTrue((String)"Expected EPackage instance", (boolean)(packageInstance instanceof EPackage));
            EPackage ePackage = (EPackage)packageInstance;
            EClassifier eClassifier = ePackage.getEClassifier(eClass.getName());
            AuditRulesTest.assertTrue((String)"EClassifier must be eclass", (boolean)(eClassifier instanceof EClass));
            return (EClass)eClassifier;
        }
        catch (Exception e) {
            e.printStackTrace();
            AuditRulesTest.fail((String)"Failed to access EPackage from the generated model");
            return null;
        }
    }

    static EClass getTargetEClass(AuditRule rule) {
        AuditRulesTest.assertNotNull((String)"Audit target must be set", (Object)rule.getTarget());
        return AuditRulesTest.getTargetEClass((EObject)rule.getTarget());
    }

    static EClass getTargetEClass(EObject target) {
        if (target instanceof DomainElementTarget) {
            return ((DomainElementTarget)target).getElement();
        }
        if (target instanceof NotationElementTarget) {
            return ((NotationElementTarget)target).getElement();
        }
        if (target instanceof DiagramElementTarget) {
            DiagramElementTarget diagramElementTarget = (DiagramElementTarget)target;
            MappingEntry entry = diagramElementTarget.getElement();
            if (entry instanceof NodeMapping) {
                return NotationPackage.eINSTANCE.getNode();
            }
            if (entry instanceof LinkMapping) {
                return NotationPackage.eINSTANCE.getEdge();
            }
        } else {
            if (target instanceof DomainAttributeTarget) {
                DomainAttributeTarget attrTarget = (DomainAttributeTarget)target;
                return attrTarget.getAttribute().getEContainingClass();
            }
            if (target instanceof AuditedMetricTarget) {
                return AuditRulesTest.getTargetEClass((EObject)((AuditedMetricTarget)target).getMetric().getTarget());
            }
        }
        AuditRulesTest.fail((String)"No target class");
        return null;
    }

    private class AuditAssert {
        private String pluginId;
        private boolean liveConstraintTested = false;
        static /* synthetic */ Class class$0;

        AuditAssert(String pluginIdentifier) {
            this.pluginId = pluginIdentifier;
        }

        String constraintGlobalId(AuditRule audit) {
            return String.valueOf(this.pluginId) + "." + audit.getId();
        }

        void assertAudit(AuditRule audit) {
            EClass target = AuditRulesTest.this.findCanonicalEClass(AuditRulesTest.getTargetEClass(audit));
            Object validatedInstance = null;
            validatedInstance = NotationPackage.eINSTANCE.getView().isSuperTypeOf(target) ? AuditRulesTest.this.createNode((GenCommonBase)AuditRulesTest.this.getSetup().getGenModel().getNodeB(), (View)AuditRulesTest.this.getDiagram()) : target.getEPackage().getEFactoryInstance().create(target);
            this.assertEvaluation(audit, (EObject)validatedInstance);
            IConstraintDescriptor descriptor = ConstraintRegistry.getInstance().getDescriptor(this.pluginId, audit.getId());
            AuditRulesTest.assertNotNull((String)"Audit rule must be in ConstraintRegistry", (Object)descriptor);
            AuditRulesTest.assertTrue((String)"The target class must be accepted", (boolean)descriptor.targetsTypeOf(validatedInstance));
            if (!descriptor.isEnabled()) {
                System.err.println("descriptor is dispabled");
                System.err.println("descriptor.isError:" + descriptor.isError());
                if (descriptor.isError()) {
                    descriptor.getException().printStackTrace(System.err);
                }
            }
            AuditRulesTest.assertTrue((String)"Descriptor shoud be valid and enabled", (boolean)descriptor.isEnabled());
            AuditRulesTest.assertEquals((String)"Constraint id must match", (String)this.constraintGlobalId(audit), (String)descriptor.getId());
            AuditRulesTest.assertEquals((String)"Constraint Name must match", (String)audit.getName(), (String)descriptor.getName());
            AuditRulesTest.assertEquals((String)"Severity must match", (String)audit.getSeverity().getName(), (String)descriptor.getSeverity().getName());
            AuditRulesTest.assertNotNull((String)"target class is required", (Object)audit.getTarget());
            if (audit.isUseInLiveMode()) {
                AuditRulesTest.assertEquals((Object)descriptor.getEvaluationMode(), (Object)EvaluationMode.LIVE);
                this.liveConstraintTested = true;
            } else {
                AuditRulesTest.assertEquals((Object)descriptor.getEvaluationMode(), (Object)EvaluationMode.BATCH);
            }
            AuditRulesTest.assertEquals((String)"Constraint description must match", (String)audit.getDescription(), (String)descriptor.getDescription());
            AuditRulesTest.assertEquals((String)"Constraint message must match", (String)audit.getMessage(), (String)descriptor.getMessagePattern());
            Set categories = descriptor.getCategories();
            AuditRulesTest.assertEquals((String)"Single category expected", (int)1, (int)categories.size());
            AuditRulesTest.assertEquals((String)"Constraint category must be registered", categories.iterator().next(), (Object)CategoryManager.getInstance().getCategory(this.getCategoryPath(audit.getContainer())));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void assertEvaluation(AuditRule audit, EObject target) {
            EObject[] validatedInstance = new EObject[1];
            if (target instanceof View) {
                validatedInstance[0] = target;
            } else {
                Node node = NotationFactory.eINSTANCE.createNode();
                node.setElement(target);
                validatedInstance[0] = node;
            }
            IModelConstraint[] constraintFound = new IModelConstraint[1];
            IValidationListener listener = new IValidationListener(this, target, audit, constraintFound){
                final /* synthetic */ AuditAssert this$1;
                private final /* synthetic */ EObject val$target;
                private final /* synthetic */ AuditRule val$audit;
                private final /* synthetic */ IModelConstraint[] val$constraintFound;
                {
                    this.this$1 = auditAssert;
                    this.val$target = eObject;
                    this.val$audit = auditRule;
                    this.val$constraintFound = iModelConstraintArray;
                }

                public void validationOccurred(ValidationEvent event) {
                    boolean isTargetMatch = false;
                    Iterator<E> it = event.getValidationTargets().iterator();
                    while (it.hasNext()) {
                        if (it.next() != this.val$target) continue;
                        isTargetMatch = true;
                        break;
                    }
                    if (!isTargetMatch) {
                        return;
                    }
                    it = event.getValidationResults().iterator();
                    while (it.hasNext()) {
                        IConstraintStatus status = (IConstraintStatus)it.next();
                        if (!this.this$1.constraintGlobalId(this.val$audit).equals(status.getConstraint().getDescriptor().getId())) continue;
                        this.val$constraintFound[0] = status.getConstraint();
                        break;
                    }
                }
            };
            Method validationMethod = null;
            try {
                Class validationProviderClass = AuditRulesTest.this.loadGeneratedClass(String.valueOf(AuditRulesTest.this.getGenModel().getGenDiagram().getValidationProviderQualifiedClassName()) + "$ValidateAction");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.gmf.runtime.notation.View");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                classArray[0] = clazz;
                validationMethod = validationProviderClass.getMethod("runValidation", classArray);
            }
            catch (Exception e) {
                AuditRulesTest.fail((String)"Could not find runValidation operation in ValidationProvider");
                e.printStackTrace();
            }
            try {
                try {
                    ModelValidationService.getInstance().addValidationListener(listener);
                    validationMethod.invoke(null, validatedInstance[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                ModelValidationService.getInstance().removeValidationListener(listener);
                throw throwable;
            }
            {
                Object var8_12 = null;
            }
            ModelValidationService.getInstance().removeValidationListener(listener);
            AuditRulesTest.assertNotNull((String)"Constraint must be involved in validation", (Object)constraintFound[0]);
        }

        void assertAuditContainer(AuditContainer auditContainer) {
            Category category = CategoryManager.getInstance().getCategory(this.getCategoryPath(auditContainer));
            AuditRulesTest.assertEquals((String)"Category id must match", (String)auditContainer.getId(), (String)category.getId());
            AuditRulesTest.assertEquals((String)"Category name must match", (String)auditContainer.getName(), (String)category.getName());
            AuditRulesTest.assertEquals((String)"Category description must match", (String)auditContainer.getDescription(), (String)category.getDescription());
            Iterator it = auditContainer.getAudits().iterator();
            while (it.hasNext()) {
                AuditRule nextRule = (AuditRule)it.next();
                this.assertAudit(nextRule);
            }
            it = auditContainer.getChildContainers().iterator();
            while (it.hasNext()) {
                this.assertAuditContainer((AuditContainer)it.next());
            }
        }

        String getCategoryPath(AuditContainer container) {
            ArrayList<AuditContainer> pathElements = new ArrayList<AuditContainer>();
            AuditContainer current = container;
            while (current != null) {
                pathElements.add(0, current);
                current = current.getParentContainer();
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < pathElements.size()) {
                AuditContainer nextContainer = (AuditContainer)pathElements.get(i);
                if (i > 0) {
                    buf.append('/');
                }
                buf.append(nextContainer.getId());
                ++i;
            }
            return buf.toString();
        }
    }
}

