/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.io.IOException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaGenFileSetup;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.GenProjectBaseSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.MultiPackageGenSetup;
import org.eclipse.gmf.tests.setup.MultiplePackagesDomainModelSetup;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;

public class CompilationTest
extends TestCase {
    public CompilationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SessionSetup.getRuntimeWorkspaceSetup();
    }

    public void testCompileDistinctModelAndDiagramFiles() throws Exception {
        DiaGenSource gmfGenSource = this.loadSource();
        gmfGenSource.getGenDiagram().getEditorGen().setSameFileForDiagramAndModel(false);
        this.generateAndCompile(gmfGenSource);
    }

    public void testCompileSingleDiagramFile() throws Exception {
        DiaGenSource gmfGenSource = this.loadSource();
        gmfGenSource.getGenDiagram().getEditorGen().setSameFileForDiagramAndModel(true);
        this.generateAndCompile(gmfGenSource);
    }

    public void testCompilePotentialNameClashes() throws Exception {
        DomainModelSetup domainModel = new DomainModelSetup().init();
        domainModel.getNodeA().getEClass().setName("Node");
        domainModel.getNodeB().getEClass().setName("ShapeNode");
        domainModel.getLinkAsClass().getEClass().setName("ConnectionNode");
        domainModel.getNodeA().getNameAttr().setName("attribute");
        domainModel.getNodeB().getNameAttr().setName("class");
        domainModel.getDiagramElement().setName("Diagram");
        MapSetup mapSource = new MapSetup().init(new DiaDefSetup().init(), domainModel, new ToolDefSetup());
        DiaGenSetup gmfGenSource = new DiaGenSetup(this.getViewmapProducer()).init(mapSource);
        this.generateAndCompile(gmfGenSource);
    }

    private DiaGenSource loadSource() throws IOException {
        URI selected = Plugin.createURI("/models/library/library.gmfgen");
        DiaGenFileSetup gmfGenSource = new DiaGenFileSetup().init(selected);
        return gmfGenSource;
    }

    public void testCompileMultiPackageDomain() throws Exception {
        MultiplePackagesDomainModelSetup ds = new MultiplePackagesDomainModelSetup().init();
        MapSetup ms = new MapSetup().init(new DiaDefSetup().init(), ds, new ToolDefSetup());
        HashSet<EPackage> additionalPacks = new HashSet<EPackage>(8);
        additionalPacks.add(ds.getNodeA().getEClass().getEPackage());
        additionalPacks.add(ds.getNodeB().getEClass().getEPackage());
        additionalPacks.add(ds.getLinkAsClass().getEClass().getEPackage());
        DiaGenSetup gmfGenSource = new MultiPackageGenSetup(additionalPacks).init(ms);
        this.generateAndCompile(gmfGenSource);
    }

    protected void generateAndCompile(DiaGenSource genSource) throws Exception {
        new GenProjectBaseSetup(this.getGeneratorConfiguration()).generateAndCompile(SessionSetup.getRuntimeWorkspaceSetup(), genSource);
    }

    protected GeneratorConfiguration getGeneratorConfiguration() {
        return new RuntimeBasedGeneratorConfiguration();
    }

    protected ViewmapProducer getViewmapProducer() {
        return new InnerClassViewmapProducer();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

