/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.expression.ast;

import junit.framework.TestCase;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.gmf.internal.xpand.expression.parser.ExpressionLexer;

public class ScannerTest
extends TestCase {
    public PrsStream scan(String txt) {
        ExpressionLexer scanner = new ExpressionLexer(txt.toCharArray(), "nofile");
        scanner.lexer(new PrsStream((LexStream)scanner));
        return scanner.getPrsStream();
    }

    public final void testString() {
        this.doTest("\"test\"");
        this.doTest("\"te\\nst\"");
        this.doTest("'test'");
        this.doTest("'te\\nst'");
        ScannerTest.assertEquals((String)"Token with kind == bad should be detected on unterminated string quoted with '", (int)0, (int)this.scan("'unterminated").getTokenAt(1).getKind());
        ScannerTest.assertEquals((String)"Token with kind == bad should be detected on unterminated string quoted with \"", (int)0, (int)this.scan("\"test").getTokenAt(1).getKind());
    }

    public void testDollarSign() {
        this.doTest("\"dollar sign $ should be ok\"");
    }

    private void doTest(String txt) {
        PrsStream scan = this.scan(txt);
        ScannerTest.assertEquals((String)txt, (String)scan.getTokenText(1));
    }
}

