/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.ui.action;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.command.IModificationValidator;
import org.eclipse.gmf.runtime.common.core.internal.command.BaseModificationValidator;
import org.eclipse.gmf.runtime.emf.ui.action.AbstractModelActionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.operations.UndoActionHandler;

public class AbstractModelActionHandlerTest
extends TestCase {
    private IProject project;
    private IFile file;
    private IOperationHistory history;
    private TransactionalEditingDomain editingDomain;
    private IWorkbenchPart part;
    private IWorkbenchPartSite site;

    protected void setUp() throws Exception {
        super.setUp();
        FileModificationValidator.setModificationValidator((IModificationValidator)new BaseModificationValidator());
        this.part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.site = this.part.getSite();
        this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        this.history = OperationHistoryFactory.getOperationHistory();
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this.project = root.getProject("FileModificationApproverTest");
            this.project.create(null);
            this.project.open(null);
            this.file = this.project.getFile("AbstractModelActionHandlerTest.txt");
            ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
            this.file.create((InputStream)contents, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.project.close((IProgressMonitor)new NullProgressMonitor());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = null;
        this.file = null;
        this.site = null;
    }

    private void fail(Exception e) {
        e.printStackTrace();
        AbstractModelActionHandlerTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }

    private void setReadOnly(boolean b) {
        try {
            ResourceAttributes resourceAttributes = this.file.getResourceAttributes();
            resourceAttributes.setReadOnly(b);
            this.file.setResourceAttributes(resourceAttributes);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void test_fileModificationValidation_155418() {
        TestModelActionHandler action = new TestModelActionHandler(this.part);
        UndoActionHandler undoAction = new UndoActionHandler(this.site, action.getUndoContext());
        undoAction.setPruneHistory(true);
        this.setReadOnly(true);
        action.run((IProgressMonitor)new NullProgressMonitor());
        AbstractModelActionHandlerTest.assertFalse((boolean)action.getCommand().isExecuted());
        AbstractModelActionHandlerTest.assertFalse((boolean)this.history.canUndo(action.getUndoContext()));
        this.setReadOnly(false);
        action.run((IProgressMonitor)new NullProgressMonitor());
        AbstractModelActionHandlerTest.assertTrue((boolean)action.getCommandStatus().isOK());
        AbstractModelActionHandlerTest.assertTrue((boolean)action.getCommand().isExecuted());
        AbstractModelActionHandlerTest.assertTrue((boolean)this.history.canUndo(action.getUndoContext()));
        this.setReadOnly(true);
        try {
            this.history.undo(action.getUndoContext(), (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        AbstractModelActionHandlerTest.assertFalse((boolean)action.getCommand().isUndone());
        Display display = PlatformUI.getWorkbench().getDisplay();
        while (display.readAndDispatch()) {
        }
        AbstractModelActionHandlerTest.assertFalse((boolean)this.history.canUndo(action.getUndoContext()));
        undoAction.dispose();
    }

    private class TestModelActionHandler
    extends AbstractModelActionHandler {
        private TestCommand command;
        private IUndoContext undoContext;

        public TestModelActionHandler(IWorkbenchPart part) {
            super(part);
            this.setText("TestModelActionHandler");
        }

        protected TransactionalEditingDomain getEditingDomain() {
            return AbstractModelActionHandlerTest.this.editingDomain;
        }

        protected void doRun(IProgressMonitor progressMonitor) {
            this.execute((IUndoableOperation)this.getCommand(), progressMonitor, null);
        }

        public TestCommand getCommand() {
            if (this.command == null) {
                this.command = new TestCommand();
                this.command.addContext(this.getUndoContext());
            }
            return this.command;
        }

        public IUndoContext getUndoContext() {
            if (this.undoContext == null) {
                this.undoContext = new UndoContext();
            }
            return this.undoContext;
        }

        public IStatus getCommandStatus() {
            return super.getStatus();
        }

        public void refresh() {
        }
    }

    private class TestCommand
    extends AbstractCommand {
        private boolean executed;
        private boolean undone;
        private boolean redone;

        public TestCommand() {
            super("AbstractModelActionHandlerTest", Collections.singletonList(AbstractModelActionHandlerTest.this.file));
            this.executed = false;
            this.undone = false;
            this.redone = false;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = true;
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.undone = true;
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.redone = true;
            return CommandResult.newOKCommandResult();
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public boolean isUndone() {
            return this.undone;
        }

        public boolean isRedone() {
            return this.redone;
        }
    }
}

