/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.graphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import org.apache.batik.ext.awt.g2d.DefaultGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;

public class Graphics2DToGraphicsAdaptor
extends DefaultGraphics2D {
    private Graphics swtGraphics;
    private Font currentFont = null;
    private Color currentColor = null;
    private Transform currentTransform = null;
    private GC swtGC;
    private RGB transparency;
    private RGB transparency_replace;
    private final AffineTransform identityTransform = new AffineTransform();
    private final Stroke defaultStroke = new BasicStroke();
    private GraphicsConfiguration gconfig;

    public Graphics2DToGraphicsAdaptor(GC swtGC, RGB transparency, RGB transparency_replace) {
        super(true);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.gconfig = bi.createGraphics().getDeviceConfiguration();
        this.gc = new GraphicContext();
        this.swtGC = swtGC;
        swtGC.setAdvanced(true);
        if (!swtGC.getAdvanced()) {
            throw new UnsupportedOperationException("Advanced graphics support is required");
        }
        this.swtGraphics = new SWTGraphics(swtGC);
        this.transparency = transparency;
        this.transparency_replace = transparency_replace;
    }

    public void dispose() {
        if (this.currentColor != null) {
            this.currentColor.dispose();
        }
        this.currentColor = null;
        if (this.currentFont != null) {
            this.currentFont.dispose();
        }
        this.currentFont = null;
        if (this.currentTransform != null) {
            this.currentTransform.dispose();
        }
        this.currentTransform = null;
        if (this.swtGraphics != null) {
            this.swtGraphics.dispose();
        }
        this.swtGraphics = null;
    }

    protected final boolean configureGraphics() {
        this.swtGraphics.pushState();
        boolean supported = true;
        supported &= this.configureStroke(this.getStroke());
        supported &= this.configureTransformation(this.getTransform());
        supported &= this.configureClipping(this.getClip());
        supported &= this.configureComposite(this.getComposite());
        supported &= this.configurePaintMode(this.getPaint());
        return supported &= this.configureRenderingHints();
    }

    private boolean configureRenderingHints() {
        Object interpolation;
        Object textAntiAlias;
        Object antiAlias = this.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (antiAlias != null) {
            if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_ON)) {
                this.swtGraphics.setAntialias(1);
            } else if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_OFF)) {
                this.swtGraphics.setAntialias(0);
            } else if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_DEFAULT)) {
                this.swtGraphics.setAntialias(-1);
            }
        }
        if ((textAntiAlias = this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING)) != null) {
            if (textAntiAlias.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_ON)) {
                this.swtGraphics.setTextAntialias(1);
            } else if (textAntiAlias.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF)) {
                this.swtGraphics.setTextAntialias(0);
            } else if (textAntiAlias.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
                this.swtGraphics.setTextAntialias(-1);
            }
        }
        if ((interpolation = this.getRenderingHint(RenderingHints.KEY_INTERPOLATION)) != null) {
            if (interpolation.equals(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
                this.swtGraphics.setInterpolation(2);
            } else if (interpolation.equals(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.swtGraphics.setInterpolation(1);
            } else if (interpolation.equals(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.swtGraphics.setInterpolation(0);
            }
        }
        return true;
    }

    private boolean configureStroke(Stroke s) {
        if (s instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)s;
            switch (basicStroke.getEndCap()) {
                case 0: {
                    this.swtGC.setLineCap(1);
                    break;
                }
                case 1: {
                    this.swtGC.setLineCap(2);
                    break;
                }
                case 2: {
                    this.swtGC.setLineCap(3);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (basicStroke.getDashArray() != null) {
                this.swtGC.setLineStyle(6);
                float[] currentDash = basicStroke.getDashArray();
                int[] dash = new int[currentDash.length];
                int i = 0;
                while (i < currentDash.length) {
                    dash[i] = Math.round(currentDash[i]);
                    ++i;
                }
                this.swtGC.setLineDash(dash);
            } else {
                this.swtGC.setLineStyle(1);
                this.swtGC.setLineDash(null);
            }
            switch (basicStroke.getLineJoin()) {
                case 2: {
                    this.swtGC.setLineJoin(3);
                    break;
                }
                case 0: {
                    this.swtGC.setLineJoin(1);
                    break;
                }
                case 1: {
                    this.swtGC.setLineJoin(2);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (basicStroke.getLineWidth() < 1.0f && basicStroke.getLineWidth() > 0.0f) {
                throw new UnsupportedOperationException();
            }
            this.swtGC.setLineWidth(Math.round(basicStroke.getLineWidth()));
            return true;
        }
        return false;
    }

    private boolean configurePaintMode(Paint p) {
        if (p instanceof java.awt.Color) {
            java.awt.Color c = (java.awt.Color)p;
            if (c.getAlpha() != 255) {
                throw new UnsupportedOperationException();
            }
            RGB rgb = new RGB(c.getRed(), c.getGreen(), c.getBlue());
            if (rgb.equals((Object)this.transparency)) {
                rgb = this.transparency_replace;
            }
            if (this.currentColor != null) {
                this.currentColor.dispose();
            }
            this.currentColor = new Color(null, rgb.red, rgb.green, rgb.blue);
            this.swtGraphics.setBackgroundColor(this.currentColor);
            this.swtGraphics.setForegroundColor(this.currentColor);
            return true;
        }
        return false;
    }

    private boolean configureComposite(Composite c) {
        if (c instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)c;
            if ((double)ac.getAlpha() != 1.0) {
                throw new UnsupportedOperationException();
            }
            this.swtGC.setAlpha(Math.round(ac.getAlpha() * 255.0f));
            if (ac.getRule() == 3) {
                return true;
            }
        }
        return false;
    }

    private boolean configureTransformation(AffineTransform cxPrime) {
        double[] values = new double[6];
        cxPrime.getMatrix(values);
        float[] fltVals = new float[6];
        int i = 0;
        while (i < values.length) {
            fltVals[i] = (float)values[i];
            ++i;
        }
        if (this.currentTransform != null) {
            this.currentTransform.dispose();
        }
        this.currentTransform = new Transform(null, fltVals);
        this.swtGC.setTransform(this.currentTransform);
        return true;
    }

    private boolean configureClipping(Shape clipShape) {
        Path path = this.getPath(clipShape);
        java.awt.Rectangle rectClip = clipShape.getBounds();
        if (path != null) {
            this.swtGraphics.setClip(new Rectangle(rectClip.x, rectClip.y, rectClip.width, rectClip.height));
            this.swtGC.setClipping(path);
        }
        return true;
    }

    protected final void resetGraphics() {
        this.configureTransformation(this.identityTransform);
        this.configurePaintMode(java.awt.Color.WHITE);
        this.configureStroke(this.defaultStroke);
        this.configureComposite(AlphaComposite.SrcOver);
        if (this.currentColor != null) {
            this.currentColor.dispose();
        }
        this.currentColor = null;
        if (this.currentFont != null) {
            this.currentFont.dispose();
        }
        this.currentFont = null;
        if (this.currentTransform != null) {
            this.currentTransform.dispose();
        }
        this.currentTransform = null;
        this.swtGC.setClipping(null);
        this.swtGraphics.popState();
    }

    private void drawImageBase(BufferedImage bufImg, int x, int y) {
        this.drawImageBase(bufImg, 0, 0, bufImg.getWidth(), bufImg.getHeight(), x, y, bufImg.getWidth(), bufImg.getHeight());
    }

    private void drawImageBase(BufferedImage bufImg, int x, int y, int width, int height, int tx, int ty, int twidth, int theight) {
        org.eclipse.swt.graphics.Image swtImage = ImageConverter.convert(bufImg);
        this.swtGraphics.drawImage(swtImage, x, y, width, height, tx, ty, twidth, theight);
        swtImage.dispose();
    }

    private BufferedImage createImage(Shape s) {
        java.awt.Rectangle rect = s.getBounds();
        if (rect.width == 0) {
            rect.width = 1;
        }
        if (rect.height == 0) {
            rect.height = 1;
        }
        return new BufferedImage(rect.width, rect.height, 2);
    }

    private Graphics2D configureGraphics2D(BufferedImage bufImg, int x, int y) {
        Graphics2D g = bufImg.createGraphics();
        g.setPaint(this.getPaint());
        g.setComposite(this.getComposite());
        g.setStroke(this.getStroke());
        g.setRenderingHints(this.getRenderingHints());
        g.setFont(this.getFont());
        g.translate(-x, -y);
        return g;
    }

    public void draw(Shape s) {
        boolean supportedByDraw2d = this.configureGraphics();
        if (supportedByDraw2d) {
            Path path = this.getPath(s);
            if (path != null) {
                this.swtGraphics.drawPath(path);
            }
        } else {
            java.awt.Rectangle rect = s.getBounds();
            BufferedImage bufImg = this.createImage(s);
            Graphics2D g = this.configureGraphics2D(bufImg, rect.x, rect.y);
            g.draw(s);
            this.drawImageBase(bufImg, rect.x, rect.y);
        }
        this.resetGraphics();
    }

    public void fill(Shape s) {
        boolean supportedByDraw2d = this.configureGraphics();
        if (supportedByDraw2d) {
            Path path = this.getPath(s);
            if (path != null) {
                this.swtGraphics.fillPath(path);
            }
        } else {
            java.awt.Rectangle rect = s.getBounds();
            BufferedImage bufImg = this.createImage(s);
            Graphics2D g = this.configureGraphics2D(bufImg, rect.x, rect.y);
            g.fill(s);
            this.drawImageBase(bufImg, rect.x, rect.y);
        }
        this.resetGraphics();
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        boolean supportedByDraw2d = this.configureGraphics();
        if (!(img instanceof BufferedImage) || !supportedByDraw2d) {
            throw new UnsupportedOperationException();
        }
        this.drawImageBase((BufferedImage)img, x, y);
        this.resetGraphics();
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        boolean supportedByDraw2d = this.configureGraphics();
        if (!(img instanceof BufferedImage) || !supportedByDraw2d) {
            throw new UnsupportedOperationException();
        }
        BufferedImage bufImg = (BufferedImage)img;
        this.drawImageBase((BufferedImage)img, 0, 0, bufImg.getWidth(), bufImg.getHeight(), x, y, width, height);
        this.resetGraphics();
        return true;
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        throw new UnsupportedOperationException();
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        throw new UnsupportedOperationException();
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void drawString(String s, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.gconfig;
    }

    private Path getPath(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        Path path = new Path(null);
        float[] seg = new float[6];
        int segType = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 1: {
                    path.lineTo(seg[0], seg[1]);
                    break;
                }
                case 4: {
                    path.close();
                    break;
                }
                case 0: {
                    path.moveTo(seg[0], seg[1]);
                    break;
                }
                case 2: {
                    path.quadTo(seg[0], seg[1], seg[2], seg[3]);
                    break;
                }
                case 3: {
                    path.cubicTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            pi.next();
        }
        return path;
    }
}

