/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.clipboard;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.render.util.DiagramImageUtils;
import org.eclipse.gmf.runtime.diagram.ui.render.util.PartPositionInfoGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagramGenerator {
    private int image_margin = 0;
    private DiagramEditPart _dgrmEP;
    private IFigure printableLayer;
    private Dimension emptyImageSize;
    private static final int DEFAULT_IMAGE_MARGIN_PIXELS = 10;
    private static final int DEFAULT_EMPTY_IMAGE_SIZE_PIXELS = 100;

    public DiagramGenerator(DiagramEditPart dgrmEP) {
        this._dgrmEP = dgrmEP;
        this.printableLayer = LayerManager.Helper.find((EditPart)this._dgrmEP).getLayer((Object)"Printable Layers");
        IMapMode mm = this.getMapMode();
        this.image_margin = mm.DPtoLP(10);
        this.emptyImageSize = (Dimension)mm.DPtoLP((Translatable)new Dimension(100, 100));
    }

    protected DiagramEditPart getDiagramEditPart() {
        return this._dgrmEP;
    }

    protected abstract Graphics setUpGraphics(int var1, int var2);

    protected void disposeGraphics(Graphics g) {
        g.dispose();
    }

    protected abstract ImageDescriptor getImageDescriptor(Graphics var1);

    public final Image createAWTImageForDiagram() {
        List editparts = this.getDiagramEditPart().getPrimaryEditParts();
        return this.createAWTImageForParts(editparts);
    }

    public Image createAWTImageForParts(List editparts) {
        org.eclipse.swt.graphics.Rectangle diagramArea = this.calculateImageRectangle(editparts);
        return this.createAWTImageForParts(editparts, diagramArea);
    }

    public final ImageDescriptor createSWTImageDescriptorForDiagram() {
        List editparts = this.getDiagramEditPart().getPrimaryEditParts();
        return this.createSWTImageDescriptorForParts(editparts);
    }

    public final ImageDescriptor createSWTImageDescriptorForParts(List editparts) {
        org.eclipse.swt.graphics.Rectangle sourceRect = this.calculateImageRectangle(editparts);
        return this.createSWTImageDescriptorForParts(editparts, sourceRect);
    }

    protected IMapMode getMapMode() {
        return MapModeUtil.getMapMode((IFigure)this.getDiagramEditPart().getFigure());
    }

    protected final void renderToGraphics(Graphics graphics, Point translateOffset, List editparts) {
        graphics.translate(-translateOffset.x, -translateOffset.y);
        graphics.pushState();
        LinkedList<Object> connectionsToPaint = new LinkedList<Object>();
        Map decorations = this.findDecorations(editparts);
        ListIterator editPartsItr = editparts.listIterator();
        while (editPartsItr.hasNext()) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)editPartsItr.next();
            if (editPart instanceof ConnectionEditPart) {
                connectionsToPaint.add(editPart);
                continue;
            }
            connectionsToPaint.addAll(this.findConnectionsToPaint(editPart));
            IFigure figure = editPart.getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
        }
        decorations = this.findDecorations(connectionsToPaint);
        Iterator connItr = connectionsToPaint.iterator();
        while (connItr.hasNext()) {
            IFigure figure = ((GraphicalEditPart)connItr.next()).getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
        }
    }

    private Collection<ConnectionEditPart> findConnectionsToPaint(IGraphicalEditPart editPart) {
        HashSet editParts = new HashSet();
        HashSet<ConnectionEditPart> connectionEPs = new HashSet<ConnectionEditPart>();
        HashSet<ConnectionEditPart> connectionsToPaint = new HashSet<ConnectionEditPart>();
        this.getNestedEditParts(editPart, editParts);
        Iterator editPartsItr = editParts.iterator();
        while (editPartsItr.hasNext()) {
            connectionEPs.addAll(this.getAllConnectionsFrom((GraphicalEditPart)editPartsItr.next()));
        }
        while (!connectionEPs.isEmpty()) {
            Stack<ConnectionEditPart> connectionsPath = new Stack<ConnectionEditPart>();
            ConnectionEditPart conn = (ConnectionEditPart)connectionEPs.iterator().next();
            connectionEPs.remove(conn);
            connectionsPath.add(conn);
            EditPart target = conn.getTarget();
            while (connectionEPs.contains(target)) {
                ConnectionEditPart targetConn = (ConnectionEditPart)target;
                connectionEPs.remove(targetConn);
                connectionsPath.add(targetConn);
                target = targetConn.getTarget();
            }
            if (!editParts.contains(target) && !connectionsToPaint.contains(target)) continue;
            connectionsToPaint.addAll(connectionsPath);
        }
        return connectionsToPaint;
    }

    private List<ConnectionEditPart> getAllConnectionsFrom(GraphicalEditPart ep) {
        LinkedList<ConnectionEditPart> connections = new LinkedList<ConnectionEditPart>();
        for (ConnectionEditPart sourceConn : ep.getSourceConnections()) {
            connections.add(sourceConn);
            connections.addAll(this.getAllConnectionsFrom((GraphicalEditPart)sourceConn));
        }
        return connections;
    }

    private void paintFigure(Graphics graphics, IFigure figure) {
        if (!figure.isVisible()) {
            return;
        }
        Rectangle relBounds = null;
        relBounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
        Rectangle abBounds = relBounds.getCopy();
        DiagramImageUtils.translateTo((Translatable)abBounds, figure, this.printableLayer);
        int transX = abBounds.x - relBounds.x;
        int transY = abBounds.y - relBounds.y;
        graphics.pushState();
        graphics.translate(transX, transY);
        figure.paint(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    private Map findDecorations(Collection editparts) {
        IGraphicalEditPart first;
        IFigure decorationLayer;
        Map figureMap = this.mapFiguresToEditParts(editparts);
        HashMap<IFigure, Object> result = new HashMap<IFigure, Object>();
        if (!editparts.isEmpty() && (decorationLayer = LayerManager.Helper.find((EditPart)(first = (IGraphicalEditPart)editparts.iterator().next())).getLayer((Object)"Decoration Printable Layer")) != null) {
            ArrayList figures = new ArrayList(editparts);
            Iterator iter = figures.listIterator();
            while (iter.hasNext()) {
                iter.set(((IGraphicalEditPart)iter.next()).getFigure());
            }
            block1: for (Object next : decorationLayer.getChildren()) {
                if (!(next instanceof Decoration)) continue;
                Decoration decoration = (Decoration)next;
                IFigure owner = decoration.getOwnerFigure();
                while (owner != null) {
                    if (figureMap.containsKey(owner)) {
                        Object existing = result.get(owner);
                        if (existing == null) {
                            result.put(owner, decoration);
                            continue block1;
                        }
                        if (existing instanceof Collection) {
                            ((Collection)existing).add(decoration);
                            continue block1;
                        }
                        ArrayList<Object> c = new ArrayList<Object>(2);
                        c.add(existing);
                        c.add(decoration);
                        result.put(owner, c);
                        continue block1;
                    }
                    owner = owner.getParent();
                }
            }
        }
        return result;
    }

    private Map mapFiguresToEditParts(Collection editParts) {
        HashMap<IFigure, IGraphicalEditPart> result = new HashMap<IFigure, IGraphicalEditPart>();
        for (IGraphicalEditPart next : editParts) {
            result.put(next.getFigure(), next);
        }
        return result;
    }

    private void paintDecorations(Graphics graphics, IFigure figure, Map decorations) {
        Object decoration = decorations.get(figure);
        if (decoration != null) {
            if (decoration instanceof Collection) {
                Iterator iter = ((Collection)decoration).iterator();
                while (iter.hasNext()) {
                    this.paintFigure(graphics, (IFigure)iter.next());
                }
            } else {
                this.paintFigure(graphics, (IFigure)decoration);
            }
        }
    }

    private void getNestedEditParts(IGraphicalEditPart childEditPart, Collection editParts) {
        for (IGraphicalEditPart child : childEditPart.getChildren()) {
            editParts.add(child);
            this.getNestedEditParts(child, editParts);
        }
    }

    public org.eclipse.swt.graphics.Rectangle calculateImageRectangle(List editparts) {
        Rectangle rect = DiagramImageUtils.calculateImageRectangle(editparts, this.getImageMargin(), this.emptyImageSize);
        return new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public List getDiagramPartInfo() {
        Assert.isNotNull((Object)this._dgrmEP);
        return this.getDiagramPartInfo(this._dgrmEP);
    }

    public List getDiagramPartInfo(DiagramEditPart diagramEditPart) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        Point origin = DiagramImageUtils.calculateImageRectangle(diagramEditPart.getPrimaryEditParts(), this.getImageMargin(), this.emptyImageSize).getLocation();
        options.put("connectionMargin", new Double(this.getImageMargin() >> 1));
        options.put("diagramOrigin", origin);
        return PartPositionInfoGenerator.getDiagramPartInfo(diagramEditPart, options);
    }

    public List<PartPositionInfo> getConstrainedDiagramPartInfo(int maxWidth, int maxHeight, boolean useMargins) {
        return this.getConstrainedDiagramPartInfo(this._dgrmEP, maxWidth, maxHeight, useMargins);
    }

    public List<PartPositionInfo> getConstrainedDiagramPartInfo(DiagramEditPart diagramEditPart, int maxWidth, int maxHeight, boolean useMargins) {
        List children = diagramEditPart.getPrimaryEditParts();
        IMapMode mm = this.getMapMode();
        ConstrainedImageRenderingData data = this.getConstrainedImageRenderingData(children, maxWidth, maxHeight, useMargins);
        Rectangle imageRect = data.imageOriginalBounds.getCopy();
        mm.DPtoLP((Translatable)imageRect);
        if (useMargins) {
            imageRect.shrink(this.getImageMargin(), this.getImageMargin());
        }
        imageRect.performScale(data.scalingFactor);
        if (useMargins) {
            imageRect.expand(this.getImageMargin(), this.getImageMargin());
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("connectionMargin", new Double(mm.DPtoLP(5)));
        options.put("diagramOrigin", imageRect.getLocation());
        options.put("scaleFactor", new Double(data.scalingFactor));
        return PartPositionInfoGenerator.getDiagramPartInfo(diagramEditPart, options);
    }

    public int getImageMargin() {
        return this.image_margin;
    }

    public void setImageMargin(int imageMargin) {
        Assert.isTrue((imageMargin >= 0 ? 1 : 0) != 0);
        this.image_margin = imageMargin;
    }

    public Image createAWTImageForParts(List editParts, org.eclipse.swt.graphics.Rectangle diagramArea) {
        return null;
    }

    public final ImageDescriptor createSWTImageDescriptorForParts(List editparts, org.eclipse.swt.graphics.Rectangle sourceRect) {
        ImageDescriptor imageDesc = new ImageDescriptor(){

            public ImageData getImageData() {
                return SharedImages.get((String)"icons/error.gif").getImageData();
            }
        };
        Graphics graphics = null;
        try {
            IMapMode mm = this.getMapMode();
            PrecisionRectangle rect = new PrecisionRectangle();
            rect.setX((double)sourceRect.x);
            rect.setY((double)sourceRect.y);
            rect.setWidth((double)sourceRect.width);
            rect.setHeight((double)sourceRect.height);
            mm.LPtoDP((Translatable)rect);
            graphics = this.setUpGraphics((int)Math.round(rect.preciseWidth), (int)Math.round(rect.preciseHeight));
            RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics(graphics, this.getMapMode());
            this.renderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), editparts);
            imageDesc = this.getImageDescriptor(graphics);
        }
        catch (Throwable throwable) {
            if (graphics != null) {
                this.disposeGraphics(graphics);
            }
            throw throwable;
        }
        if (graphics != null) {
            this.disposeGraphics(graphics);
        }
        return imageDesc;
    }

    public final ImageDescriptor createConstrainedSWTImageDecriptorForParts(List editParts, int maxDeviceWidth, int maxDeviceHeight, boolean useMargins) {
        ImageDescriptor imageDesc = new ImageDescriptor(){

            public ImageData getImageData() {
                return SharedImages.get((String)"icons/error.gif").getImageData();
            }
        };
        Graphics graphics = null;
        try {
            IMapMode mm = this.getMapMode();
            ConstrainedImageRenderingData data = this.getConstrainedImageRenderingData(editParts, maxDeviceWidth, maxDeviceHeight, useMargins);
            graphics = this.setUpGraphics(data.imageWidth, data.imageHeight);
            ScaledGraphics scaledGraphics = new ScaledGraphics(graphics);
            RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics((Graphics)scaledGraphics, this.getMapMode());
            graphics.translate(data.margin, data.margin);
            mapModeGraphics.scale(data.scalingFactor);
            PrecisionPoint location = new PrecisionPoint(data.imageOriginalBounds.preciseX(), data.imageOriginalBounds.preciseY());
            mm.DPtoLP((Translatable)location);
            this.renderToGraphics((Graphics)mapModeGraphics, (Point)location, editParts);
            imageDesc = this.getImageDescriptor(graphics);
        }
        catch (Throwable throwable) {
            if (graphics != null) {
                this.disposeGraphics(graphics);
            }
            throw throwable;
        }
        if (graphics != null) {
            this.disposeGraphics(graphics);
        }
        return imageDesc;
    }

    ConstrainedImageRenderingData getConstrainedImageRenderingData(List editParts, int maxDeviceWidth, int maxDeviceHeight, boolean useMargins) {
        double xScalingFactor;
        ConstrainedImageRenderingData data = new ConstrainedImageRenderingData();
        IMapMode mm = this.getMapMode();
        data.imageOriginalBounds = new PrecisionRectangle(new Rectangle(this.calculateImageRectangle(editParts)));
        mm.LPtoDP((Translatable)data.imageOriginalBounds);
        int deviceMargins = mm.LPtoDP(this.getImageMargin());
        data.margin = useMargins ? deviceMargins : 0;
        double yScalingFactor = xScalingFactor = 1.0;
        data.imageOriginalBounds.shrink(deviceMargins, deviceMargins);
        if (maxDeviceWidth > data.margin) {
            xScalingFactor = (double)(maxDeviceWidth - data.margin - data.margin) / data.imageOriginalBounds.preciseWidth();
        }
        if (maxDeviceHeight > data.margin) {
            yScalingFactor = (double)(maxDeviceHeight - data.margin - data.margin) / data.imageOriginalBounds.preciseHeight();
        }
        data.scalingFactor = Math.min(Math.min(xScalingFactor, yScalingFactor), 1.0);
        data.imageWidth = data.imageOriginalBounds.width + data.margin + data.margin;
        data.imageHeight = data.imageOriginalBounds.height + data.margin + data.margin;
        if (data.scalingFactor < 1.0) {
            data.imageWidth = (int)Math.round(data.imageOriginalBounds.preciseWidth() * data.scalingFactor) + data.margin + data.margin;
            data.imageHeight = (int)Math.round(data.imageOriginalBounds.preciseHeight() * data.scalingFactor) + data.margin + data.margin;
        } else {
            data.scalingFactor = 1.0;
        }
        return data;
    }

    public Image createConstrainedAWTImageForParts(List editParts, int maxDeviceWidth, int maxDeviceHeight, boolean useMargins) {
        return null;
    }

    class ConstrainedImageRenderingData {
        double scalingFactor;
        int imageWidth;
        int imageHeight;
        Rectangle imageOriginalBounds;
        int margin;

        ConstrainedImageRenderingData() {
        }
    }
}

