/*
 * Copyright (c) 2006, 2009 Borland Software Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     committers of openArchitectureWare - Xpand language syntax
 *     Artem Tikhomirov (Borland) - LALR grammar
 *                                - Migration to OCL expressions
 */
package org.eclipse.gmf.internal.xpand.parser;

public class XpandParserprs implements lpg.runtime.ParseTable, XpandParsersym {
    public final static int ERROR_SYMBOL = 42;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 64;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 65;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 30;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 316;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 192;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 5439;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 354;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 150;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 342;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 4558;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 3;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 69;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 69;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 5084;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 5085;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return XpandParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,1,0,0,0,1,
            1,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,1,1,0,
            0,0,0,0,1,1,1,0,0,0,
            1,0,0,0,0,0,0,0,1,0,
            0,0,1,1,1,0,0,1,0,0,
            0,1,0,0,0,0,0,0,0,1,
            0,1,1,0,1,1,1,1,1,0,
            0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static char prosthesesIndex[] = {0,
            11,8,9,13,15,16,38,30,36,37,
            39,40,41,42,10,27,28,29,31,44,
            45,46,47,48,49,50,51,52,57,58,
            59,84,86,87,88,89,92,94,81,82,
            83,78,79,80,75,76,77,72,73,74,
            69,70,71,66,67,68,63,64,65,22,
            53,60,61,62,14,91,93,99,138,129,
            125,19,54,55,20,23,25,115,56,85,
            111,112,113,124,128,6,7,12,21,24,
            34,35,118,119,121,127,32,33,96,97,
            100,107,116,117,120,122,123,126,130,131,
            132,133,134,135,136,137,139,140,141,142,
            145,148,2,3,4,17,18,43,90,95,
            98,101,102,103,104,105,106,108,109,110,
            114,143,144,146,147,149,150,1,5,26
        };
    };
    public final static char prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            0,1,1,0,0,0,1,1,1,1,
            1,1,1,1,1,1,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,1,1,0,1,0,0,1,
            0,0,0,0,0,0,0,1,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,1,1,1,1,1,1,1,
            1,1,0,0,0,0,0,1,1,1,
            1,1,1,1,1,1,1,1,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,3,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,4,4,0,1,1,3,
            1,3,3,5,1,1,1,1,1,1,
            1,1,1,1,1,1,4,0,1,1,
            3,1,1,3,1,1,1,1,1,1,
            1,4,1,3,1,1,1,2,1,1,
            1,1,1,1,1,1,1,1,1,1,
            8,10,10,8,10,1,1,1,5,6,
            8,8,7,7,5,6,9,1,4,6,
            4,0,0,1,1,3,1,1,1,1,
            1,1,1,1,1,3,1,3,1,1,
            1,3,1,3,1,1,1,3,1,3,
            1,1,1,3,1,3,1,1,1,3,
            3,1,3,3,1,1,1,3,3,3,
            3,1,3,3,3,3,1,1,1,3,
            3,1,3,3,1,1,1,3,3,1,
            3,3,1,1,1,2,2,1,2,2,
            1,1,1,1,1,1,3,4,1,3,
            1,4,4,1,6,4,1,1,1,3,
            1,0,1,3,2,5,1,3,1,7,
            5,7,6,5,4,3,2,3,1,1,
            1,1,1,1,1,1,4,4,2,1,
            3,5,5,1,3,0,1,2,0,1,
            6,3,1,1,1,1,3,5,5,3,
            1,1,0,3,5,4,4,0,1,0,
            2,0,2,4,0,2,4,6,9,11,
            9,2,2,0,1,2,6,9,1,3,
            1,2,2,0,3,1,1,1,1,1,
            1,3,0,3,0,1,1,1,1,2,
            3,5,6,0,3,1,1,5,0,1,
            8,0,2,0,2,6,0,4,0,2,
            6,10,0,1,-58,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-135,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-210,-2,0,0,0,0,0,0,0,
            0,-9,0,0,0,-150,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -136,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-14,0,0,0,0,0,0,0,
            0,0,-45,0,0,0,-224,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-13,0,-3,0,0,
            -47,0,0,0,-281,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-15,-72,0,0,0,-16,0,
            -114,0,-126,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-228,0,0,
            0,0,-4,-6,0,0,0,0,0,0,
            0,0,-28,0,0,0,-121,0,0,0,
            -18,-29,-24,0,0,-222,0,0,0,0,
            0,-128,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-19,0,0,0,0,0,0,0,-23,
            0,0,0,0,0,0,0,-26,0,-194,
            0,-36,0,0,-279,0,0,-37,0,0,
            -226,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-166,-38,0,
            -239,0,0,-39,-40,0,-41,0,-147,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-5,0,-164,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-42,-17,-43,0,0,0,-277,0,
            0,-283,0,0,-10,0,0,-218,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-8,0,0,0,0,0,0,0,
            0,-20,0,-116,-119,0,0,-248,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-44,-21,0,
            0,-22,-46,-155,-27,-48,0,-250,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-50,-57,0,
            0,-59,0,-165,-61,-305,0,-292,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-30,-7,-12,0,-11,0,-25,-33,
            0,-286,0,-231,0,-62,0,-183,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-64,0,0,-66,0,0,
            -67,-68,0,0,-69,0,0,0,-70,0,
            0,0,0,0,0,0,0,0,0,0,
            -71,0,-167,0,-169,-249,-256,-153,0,-207,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-284,0,0,0,0,0,
            0,-262,0,-230,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-123,0,
            0,0,0,-73,-290,0,-74,-76,-77,-78,
            -79,-80,-83,0,0,-84,-85,-86,-87,-88,
            -89,-300,-159,-90,0,0,-263,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-91,-92,-93,-94,
            -98,-99,-100,-101,-102,-103,-111,-115,-120,-122,
            -130,-137,-138,-139,-152,-154,-156,-158,-160,-162,
            -163,-168,0,0,-151,-129,0,0,-280,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-105,0,0,-170,0,-104,
            -75,0,-81,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-245,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-172,0,0,
            -55,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-82,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -106,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-107,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -108,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-109,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -110,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-148,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -149,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-157,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -195,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-219,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -227,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-229,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -232,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-235,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -236,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-241,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -243,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-264,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -276,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-278,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -285,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-288,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -291,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-307,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -308,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-309,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -310,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-311,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -131,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -132,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-146,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-133,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-134,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-142,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-143,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-144,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-145,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-95,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -96,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-265,
            -240,0,-173,-174,-124,0,-175,-177,-178,-179,
            -180,-181,-182,-184,-185,-186,-187,-1,-188,-189,
            -190,-266,-191,-192,-193,-197,-198,-199,-200,-201,
            -202,-203,-204,-205,-206,-209,-211,-212,-214,-216,
            0,-140,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -141,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-217,
            0,0,-31,0,0,0,0,0,0,-34,
            0,0,0,0,0,0,0,0,0,0,
            0,-171,0,-220,-221,-176,0,-223,-234,-237,
            -49,0,0,0,0,0,0,-233,0,-238,
            0,-60,0,0,0,0,0,0,-125,-53,
            0,-287,-244,-246,-247,0,0,0,0,0,
            0,0,0,-251,-252,-253,-254,0,0,0,
            -255,-257,-208,-258,0,0,0,-259,-260,-261,
            -267,-268,-271,0,0,0,-272,0,-273,0,
            0,0,0,0,0,0,0,0,-32,0,
            0,0,0,0,0,0,0,0,0,-274,
            0,0,0,0,-275,0,-293,0,-294,0,
            -215,0,0,0,0,-295,0,-35,0,0,
            0,0,0,0,-51,0,0,0,0,0,
            0,0,0,0,-296,-297,-298,0,0,-52,
            0,0,0,0,0,0,-54,0,0,0,
            0,0,0,0,0,0,-56,0,0,0,
            0,0,0,-242,-299,0,0,-301,0,0,
            -63,0,0,0,0,0,0,-97,0,0,
            0,0,0,0,0,-269,-302,-303,-304,0,
            0,0,-65,0,0,0,0,0,0,-306,
            -313,-314,-315,-316,0,0,0,-127,0,0,
            0,0,0,0,-113,0,0,0,0,0,
            0,0,0,0,-117,0,0,0,0,0,
            0,-270,0,0,0,0,0,0,-118,0,
            0,0,0,0,0,-161,0,0,0,0,
            0,0,-289,0,0,0,0,0,0,0,
            -196,0,0,0,0,0,0,-282,0,0,
            0,0,0,0,-225,0,-112,0,-213,0,
            0,0,0,0,-312,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            123,124,124,124,124,124,124,124,124,124,
            124,124,124,124,124,124,125,149,149,149,
            149,149,149,149,149,149,149,149,86,87,
            87,87,15,1,88,88,4,4,3,3,
            3,3,3,3,3,3,2,2,2,2,
            2,65,65,65,65,5,6,126,126,127,
            127,75,72,89,76,90,90,77,77,150,
            150,150,150,16,16,16,16,17,97,97,
            98,98,91,91,92,8,8,8,8,8,
            8,8,18,128,128,9,10,7,7,11,
            11,12,13,14,19,19,19,20,20,22,
            22,23,23,23,24,24,21,21,21,26,
            26,26,26,26,26,26,26,26,28,27,
            27,29,74,79,79,73,73,60,60,31,
            30,61,61,64,64,62,62,63,63,58,
            58,57,57,59,59,55,55,54,54,56,
            56,52,52,51,51,53,53,49,49,48,
            48,48,50,50,50,46,46,45,45,45,
            45,45,47,47,47,47,47,43,43,42,
            42,42,44,44,44,40,40,39,39,39,
            41,41,41,80,80,32,32,32,33,33,
            33,25,25,34,34,34,34,34,35,129,
            129,65,66,37,65,67,38,99,16,16,
            100,130,130,131,131,131,23,73,73,101,
            36,36,36,36,36,36,36,36,24,133,
            133,133,133,134,134,135,135,132,132,132,
            136,136,136,137,102,102,138,138,139,140,
            140,24,24,34,34,81,81,82,82,82,
            83,68,123,141,141,123,93,93,105,105,
            78,78,103,103,106,104,104,107,95,95,
            95,95,84,84,96,96,96,94,94,108,
            108,85,85,71,109,109,110,110,110,110,
            110,110,70,117,117,69,69,111,111,111,
            118,119,119,119,143,143,142,120,112,144,
            144,113,145,145,121,121,114,122,122,146,
            146,115,116,147,147,1,745,1742,104,1737,
            105,106,1740,75,85,86,88,89,90,91,
            139,215,73,74,76,213,107,108,109,110,
            1931,116,117,118,128,1750,214,197,200,1734,
            208,216,228,229,1743,1831,192,1747,1830,182,
            1746,1832,172,1749,1829,165,1748,1833,159,1754,
            1828,153,1751,1834,147,337,137,1835,142,1827,
            380,745,1742,104,1737,105,106,1740,75,85,
            86,88,89,90,91,139,215,73,74,76,
            213,107,108,109,110,1931,116,117,118,128,
            4563,214,197,200,1734,208,216,228,229,195,
            4564,194,1062,87,313,1930,316,317,318,319,
            320,321,170,327,328,329,1,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,337,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,4563,214,197,200,1734,208,216,228,229,
            195,4565,193,714,4541,315,1930,316,317,318,
            319,320,321,728,327,328,329,175,1587,1742,
            104,1737,105,106,1740,75,85,86,88,89,
            90,91,139,215,73,74,76,213,107,108,
            109,110,1931,116,117,118,128,1750,214,197,
            200,1734,208,216,228,229,1743,1831,192,1747,
            1830,182,1746,1832,172,1749,1829,165,1748,1833,
            159,1754,1828,153,1751,1834,147,4724,4731,1835,
            142,1827,1402,355,1399,236,256,36,172,4727,
            922,728,67,4725,4726,342,1752,1742,104,1737,
            105,106,1740,75,85,86,88,89,90,91,
            139,215,73,74,76,213,107,108,109,110,
            1931,116,117,118,128,1750,214,197,200,1734,
            208,216,228,229,1743,1831,192,1747,1830,182,
            1746,1832,172,1749,1829,165,1748,1833,159,1754,
            1828,153,1751,1834,147,135,137,1835,142,1827,
            1402,355,1486,237,990,73,823,68,4835,992,
            67,728,4807,417,745,1742,104,1737,105,106,
            1740,75,85,86,88,89,90,91,139,215,
            73,74,76,213,107,108,109,110,1931,116,
            117,118,128,1750,214,197,200,1734,208,216,
            228,229,1743,1831,192,1747,1830,182,1746,1832,
            172,1749,1829,165,1748,1833,159,1754,1828,153,
            1751,1834,147,4549,137,1835,142,1827,889,1839,
            1402,355,1849,81,586,1740,227,85,86,88,
            89,90,91,780,34,29,30,780,34,29,
            30,401,678,719,80,82,780,34,29,30,
            4548,4550,417,745,1742,104,1737,105,106,1740,
            75,85,86,88,89,90,91,139,215,73,
            74,76,213,107,108,109,110,1931,116,117,
            118,128,1750,214,197,200,1734,208,216,228,
            229,1743,1831,192,1747,1830,182,1746,1832,172,
            1749,1829,165,1748,1833,159,1754,1828,153,1751,
            1834,147,4549,137,1835,142,1827,4547,234,31,
            35,37,39,31,35,1404,824,305,1477,1474,
            77,1475,31,35,1586,289,749,744,607,303,
            256,1844,648,80,82,256,4734,287,730,4553,
            4550,380,1662,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,260,137,1835,142,1827,220,68,1041,657,
            67,1078,4805,68,661,665,67,735,4740,380,
            745,1742,104,1737,105,106,1740,75,85,86,
            88,89,90,91,139,215,73,74,76,213,
            107,108,109,110,1931,116,117,118,128,4573,
            214,197,200,1734,208,216,228,229,1743,1831,
            192,1747,1830,182,1746,1832,172,1749,1829,165,
            1748,1833,159,155,4574,154,258,4739,89,745,
            1742,104,1737,105,106,1740,75,85,86,88,
            89,90,91,139,215,73,74,76,213,107,
            108,109,110,1931,116,117,118,128,1750,214,
            197,200,1734,208,216,228,229,1743,1831,192,
            1747,1830,182,1746,1832,172,1749,1829,165,1748,
            1833,159,1754,1828,153,1751,1834,147,135,137,
            1835,142,1827,687,62,285,237,270,2786,256,
            1844,4660,256,4734,472,258,4562,4580,132,745,
            1742,104,1737,105,106,1740,75,85,86,88,
            89,90,91,139,215,73,74,76,213,107,
            108,109,110,1931,116,117,118,128,1750,214,
            197,200,1734,208,216,228,229,1743,1831,192,
            1747,1830,182,1746,1832,172,1749,1829,165,1748,
            1833,159,1754,1828,153,1751,1834,147,135,137,
            1835,142,1827,623,68,4779,237,67,930,265,
            583,4660,258,291,728,256,1565,4714,218,745,
            1742,104,1737,105,106,1740,75,85,86,88,
            89,90,91,139,215,73,74,76,213,107,
            108,109,110,1931,116,117,118,128,1750,214,
            197,200,1734,208,216,228,229,1743,1831,192,
            1747,1830,182,1746,1832,172,1749,1829,165,1748,
            1833,159,1754,1828,153,1751,1834,147,135,137,
            1835,142,1827,1402,355,1850,237,60,438,258,
            294,4660,258,746,728,258,762,4749,261,745,
            1742,104,1737,105,106,1740,75,85,86,88,
            89,90,91,139,215,73,74,76,213,107,
            108,109,110,1931,116,117,118,128,1750,214,
            197,200,1734,208,216,228,229,1743,1831,192,
            1747,1830,182,1746,1832,172,1749,1829,165,1748,
            1833,159,1754,1828,153,1751,1834,147,135,137,
            1835,142,1827,1402,355,462,237,842,769,824,
            1473,4660,997,297,945,924,1150,4775,304,745,
            1742,104,1737,105,106,1740,75,85,86,88,
            89,90,91,139,215,73,74,76,213,107,
            108,109,110,1931,116,117,118,128,1750,214,
            197,200,1734,208,216,228,229,1743,1831,192,
            1747,1830,182,1746,1832,172,1749,1829,165,1748,
            1833,159,1754,1828,153,1751,1834,147,135,137,
            1835,142,1827,678,81,586,237,569,129,719,
            719,4660,256,4734,256,4552,748,4870,342,745,
            1742,104,1737,105,106,1740,75,85,86,88,
            89,90,91,139,215,73,74,76,213,107,
            108,109,110,1931,116,117,118,128,1750,214,
            197,200,1734,208,216,228,229,1743,1831,192,
            1747,1830,182,1746,1832,172,1749,1829,165,1748,
            1833,159,1754,1828,153,1751,1834,147,239,137,
            1835,142,1827,4955,68,970,245,67,1006,264,
            66,1007,1008,305,305,651,289,749,744,1009,
            285,749,744,65,94,302,306,293,286,296,
            1474,1013,1475,44,4858,1045,1094,899,1031,4698,
            342,745,1742,104,1737,105,106,1740,75,85,
            86,88,89,90,91,139,215,73,74,76,
            213,107,108,109,110,1931,116,117,118,128,
            1750,214,197,200,1734,208,216,228,229,1743,
            1831,192,1747,1830,182,1746,1832,172,1749,1829,
            165,1748,1833,159,1754,1828,153,1751,1834,147,
            135,137,1835,142,1827,256,4552,4685,237,4688,
            4770,1839,902,4690,380,745,1742,104,1737,105,
            106,1740,75,85,86,88,89,90,91,139,
            215,73,74,76,213,107,108,109,110,1931,
            116,117,118,128,1750,214,197,200,1734,208,
            216,228,229,1743,1831,192,1747,1830,182,1746,
            1832,172,1749,1829,165,1748,1833,159,1754,1828,
            153,1751,1834,147,4549,137,1835,142,1827,706,
            1585,66,4733,1852,83,1062,1839,512,199,980,
            820,840,892,802,65,4857,22,832,495,328,
            626,458,904,728,1010,81,82,342,745,1742,
            104,1737,105,106,1740,75,85,86,88,89,
            90,91,139,215,73,74,76,213,107,108,
            109,110,1931,116,117,118,128,1750,214,197,
            200,1734,208,216,228,229,1743,1831,192,1747,
            1830,182,1746,1832,172,1749,1829,165,1748,1833,
            159,1754,1828,153,1751,1834,147,239,137,1835,
            142,1827,1402,355,4579,243,1839,25,1018,707,
            927,817,606,731,532,972,5,1019,1022,896,
            173,1020,169,873,688,1028,1029,1033,1035,1037,
            1039,1036,1043,16,1583,1025,871,348,4712,342,
            745,1742,104,1737,105,106,1740,75,85,86,
            88,89,90,91,139,215,73,74,76,213,
            107,108,109,110,1931,116,117,118,128,1750,
            214,197,200,1734,208,216,228,229,1743,1831,
            192,1747,1830,182,1746,1832,172,1749,1829,165,
            1748,1833,159,1754,1828,153,1751,1834,147,135,
            137,1835,142,1827,246,256,36,237,1046,1845,
            728,679,4806,342,745,1742,104,1737,105,106,
            1740,75,85,86,88,89,90,91,139,215,
            73,74,76,213,107,108,109,110,1931,116,
            117,118,128,1750,214,197,200,1734,208,216,
            228,229,1743,1831,192,1747,1830,182,1746,1832,
            172,1749,1829,165,1748,1833,159,1754,1828,153,
            1751,1834,147,1856,137,1835,142,1827,4575,1402,
            476,247,342,745,1742,104,1737,105,106,1740,
            75,85,86,88,89,90,91,139,215,73,
            74,76,213,107,108,109,110,1931,116,117,
            118,128,1750,214,197,200,1734,208,216,228,
            229,1743,1831,192,1747,1830,182,1746,1832,172,
            1749,1829,165,1748,1833,159,1754,1828,153,1751,
            1834,147,136,137,1835,142,1827,1855,1049,1840,
            238,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,280,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,1841,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,330,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,1588,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,1846,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,1324,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,1847,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,279,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,278,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,4578,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,218,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,4715,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,230,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,84,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,63,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,4540,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,332,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,4902,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,4747,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,64,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,4777,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,4786,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,261,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,345,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,1406,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,4871,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,4872,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,4873,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1750,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,1751,1834,
            147,263,137,1835,142,1827,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,1750,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,1746,1832,172,1749,1829,165,1748,1833,159,
            1754,1828,153,1751,1834,147,262,137,1835,142,
            1827,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,4554,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,1748,1833,159,1754,1828,153,149,4555,
            148,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,4556,214,197,200,1734,208,216,228,229,
            1743,1831,192,1747,1830,182,1746,1832,172,1749,
            1829,165,161,4557,160,380,745,1742,104,1737,
            105,106,1740,75,85,86,88,89,90,91,
            139,215,73,74,76,213,107,108,109,110,
            1931,116,117,118,128,4571,214,197,200,1734,
            208,216,228,229,1743,1831,192,1747,1830,182,
            1746,1832,172,167,4572,166,380,745,1742,104,
            1737,105,106,1740,75,85,86,88,89,90,
            91,139,215,73,74,76,213,107,108,109,
            110,1931,116,117,118,128,4559,214,197,200,
            1734,208,216,228,229,1743,1831,192,1747,1830,
            182,175,4560,174,380,745,1742,104,1737,105,
            106,1740,75,85,86,88,89,90,91,139,
            215,73,74,76,213,107,108,109,110,1931,
            116,117,118,128,4559,214,197,200,1734,208,
            216,228,229,1743,1831,192,1747,1830,182,175,
            4561,173,380,745,1742,104,1737,105,106,1740,
            75,85,86,88,89,90,91,139,215,73,
            74,76,213,107,108,109,110,1931,116,117,
            118,128,4566,214,197,200,1734,208,216,228,
            229,1743,1831,192,187,4567,186,380,745,1742,
            104,1737,105,106,1740,75,85,86,88,89,
            90,91,139,215,73,74,76,213,107,108,
            109,110,1931,116,117,118,128,4566,214,197,
            200,1734,208,216,228,229,1743,1831,192,187,
            4568,185,380,745,1742,104,1737,105,106,1740,
            75,85,86,88,89,90,91,139,215,73,
            74,76,213,107,108,109,110,1931,116,117,
            118,128,4566,214,197,200,1734,208,216,228,
            229,1743,1831,192,187,4569,184,380,745,1742,
            104,1737,105,106,1740,75,85,86,88,89,
            90,91,139,215,73,74,76,213,107,108,
            109,110,1931,116,117,118,128,4566,214,197,
            200,1734,208,216,228,229,1743,1831,192,187,
            4570,183,380,745,1742,104,1737,105,106,1740,
            75,85,86,88,89,90,91,139,215,73,
            74,76,213,107,108,109,110,1931,116,117,
            118,128,1842,214,203,210,1734,208,216,228,
            229,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1842,214,203,209,1734,208,216,228,229,
            1108,1084,207,1051,1053,710,1928,1054,1055,171,
            1056,937,921,1057,727,1058,816,1060,712,885,
            668,886,1108,255,947,953,784,952,961,962,
            963,831,940,801,1061,948,1063,1064,1069,1070,
            1072,206,380,745,1742,104,1737,105,106,1740,
            75,85,86,88,89,90,91,139,215,73,
            74,76,213,107,108,109,110,1931,116,117,
            118,128,1842,214,203,202,1734,208,216,228,
            229,380,745,1742,104,1737,105,106,1740,75,
            85,86,88,89,90,91,139,215,73,74,
            76,213,107,108,109,110,1931,116,117,118,
            128,1842,214,203,201,1734,208,216,228,229,
            1079,333,199,38,36,1027,51,1155,53,54,
            682,36,1027,51,1155,53,54,248,4543,2068,
            4682,463,1048,4923,1071,1080,814,4742,1086,1074,
            975,602,36,1027,51,1155,53,54,684,282,
            1082,198,682,36,1027,51,1155,53,54,882,
            475,1565,42,1088,1089,1091,1740,227,85,86,
            88,89,90,91,1097,1102,302,1103,1318,221,
            224,1104,1117,728,1105,1318,221,224,981,1118,
            1106,1120,1119,1126,311,275,276,1127,309,1128,
            259,311,275,276,235,309,1318,221,224,627,
            36,1027,51,1155,53,54,244,1318,221,224,
            1129,948,311,275,276,1133,310,1136,1323,1131,
            242,728,59,311,275,276,1138,310,627,36,
            1027,51,1155,53,54,627,36,1027,51,1155,
            53,54,1402,355,4700,1139,982,1143,4547,233,
            627,36,1027,51,1155,53,54,627,36,1027,
            51,1155,53,54,593,221,224,627,36,1027,
            51,1155,53,54,728,983,1562,1569,1148,4544,
            4686,627,36,1027,51,1155,53,54,256,1844,
            1402,355,4713,671,221,224,728,1146,984,1149,
            1558,221,224,627,36,1027,51,1155,53,54,
            1152,1159,1160,1165,1151,1561,221,224,256,4552,
            5085,5085,1581,221,224,627,36,1027,51,1155,
            53,54,1836,221,224,627,36,1027,51,1155,
            53,54,728,1402,355,4743,751,221,224,627,
            36,1027,51,1155,53,54,627,36,1027,51,
            1155,53,54,728,219,1402,355,350,1244,221,
            224,627,36,1027,51,1155,53,54,627,36,
            1027,51,1155,53,54,256,4734,901,5085,971,
            1753,221,224,5085,66,728,5085,5085,5085,5085,
            1851,221,224,5085,5085,5085,5085,65,93,5085,
            5085,1402,355,1735,62,221,224,1843,5085,5085,
            5085,4781,221,224,5085,5085,5085,5085,5085,5085,
            5085,5085,1402,355,4859,5085,4689,221,224,5085,
            5085,5085,5085,4838,221,224,4551,5085,5085,5085,
            5085,5085,5085,5085,5085,5085,1848,68,1848,5085,
            67,5085,264,5085,1402,355,4874,5085,5085,5085,
            5085,5085,5085,5085,5085,5085,5085,5085,5085,5085,
            5085,5085,5085,5085,5085,5085,5085,4738,5085,5085,
            5085,5085,5085,5085,5085,5085,5085,5085,5085,5085,
            5085,5085,5085,5085,322,5085,324,5085,5085,5085,
            5085,5085,5085,5085,5085,5085,5085,5085,5085,5085,
            5085,5085,4732,5085,5085
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static char termCheck[] = {0,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,0,22,23,0,25,26,27,28,29,
            30,31,32,33,34,35,36,0,0,2,
            3,0,38,0,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,0,22,
            23,0,24,2,3,0,62,67,47,48,
            49,50,0,1,74,75,0,1,40,79,
            0,81,0,42,60,85,0,87,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,68,
            22,23,40,25,26,27,28,29,30,31,
            32,33,34,35,36,43,44,45,46,53,
            42,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,72,22,23,69,25,26,27,28,
            29,30,31,32,33,34,35,36,0,0,
            0,0,0,42,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,24,22,23,0,25,
            26,27,28,29,30,31,32,33,34,35,
            36,43,44,45,46,43,42,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,69,22,
            23,71,25,26,27,28,29,30,31,32,
            33,34,35,36,0,0,58,0,3,42,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,24,22,23,0,25,26,27,28,29,
            30,31,32,33,34,35,36,43,44,45,
            46,0,42,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,40,22,23,0,25,26,
            27,28,29,30,31,32,33,34,35,36,
            39,0,1,2,3,42,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,61,22,23,38,25,26,27,28,
            29,30,31,32,33,34,35,36,51,0,
            1,2,3,42,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            0,22,23,3,25,26,27,28,29,30,
            31,32,33,34,35,36,0,1,2,3,
            0,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,0,22,23,
            3,25,26,27,28,29,30,31,32,33,
            34,35,36,0,1,2,3,0,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,0,22,23,3,25,26,
            27,28,29,30,31,32,33,34,35,36,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,0,22,23,57,25,26,27,28,29,
            30,31,32,33,34,35,36,0,1,2,
            3,0,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,54,22,
            23,40,25,26,27,28,29,30,31,32,
            33,34,35,36,0,1,2,3,0,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,0,22,23,57,25,
            26,27,28,29,30,31,32,33,34,35,
            36,0,0,2,3,0,0,1,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,0,22,23,0,0,2,6,3,
            5,63,64,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,0,22,23,
            0,4,47,48,49,50,0,1,73,53,
            0,1,37,38,0,1,41,0,43,44,
            45,46,47,48,49,50,51,0,0,54,
            55,0,57,0,3,60,0,0,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,52,22,23,0,0,2,3,0,
            5,0,3,0,47,48,49,50,0,6,
            2,3,44,45,46,42,0,0,2,0,
            0,5,5,4,0,1,31,24,52,52,
            63,64,37,38,38,0,41,0,62,4,
            21,68,47,48,49,50,51,51,40,54,
            55,0,57,37,38,60,21,41,0,43,
            44,45,46,47,48,49,50,51,95,0,
            54,55,3,0,54,2,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            0,0,2,2,93,5,97,98,99,100,
            101,102,65,0,53,0,0,2,2,0,
            5,53,0,0,41,6,43,44,45,46,
            0,0,2,0,21,5,5,37,38,0,
            1,41,41,43,44,45,46,47,48,49,
            50,51,37,38,54,42,41,41,43,44,
            45,46,47,48,49,50,51,37,37,56,
            0,41,0,43,44,45,46,47,48,49,
            50,0,59,2,0,0,2,6,0,5,
            2,0,1,21,6,0,1,58,0,1,
            0,0,1,0,1,5,25,26,27,28,
            29,30,42,25,26,27,28,29,30,21,
            0,37,21,0,24,41,0,43,44,45,
            46,5,47,48,49,50,0,39,40,0,
            39,40,39,40,0,1,0,0,2,58,
            52,0,0,52,2,52,5,21,38,61,
            0,0,0,37,94,5,5,5,96,0,
            0,0,52,4,0,5,53,38,4,0,
            0,0,0,0,40,4,4,41,37,0,
            51,0,56,41,24,21,0,37,37,37,
            53,21,21,21,21,0,0,0,0,0,
            4,4,0,24,67,24,4,0,0,0,
            24,0,39,4,0,1,21,0,0,21,
            0,60,0,3,0,0,0,58,0,4,
            0,61,0,3,0,0,1,0,0,1,
            0,1,0,0,0,0,0,0,24,0,
            0,0,0,0,55,3,3,40,0,0,
            0,0,55,0,53,4,21,0,0,0,
            1,0,40,0,40,0,1,0,0,42,
            0,38,4,0,66,59,0,59,66,21,
            4,0,0,0,0,0,88,0,56,39,
            56,38,56,54,57,55,0,0,0,0,
            4,4,3,21,21,0,0,0,0,1,
            0,4,0,40,65,0,4,0,0,4,
            39,4,0,82,39,0,59,0,0,0,
            0,0,0,0,77,4,52,89,0,0,
            70,80,4,4,0,0,83,0,4,39,
            0,0,0,0,0,0,24,39,0,0,
            0,39,0,76,39,38,0,0,0,24,
            0,24,39,0,24,24,24,24,24,0,
            0,0,84,0,0,0,0,0,0,0,
            0,86,0,0,0,0,90,0,0,0,
            0,0,0,0,0,0,78,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            91,0,92,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0
        };
    };
    public final static char termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            314,2136,5186,5118,277,4501,5182,5131,5132,5133,
            5134,5135,5126,5124,5127,5125,5123,1741,5128,5130,
            5129,169,1738,1739,5085,5180,5181,5184,5185,5188,
            5187,4462,5117,1933,4848,5358,5359,5085,5085,942,
            1153,5085,2591,132,5131,5132,5133,5134,5135,5126,
            5124,5127,5125,5123,1025,5128,5130,5129,5085,1019,
            1024,5085,1325,1479,843,5085,2526,2331,175,175,
            175,175,140,132,2201,1925,5085,4663,833,2266,
            292,2396,205,5366,4021,2461,5085,1837,5085,2136,
            5186,5118,133,4501,5182,5131,5132,5133,5134,5135,
            5126,5124,5127,5125,5123,1741,5128,5130,5129,5325,
            1738,1739,36,5180,5181,5184,5185,5188,5187,4462,
            5117,1933,4848,5358,5359,211,211,211,211,4759,
            5366,5085,2136,5186,5118,133,4501,5182,5131,5132,
            5133,5134,5135,5126,5124,5127,5125,5123,1741,5128,
            5130,5129,1233,1738,1739,5084,5180,5181,5184,5185,
            5188,5187,4462,5117,1933,4848,5358,5359,204,291,
            83,290,5085,5366,5085,2136,5186,5118,5204,4501,
            5182,5131,5132,5133,5134,5135,5126,5124,5127,5125,
            5123,1741,5128,5130,5129,1086,1738,1739,5085,5180,
            5181,5184,5185,5188,5187,4462,5117,1933,4848,5358,
            5359,212,212,212,212,1018,5366,5085,2136,5186,
            5118,133,4501,5182,5131,5132,5133,5134,5135,5126,
            5124,5127,5125,5123,1741,5128,5130,5129,284,1738,
            1739,2916,5180,5181,5184,5185,5188,5187,4462,5117,
            1933,4848,5358,5359,196,5085,4709,290,5118,5366,
            5085,2136,5186,5118,133,4501,5182,5131,5132,5133,
            5134,5135,5126,5124,5127,5125,5123,1741,5128,5130,
            5129,1165,1738,1739,52,5180,5181,5184,5185,5188,
            5187,4462,5117,1933,4848,5358,5359,212,212,212,
            212,5085,5366,5085,2136,5186,5118,133,4501,5182,
            5131,5132,5133,5134,5135,5126,5124,5127,5125,5123,
            1741,5128,5130,5129,833,1738,1739,163,5180,5181,
            5184,5185,5188,5187,4462,5117,1933,4848,5358,5359,
            3436,5085,2136,5186,5118,5366,4501,5182,5131,5132,
            5133,5134,5135,5126,5124,5127,5125,5123,1741,5128,
            5130,5129,1159,1738,1739,167,5180,5181,5184,5185,
            5188,5187,4462,5117,1933,4848,5358,5359,167,5085,
            2136,5186,5118,5366,4501,5182,5131,5132,5133,5134,
            5135,5126,5124,5127,5125,5123,1741,5128,5130,5129,
            5085,1738,1739,938,5180,5181,5184,5185,5188,5187,
            4462,5117,1933,4848,5358,5359,78,2136,5186,5118,
            5085,4501,5182,5131,5132,5133,5134,5135,5126,5124,
            5127,5125,5123,1741,5128,5130,5129,5085,1738,1739,
            5397,5180,5181,5184,5185,5188,5187,4462,5117,1933,
            4848,5358,5359,181,420,420,420,145,420,420,
            420,420,420,420,420,420,420,420,420,420,
            420,420,420,420,57,420,420,5118,420,420,
            420,420,420,420,420,420,420,420,420,420,
            180,420,420,420,157,420,420,420,420,420,
            420,420,420,420,420,420,420,420,420,420,
            420,5085,420,420,149,420,420,420,420,420,
            420,420,420,420,420,420,420,179,420,420,
            420,5085,420,420,420,420,420,420,420,420,
            420,420,420,420,420,420,420,420,161,420,
            420,837,420,420,420,420,420,420,420,420,
            420,420,420,420,178,420,420,420,5085,420,
            420,420,420,420,420,420,420,420,420,420,
            420,420,420,420,420,295,420,420,1029,420,
            420,420,420,420,420,420,420,420,420,420,
            420,5085,5085,1555,1153,5085,5085,4670,5131,5132,
            5133,5134,5135,5126,5124,5127,5125,5123,1025,5128,
            5130,5129,5085,1019,1024,138,5085,196,5182,5118,
            6605,1154,841,5131,5132,5133,5134,5135,5126,5124,
            5127,5125,5123,1025,5128,5130,5129,5085,1019,1024,
            5085,1326,4417,4372,4327,4282,5085,4795,666,4788,
            5085,4810,188,168,5085,4710,196,171,212,212,
            212,212,176,176,176,176,168,288,266,162,
            156,5085,150,5085,1153,144,33,5085,5131,5132,
            5133,5134,5135,5126,5124,5127,5125,5123,1025,5128,
            5130,5129,4909,1019,1024,5085,5085,5099,5118,5085,
            5098,283,5118,5085,4417,4372,4327,4282,304,5183,
            1479,843,4545,1729,5352,5366,150,325,196,5085,
            5085,6610,5411,1398,5085,4817,5088,1242,4827,4931,
            1154,841,5097,5095,4234,5085,5100,5085,2071,1405,
            4691,5326,5094,5091,5093,5092,5096,4186,1480,5086,
            5089,5085,5090,188,168,5087,4702,196,5085,212,
            212,212,212,176,176,176,176,168,1757,5085,
            162,156,5118,188,4135,196,5131,5132,5133,5134,
            5135,5126,5124,5127,5125,5123,5113,5128,5130,5129,
            156,189,196,195,668,6614,5334,5335,5336,5337,
            5338,5339,5392,5085,4841,162,5085,196,4621,87,
            6611,4863,5085,5085,196,5183,212,212,212,212,
            168,177,196,5085,818,6613,6592,188,168,5085,
            4710,196,195,212,212,212,212,176,176,176,
            176,168,188,168,162,5366,196,4582,212,212,
            212,212,176,176,176,176,168,188,187,231,
            5085,196,5085,212,212,212,212,176,176,176,
            176,232,5383,5186,176,170,196,5182,5085,6612,
            5186,5085,4817,940,5182,5085,1088,4878,140,132,
            323,140,132,140,132,6607,5180,5181,5184,5185,
            5188,5187,5366,5180,5181,5184,5185,5188,5187,675,
            5085,188,1482,5085,325,196,5085,212,212,212,
            212,420,4417,4372,4327,4282,5085,61,36,164,
            61,36,61,36,132,1168,191,331,4621,852,
            4938,181,190,4909,4621,4909,5893,1484,2981,61,
            180,179,178,541,1488,5930,5967,6004,2721,5085,
            323,141,4931,1838,5085,6607,4885,4234,5420,5085,
            5085,5085,5085,5085,37,5206,5207,4582,541,5085,
            4186,5085,5177,4582,325,2002,5085,541,541,541,
            3111,1162,2002,2002,1162,5085,5085,5085,58,151,
            5307,5141,5085,1319,3046,1322,5140,5085,5085,5085,
            4947,5085,3956,5302,334,1590,4895,336,5085,1245,
            339,143,5085,5425,5085,5085,5085,753,5085,5310,
            269,1655,5085,6593,132,272,597,5085,256,4945,
            255,951,5085,5085,5085,79,5085,146,4949,158,
            152,347,5085,5085,155,1021,4834,833,5085,5085,
            5085,5085,4081,5085,4916,5210,1664,342,134,5085,
            1248,5085,846,349,36,131,1328,5085,5085,5366,
            5085,2851,5211,132,4576,5386,5085,5384,4577,2002,
            5205,5085,68,137,61,5085,2656,344,5311,5353,
            5308,3306,5162,4135,1029,4081,5085,5085,5085,5085,
            5343,5342,5428,945,1859,5085,5085,5085,130,1408,
            5085,5208,5085,37,5393,5085,5209,5085,5085,5199,
            3371,5196,5085,3176,3501,5085,5385,62,5085,353,
            5085,5085,187,269,4741,5212,4909,3241,5085,5085,
            5356,5423,5200,5198,5085,188,4856,323,5197,3696,
            188,188,188,188,188,5085,177,3761,5085,5085,
            5085,3826,5085,3566,3891,3306,5085,5085,5085,138,
            5085,5411,4684,5085,150,162,176,168,156,5085,
            5085,5085,5431,5085,5085,5085,5085,5085,5085,5085,
            5085,5436,5085,5085,5085,5085,3631,5085,5085,5085,
            5085,5085,5085,5085,5085,5085,5426,5085,5085,5085,
            5085,5085,5085,5085,5085,5085,5085,5085,5085,5085,
            5439,5085,5437
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            317,167,8,104,102,105,104,143,103,102,
            106,105,402,5,51,51,150,402,94,8,
            164,164,91,88,88,91,9,388,165,165,
            385,386,88,386,386,280,279,92,92,92,
            92,145,153,402,50,279,50,292,385,292,
            386,386,332,386,370,386,169,354,51,386,
            292,171,386,280,386,343,280,280,173,279,
            280,14,16,148,196,261,261,222,260,260,
            110,370,20,23,22,29,27,16,31,30,
            263,265,267,270,370,370,402,219,255,273,
            275,32,277,50,402,370,370,370,370,370,
            282,353,386,50,292,50,386,386,402,92,
            388,199,205,302,78,53,402,53,296,280,
            370,370,370,370,370,370,16,284,173,370,
            370,370,370,370,370,370,370,370,370,354,
            288,287,201,294,50,294,370,51,50,169,
            386,169,280,109,14,370,92,148,14,15,
            328,299,299,86,315,322,86,310,311,311,
            314,86,110,16,31,16,29,16,23,23,
            16,20,20,402,370,386,16,22,22,22,
            22,16,27,16,30,289,110,50,402,1,
            402,320,353,171,50,280,279,109,370,162,
            92,388,15,109,402,370,370,136,370,370,
            402,370,326,315,370,370,279,330,97,2,
            370,50,370,169,110,280,335,109,14,109,
            280,162,337,160,279,175,280,340,342,280,
            162,176,110,370,98,98,402,3,50,50,
            345,347,280,15,280,370,402,370,402,110,
            110,386,402,402,370,402,327,370,50,1,
            370,109,280,162,280,162,279,162,279,176,
            159,162,161,349,49,280,370,370,370,370,
            370,50,280,280,280,351
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static char asr[] = {0,
            82,83,84,0,6,24,0,72,73,63,
            64,24,0,40,1,43,44,45,46,2,
            41,37,47,48,49,50,38,51,54,55,
            57,60,4,56,70,39,21,71,76,66,
            89,90,94,95,68,96,3,42,91,5,
            24,0,34,5,31,1,35,36,33,7,
            8,9,10,11,17,16,13,15,12,14,
            18,20,19,23,22,32,3,25,26,6,
            27,28,2,30,29,56,0,2,3,40,
            53,1,0,40,24,0,77,5,24,76,
            0,24,69,72,73,64,63,0,4,42,
            34,5,31,1,35,36,33,7,8,9,
            10,11,17,16,13,15,12,14,18,20,
            19,23,22,32,3,25,26,27,28,2,
            30,29,6,0,3,52,62,40,0,2,
            3,0,5,4,62,3,24,40,38,61,
            21,39,0,24,64,63,69,0,59,0,
            65,0,52,0,61,37,5,2,41,47,
            48,38,49,50,51,4,54,55,57,60,
            39,40,1,52,21,46,44,45,43,0,
            5,24,3,0,3,54,60,31,55,57,
            48,50,49,47,38,51,37,5,2,41,
            0,37,5,2,41,38,51,4,56,43,
            70,44,39,21,45,71,46,76,66,89,
            90,91,94,95,68,54,55,57,60,96,
            3,24,42,6,47,48,49,50,0,1,
            58,0,60,0,55,0,38,51,0,37,
            5,0,54,0,57,0,38,62,21,4,
            0,88,0,96,21,0,40,1,5,24,
            67,53,0,66,0,42,94,0,42,1,
            0,97,98,99,100,101,102,3,0,71,
            56,21,0,52,38,0,69,93,0,89,
            0,56,42,21,0,95,68,42,0,80,
            0,4,3,0,70,0,39,61,0,39,
            52,61,21,0,86,0,90,0,78,0,
            92,0,24,59,65,78,80,82,83,84,
            86,92,87,85,81,67,79,74,75,34,
            5,31,1,35,36,33,29,30,27,28,
            6,26,25,32,2,23,22,17,16,13,
            15,12,14,18,20,19,7,8,9,10,
            11,3,0
        };
    };
    public final static char asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static char nasb[] = {0,
            118,22,23,30,23,32,30,52,22,23,
            61,32,126,22,22,22,54,22,22,23,
            23,23,22,40,40,22,23,34,36,36,
            120,125,40,120,125,22,22,22,22,22,
            22,22,22,22,13,22,13,22,124,22,
            125,125,131,125,19,125,22,1,22,124,
            22,22,125,22,125,22,22,22,22,22,
            22,25,22,22,77,22,22,22,22,22,
            18,19,22,22,22,22,22,22,22,22,
            22,22,22,22,104,104,134,22,22,22,
            22,22,22,13,126,19,19,19,19,19,
            22,143,125,13,22,13,125,125,56,22,
            34,22,70,113,128,19,137,19,75,22,
            79,84,94,94,6,6,22,22,22,104,
            104,99,99,99,99,89,49,19,19,1,
            73,22,68,22,13,22,19,22,13,22,
            125,22,22,19,25,45,25,22,25,22,
            75,22,22,22,22,75,22,22,22,22,
            22,22,18,22,22,22,22,22,22,22,
            22,22,22,42,19,125,22,22,22,22,
            22,22,22,22,22,22,19,13,22,11,
            22,22,143,22,13,22,22,19,19,22,
            22,34,22,16,140,19,19,27,19,19,
            65,19,75,22,19,19,22,22,47,111,
            19,13,19,22,18,22,22,19,25,19,
            22,22,22,22,22,25,22,22,22,22,
            22,25,18,19,109,109,22,22,13,13,
            22,22,22,22,22,19,42,19,21,19,
            19,125,21,65,19,21,75,19,13,11,
            19,19,22,22,22,22,22,22,22,25,
            22,22,22,22,59,22,19,19,19,19,
            19,13,22,22,22,22
        };
    };
    public final static char nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            2,7,1,109,0,1,2,7,41,0,
            122,0,69,70,0,72,76,68,2,7,
            1,0,78,0,74,0,7,100,0,106,
            0,107,0,88,0,94,95,105,0,96,
            0,1,76,0,140,0,145,0,2,1,
            56,7,0,84,0,1,72,0,147,0,
            94,95,93,0,1,90,0,144,0,1,
            125,0,143,0,68,0,138,0,1,2,
            7,59,0,1,2,7,53,0,2,7,
            1,50,0,1,2,7,47,0,2,7,
            1,44,0,1,2,7,33,0,121,0,
            146,0,133,134,1,132,0,123,0,4,
            2,108,0,85,2,4,0,131,7,0,
            127,1,0,1,129,0,1,128,0,1,
            137,0,69,117,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,3,185,12,2,34,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            19,95,96,192,32,33,77,78,79,80,
            73,65,66,75,97,112,1,7,18,21,
            4,193,15,17,23,27,5,6,8,9,
            10,20,45,70,71,14,72,13,40,74,
            22,25,39,41,42,47,49,69,184,16,
            24,37,38,43,44,46,48,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,30,67,68,76,100,101,102,103,
            104,105,26,28,29,35,36,98,99,106,
            107,108,109,110,111,113,114,115,116,117,
            118,119,120,121,122,123,124,125,126,127,
            128,129,130,131,132,133,134,135,136,137,
            138,139,140,141,142,143,144,145,146,147,
            148,149,150,151,152,153,154,155,156,157,
            158,159,160,161,162,163,164,165,166,167,
            168,169,170,171,172,173,174,175,176,177,
            178,179,180,181,182,183,186,187,188,189,
            190,191
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            196,195,0,198,0,0,208,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,210,0,0,0,0,213,
            0,0,238,239,0,0,0,0,234,235,
            236,231,232,233,228,229,230,225,226,227,
            222,223,224,219,220,221,216,217,218,202,
            211,214,0,215,199,0,0,244,0,262,
            259,201,212,0,0,203,205,0,0,237,
            0,0,0,258,261,0,0,197,0,204,
            207,0,253,254,255,0,0,206,241,242,
            245,252,0,0,0,256,257,260,0,263,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,194,0,200,209,240,0,
            243,246,247,248,249,250,251,0,0,0,
            0,264,0,0,0,0,0,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            1,295,331,341,229,29,263,271,317,351,
            305,101,101,249,256,13,21,51,140,238,
            289,279,325,39,84,84,244,84,84,84,
            66,72,134,154,158,359,363,367,371,59,
            146,76,168,76,162,76,76,76,76,76,
            46,171,171,179,179,187,187,187,187,201,
            201,209,214,219,224
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            11,70,70,70,70,37,70,70,70,70,
            313,79,118,70,70,19,27,57,70,70,
            70,285,313,44,79,118,70,93,108,124,
            70,70,138,138,70,138,138,70,70,63,
            150,79,70,81,165,89,120,96,112,128,
            48,173,176,181,184,189,192,195,198,203,
            206,211,216,221,226
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            116,24,23,23,26,113,26,26,24,23,
            24,36,36,26,26,115,114,24,67,26,
            26,26,24,112,36,36,26,36,36,36,
            132,132,38,37,66,18,17,6,5,137,
            67,36,34,36,35,36,36,36,36,36,
            109,41,41,44,44,47,47,47,47,50,
            50,53,56,59,63
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static char scopeLa[] = {
            92,4,4,4,4,78,4,4,4,4,
            39,42,68,4,4,86,84,70,4,4,
            4,21,39,80,42,68,4,95,95,95,
            4,4,56,56,4,56,56,4,4,39,
            21,42,4,94,96,94,94,94,94,94,
            5,41,2,5,37,50,49,48,47,51,
            38,54,55,57,60
        };
    };
    public final static char scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            86,23,23,23,23,86,23,23,23,23,
            23,23,23,23,23,86,86,23,89,23,
            23,23,23,86,23,23,23,23,23,23,
            3,3,23,23,89,23,23,5,5,1,
            89,23,23,23,23,23,23,23,23,23,
            86,27,27,29,29,33,33,33,33,35,
            35,36,37,38,39
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            263,339,252,90,252,89,252,88,87,0,
            92,0,263,3,66,252,85,0,86,0,
            338,314,263,252,81,0,84,0,263,313,
            337,3,66,252,67,0,78,0,263,336,
            252,79,0,80,0,302,0,262,301,0,
            252,332,43,330,217,0,70,0,282,61,
            294,0,39,252,0,329,1,326,0,4,
            0,328,1,325,0,252,33,0,260,0,
            94,260,0,293,94,252,33,0,94,293,
            260,0,95,260,0,94,293,95,260,0,
            293,95,293,94,252,33,0,95,293,260,
            0,94,293,95,293,260,0,68,0,94,
            293,68,0,95,293,68,0,94,293,95,
            293,68,0,322,58,22,0,56,0,257,
            21,257,1,22,0,257,1,22,0,21,
            257,4,0,289,58,23,0,257,1,23,
            0,321,34,0,96,252,0,252,1,0,
            232,0,41,225,0,2,225,0,235,0,
            5,233,0,37,233,0,238,0,50,236,
            0,49,236,0,48,236,0,47,236,0,
            241,0,51,239,0,38,239,0,244,0,
            54,242,0,247,0,55,245,0,250,0,
            57,248,0,256,0,60,251,0,271,1,
            266,280,40,196,45,217,0,271,1,280,
            40,196,0,271,1,266,193,0,271,1,
            266,193,45,217,0,271,1,266,317,45,
            217,0,265,21,193,1,193,44,217,0,
            265,21,253,1,193,44,217,0,253,1,
            193,44,217,0,21,265,4,0,252,1,
            193,44,217,0,252,39,268,61,269,1,
            193,44,217,0,268,61,269,1,193,44,
            217,0,39,252,4,0,252,39,268,1,
            193,44,217,0,268,1,193,44,217,0,
            252,39,269,21,264,1,193,44,217,0,
            252,39,269,21,193,1,193,44,217,0,
            252,39,269,1,193,44,217,0,320,58,
            17,0,289,58,194,0,318,1,17,0,
            257,1,194,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            4945,0,4545,0,4938,4931,4916,4909,4895,4885,
            4863,4841,4702,4827,4817,4810,4795,4691,4788,4670,
            4759,4663,4621,4582,4501,4462,541,420,4417,4372,
            4327,4282,4234,4186,4135,4081,1029,4021,3956,3891,
            3826,3761,3696,1408,3631,3566,3501,675,1859,3436,
            3371,3306,1757,1328,1248,2002,3241,3176,3111,3046,
            2981,1664,2916,2851,951,597,2786,1168,1590,2721,
            1488,1088,2656,2591,2526,852,753,2461,2396,2331,
            2266,2201,2136,1933,2071,476,355,0,4938,4931,
            4916,4909,4895,4885,4863,4841,4702,4827,4817,4810,
            4795,4691,4788,4670,4759,4663,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,315,93,270,24,295,298,72,270,24,
            296,299,73,199,287,286,63,64,196,24,
            24,24,276,3,2,3,24,40,270,270,
            1,53,40,1,53,2,300,22,23,17,
            194,3,196,257,257,300,257,4,21,4,
            1,1,1,1,62,52,263,262,261,21,
            4,263,53,2,53,257,257,318,193,319,
            257,193,226,196,217,22,23,199,17,194,
            33,1,231,237,234,243,240,222,249,246,
            256,247,241,235,31,5,34,232,238,244,
            250,254,257,302,75,74,79,67,81,85,
            87,24,53,257,4,257,21,52,21,266,
            40,330,45,44,58,58,58,58,252,252,
            60,55,51,38,5,37,222,321,193,41,
            2,50,49,48,47,54,57,62,38,262,
            334,196,252,252,252,252,88,261,257,263,
            53,263,257,1,280,43,317,196,193,193,
            327,326,325,322,291,323,289,252,290,320,
            193,289,94,222,250,222,244,222,238,238,
            222,232,232,21,96,52,222,235,235,235,
            235,222,241,222,247,335,1,336,66,263,
            66,252,24,263,257,271,265,1,332,3,
            266,40,266,1,1,1,38,21,71,21,
            21,38,293,257,67,53,265,263,3,314,
            82,3,89,263,21,271,252,1,280,1,
            252,268,269,264,253,193,329,193,294,328,
            269,193,95,38,252,337,77,338,83,252,
            263,252,271,266,271,39,61,39,21,21,
            21,52,21,61,39,21,293,76,313,263,
            90,1,252,268,252,269,265,269,265,193,
            257,282,294,263,252,271,39,39,39,39,
            39,339,252,252,252,263
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            ":=",
            "+=",
            "!",
            "::=",
            "?",
            "\\u00AB",
            "$empty",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "STRING_LITERAL",
            "SINGLE_LINE_COMMENT",
            "MULTI_LINE_COMMENT",
            "IMPORT",
            "EXTENSION",
            "AROUND",
            "ENDAROUND",
            "DEFINE",
            "ENDDEFINE",
            "ERROR",
            "EXPAND",
            "FOR",
            "SEPARATOR",
            "AS",
            "ITERATOR",
            "FOREACH",
            "ENDFOREACH",
            "FILE",
            "ENDFILE",
            "IF",
            "ELSEIF",
            "ELSE",
            "ENDIF",
            "LET",
            "ENDLET",
            "PROTECT",
            "CSTART",
            "CEND",
            "ID",
            "DISABLE",
            "ENDPROTECT",
            "self",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "null",
            "invalid",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "OclInvalid",
            "Dict",
            "List",
            "break",
            "switch",
            "case",
            "xselect",
            "xcollect",
            "selectOne",
            "collectOne",
            "collectselect",
            "collectselectOne",
            "forEach",
            "forOne",
            "compute",
            "return",
            "var",
            "while",
            "continue",
            "log",
            "assert",
            "with",
            "new",
            "static",
            "init",
            "end",
            "out",
            "object",
            "transformation",
            "import",
            "library",
            "metamodel",
            "mapping",
            "query",
            "helper",
            "inout",
            "when",
            "configuration",
            "intermediate",
            "property",
            "opposites",
            "class",
            "population",
            "map",
            "xmap",
            "late",
            "resolve",
            "resolveone",
            "resolveIn",
            "resolveoneIn",
            "invresolve",
            "invresolveone",
            "invresolveIn",
            "invresolveoneIn",
            "modeltype",
            "uses",
            "where",
            "refines",
            "access",
            "extends",
            "blackbox",
            "abstract",
            "result",
            "main",
            "this",
            "rename",
            "disjuncts",
            "merges",
            "inherits",
            "composes",
            "constructor",
            "datatype",
            "default",
            "derived",
            "do",
            "elif",
            "enum",
            "except",
            "exception",
            "from",
            "literal",
            "ordered",
            "primitive",
            "raise",
            "readonly",
            "references",
            "tag",
            "try",
            "typedef",
            "unlimited",
            "EOF_TOKEN",
            "IDENTIFIER",
            "STEREOTYPE_QUALIFIER_OPEN",
            "STEREOTYPE_QUALIFIER_CLOSE",
            "MULTIPLICITY_RANGE",
            "TILDE_SIGN",
            "NOT_EQUAL_EXEQ",
            "AT_SIGN",
            "TEXT",
            "ERROR_TOKEN",
            "conceptualOperationNameCS",
            "CollectionTypeIdentifierCS",
            "simpleNameCS",
            "unreservedSimpleNameCS",
            "pathNameCS",
            "typeCS",
            "tupleTypePartsCS",
            "typedUninitializedVariableCS",
            "OclExpressionCS",
            "typedInitializedVariableCS",
            "initializedVariableCS",
            "uninitializedVariableCS",
            "CollectionLiteralPartsCS",
            "CollectionLiteralPartCS",
            "StringLiteralExpCS",
            "TupleLiteralPartsCS",
            "primaryExpCS",
            "notNameExpressionCS",
            "argumentsCS",
            "SimpleNameExpCS",
            "impliesNotNameNotLetCS",
            "impliesNotLetCS",
            "xorNotNameNotLetCS",
            "xorNotLetCS",
            "xorWithLetCS",
            "orNotNameNotLetCS",
            "orNotLetCS",
            "orWithLetCS",
            "andNotNameNotLetCS",
            "andNotLetCS",
            "andWithLetCS",
            "equalityNotNameNotLetCS",
            "equalityNotLetCS",
            "equalityWithLetCS",
            "relationalNotNameNotLetCS",
            "relationalNotLetCS",
            "relationalWithLetCS",
            "additiveNotNameNotLetCS",
            "additiveNotLetCS",
            "additiveWithLetCS",
            "multiplicativeNotNameNotLetCS",
            "multiplicativeNotLetCS",
            "multiplicativeWithLetCS",
            "unaryNotLetCS",
            "unaryWithLetCS",
            "primaryNotNameCS",
            "letVariablesCS",
            "literalSimpleCS",
            "dictLiteralPartCS",
            "dictLiteralPartListCS",
            "qvtErrorToken",
            "ifExpBodyCS",
            "imperativeIterateExpCS",
            "imperativeIteratorExpCSToken12",
            "imperativeIteratorExpCSToken3",
            "imperativeIteratorExpCSToken",
            "imperativeIterContents12",
            "imperativeIterContents3",
            "variableDeclarationListCS",
            "defineOrAroundSeq",
            "define",
            "around",
            "anImport",
            "anExtensionImport",
            "pointcut",
            "sequence",
            "parametersList",
            "parameter",
            "text",
            "statement",
            "definitionName"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
