/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.MetaModelSource;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.gmf.xtend.migration";
    private static Activator plugin;
    private final Set<MetaModelSource> modelSources = new LinkedHashSet<MetaModelSource>();
    private final Map<IProject, RootManager> rootManagers = new HashMap<IProject, RootManager>();
    private final IResourceChangeListener myRootsTracker = new IResourceChangeListener(){

        public synchronized void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta projectDelta;
            if (event == null || event.getDelta() == null) {
                return;
            }
            HashSet<RootManager> affectedRootManagers = new HashSet<RootManager>();
            IResourceDelta rootDelta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = rootDelta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                projectDelta = iResourceDeltaArray[n2];
                IProject affectedProject = (IProject)projectDelta.getResource();
                if (this.isRemovedOrClosed(projectDelta)) {
                    Activator.this.rootManagers.remove(affectedProject);
                } else {
                    IResourceDelta configFileDelta = projectDelta.findMember(RootManager.PROJECT_RELATIVE_PATH_TO_CONFIG_FILE);
                    if (configFileDelta != null && Activator.this.rootManagers.containsKey(affectedProject) && this.affectsConfigFile(configFileDelta)) {
                        affectedRootManagers.add(Activator.getRootManager(affectedProject));
                    }
                }
                ++n2;
            }
            iResourceDeltaArray = rootDelta.getAffectedChildren();
            n = iResourceDeltaArray.length;
            n2 = 0;
            while (n2 < n) {
                projectDelta = iResourceDeltaArray[n2];
                if (this.mayAffectOtherResourceManagers(projectDelta)) {
                    IPath projectPath = projectDelta.getFullPath();
                    for (RootManager nextManager : Activator.this.rootManagers.values()) {
                        if (!nextManager.containsProject(projectPath)) continue;
                        affectedRootManagers.add(nextManager);
                    }
                }
                ++n2;
            }
            for (RootManager nextManager : affectedRootManagers) {
                nextManager.rootsChanged();
            }
        }

        private boolean affectsConfigFile(IResourceDelta configFileDelta) {
            if ((configFileDelta.getKind() & 3) > 0) {
                return true;
            }
            return (configFileDelta.getFlags() & 0x158100) > 0;
        }

        private boolean isRemovedOrClosed(IResourceDelta projectDelta) {
            if (projectDelta.getKind() == 2) {
                return true;
            }
            if ((projectDelta.getFlags() & 0x4000) > 0) {
                return !projectDelta.getResource().isAccessible();
            }
            return false;
        }

        private boolean mayAffectOtherResourceManagers(IResourceDelta projectDelta) {
            if ((projectDelta.getKind() & 3) > 0) {
                return true;
            }
            if ((projectDelta.getFlags() & 0x4000) > 0) {
                return !projectDelta.getResource().isAccessible();
            }
            return false;
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.myRootsTracker);
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.myRootsTracker);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logError(Exception e) {
        if (e instanceof CoreException) {
            Activator.log(((CoreException)((Object)e)).getStatus());
        } else {
            Activator.log((IStatus)new Status(4, Activator.getId(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void logWarn(String message) {
        Activator.log((IStatus)new Status(2, Activator.getId(), 0, message, null));
    }

    private static String getId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static void registerModelSource(MetaModelSource modelSource) {
        assert (modelSource != null);
        Activator.getDefault().modelSources.add(modelSource);
    }

    public static EPackage findMetaModel(String nsURI) {
        if (Activator.getDefault() == null) {
            return null;
        }
        for (MetaModelSource s : Activator.getDefault().modelSources) {
            EPackage p = s.find(nsURI);
            if (p == null) continue;
            return p;
        }
        return EPackage.Registry.INSTANCE.getEPackage(nsURI);
    }

    public static ResourceManager getResourceManager(IFile file) {
        RootManager manager = Activator.getRootManager(file.getProject());
        WorkspaceResourceManager result = manager.getResourceManager(file);
        assert (result != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RootManager getRootManager(IProject project) {
        IResourceChangeListener iResourceChangeListener = Activator.plugin.myRootsTracker;
        synchronized (iResourceChangeListener) {
            RootManager result = Activator.plugin.rootManagers.get(project);
            if (result == null) {
                result = new RootManager(project);
                Activator.plugin.rootManagers.put(project, result);
            }
            return result;
        }
    }
}

