/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelFileSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.RTSetup;
import org.eclipse.gmf.tests.setup.RTSource;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.gmf.tests.setup.annotated.GenASetup;
import org.eclipse.gmf.tests.setup.annotated.GraphDefASetup;
import org.eclipse.gmf.tests.setup.annotated.MapDefASetup;
import org.eclipse.gmf.tests.setup.annotated.ToolDefASetup;

public class LinkEcoreConstraintsTest
extends GeneratedCanvasTest {
    public static final SessionSetup setup = new SessionSetup(new RuntimeBasedGeneratorConfiguration()){
        private DiaGenSource myGenModel;
        private DomainModelSource myDmSource;

        public DomainModelSource getDomainModel() {
            if (this.myDmSource == null) {
                try {
                    URI selected = Plugin.createURI("/models/library/library.ecore");
                    this.myDmSource = new DomainModelFileSetup().init(selected);
                }
                catch (IOException e) {
                    LinkEcoreConstraintsTest.fail((String)("exception: " + e.getMessage()));
                }
            }
            return this.myDmSource;
        }

        public DiaGenSource getGenModel() {
            if (this.myGenModel == null) {
                ToolDefASetup tdmSource = new ToolDefASetup(this.getDomainModel().getModel());
                GraphDefASetup gdmSource = new GraphDefASetup(this.getDomainModel().getModel());
                MapDefASetup mmSource = new MapDefASetup(this.getDomainModel().getModel(), tdmSource.getRegistry(), gdmSource.getCanvasDef());
                this.myGenModel = new GenASetup(mmSource.getMapping(), (ViewmapProducer)new InnerClassViewmapProducer(), false){

                    public GenNode getNodeA() {
                        return (GenNode)this.getGenDiagram().getTopLevelNodes().get(0);
                    }

                    public GenNode getNodeB() {
                        return (GenNode)this.getGenDiagram().getTopLevelNodes().get(1);
                    }

                    public GenLink getLinkD() {
                        return (GenLink)this.getGenDiagram().getLinks().get(0);
                    }
                };
            }
            return this.myGenModel;
        }
    };

    public LinkEcoreConstraintsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.configure(setup);
        super.setUp();
    }

    protected RTSource createCanvasInstance() throws Exception {
        return new RTSetup(){

            protected void initDiagramFileContents(RTSetup.DomainInstanceProducer instanceProducer, DiaGenSource genSource) {
                this.myCanvas = NotationFactory.eINSTANCE.createDiagram();
                this.myDiagramElement = instanceProducer.createInstance(genSource.getGenDiagram().getDomainDiagramElement());
                this.myCanvas.setElement(this.myDiagramElement);
                this.myCanvas.setType(genSource.getGenDiagram().getEditorGen().getModelID());
            }
        }.init(this.getSetup().getGeneratedPlugin(), this.getSetup().getGenModel());
    }

    public void testOppositeBounds() {
        GenLink wroteRef = this.getSetup().getGenModel().getLinkD();
        GenNode writerNode = this.getSetup().getGenModel().getNodeA();
        GenNode bookNode = this.getSetup().getGenModel().getNodeB();
        Node nodeW1 = this.createNode((GenCommonBase)writerNode, (View)this.getDiagram());
        Node nodeB1 = this.createNode((GenCommonBase)bookNode, (View)this.getDiagram());
        LinkEcoreConstraintsTest.assertNotNull((Object)nodeW1);
        LinkEcoreConstraintsTest.assertNotNull((Object)nodeB1);
        Edge link1 = this.createLink(wroteRef, (View)nodeW1, (View)nodeB1);
        LinkEcoreConstraintsTest.assertNotNull((Object)link1);
        Node nodeW2 = this.createNode((GenCommonBase)writerNode, (View)this.getDiagram());
        Edge link2 = this.createLink(wroteRef, (View)nodeW2, (View)nodeB1);
        LinkEcoreConstraintsTest.assertNull((Object)link2);
        Command targetCmd = this.getViewerConfiguration().getCreateLinkCommand((View)nodeW2, (View)nodeB1, (GenCommonBase)wroteRef);
        LinkEcoreConstraintsTest.assertNotNull((Object)targetCmd);
        LinkEcoreConstraintsTest.assertFalse((boolean)targetCmd.canExecute());
    }
}

