/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.labels;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.internal.runtime.lite.Activator;
import org.eclipse.gmf.runtime.lite.edit.parts.labels.AbstractLabelTextDisplayer;
import org.eclipse.gmf.runtime.lite.services.ParserUtil;
import org.eclipse.jface.viewers.ICellEditorValidator;

public abstract class AbstractFeatureBasedLabelTextDisplayer
extends AbstractLabelTextDisplayer
implements ICellEditorValidator {
    private final EStructuralFeature[] myFeatures;
    protected static final String EMPTY_STRING = "";

    public AbstractFeatureBasedLabelTextDisplayer(EStructuralFeature ... features) {
        this.myFeatures = features;
    }

    public String getDisplayText(EObject source) {
        if (source == null) {
            return null;
        }
        Object[] values = this.getValues(source);
        if (values == null) {
            return null;
        }
        String result = this.buildDisplayText(values);
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    public String getEditText(EObject source) {
        if (source == null) {
            return EMPTY_STRING;
        }
        Object[] values = this.getValues(source);
        if (values == null) {
            return EMPTY_STRING;
        }
        String result = this.buildEditText(values);
        if (result == null) {
            return EMPTY_STRING;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] getValues(EObject source) {
        Object[] result = new Object[this.myFeatures.length];
        try {
            int i = 0;
            while (true) {
                if (i >= this.myFeatures.length) {
                    return result;
                }
                result[i] = this.getValidValue(this.myFeatures[i], source.eGet(this.myFeatures[i]));
                if (result[i] == null) {
                    return null;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError("Exception occurred while building text for a label", e);
            return null;
        }
    }

    protected Object getValidValue(EStructuralFeature feature, Object value) {
        EClassifier type;
        if (value == null && (type = feature.getEType()) instanceof EDataType && String.class.equals((Object)type.getInstanceClass())) {
            return EMPTY_STRING;
        }
        return value;
    }

    public boolean isAffectingEvent(Notification notification) {
        if (notification == null || notification.isTouch()) {
            return false;
        }
        Object feature = notification.getFeature();
        EStructuralFeature[] eStructuralFeatureArray = this.myFeatures;
        int n = this.myFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature nextFeature = eStructuralFeatureArray[n2];
            if (nextFeature.equals(feature)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Command getApplyCommand(EObject source, String newValue) {
        Object[] newValues;
        try {
            Object[] parsedValues = this.parseEditedValues(newValue);
            if (parsedValues == null || parsedValues.length != this.myFeatures.length) {
                return UnexecutableCommand.INSTANCE;
            }
            newValues = new Object[this.myFeatures.length];
            int i = 0;
            while (i < this.myFeatures.length) {
                newValues[i] = this.getValidNewValue(this.myFeatures[i], parsedValues[i]);
                ++i;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)source);
        CompoundCommand result = new CompoundCommand();
        int i = 0;
        while (i < this.myFeatures.length) {
            if (this.myFeatures[i].isMany()) {
                BasicEList valuesList = new BasicEList();
                valuesList.addAll((Collection)source.eGet(this.myFeatures[i]));
                result.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)source, (Object)this.myFeatures[i], (Collection)valuesList));
                if (newValues[i] != null) {
                    result.append(AddCommand.create((EditingDomain)editingDomain, (Object)source, (Object)this.myFeatures[i], (Object)newValues[i]));
                }
            } else {
                result.append(SetCommand.create((EditingDomain)editingDomain, (Object)source, (Object)this.myFeatures[i], (Object)(newValues[i] == null ? SetCommand.UNSET_VALUE : newValues[i])));
            }
            ++i;
        }
        return result.unwrap();
    }

    public ICellEditorValidator getValidator() {
        return this;
    }

    public String isValid(Object value) {
        Object[] values;
        if (!(value instanceof String)) {
            return "String value expected";
        }
        String stringValue = (String)value;
        try {
            values = this.parseEditedValues(stringValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "Unable to parse input";
        }
        if (values == null || values.length != this.myFeatures.length) {
            return "Unable to parse input";
        }
        int i = 0;
        while (i < this.myFeatures.length) {
            try {
                this.getValidNewValue(this.myFeatures[i], values[i]);
            }
            catch (IllegalArgumentException e) {
                MessageFormat.format("Invalid input at {0}: {1}", i, e.getLocalizedMessage());
            }
            ++i;
        }
        return null;
    }

    protected Object getValidNewValue(EStructuralFeature structuralFeature, Object value) throws IllegalArgumentException {
        if (EMPTY_STRING.equals(value) && this.shouldReplaceEmptyStringsWithNulls(structuralFeature)) {
            return null;
        }
        if (structuralFeature instanceof EAttribute) {
            return ParserUtil.parseValue((EAttribute)structuralFeature, value);
        }
        return null;
    }

    protected boolean shouldReplaceEmptyStringsWithNulls(EStructuralFeature structuralFeature) {
        return !structuralFeature.isRequired();
    }

    protected EStructuralFeature[] getFeatures() {
        return this.myFeatures;
    }

    protected abstract String buildDisplayText(Object[] var1);

    protected abstract String buildEditText(Object[] var1);

    protected abstract Object[] parseEditedValues(String var1) throws IllegalArgumentException;
}

