/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IContainedEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public abstract class TopGraphicEditPart
extends GraphicalEditPart
implements IContainedEditPart {
    public TopGraphicEditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ConstrainedToolbarLayoutEditPolicy());
    }

    public List getResizableCompartments() {
        ArrayList resizableChildren = new ArrayList();
        for (Object child : this.getChildren()) {
            if (!(child instanceof ResizableCompartmentEditPart)) continue;
            resizableChildren.add(child);
        }
        return resizableChildren;
    }

    public List getResizableNotationViews() {
        View view = this.getNotationView();
        if (view != null) {
            ArrayList<View> resizableChildren = new ArrayList<View>();
            for (View child : view.getChildren()) {
                if (!(child instanceof Node) || ((Node)child).getStyle(NotationPackage.eINSTANCE.getDrawerStyle()) == null) continue;
                resizableChildren.add(child);
            }
            return resizableChildren;
        }
        return Collections.EMPTY_LIST;
    }

    protected void performDirectEditRequest(Request request) {
        TopGraphicEditPart editPart = this;
        if (request instanceof DirectEditRequest) {
            Point p = new Point(((DirectEditRequest)request).getLocation());
            this.getFigure().translateToRelative((Translatable)p);
            IFigure fig = this.getFigure().findFigureAt(p);
            editPart = (EditPart)this.getViewer().getVisualPartMap().get(fig);
        }
        if (editPart == this) {
            try {
                editPart = (EditPart)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                    public void run() {
                        this.setResult(TopGraphicEditPart.this.getPrimaryChildEditPart());
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"performDirectEditRequest", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"performDirectEditRequest", (Throwable)e);
            }
            if (editPart != null) {
                editPart.performRequest(request);
            }
        }
    }

    public boolean understandsRequest(Request req) {
        return "direct edit" == req.getType() || super.understandsRequest(req);
    }
}

