/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DescriptionCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DiagramNameCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateRootEditPartOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramEditPartProvider
extends AbstractEditPartProvider {
    private Map shapeMap = new HashMap();
    private Map textCompartmentMap;
    private Map connectionMap;

    public DiagramEditPartProvider() {
        this.shapeMap.put(ViewType.NOTE, NoteEditPart.class);
        this.shapeMap.put(ViewType.TEXT, TextEditPart.class);
        this.shapeMap.put(ViewType.GROUP, GroupEditPart.class);
        this.textCompartmentMap = new HashMap();
        this.textCompartmentMap.put(ViewType.DIAGRAM_NAME, DiagramNameCompartmentEditPart.class);
        this.textCompartmentMap.put("Description", DescriptionCompartmentEditPart.class);
        this.connectionMap = new HashMap();
        this.connectionMap.put(ViewType.NOTEATTACHMENT, NoteAttachmentEditPart.class);
    }

    protected Class getEdgeEditPartClass(View view) {
        return (Class)this.connectionMap.get(view.getType());
    }

    protected Class getNodeEditPartClass(View view) {
        String type = view.getType();
        Class clazz = null;
        if (type != null && type.length() > 0) {
            clazz = (Class)this.textCompartmentMap.get(type);
            if (clazz == null) {
                clazz = (Class)this.shapeMap.get(type);
            }
        } else if (NotationPackage.eINSTANCE.getDiagram().isSuperTypeOf(DiagramEditPartProvider.getReferencedElementEClass((View)view))) {
            clazz = NoteEditPart.class;
        }
        return clazz;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof CreateRootEditPartOperation) {
            return true;
        }
        return super.provides(operation);
    }

    public RootEditPart createRootEditPart(Diagram diagram) {
        return new DiagramRootEditPart(diagram.getMeasurementUnit());
    }
}

