/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TransformOptions
extends AbstractPreferenceInitializer {
    private static final String PREF_GENERATE_RCP = "generate_rcp";
    private static final String PREF_USE_MAP_MODE = "use_map_mode";
    private static final String PREF_USE_RUNTIME_FIGURES = "use_runtime_figures";
    private static final String PREF_IGNORE_MAPMODEL_VALIDATION = "ignore_mapmodel_validation";
    private static final String PREF_IGNORE_GMFGEN_VALIDATION = "ignore_gmfgen_validation";
    private static final String PREF_FIGURE_TEMPLATES = "dynamic_figure_templates";
    private static final String PREF_MAIN_TRANSFORM = "main-qvto";
    private static final String PREF_PRE_RECONCILE_TRANSFORM = "pre-reconcile-qvto";
    private static final String PREF_POST_RECONCILE_TRANSFORM = "post-reconcile-qvto";
    private static String[] PROP_NAMES = new String[]{"generate_rcp", "use_map_mode", "use_runtime_figures", "ignore_mapmodel_validation", "ignore_gmfgen_validation", "dynamic_figure_templates", "main-qvto", "pre-reconcile-qvto", "post-reconcile-qvto"};
    private Preferences myContextPrefs;
    private Preferences myGlobalPrefs;
    private final HashMap<String, String> myInMemPrefs = new HashMap();

    public void setContext(Preferences contextPrefs) {
        this.myContextPrefs = contextPrefs;
    }

    public void reset() {
        this.myInMemPrefs.clear();
    }

    public void flush() {
        try {
            for (String k : this.myInMemPrefs.keySet()) {
                this.getGlobalPrefs().put(k, this.myInMemPrefs.get(k));
            }
            this.getGlobalPrefs().flush();
            if (this.myContextPrefs != null) {
                String[] stringArray = PROP_NAMES;
                int n = PROP_NAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String k;
                    k = stringArray[n2];
                    String v = this.getWithContexts(k);
                    if (v != null) {
                        this.myContextPrefs.put(k, v);
                    }
                    ++n2;
                }
                this.myContextPrefs.flush();
            }
        }
        catch (BackingStoreException ex) {
            Plugin.log((Exception)((Object)ex));
        }
    }

    public boolean getGenerateRCP() {
        return this.getBoolean(PREF_GENERATE_RCP);
    }

    public boolean getUseMapMode() {
        return this.getBoolean(PREF_USE_MAP_MODE);
    }

    public boolean getUseRuntimeFigures() {
        return this.getBoolean(PREF_USE_RUNTIME_FIGURES);
    }

    public boolean getIgnoreMapModelValidation() {
        return this.getBoolean(PREF_IGNORE_MAPMODEL_VALIDATION);
    }

    public boolean getIgnoreGMFGenValidation() {
        return this.getBoolean(PREF_IGNORE_GMFGEN_VALIDATION);
    }

    public URL getFigureTemplatesPath() {
        return this.getURL(PREF_FIGURE_TEMPLATES);
    }

    public URL getMainTransformation() {
        return this.getURL(PREF_MAIN_TRANSFORM);
    }

    public URL getPreReconcileTransform() {
        return this.getURL(PREF_PRE_RECONCILE_TRANSFORM);
    }

    public URL getPostReconcileTransform() {
        return this.getURL(PREF_POST_RECONCILE_TRANSFORM);
    }

    public void setGenerateRCP(boolean value) {
        this.myInMemPrefs.put(PREF_GENERATE_RCP, Boolean.toString(value));
    }

    public void setUseMapMode(boolean value) {
        this.myInMemPrefs.put(PREF_USE_MAP_MODE, Boolean.toString(value));
    }

    public void setUseRuntimeFigures(boolean value) {
        this.myInMemPrefs.put(PREF_USE_RUNTIME_FIGURES, Boolean.toString(value));
    }

    public void setIgnoreMapModelValidation(boolean value) {
        this.myInMemPrefs.put(PREF_IGNORE_MAPMODEL_VALIDATION, Boolean.toString(value));
    }

    public void setIgnoreGMFGenValidation(boolean value) {
        this.myInMemPrefs.put(PREF_IGNORE_GMFGEN_VALIDATION, Boolean.toString(value));
    }

    public void setFigureTemplatesPath(URL path) {
        if (path == null) {
            this.myInMemPrefs.remove(PREF_FIGURE_TEMPLATES);
        } else {
            this.myInMemPrefs.put(PREF_FIGURE_TEMPLATES, path.toString());
        }
    }

    public void setTransformation(URL path) {
        if (path == null) {
            this.myInMemPrefs.remove(PREF_MAIN_TRANSFORM);
        } else {
            this.myInMemPrefs.put(PREF_MAIN_TRANSFORM, path.toString());
        }
    }

    public void setPreReconcileTransform(URL path) {
        if (path == null) {
            this.myInMemPrefs.remove(PREF_PRE_RECONCILE_TRANSFORM);
        } else {
            this.myInMemPrefs.put(PREF_PRE_RECONCILE_TRANSFORM, path.toString());
        }
    }

    public void setPostReconcileTransform(URL path) {
        if (path == null) {
            this.myInMemPrefs.remove(PREF_POST_RECONCILE_TRANSFORM);
        } else {
            this.myInMemPrefs.put(PREF_POST_RECONCILE_TRANSFORM, path.toString());
        }
    }

    public void initializeDefaultPreferences() {
        Preferences node = TransformOptions.getDefaultPrefs();
        node.putBoolean(PREF_GENERATE_RCP, false);
        node.putBoolean(PREF_USE_MAP_MODE, true);
        node.putBoolean(PREF_USE_RUNTIME_FIGURES, true);
        node.putBoolean(PREF_IGNORE_MAPMODEL_VALIDATION, false);
        node.putBoolean(PREF_IGNORE_GMFGEN_VALIDATION, false);
    }

    static boolean checkLiteOptionPresent() {
        return Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") != null;
    }

    private String getWithContexts(String key) {
        if (this.myInMemPrefs.containsKey(key)) {
            return this.myInMemPrefs.get(key);
        }
        ArrayList<Preferences> scopes = new ArrayList<Preferences>(3);
        if (this.myContextPrefs != null) {
            scopes.add(this.myContextPrefs);
        }
        scopes.add(this.getGlobalPrefs());
        scopes.add(TransformOptions.getDefaultPrefs());
        return Platform.getPreferencesService().get(key, null, scopes.toArray(new Preferences[scopes.size()]));
    }

    private boolean getBoolean(String key) {
        String value = this.getWithContexts(key);
        assert (value != null);
        return Boolean.parseBoolean(value);
    }

    private URL getURL(String key) {
        String value = this.getWithContexts(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException ex) {
            Plugin.log(ex);
            return null;
        }
    }

    private Preferences getGlobalPrefs() {
        if (this.myGlobalPrefs == null) {
            this.myGlobalPrefs = new InstanceScope().getNode(Plugin.getPluginID());
        }
        return this.myGlobalPrefs;
    }

    private static Preferences getDefaultPrefs() {
        return new DefaultScope().getNode(Plugin.getPluginID());
    }
}

