/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.clipboard.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.examples.runtime.emf.clipboard.actions.AbstractClipboardDelegate;
import org.eclipse.gmf.examples.runtime.emf.clipboard.actions.RecordingCommand;
import org.eclipse.gmf.examples.runtime.emf.clipboard.internal.l10n.EMFClipboardMessages;
import org.eclipse.gmf.examples.runtime.emf.clipboard.transfer.EmfTransfer;
import org.eclipse.gmf.examples.runtime.emf.clipboard.transfer.EmfTransferType;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public class PasteDelegate
extends AbstractClipboardDelegate {
    private static final String PROBLEMS_TITLE = EMFClipboardMessages.pasteProblems_title;
    private static final String PROBLEMS_MESSAGE = EMFClipboardMessages.pasteProblems_msg;

    protected void doRun(final Clipboard clipboard) {
        final HashSet objectsPasted = new HashSet();
        EditingDomain domain = this.getEditor().getEditingDomain();
        CompoundCommand command = new CompoundCommand(EMFClipboardMessages.paste_label);
        command.append((Command)new RecordingCommand(domain, "", new Runnable(){

            public void run() {
                PasteDelegate.this.doRun(clipboard, objectsPasted);
            }
        }));
        command.append((Command)new SelectionCommand(objectsPasted));
        domain.getCommandStack().execute((Command)command);
    }

    void doRun(Clipboard clipboard, Collection objectsPasted) {
        boolean problems = false;
        EmfTransferType data = (EmfTransferType)clipboard.getContents((Transfer)EmfTransfer.getInstance());
        if (data != null) {
            Collection pasted;
            EObject target;
            String clipString = data.getString();
            Iterator iter = this.getSelectedObjects().iterator();
            while (iter.hasNext()) {
                target = (EObject)iter.next();
                pasted = ClipboardUtil.pasteElementsFromString((String)clipString, (EObject)target, null, null);
                if (pasted == null || pasted.isEmpty()) {
                    problems = true;
                    continue;
                }
                objectsPasted.addAll(pasted);
            }
            iter = this.getSelectedResources().iterator();
            while (iter.hasNext()) {
                target = (Resource)iter.next();
                pasted = ClipboardUtil.pasteElementsFromString((String)clipString, (Resource)target, null, null);
                if (pasted == null || pasted.isEmpty()) {
                    problems = true;
                    continue;
                }
                objectsPasted.addAll(pasted);
            }
        }
        if (problems) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PROBLEMS_TITLE, (String)PROBLEMS_MESSAGE);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (!action.isEnabled()) {
            action.setEnabled(!this.getSelectedResources().isEmpty());
        }
    }

    private class SelectionCommand
    extends AbstractCommand {
        private Collection elementsToSelect;

        SelectionCommand(Collection elements) {
            this.elementsToSelect = elements;
        }

        public void execute() {
            PasteDelegate.this.selectInEditor(this.elementsToSelect);
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
        }

        protected boolean prepare() {
            return true;
        }

        public void dispose() {
            this.elementsToSelect = null;
        }
    }
}

