/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import org.eclipse.jdt.core.IJavaProject;

/**
 * Represents a Java type reference that may be resolvable in the context of a
 * Java project. This allows us to delay Java type lookup until absolutely
 * necessary.
 * 
 * <p>
 * Clients may implement this interface.
 * </p>
 */
public interface IJavaTypeReference {

	/**
	 * Returns the Java project context.
	 * 
	 * @return Java project context
	 */
	IJavaProject getContext();

	/**
	 * Returns the name of the Java type.
	 * 
	 * @return name of the Java type
	 */
	String getTypeName();
}