/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.net4j.core.Executor;
import org.eclipse.net4j.core.ITempManager;
import org.eclipse.net4j.core.Task;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.IOHelper;
import org.eclipse.net4j.util.UnderlyingIOException;

public class TempManager
extends ServiceImpl
implements ITempManager {
    public static final long DEFAULT_RELEASE_DELAY = 1000L;
    private Executor releaseExecutor;
    private long releaseDelay = 1000L;
    private int releaseTimerCounter = 0;
    private int tempCounter = 0;
    private transient File rootFolder;

    public Executor getReleaseExecutor() {
        return this.releaseExecutor;
    }

    public void setReleaseExecutor(Executor releaseExecutor) {
        this.doSet("releaseExecutor", releaseExecutor);
    }

    public long getReleaseDelay() {
        return this.releaseDelay;
    }

    public void setReleaseDelay(long releaseDelay) {
        this.doSet("releaseDelay", releaseDelay);
    }

    public int getTempCounter() {
        return this.tempCounter;
    }

    public int getReleaseTimerCounter() {
        return this.releaseTimerCounter;
    }

    public File createTempFile(String prefix, String suffix) {
        try {
            String name;
            File temp;
            while ((temp = new File(this.rootFolder, name = this.getTempName(prefix, suffix))).exists() || !temp.createNewFile()) {
            }
            return temp;
        }
        catch (IOException ex) {
            throw new UnderlyingIOException("Could not create temp file", (Throwable)ex);
        }
    }

    public File createTempFile(String prefix) {
        return this.createTempFile(prefix, null);
    }

    public File createTempFile() {
        return this.createTempFile(null);
    }

    public File createTempFolder(String prefix, String suffix) {
        String name;
        File temp;
        while ((temp = new File(this.rootFolder, name = this.getTempName(prefix, suffix))).exists() || !temp.mkdirs()) {
        }
        return temp;
    }

    public File createTempFolder(String prefix) {
        return this.createTempFolder(prefix, null);
    }

    public File createTempFolder() {
        return this.createTempFolder(null);
    }

    public synchronized void release(final File temp) {
        if (temp == null) {
            return;
        }
        if (this.releaseDelay > 0L) {
            Timer timer = new Timer(String.valueOf(this.getFullBeanName()) + ".ReleaseTimer-" + ++this.releaseTimerCounter);
            timer.schedule(new TimerTask(){

                public void run() {
                    TempManager.this.doRelease(temp);
                }
            }, this.releaseDelay);
        } else {
            this.doRelease(temp);
        }
    }

    protected void doRelease(File temp) {
        try {
            this.releaseExecutor.execute(new ReleaseTask(temp), null);
        }
        catch (Exception ex) {
            this.warn("Problem while scheduling release of temp file " + temp, ex);
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("releaseExecutor");
    }

    protected void activate() throws Exception {
        super.activate();
        this.rootFolder = IOHelper.createTempFolder((String)this.getFullBeanName());
    }

    protected void deactivate() throws Exception {
        IOHelper.deleteFile((File)this.rootFolder);
        this.releaseExecutor = null;
        this.rootFolder = null;
        super.deactivate();
    }

    private synchronized String getTempName(String prefix, String suffix) {
        return String.valueOf(prefix == null ? "" : prefix) + ++this.tempCounter + (suffix == null ? ".tmp" : suffix);
    }

    private class ReleaseTask
    implements Task {
        private File temp;

        public ReleaseTask(File temp) {
            this.temp = temp;
        }

        public void execute() throws Exception {
            if (TempManager.this.isDebugEnabled()) {
                TempManager.this.debug("Deleting temp file " + this.temp.getName());
            }
            IOHelper.deleteFile((File)this.temp);
            if (this.temp.exists()) {
                TempManager.this.warn("Could not delete temp file " + this.temp);
                TempManager.this.release(this.temp);
            }
        }
    }
}

