/*******************************************************************************
 * Copyright (c) 2008 - 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Arrays;
import java.util.List;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GenModelItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_MODEL__MODEL_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__EDIT_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__EDITOR_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__TESTS_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__MODEL_PLUGIN_CLASS,
					GenModelPackage.Literals.GEN_MODEL__EDIT_PLUGIN_CLASS,
					GenModelPackage.Literals.GEN_MODEL__EDITOR_PLUGIN_CLASS,
					GenModelPackage.Literals.GEN_MODEL__TEST_SUITE_CLASS,
					GenModelPackage.Literals.GEN_MODEL__ROOT_EXTENDS_INTERFACE,
					GenModelPackage.Literals.GEN_MODEL__ROOT_EXTENDS_CLASS,
					GenModelPackage.Literals.GEN_MODEL__ROOT_IMPLEMENTS_INTERFACE,
					GenModelPackage.Literals.GEN_MODEL__FEATURE_MAP_WRAPPER_INTERFACE,
					GenModelPackage.Literals.GEN_MODEL__FEATURE_MAP_WRAPPER_INTERNAL_INTERFACE,
					GenModelPackage.Literals.GEN_MODEL__FEATURE_MAP_WRAPPER_CLASS,
					GenModelPackage.Literals.GEN_MODEL__PROVIDER_ROOT_EXTENDS_CLASS,
					GenModelPackage.Literals.GEN_MODEL__MODEL_NAME,
					GenModelPackage.Literals.GEN_MODEL__MODEL_PLUGIN_ID);

	public GenModelItemProvider(
			GenModelJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenModel genModel = (GenModel) object;
		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		if (genModel.hasModelPluginClass())
			addType(genModel.getModelDirectory(), genModel
					.getQualifiedModelPluginClassName(), CAT_IMPLEMENTATION,
					Messages.GenModelItemProvider_ModelPluginClassLabel,
					Messages.GenModelItemProvider_ModelPluginClassDescription,
					GenModelPackage.Literals.GEN_MODEL__MODEL_PLUGIN_CLASS,
					true, list);

		if (genModel.hasEditSupport())
			addType(genModel.getEditDirectory(), genModel
					.getQualifiedEditPluginClassName(), CAT_PROVIDER,
					Messages.GenModelItemProvider_EditPluginClassLabel,
					Messages.GenModelItemProvider_EditPluginClassDescription,
					GenModelPackage.Literals.GEN_MODEL__EDIT_PLUGIN_CLASS,
					true, list);

		if (genModel.hasEditorSupport()) {
			addType(genModel.getEditorDirectory(), genModel
					.getQualifiedEditorPluginClassName(), CAT_PRESENTATION,
					Messages.GenModelItemProvider_EditorPluginClassLabel,
					Messages.GenModelItemProvider_EditorPluginClassDescription,
					GenModelPackage.Literals.GEN_MODEL__EDITOR_PLUGIN_CLASS,
					true, list);
			if (genModel.isRichClientPlatform())
				addType(
						genModel.getEditorDirectory(),
						genModel.getQualifiedEditorAdvisorClassName(),
						CAT_PRESENTATION,
						Messages.GenModelItemProvider_EditorAdvisorClassLabel,
						Messages.GenModelItemProvider_EditorAdvisorClassDescription,
						null, true, list);
		}

		if (genModel.hasTestSupport() && genModel.hasTestSuiteClass())
			addType(genModel.getTestsDirectory(), genModel
					.getQualifiedTestSuiteClassName(), CAT_TEST,
					Messages.GenModelItemProvider_TestSuiteLabel,
					Messages.GenModelItemProvider_TestSuiteDescription,
					GenModelPackage.Literals.GEN_MODEL__TEST_SUITE_CLASS, true,
					list);

		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IPath path = new Path(genModel.getModelProjectDirectory());
		IJavaProject ctx = JavaCore.create(root.getProject(path.segment(0)));

		addType(ctx, genModel.getRootExtendsInterface(), CAT_INTERFACE,
				Messages.GenModelItemProvider_RootExtendsInterfaceLabel,
				Messages.GenModelItemProvider_RootExtendsInterfaceDescription,
				GenModelPackage.Literals.GEN_MODEL__ROOT_EXTENDS_INTERFACE,
				list);
		addType(ctx, genModel.getRootExtendsClass(), CAT_IMPLEMENTATION,
				Messages.GenModelItemProvider_RootExtendsClassLabel,
				Messages.GenModelItemProvider_RootExtendsClassDescription,
				GenModelPackage.Literals.GEN_MODEL__ROOT_EXTENDS_INTERFACE,
				list);
		addType(
				ctx,
				genModel.getRootImplementsInterface(),
				CAT_INTERFACE,
				Messages.GenModelItemProvider_RootImplementsInterfaceLabel,
				Messages.GenModelItemProvider_RootImplementsInterfaceDescription,
				GenModelPackage.Literals.GEN_MODEL__ROOT_IMPLEMENTS_INTERFACE,
				list);

		path = new Path(genModel.getEditProjectDirectory());
		ctx = JavaCore.create(root.getProject(path.segment(0)));

		addType(
				ctx,
				genModel.getProviderRootExtendsClass(),
				CAT_PROVIDER,
				Messages.GenModelItemProvider_ProviderRootExtendsClassLabel,
				Messages.GenModelItemProvider_ProviderRootExtendsClassDescription,
				GenModelPackage.Literals.GEN_MODEL__PROVIDER_ROOT_EXTENDS_CLASS,
				list);

		return list;
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new ObservedFeatureGenModelSwitch() {
			@Override
			public List<EStructuralFeature> caseGenModel(GenModel object) {
				return OBSERVED_FEATURES;
			}
		};
	}
}
