/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.cdo.client.MappingProvider;
import org.eclipse.emf.cdo.mapping.AttributeMapping;
import org.eclipse.emf.cdo.mapping.ClassMapping;
import org.eclipse.emf.cdo.mapping.PackageMapping;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;

public class XMLMappingProviderImpl
implements MappingProvider {
    protected PackageMapping packageMapping;

    public XMLMappingProviderImpl(String fileName) throws IOException {
        this.loadMappingModel(fileName);
    }

    public PackageMapping getPackageMapping() {
        return this.packageMapping;
    }

    public ClassMapping getClassMapping(String className) {
        return this.packageMapping.getClassMapping(className);
    }

    public AttributeMapping getAttributeMapping(String className, String attributeName) {
        ClassMapping classMapping = this.packageMapping.getClassMapping(className);
        if (classMapping == null) {
            return null;
        }
        return classMapping.getAttributeMapping(attributeName);
    }

    protected void loadMappingModel(String fileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("xml", new XMLResourceFactoryImpl());
        URI uri = URI.createFileURI((String)fileName);
        Resource resource = resourceSet.createResource(uri);
        resource.load(Collections.EMPTY_MAP);
        this.packageMapping = (PackageMapping)resource.getContents().get(0);
    }
}

