/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class DirectoryCleaner
extends AbstractWorkflowComponent2 {
    private static final String COMPONENT_NAME = "Directory Cleaner";
    private static final Log LOG = LogFactory.getLog(DirectoryCleaner.class);
    private String directory;
    private final Collection<String> excludes = new HashSet<String>();
    private final Collection<String> defaultExcludes = Arrays.asList("CVS", ".cvsignore", ".svn");
    private boolean useDefaultExcludes = true;

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getLogMessage() {
        return "cleaning directory '" + this.directory + "'";
    }

    protected void invokeInternal(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        if (this.directory != null) {
            StringTokenizer st = new StringTokenizer(this.directory, ",");
            while (st.hasMoreElements()) {
                String dir = st.nextToken().trim();
                File f = new File(dir);
                if (!f.exists() || !f.isDirectory()) continue;
                LOG.info((Object)("Cleaning " + f.getAbsolutePath()));
                try {
                    this.cleanFolder(f.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    issues.addError(e.getMessage());
                }
            }
        }
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.directory == null) {
            issues.addWarning("No directories specified!");
        }
    }

    public void cleanFolder(String srcGenPath) throws FileNotFoundException {
        File f = new File(srcGenPath);
        if (!f.exists()) {
            throw new FileNotFoundException(String.valueOf(srcGenPath) + " " + f.getAbsolutePath());
        }
        LOG.debug((Object)("Cleaning folder " + f.getPath()));
        this.cleanFolder(f, new FileFilter(){

            public boolean accept(File path) {
                return !DirectoryCleaner.this.isExcluded(path);
            }
        }, false, false);
    }

    public boolean isExcluded(File path) {
        if (this.useDefaultExcludes && this.defaultExcludes.contains(path.getName())) {
            return true;
        }
        return this.excludes.contains(path.getName());
    }

    public boolean cleanFolder(File parentFolder, FileFilter filter, boolean continueOnError, boolean deleteParentFolder) throws FileNotFoundException {
        if (!parentFolder.exists()) {
            throw new FileNotFoundException(parentFolder.getAbsolutePath());
        }
        FileFilter myFilter = filter;
        if (myFilter == null) {
            myFilter = new FileFilter(){

                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        LOG.debug((Object)("Cleaning folder " + parentFolder.toString()));
        File[] contents = parentFolder.listFiles(myFilter);
        int j = 0;
        while (j < contents.length) {
            File file = contents[j];
            if (file.isDirectory()) {
                if (!this.cleanFolder(file, myFilter, continueOnError, false) && !continueOnError) {
                    return false;
                }
            } else if (!file.delete()) {
                LOG.error((Object)("Couldn't delete " + file.getAbsolutePath()));
                if (!continueOnError) {
                    return false;
                }
            }
            ++j;
        }
        if (deleteParentFolder && !parentFolder.delete()) {
            LOG.error((Object)("Couldn't delete " + parentFolder.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

