/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.filter;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.match.filter.IResourceFilter;
import org.eclipse.emf.compare.match.internal.filter.ResourceFilterRegistryEclipseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceFilterRegistry {
    public static final ResourceFilterRegistry INSTANCE = new ResourceFilterRegistry();
    private final Set<IResourceFilter> registeredFilters = new LinkedHashSet<IResourceFilter>();

    private ResourceFilterRegistry() {
    }

    public void addFilter(IResourceFilter filter) {
        this.registeredFilters.add(filter);
    }

    public void removeFilter(IResourceFilter filter) {
        this.registeredFilters.remove(filter);
    }

    public void clearRegistry() {
        this.registeredFilters.clear();
    }

    public Set<IResourceFilter> getRegisteredResourceFilters() {
        LinkedHashSet<IResourceFilter> compound = new LinkedHashSet<IResourceFilter>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            compound.addAll(ResourceFilterRegistryEclipseUtil.getRegisteredResourceFilters());
        }
        compound.addAll(this.registeredFilters);
        return compound;
    }
}

