/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.dyncheck;

import java.util.Iterator;

import org.eclipse.emf.codegen.jet.editor.presentation.JETTextEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

/**
 * @author Joel
 * @version $Revision: 1.2 $
 */
public class JETTextHover implements ITextHover {

  private IEditorPart editor;
  
  /**
   * Constructor for JETTextHover.
   * @param editor IEditorPart
   */
  public JETTextHover(IEditorPart editor) {
    this.editor = editor;
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.text.ITextHover#getHoverInfo(org.eclipse.jface.text.ITextViewer, org.eclipse.jface.text.IRegion)
   */
  public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
    if (editor == null)
      return null;

    IDocumentProvider provider = ((JETTextEditor)editor).getDocumentProvider();
    IAnnotationModel model = provider.getAnnotationModel(getEditor().getEditorInput());

    if (model != null) {
      Iterator e = model.getAnnotationIterator();
      while (e.hasNext()) {
        Annotation a = (Annotation)e.next();
        Position p = model.getPosition(a);
        if (p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength())) {
          if (a instanceof JETProblemAnnotation) {
            String msg = ((JETProblemAnnotation)a).getText();
            if (msg != null && msg.trim().length() > 0)
              return msg;
          }
        }
      }
    }
    return null;
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.text.ITextHover#getHoverRegion(org.eclipse.jface.text.ITextViewer, int)
   */
  public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
    return JavaWordFinder.findWord(textViewer.getDocument(), offset);
  }

  /**
   * @return IEditorPart
   */
  public IEditorPart getEditor() {
    return editor;
  }

}
