/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.text.typesystem;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.text.henshin_text.AndExpression;
import org.eclipse.emf.henshin.text.henshin_text.BoolValue;
import org.eclipse.emf.henshin.text.henshin_text.BracketExpression;
import org.eclipse.emf.henshin.text.henshin_text.ComparisonExpression;
import org.eclipse.emf.henshin.text.henshin_text.EqualityExpression;
import org.eclipse.emf.henshin.text.henshin_text.Expression;
import org.eclipse.emf.henshin.text.henshin_text.IntegerValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaAttributeValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaClassValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaImport;
import org.eclipse.emf.henshin.text.henshin_text.MinusExpression;
import org.eclipse.emf.henshin.text.henshin_text.MulOrDivExpression;
import org.eclipse.emf.henshin.text.henshin_text.MultiRule;
import org.eclipse.emf.henshin.text.henshin_text.NaturalValue;
import org.eclipse.emf.henshin.text.henshin_text.NotExpression;
import org.eclipse.emf.henshin.text.henshin_text.NumberValue;
import org.eclipse.emf.henshin.text.henshin_text.OrExpression;
import org.eclipse.emf.henshin.text.henshin_text.ParameterType;
import org.eclipse.emf.henshin.text.henshin_text.ParameterValue;
import org.eclipse.emf.henshin.text.henshin_text.PlusExpression;
import org.eclipse.emf.henshin.text.henshin_text.Rule;
import org.eclipse.emf.henshin.text.henshin_text.StringValue;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textBoolType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textComplexType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textNumberType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textStringType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textType;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Henshin_textTypeProvider {
    public static final Henshin_textStringType stringType = new Henshin_textStringType();
    public static final Henshin_textNumberType numberType = new Henshin_textNumberType();
    public static final Henshin_textBoolType boolType = new Henshin_textBoolType();
    public static final Henshin_textComplexType complexType = new Henshin_textComplexType();

    public Henshin_textType typeFor(Expression expression) {
        boolean _matched = false;
        if (expression instanceof StringValue) {
            _matched = true;
            return stringType;
        }
        if (!_matched && expression instanceof NumberValue) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof IntegerValue) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof NaturalValue) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof BoolValue) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof OrExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof AndExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof EqualityExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof ComparisonExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof PlusExpression) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof MinusExpression) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof MulOrDivExpression) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof BracketExpression) {
            _matched = true;
            return this.typeFor(((BracketExpression)expression).getExpression());
        }
        if (!_matched && expression instanceof NotExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof ParameterValue) {
            _matched = true;
            return this.typeFor(((ParameterValue)expression).getValue().getType());
        }
        if (!_matched && expression instanceof JavaClassValue) {
            _matched = true;
            return this.typeFor((JavaClassValue)expression);
        }
        if (!_matched && expression instanceof JavaAttributeValue) {
            _matched = true;
            return this.typeFor((JavaAttributeValue)expression);
        }
        return null;
    }

    public Henshin_textType typeFor(JavaAttributeValue javaAttribute) {
        EObject container = javaAttribute.eContainer();
        while (!(container instanceof Rule) && !(container instanceof MultiRule)) {
            container = container.eContainer();
        }
        Iterable iterableOfJavaImportImpl = null;
        iterableOfJavaImportImpl = container instanceof Rule ? Iterables.filter(((Rule)container).getRuleElements(), JavaImport.class) : Iterables.filter(((MultiRule)container).getMultiruleElements(), JavaImport.class);
        for (JavaImport imports : iterableOfJavaImportImpl) {
            try {
                Field[] _declaredFields;
                String _packagename = imports.getPackagename();
                String _plus = String.valueOf(_packagename) + ".";
                String _get = javaAttribute.getValue().split("\\.")[0];
                String _plus_1 = String.valueOf(_plus) + _get;
                Class<?> calledClass = Class.forName(_plus_1);
                Field[] fieldArray = _declaredFields = calledClass.getDeclaredFields();
                int n = _declaredFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String _get_1;
                    Field atrib = fieldArray[n2];
                    String _name = atrib.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_get_1 = javaAttribute.getValue().split("\\.")[1]));
                    if (_equals) {
                        return this.typeForJavaType(atrib.getType().getName());
                    }
                    ++n2;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return stringType;
    }

    public Henshin_textType typeFor(JavaClassValue javaCall) {
        EObject container = javaCall.eContainer();
        while (!(container instanceof Rule) && !(container instanceof MultiRule)) {
            container = container.eContainer();
        }
        Iterable iterableOfJavaImportImpl = null;
        iterableOfJavaImportImpl = container instanceof Rule ? Iterables.filter(((Rule)container).getRuleElements(), JavaImport.class) : Iterables.filter(((MultiRule)container).getMultiruleElements(), JavaImport.class);
        for (JavaImport imports : iterableOfJavaImportImpl) {
            try {
                Method[] _methods;
                String _packagename = imports.getPackagename();
                String _plus = String.valueOf(_packagename) + ".";
                String _get = javaCall.getValue().split("\\.")[0];
                String _plus_1 = String.valueOf(_plus) + _get;
                Class<?> calledClass = Class.forName(_plus_1);
                Method[] methodArray = _methods = calledClass.getMethods();
                int n = _methods.length;
                int n2 = 0;
                while (n2 < n) {
                    String _get_1;
                    Method methode = methodArray[n2];
                    String _name = methode.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_get_1 = javaCall.getValue().split("\\.")[1]));
                    if (_equals) {
                        return this.typeForJavaType(methode.getReturnType().getName());
                    }
                    ++n2;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return stringType;
    }

    public Henshin_textType typeForJavaType(String className) {
        boolean _matched = false;
        if (Objects.equal((Object)className, (Object)"java.lang.Boolean")) {
            _matched = true;
            return boolType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"boolean")) {
            _matched = true;
            return boolType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.Byte")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"byte")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.Character")) {
            _matched = true;
            return stringType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"char")) {
            _matched = true;
            return stringType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.Double")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"double")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.Float")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"float")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.Integer")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"int")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.Long")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"long")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.Short")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"short")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"java.lang.String")) {
            _matched = true;
            return stringType;
        }
        if (!_matched && Objects.equal((Object)className, (Object)"string")) {
            _matched = true;
            return stringType;
        }
        return complexType;
    }

    public Henshin_textType typeFor(ParameterType parameterType) {
        EClass _type = parameterType.getType();
        boolean _equals = Objects.equal((Object)_type, null);
        if (_equals) {
            return this.typeFor(parameterType.getEnumType().getLiteral());
        }
        return complexType;
    }

    public Henshin_textType typeFor(String eType) {
        boolean _matched = false;
        if (Objects.equal((Object)eType, (Object)"EBigDecimal")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EBigInteger")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EBoolean")) {
            _matched = true;
            return boolType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EBooleanObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EByte")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EByteArray")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EByteObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EChar")) {
            _matched = true;
            return stringType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"ECharacterObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EDate")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EDiagnosticChain")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EDouble")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EDoubleObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EEList")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EEnumerator")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EFeatureMap")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EFeatureMapEntry")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EFloat")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EFloatObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EInt")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EIntegerObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"ETreeIterator")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EInvocationTargetException")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EJavaClass")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EJavaObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"ELong")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"ELongObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EMap")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EResource")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EResourceSet")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EShort")) {
            _matched = true;
            return numberType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EShortObject")) {
            _matched = true;
            return complexType;
        }
        if (!_matched && Objects.equal((Object)eType, (Object)"EString")) {
            _matched = true;
            return stringType;
        }
        return null;
    }

    public boolean isInt(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)numberType);
    }

    public boolean isString(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)stringType);
    }

    public boolean isBoolean(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)boolType);
    }

    public boolean isComplex(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)complexType);
    }
}

