/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;

public class StateSpaceTypesHelper {
    public static List<EClass> getTypes(StateSpace stateSpace) {
        ArrayList<EClass> types = new ArrayList<EClass>();
        for (Rule rule : stateSpace.getRules()) {
            for (EPackage pack : rule.getModule().getImports()) {
                for (EClassifier type : pack.getEClassifiers()) {
                    if (!(type instanceof EClass) || types.contains(type)) continue;
                    types.add((EClass)type);
                }
            }
        }
        return types;
    }

    public static Map<String, EClass> getTypesNameMap(StateSpace stateSpace) {
        LinkedHashMap<String, EClass> typesMap = new LinkedHashMap<String, EClass>();
        for (EClass type : StateSpaceTypesHelper.getTypes(stateSpace)) {
            typesMap.put(type.getName(), type);
        }
        return typesMap;
    }

    public static Map<String, EAttribute> getAttributesNameMap(StateSpace stateSpace) {
        LinkedHashMap<String, EAttribute> attributes = new LinkedHashMap<String, EAttribute>();
        for (EClass type : StateSpaceTypesHelper.getTypes(stateSpace)) {
            for (EAttribute att : type.getEAllAttributes()) {
                attributes.put(String.valueOf(type.getName()) + "." + att.getName(), att);
            }
        }
        return attributes;
    }
}

