/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.util;

import graph.Graph;
import graph.GraphFactory;
import graph.Node;
import java.util.HashMap;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Parameter;

public class GraphAdapter {
    private static final String VAR = "var";
    private org.eclipse.emf.henshin.model.Graph henshinGraph;
    private Graph graph;
    private EPackage typeModel;
    private HashMap<org.eclipse.emf.henshin.model.Node, Node> nodeMappingsFromHenshin;
    private HashMap<Node, org.eclipse.emf.henshin.model.Node> nodeMappingsToHenshin;
    private final GraphFactory factory = GraphFactory.eINSTANCE;
    private final HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
    public HashMap<Parameter, graph.Attribute> henVarMappingsToNcAttribute;

    public GraphAdapter(org.eclipse.emf.henshin.model.Graph henshinGraph, EPackage typeModel) {
        this.henshinGraph = henshinGraph;
        this.graph = this.factory.createGraph();
        this.typeModel = typeModel;
        this.nodeMappingsFromHenshin = new HashMap();
        this.henVarMappingsToNcAttribute = new HashMap();
    }

    public GraphAdapter(Graph graph) {
        this.henshinGraph = this.henshinFactory.createGraph();
        this.graph = graph;
        this.nodeMappingsToHenshin = new HashMap();
        this.henVarMappingsToNcAttribute = new HashMap();
    }

    public void adaptToHenshin() {
        this.adaptNodesWithAttributesToHenshin();
        this.adaptEdgesToHenshin();
    }

    private void adaptEdgesToHenshin() {
        for (graph.Edge edge : this.graph.getEdges()) {
            Edge henshinEdge = this.henshinFactory.createEdge();
            henshinEdge.setType(edge.getType());
            henshinEdge.setSource(this.nodeMappingsToHenshin.get(edge.getSource()));
            henshinEdge.setTarget(this.nodeMappingsToHenshin.get(edge.getTarget()));
            this.henshinGraph.getEdges().add((Object)henshinEdge);
        }
    }

    private void adaptNodesWithAttributesToHenshin() {
        for (Node ncNode : this.graph.getNodes()) {
            org.eclipse.emf.henshin.model.Node henshinNode = this.henshinFactory.createNode();
            henshinNode.setType(ncNode.getType());
            henshinNode.setName(ncNode.getName());
            if (ncNode.getAttributes().size() > 0) {
                for (graph.Attribute ncAttribute : ncNode.getAttributes()) {
                    Attribute henshinAttribute = this.henshinFactory.createAttribute();
                    henshinAttribute.setType(ncAttribute.getType());
                    if (ncAttribute.getOp().isEmpty() || ncAttribute.getOp().contentEquals("=")) {
                        henshinAttribute.setValue(ncAttribute.getValue());
                    } else if (!ncAttribute.getOp().isEmpty()) {
                        Parameter henVar = this.henshinFactory.createParameter();
                        String nodeName = ncNode.getName();
                        if (nodeName.contains("=")) {
                            nodeName = nodeName.substring(0, nodeName.indexOf("="));
                        }
                        henVar.setName(VAR + nodeName.toUpperCase() + ncAttribute.getType().getName());
                        henshinAttribute.setValue(henVar.getName());
                        if (!this.henVarMappingsToNcAttribute.containsKey(henVar)) {
                            this.henVarMappingsToNcAttribute.put(henVar, ncAttribute);
                        }
                    }
                    henshinNode.getAttributes().add((Object)henshinAttribute);
                }
            }
            this.nodeMappingsToHenshin.put(ncNode, henshinNode);
            this.henshinGraph.getNodes().add((Object)henshinNode);
        }
    }

    public void adaptFromHenshin() {
        this.graph.setTypegraph(this.typeModel);
        this.adaptNodesWithAttributesFromHenshin();
        this.adaptEdgesFromHenshin();
    }

    private void adaptEdgesFromHenshin() {
        for (Edge henshinEdge : this.henshinGraph.getEdges()) {
            graph.Edge edge = this.factory.createEdge();
            edge.setType(henshinEdge.getType());
            edge.setSource(this.nodeMappingsFromHenshin.get(henshinEdge.getSource()));
            edge.setTarget(this.nodeMappingsFromHenshin.get(henshinEdge.getTarget()));
            this.graph.getEdges().add((Object)edge);
        }
    }

    private void adaptNodesWithAttributesFromHenshin() {
        for (org.eclipse.emf.henshin.model.Node henshinNode : this.henshinGraph.getNodes()) {
            Node node = this.factory.createNode();
            node.setType(henshinNode.getType());
            node.setName(henshinNode.getName());
            this.nodeMappingsFromHenshin.put(henshinNode, node);
            for (Attribute henAttribute : henshinNode.getAttributes()) {
                graph.Attribute ncAttribute = this.factory.createAttribute();
                ncAttribute.setType(henAttribute.getType());
                ncAttribute.setValue(henAttribute.getValue());
                ncAttribute.setOp("=");
                node.getAttributes().add((Object)ncAttribute);
            }
            this.graph.getNodes().add((Object)node);
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public org.eclipse.emf.henshin.model.Graph getHenshinGraph() {
        return this.henshinGraph;
    }
}

