/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.framework;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.multicda.cda.ConflictAnalysis;
import org.eclipse.emf.henshin.multicda.cda.framework.NullPrintStream;
import org.eclipse.emf.henshin.multicda.cda.framework.Options;
import org.eclipse.emf.henshin.multicda.cda.framework.Worker;
import org.eclipse.emf.henshin.multicda.cpa.CDAOptions;
import org.eclipse.emf.henshin.multicda.cpa.CpaByAGG;
import org.eclipse.emf.henshin.multicda.cpa.UnsupportedRuleException;
import org.eclipse.emf.henshin.multicda.cpa.result.CPAResult;
import org.eclipse.emf.henshin.multicda.cpa.result.Conflict;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalElement;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalPair;
import org.eclipse.emf.henshin.multicda.cpa.result.Dependency;
import org.eclipse.emf.henshin.preprocessing.NonDeletingPreparator;
import org.eclipse.emf.henshin.preprocessing.RulePreparator;

public class CpaWorker
extends Worker {
    private CpaByAGG cpa;
    private CPAResult result;
    private Options options = new Options(new boolean[0]);

    public CpaWorker(String henshin, String[] rules, Options ... options) {
        this(henshin, rules, rules, options);
    }

    public CpaWorker(List<Rule> rules, Options ... options) {
        this(rules, rules, options);
    }

    public CpaWorker(String henshin, Options ... options) {
        this(henshin, new String[0], new String[0], options);
    }

    public CpaWorker(List<Rule> first, List<Rule> second, Options ... options) {
        this.init(first, second, false, false, options);
    }

    public CpaWorker(String henshin, String[] first, String[] second, Options ... options) {
        Rule rule;
        String r = henshin.substring(0, henshin.lastIndexOf("/") + 1);
        String m = henshin.substring(henshin.lastIndexOf("/") + 1, henshin.length());
        HenshinResourceSet resourceSet = new HenshinResourceSet(r);
        Module module = resourceSet.getModule(m, false);
        ArrayList<Rule> f = new ArrayList<Rule>();
        ArrayList<Rule> s = new ArrayList<Rule>();
        Object object = first;
        int n = first.length;
        int n2 = 0;
        while (n2 < n) {
            String firstRule = object[n2];
            rule = (Rule)module.getUnit(firstRule);
            if (rule == null) {
                System.err.println("Rule " + firstRule + " not found");
                return;
            }
            f.add(rule);
            ++n2;
        }
        object = second;
        n = second.length;
        n2 = 0;
        while (n2 < n) {
            String secondRule = object[n2];
            rule = (Rule)module.getUnit(secondRule);
            if (rule == null) {
                System.err.println("Rule " + secondRule + " not found");
                return;
            }
            s.add(rule);
            ++n2;
        }
        if (f.isEmpty()) {
            f = new ArrayList(s);
        }
        if (s.isEmpty()) {
            s = new ArrayList(f);
        }
        boolean firstAll = false;
        boolean secondAll = false;
        if (f.isEmpty()) {
            firstAll = true;
            for (Unit u : module.getUnits()) {
                if (!(u instanceof Rule)) continue;
                f.add((Rule)u);
            }
        }
        if (s.isEmpty()) {
            secondAll = true;
            for (Unit u : module.getUnits()) {
                if (!(u instanceof Rule)) continue;
                s.add((Rule)u);
            }
        }
        this.init(f, s, firstAll, secondAll, options);
    }

    private void init(List<Rule> first, List<Rule> second, boolean firstAll, boolean secondAll, Options ... opt) {
        if (opt.length != 0) {
            this.options = opt[0];
        }
        String ff = "";
        String ss = "";
        if (firstAll) {
            ff = "All";
        } else {
            for (Rule nameF : first) {
                ff = String.valueOf(ff) + (ff.isEmpty() ? "" : ", ") + nameF.getName();
            }
        }
        if (secondAll) {
            ss = "All";
        } else {
            for (Rule nameS : second) {
                ss = String.valueOf(ss) + (ss.isEmpty() ? "" : ", ") + nameS.getName();
            }
        }
        for (Rule r1 : first) {
            r1 = ConflictAnalysis.prepare(r1);
        }
        for (Rule r2 : second) {
            r2 = ConflictAnalysis.prepare(r2);
        }
        CDAOptions o = new CDAOptions();
        o.essentialCP = this.options.is(2) || this.options.is(4);
        o.setReduceSameRuleAndSameMatch(false);
        o.setIgnoreSameRules(false);
        o.setIgnoreMultiplicities(true);
        this.cpa = new CpaByAGG();
        this.NAME = "CPA Tester";
        try {
            if (this.options.is(8)) {
                first = RulePreparator.prepareRule(first);
                second = RulePreparator.prepareRule(second);
            }
            if (this.options.is(16)) {
                second = NonDeletingPreparator.prepareNoneDeletingsVersionsRules(second);
            }
            this.cpa.init(new HashSet<Rule>(first), new HashSet<Rule>(second), o);
        }
        catch (UnsupportedRuleException e) {
            System.err.println(e.getMessage());
        }
        PrintStream original = System.out;
        if (this.options.is(128)) {
            System.setOut(new NullPrintStream());
        }
        this.result = this.options.is(1) ? this.cpa.runDependencyAnalysis() : this.cpa.runConflictAnalysis();
        if (this.options.is(128)) {
            System.setOut(original);
        }
        if (!(!this.options.is(32) || this.options.is(256) && this.getResult().isEmpty())) {
            System.out.println("\n\t\t  " + ff + " --> " + ss + "\n\t\t\tCPA " + (this.options.is(2) ? "Essential" : ""));
            this.print(this.options + "\n", new boolean[0]);
        }
        if (this.options.is(32) && this.options.is(64) && (!this.options.is(256) || !this.getResult().isEmpty())) {
            this.printResult();
            this.print();
            System.out.println();
        }
    }

    private void printResult() {
        CpaWorker.printCP(this.getResult(), new boolean[0]);
    }

    public Set<CriticalPair> getResult() {
        if (this.result != null) {
            if (this.options.is(2)) {
                return new HashSet<CriticalPair>(this.result.getEssentialCriticalPairs());
            }
            if (this.options.is(4)) {
                return new HashSet<CriticalPair>(this.result.getInitialCriticalPairs());
            }
            return new HashSet<CriticalPair>(this.result.getCriticalPairs());
        }
        return new HashSet<CriticalPair>();
    }

    public String toString() {
        if (!this.options.is(1)) {
            return String.valueOf(this.getResult().size()) + " Critical Pairs.";
        }
        return String.valueOf(this.getResult().size()) + " Dependency Critical Pairs.";
    }

    public static String printCP(Set<CriticalPair> cp, boolean ... errorOut) {
        String result = "";
        for (CriticalPair criticalPair : cp) {
            criticalPair.getMinimalModel();
            String criticalPairKind = "";
            if (criticalPair instanceof Conflict) {
                criticalPairKind = ((Conflict)criticalPair).getConflictKind().toString();
            } else if (criticalPair instanceof Dependency) {
                criticalPairKind = ((Dependency)criticalPair).getDependencyKind().toString();
            }
            String r = "";
            for (CriticalElement e : criticalPair.getCriticalElements()) {
                r = String.valueOf(r) + ", [" + e + "]";
            }
            result = String.valueOf(result) + criticalPairKind + ": " + r.substring(2) + "\n";
        }
        if (errorOut.length <= 1 || errorOut.length > 1 && errorOut[1]) {
            if (errorOut.length == 0 || errorOut.length != 0 && !errorOut[0]) {
                System.out.println(result);
            } else {
                System.err.println("\n" + result + "\n");
            }
        }
        return result;
    }
}

