/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.debug;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugElement;
import org.eclipse.emf.henshin.interpreter.matching.conditions.DebugApplicationCondition;

public class HenshinDebugThread
extends HenshinDebugElement
implements IThread {
    private DebugApplicationCondition applicationCondition;

    public HenshinDebugThread(IDebugTarget target, DebugApplicationCondition applicationCondition) {
        super(target);
        this.applicationCondition = applicationCondition;
    }

    public boolean canResume() {
        return this.applicationCondition.isSuspended();
    }

    public boolean canSuspend() {
        return this.applicationCondition.canSuspend();
    }

    public boolean isSuspended() {
        return this.applicationCondition.isSuspended();
    }

    public void resume() throws DebugException {
        this.applicationCondition.resume();
    }

    public void suspend() throws DebugException {
        this.applicationCondition.suspend();
    }

    public boolean canStepInto() {
        return this.applicationCondition.canStepInto();
    }

    public boolean canStepOver() {
        return this.applicationCondition.canStepOver();
    }

    public boolean canStepReturn() {
        return this.applicationCondition.canStepReturn();
    }

    public boolean isStepping() {
        return this.applicationCondition.isStepping();
    }

    public void stepInto() throws DebugException {
        this.applicationCondition.stepInto();
    }

    public void stepOver() throws DebugException {
        this.applicationCondition.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.applicationCondition.stepReturn();
    }

    public boolean canTerminate() {
        return this.applicationCondition.canTerminate();
    }

    public boolean isTerminated() {
        return this.applicationCondition.isTerminated();
    }

    public void terminate() throws DebugException {
        this.applicationCondition.terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        IStackFrame[] stackFrames = this.applicationCondition.getStackFrames(this);
        List<IStackFrame> stackFrameList = Arrays.asList(stackFrames);
        Collections.reverse(stackFrameList);
        return stackFrameList.toArray(stackFrames);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.applicationCondition.getCurrentDebugState() == DebugApplicationCondition.DebugState.TERMINATED_TRUE || this.applicationCondition.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] stackFrames = this.getStackFrames();
        return stackFrames.length > 0 ? stackFrames[0] : null;
    }

    public String getName() throws DebugException {
        return this.applicationCondition.getName();
    }

    public IBreakpoint[] getBreakpoints() {
        return this.applicationCondition.getBreakpoints();
    }

    public void fireEvent(DebugEvent event) {
        try {
            DebugEvent threadEvent = new DebugEvent((Object)this.getTopStackFrame(), event.getKind(), event.getDetail());
            if (DebugPlugin.getDefault() != null) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event, threadEvent});
            }
        }
        catch (DebugException debugException) {}
    }
}

