/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.presentation.HenshinIcons;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NodeGraphicalEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(Object type, CreateConnectionRequest request) {
        if (type instanceof EReference && request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateRequest realRequest = ((CreateUnspecifiedTypeConnectionRequest)request).getRequestForType(HenshinElementTypes.Edge_4001);
            if (realRequest != null) {
                realRequest.getExtendedData().put("henshin_edge_type", type);
            }
            type = HenshinElementTypes.Edge_4001;
        }
        return super.getConnectionCompleteCommand(type, request);
    }

    protected List<EReference> getConnectionMenuContent(CreateConnectionRequest request) {
        IGraphicalEditPart source = (IGraphicalEditPart)request.getSourceEditPart();
        IGraphicalEditPart target = (IGraphicalEditPart)request.getTargetEditPart();
        Node src = (Node)source.getNotationView().getElement();
        Node trg = (Node)target.getNotationView().getElement();
        if (src.getType() == null) {
            return new ArrayList<EReference>();
        }
        Rule rule = src.getGraph().getRule();
        ArrayList<EReference> result = new ArrayList<EReference>();
        for (EReference reference : src.getType().getEAllReferences()) {
            if (!rule.canCreateEdge(src, trg, reference)) continue;
            result.add(reference);
        }
        return result;
    }

    protected ICommand getPromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
        return new PromptAndCreateEdgeCommand(content, request);
    }

    private class EReferenceLabelProvider
    extends LabelProvider {
        private EReferenceLabelProvider() {
        }

        public String getText(Object object) {
            return ((EReference)object).getName();
        }

        public Image getImage(Object element) {
            return HenshinIcons.EREFERENCE;
        }
    }

    private class PromptAndCreateEdgeCommand
    extends GraphicalNodeEditPolicy.PromptAndCreateConnectionCommand {
        public PromptAndCreateEdgeCommand(List<EReference> content, CreateConnectionRequest request) {
            super((GraphicalNodeEditPolicy)NodeGraphicalEditPolicy.this, content, request);
        }

        protected ILabelProvider getLabelProvider() {
            return new EReferenceLabelProvider();
        }
    }
}

