/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.InvalidAlgorithmException;
import agg.parser.LayerFunction;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.LayeredExcludeParser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.RuleInstances;
import agg.parser.TripleData;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.util.Pair;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class LayeredSimpleExcludeParser
extends LayeredExcludeParser {
    public LayeredSimpleExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, LayeredExcludePairContainer excludeContainer, LayerFunction layer) {
        super(grammar, hostGraph, stopGraph, excludeContainer, layer);
    }

    public LayeredSimpleExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, LayeredExcludePairContainer excludeContainer, RuleLayer layer) {
        super(grammar, hostGraph, stopGraph, excludeContainer, layer);
    }

    @Override
    public boolean parse() {
        this.fireParserEvent(new ParserMessageEvent(this, "Starting layered simple exclude parser ..."));
        boolean result = true;
        Hashtable<Integer, HashSet<Rule>> invertedRuleLayer = this.layer.invertLayer();
        OrderedSet<Integer> ruleLayer = new OrderedSet<Integer>(new IntComparator());
        Enumeration<Integer> en = invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            ruleLayer.add(en.nextElement());
        }
        Integer currentLayer = this.layer.getStartLayer();
        int i = 0;
        RuleInstances eri = new RuleInstances();
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFree = null;
        try {
            conflictFree = this.pairContainer.getContainer(3);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> exclude = null;
        try {
            exclude = this.pairContainer.getContainer(0);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFreeLight = null;
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> excludeLight = null;
        excludeLight = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
        conflictFreeLight = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
        this.makeLightContainer(exclude, excludeLight);
        this.makeLightContainer(conflictFree, conflictFreeLight);
        Enumeration<Rule> keys = conflictFreeLight.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            if (!excludeLight.containsKey(key)) continue;
            conflictFreeLight.remove(key);
        }
        Hashtable<Integer, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>> layeredExcludeLight = new Hashtable<Integer, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>>();
        Hashtable<Integer, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>> layeredConflictFreeLight = new Hashtable<Integer, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>>();
        Enumeration en2 = ruleLayer.elements();
        while (en2.hasMoreElements() && !this.stop) {
            Integer l = (Integer)en2.nextElement();
            HashSet<Rule> lRules = invertedRuleLayer.get(l);
            Iterator<Rule> en22 = lRules.iterator();
            while (en22.hasNext() && !this.stop) {
                Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> hashtable;
                Rule r = en22.next();
                Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> value = conflictFreeLight.get(r);
                if (value != null) {
                    hashtable = (Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>)layeredConflictFreeLight.get(l);
                    if (hashtable == null) {
                        hashtable = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
                        layeredConflictFreeLight.put(l, hashtable);
                    }
                    hashtable.put(r, value);
                    continue;
                }
                value = excludeLight.get(r);
                if (value == null) continue;
                hashtable = (Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>)layeredExcludeLight.get(l);
                if (hashtable == null) {
                    hashtable = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
                    layeredExcludeLight.put(l, hashtable);
                }
                hashtable.put(r, value);
            }
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Layered simple parser initialized"));
        boolean ruleApplied = false;
        while (!this.stop && !this.getHostGraph().isIsomorphicTo(this.stopGraph) && result && currentLayer != null) {
            TripleData tmpTriple;
            OrdinaryMorphism copyMorph;
            ruleApplied = false;
            Hashtable lFree = (Hashtable)layeredConflictFreeLight.get(currentLayer);
            Match m = null;
            if (lFree != null) {
                m = this.findMatch(this.getHostGraph(), lFree.keySet().iterator(), eri);
            }
            if (m != null && this.applyRule(m)) {
                ruleApplied = true;
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException en22) {
                    // empty catch block
                }
            }
            if (ruleApplied) continue;
            Hashtable lExclude = (Hashtable)layeredExcludeLight.get(currentLayer);
            Match savedMatch = null;
            if (lExclude != null) {
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for difficult match"));
                m = this.findMatch(this.getHostGraph(), lExclude.keySet().iterator(), eri);
                if (m != null) {
                    savedMatch = m;
                }
            }
            if (!ruleApplied && savedMatch != null && (copyMorph = this.getHostGraph().isomorphicCopy()) != null) {
                this.fireParserEvent(new ParserMessageEvent(copyMorph, "IsoCopy"));
                eri.add(savedMatch);
                tmpTriple = new TripleData(this.getHostGraph(), eri, currentLayer);
                this.stack.push(tmpTriple);
                eri = new RuleInstances();
                this.setHostGraph(copyMorph.getImage());
                OrdinaryMorphism tmpMorph = savedMatch.compose(copyMorph);
                Match n = tmpMorph.makeMatch(savedMatch.getRule());
                n.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                boolean notFound = false;
                while (!n.isValid() && !notFound) {
                    if (n.nextCompletion()) continue;
                    notFound = true;
                }
                if (!notFound && this.applyRule(n)) {
                    ruleApplied = true;
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (ruleApplied) continue;
            boolean nextLayerExists = true;
            if (++i < ruleLayer.size()) {
                currentLayer = (Integer)ruleLayer.get(i);
            } else {
                nextLayerExists = false;
            }
            if (nextLayerExists) continue;
            try {
                tmpTriple = (TripleData)this.stack.pop();
                this.setHostGraph(tmpTriple.getHostGraph());
                eri = tmpTriple.getRuleInstance();
                currentLayer = tmpTriple.getLayer();
            }
            catch (EmptyStackException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                result = false;
            }
        }
        while (!this.stack.empty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                TripleData tmpTriple = (TripleData)this.stack.pop();
                Graph g = tmpTriple.getHostGraph();
                g.dispose();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        this.correct = result;
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + result + "."));
        return result;
    }
}

