/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GraGraTreeModel
extends DefaultTreeModel {
    private JFrame applFrame;

    public GraGraTreeModel(TreeNode newRoot) {
        super(newRoot);
    }

    public GraGraTreeModel(JFrame frame, TreeNode newRoot) {
        super(newRoot);
        this.applFrame = frame;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        GraGraTreeNodeData data;
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (this.checkNewValue(aNode, data = (GraGraTreeNodeData)aNode.getUserObject(), (String)newValue)) {
            data.setString((String)newValue);
            this.nodeChanged(aNode);
        }
    }

    private boolean checkNewValue(DefaultMutableTreeNode aNode, GraGraTreeNodeData sd, String name) {
        if (sd.isGraGra()) {
            if (!this.isValid(this.getGraGraNames(), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isGraph()) {
            EdGraGra egra = this.getGraGra(aNode);
            if (!this.isValid(this.getGraGraChildrenNames(egra), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isRuleScheme()) {
            EdGraGra egra = this.getGraGra(aNode);
            if (!this.isValid(this.getGraGraChildrenNames(egra), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isRule()) {
            if (sd.isKernelRule() || sd.isMultiRule() || sd.isAmalgamatedRule()) {
                EdRuleScheme ruleScheme = this.getRuleScheme(aNode);
                if (!this.isValid(this.getRuleSchemeChildrenNames(ruleScheme), name, sd.toString())) {
                    this.warning(this.applFrame, name);
                    return false;
                }
                return true;
            }
            EdGraGra egra = this.getGraGra(aNode);
            if (!this.isValid(this.getGraGraChildrenNames(egra), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isNAC()) {
            EdRule erule = this.getRule(aNode);
            if (!this.isValid(this.getRuleChildrenNames(erule), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isPAC()) {
            EdRule erule = this.getRule(aNode);
            if (!this.isValid(this.getRuleChildrenNames(erule), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isNestedAC()) {
            EdRule erule = this.getRule(aNode);
            if (erule == null) {
                EdNestedApplCond ac = this.getParentCond(aNode);
                if (!this.isValid(this.getNestedChildrenNames(ac), name, sd.toString())) {
                    this.warning(this.applFrame, name);
                    return false;
                }
            } else if (!this.isValid(this.getRuleChildrenNames(erule), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        return true;
    }

    public DefaultMutableTreeNode getTreeNodeOfGraGraRule(DefaultMutableTreeNode gragraNode, Object searchedObj) {
        if (!(searchedObj instanceof EdRule)) {
            return null;
        }
        int j = 0;
        while (j < gragraNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)gragraNode.getChildAt(j);
            GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
            if (sd.isRule()) {
                if (sd.isRuleScheme() || sd.isKernelRule() || sd.isMultiRule() || sd.isAmalgamatedRule()) {
                    return null;
                }
                if (searchedObj instanceof EdRule && sd.getRule().equals(searchedObj)) {
                    return node;
                }
            }
            ++j;
        }
        return null;
    }

    public boolean isValid(Vector<String> names, String newName, String oldName) {
        String testold = oldName;
        String testnew = newName;
        int ind = testold.lastIndexOf(93);
        testold = testold.substring(ind + 1);
        ind = testnew.lastIndexOf(93);
        testnew = testnew.substring(ind + 1);
        int i = 0;
        while (i < names.size()) {
            if (!names.elementAt(i).equals(testold) && names.elementAt(i).equals(testnew)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String makeNewName(EdGraGra gragra, String name) {
        String result = name;
        if (!this.isValid(this.getGraGraChildrenNames(gragra), name, "")) {
            result = name.concat("_");
        }
        return result;
    }

    public String makeNewName(EdRule rule, String name) {
        String result = name;
        if (!this.isValid(this.getRuleChildrenNames(rule), name, "")) {
            result = name.concat("_");
        }
        return result;
    }

    public String makeNewName(EdNestedApplCond ac, String name) {
        String result = name;
        if (!this.isValid(this.getNestedChildrenNames(ac), name, "")) {
            result = name.concat("_");
        }
        return result;
    }

    public void ruleNameChanged(EdGraGra gragra, boolean layered) {
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            GraGraTreeNodeData sdGra = (GraGraTreeNodeData)node.getUserObject();
            if (sdGra.getGraGra().equals(gragra)) {
                int j = 0;
                while (j < node.getChildCount()) {
                    DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)node.getChildAt(j);
                    GraGraTreeNodeData sd = (GraGraTreeNodeData)node1.getUserObject();
                    if (sd.isRule()) {
                        String tag = "";
                        String tag1 = "";
                        if (!sd.getRule().getBasisRule().isEnabled()) {
                            tag = "[D]";
                        }
                        if (layered) {
                            tag1 = "[" + sd.getRule().getBasisRule().getLayer() + "]";
                        }
                        sd.setString(tag, tag1, sd.getRule().getBasisRule().getName());
                        this.nodeChanged(node1);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public void ruleNameChanged(EdGraGra gragra, boolean layered, boolean priority) {
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            GraGraTreeNodeData sdGra = (GraGraTreeNodeData)node.getUserObject();
            if (sdGra.getGraGra().equals(gragra)) {
                int j = 0;
                while (j < node.getChildCount()) {
                    DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)node.getChildAt(j);
                    GraGraTreeNodeData sd = (GraGraTreeNodeData)node1.getUserObject();
                    if (sd.isRule() && sd.getRule() != null) {
                        String tag = "";
                        String tag1 = "";
                        if (!sd.getRule().getBasisRule().isEnabled()) {
                            tag = "[D]";
                        }
                        if (layered) {
                            tag1 = "[" + sd.getRule().getBasisRule().getLayer() + "]";
                        } else if (priority) {
                            tag1 = "[" + sd.getRule().getBasisRule().getPriority() + "]";
                        }
                        sd.setString(tag, tag1, sd.getRule().getBasisRule().getName());
                        this.nodeChanged(node1);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public void ruleNameChanged(DefaultMutableTreeNode ruleNode, boolean layered) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
        if (sd.isRule()) {
            String tag = "";
            String tag1 = "";
            if (!sd.getRule().getBasisRule().isEnabled()) {
                tag = "[D]";
            }
            if (layered) {
                tag1 = "[" + sd.getRule().getBasisRule().getLayer() + "]";
            }
            sd.setString(tag, tag1, sd.getRule().getBasisRule().getName());
            this.nodeChanged(ruleNode);
        }
    }

    public void ruleNameChanged(DefaultMutableTreeNode ruleNode, boolean layered, boolean priority) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
        if (sd.isRule()) {
            String tag = "";
            String tag1 = "";
            if (!sd.getRule().getBasisRule().isEnabled()) {
                tag = "[D]";
            }
            if (layered) {
                tag1 = "[" + sd.getRule().getBasisRule().getLayer() + "]";
            } else if (priority) {
                tag1 = "[" + sd.getRule().getBasisRule().getPriority() + "]";
            }
            sd.setString(tag, tag1, sd.getRule().getBasisRule().getName());
            this.nodeChanged(ruleNode);
        }
    }

    public void constraintNameChanged(EdGraGra gragra, boolean layered) {
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            GraGraTreeNodeData sdGra = (GraGraTreeNodeData)node.getUserObject();
            if (sdGra.getGraGra().equals(gragra)) {
                int j = 0;
                while (j < node.getChildCount()) {
                    DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)node.getChildAt(j);
                    GraGraTreeNodeData sd = (GraGraTreeNodeData)node1.getUserObject();
                    if (sd.isConstraint()) {
                        String tagD = "";
                        if (!sd.getConstraint().getBasisConstraint().isEnabled()) {
                            tagD = "[D]";
                        }
                        String tag = "";
                        Vector<Integer> layer = sd.getConstraint().getBasisConstraint().getLayer();
                        if (layered && !layer.isEmpty()) {
                            tag = "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]";
                        }
                        sd.setString(tagD, tag, sd.getConstraint().getBasisConstraint().getName());
                        this.nodeChanged(node1);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public void constraintNameChanged(EdGraGra gragra, boolean layered, boolean priority) {
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            GraGraTreeNodeData sdGra = (GraGraTreeNodeData)node.getUserObject();
            if (sdGra.getGraGra().equals(gragra)) {
                int j = 0;
                while (j < node.getChildCount()) {
                    DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)node.getChildAt(j);
                    GraGraTreeNodeData sd = (GraGraTreeNodeData)node1.getUserObject();
                    if (sd.isConstraint()) {
                        String tagD = "";
                        if (!sd.getConstraint().getBasisConstraint().isEnabled()) {
                            tagD = "[D]";
                        }
                        String tag = "";
                        Vector<Integer> layer = sd.getConstraint().getBasisConstraint().getLayer();
                        Vector<Integer> prior = sd.getConstraint().getBasisConstraint().getPriority();
                        if (layered && !layer.isEmpty()) {
                            tag = "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]";
                        } else if (priority && !prior.isEmpty()) {
                            tag = "[" + sd.getConstraint().getBasisConstraint().getPriorityAsString() + "]";
                        }
                        sd.setString(tagD, tag, sd.getConstraint().getBasisConstraint().getName());
                        this.nodeChanged(node1);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public void constraintNameChanged(DefaultMutableTreeNode node, boolean layered) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isConstraint()) {
            String tagD = "";
            if (!sd.getConstraint().getBasisConstraint().isEnabled()) {
                tagD = "[D]";
            }
            String tag = "";
            Vector<Integer> layer = sd.getConstraint().getBasisConstraint().getLayer();
            if (layered && !layer.isEmpty()) {
                tag = "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]";
            }
            sd.setString(tagD, tag, sd.getConstraint().getBasisConstraint().getName());
            this.nodeChanged(node);
        }
    }

    public void constraintNameChanged(DefaultMutableTreeNode node, boolean layered, boolean priority) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isConstraint()) {
            String tagD = "";
            if (!sd.getConstraint().getBasisConstraint().isEnabled()) {
                tagD = "[D]";
            }
            String tag = "";
            Vector<Integer> layer = sd.getConstraint().getBasisConstraint().getLayer();
            Vector<Integer> prior = sd.getConstraint().getBasisConstraint().getPriority();
            if (layered && !layer.isEmpty()) {
                tag = "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]";
            } else if (priority && !prior.isEmpty()) {
                tag = "[" + sd.getConstraint().getBasisConstraint().getPriorityAsString() + "]";
            }
            sd.setString(tagD, tag, sd.getConstraint().getBasisConstraint().getName());
            this.nodeChanged(node);
        }
    }

    private void warning(JFrame fr, String str) {
        String test = str;
        int ind = test.indexOf("]");
        while (ind > 0) {
            test = test.substring(ind + 1);
            ind = test.indexOf("]");
        }
        JOptionPane.showMessageDialog(fr, "Name  \"" + test + "\"  exists.", "Warning", 0);
    }

    public Vector<String> getGraGraNames() {
        Vector<String> gragraNames = new Vector<String>();
        int i = 0;
        while (i < this.root.getChildCount()) {
            gragraNames.addElement(((DefaultMutableTreeNode)this.root.getChildAt(i)).toString());
            ++i;
        }
        return gragraNames;
    }

    public Vector<String> getGraGraChildrenNames(EdGraGra eGra) {
        Vector<String> childrenNames = new Vector<String>();
        int i = 0;
        while (i < eGra.getGraphs().size()) {
            childrenNames.add(eGra.getGraphs().get(i).getBasisGraph().getName());
            ++i;
        }
        i = 0;
        while (i < eGra.getRules().size()) {
            if (eGra.getRules().elementAt(i) != null) {
                EdPAC epac;
                EdRule er = eGra.getRules().elementAt(i);
                childrenNames.add(er.getBasisRule().getName());
                int j = 0;
                while (j < er.getNACs().size()) {
                    EdNAC enac = er.getNACs().elementAt(j);
                    childrenNames.add(enac.getBasisGraph().getName());
                    ++j;
                }
                j = 0;
                while (j < er.getPACs().size()) {
                    epac = er.getPACs().elementAt(j);
                    childrenNames.add(epac.getBasisGraph().getName());
                    ++j;
                }
                j = 0;
                while (j < er.getNestedACs().size()) {
                    epac = er.getNestedACs().elementAt(j);
                    childrenNames.add(epac.getBasisGraph().getName());
                    ++j;
                }
            }
            ++i;
        }
        return childrenNames;
    }

    private Vector<String> getRuleChildrenNames(EdRule eRule) {
        Vector<String> childrenNames = new Vector<String>();
        int i = 0;
        while (i < eRule.getNACs().size()) {
            childrenNames.add(eRule.getNACs().elementAt(i).getBasisGraph().getName());
            ++i;
        }
        i = 0;
        while (i < eRule.getPACs().size()) {
            childrenNames.add(eRule.getPACs().elementAt(i).getBasisGraph().getName());
            ++i;
        }
        i = 0;
        while (i < eRule.getNestedACs().size()) {
            childrenNames.add(eRule.getNestedACs().elementAt(i).getBasisGraph().getName());
            ++i;
        }
        return childrenNames;
    }

    private Vector<String> getNestedChildrenNames(EdNestedApplCond ac) {
        Vector<String> childrenNames = new Vector<String>();
        int i = 0;
        while (i < ac.getNestedACs().size()) {
            childrenNames.add(ac.getNestedACs().get(i).getBasisGraph().getName());
            ++i;
        }
        return childrenNames;
    }

    private Vector<String> getRuleSchemeChildrenNames(EdRuleScheme eRuleScheme) {
        Vector<String> ruleSchemeChildrenNames = new Vector<String>();
        ruleSchemeChildrenNames.add(eRuleScheme.getBasisRuleScheme().getSchemeName());
        ruleSchemeChildrenNames.add(eRuleScheme.getBasisRuleScheme().getKernelRule().getName());
        int i = 0;
        while (i < eRuleScheme.getMultiRules().size()) {
            ruleSchemeChildrenNames.add(eRuleScheme.getMultiRules().get(i).getBasisRule().getName());
            ++i;
        }
        if (eRuleScheme.getAmalgamatedRule() != null) {
            ruleSchemeChildrenNames.add(eRuleScheme.getAmalgamatedRule().getName());
        }
        return ruleSchemeChildrenNames;
    }

    private EdGraGra getGraGra(DefaultMutableTreeNode aNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)aNode.getParent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (data.isGraGra()) {
            return data.getGraGra();
        }
        return null;
    }

    private EdRule getRule(DefaultMutableTreeNode aNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)aNode.getParent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (data.isRule()) {
            return data.getRule();
        }
        return null;
    }

    private EdRuleScheme getRuleScheme(DefaultMutableTreeNode aNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)aNode.getParent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (data.isRuleScheme()) {
            return data.getRuleScheme();
        }
        return null;
    }

    private EdNestedApplCond getParentCond(DefaultMutableTreeNode aNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)aNode.getParent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (data.isNestedAC()) {
            return data.getNestedAC();
        }
        return null;
    }
}

