/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.computation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.CospanMappingToMaps;
import org.eclipse.emf.henshin.multicda.cda.MapOfLSetEnumerator;
import org.eclipse.emf.henshin.multicda.cda.Pushout;
import org.eclipse.emf.henshin.multicda.cda.ReasonFactory;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.computation.AtomCandidateComputation;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;
import org.eclipse.emf.henshin.multicda.cda.units.SpanMappings;

public class MinimalReasonComputation {
    static Action deleteAction = new Action(Action.Type.DELETE);
    static Action preserveAction = new Action(Action.Type.PRESERVE);
    static HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
    Map<Span, Pushout> span2pushout = new HashMap<Span, Pushout>();
    protected Rule rule1;
    protected Rule rule2;
    protected Set<Span> checked;

    public MinimalReasonComputation(Rule rule1, Rule rule2) {
        this.rule1 = rule1;
        this.rule2 = rule2;
        this.checked = new HashSet<Span>();
    }

    public Set<ConflictReason> computeMinimalConflictReasons() {
        HashSet<ConflictReason> result = new HashSet<ConflictReason>();
        Set<Atom> candidates = new AtomCandidateComputation(this.rule1, this.rule2).computeAtomCandidates();
        for (Atom candidate : candidates) {
            if (!Utils.attributesCheck(candidate)) continue;
            this.computeMinimalConflictReasons(candidate, result);
        }
        return result;
    }

    public void computeMinimalConflictReasons(Span s1, Set<ConflictReason> result) {
        if (!this.checked.contains(s1)) {
            if (this.isMinReason(s1)) {
                result.add((ConflictReason)ReasonFactory.eINSTANCE.createMinimalReason(s1));
                if (result.size() > 1) {
                    for (Reason reason : result) {
                        reason.hashCode();
                    }
                }
                return;
            }
            Set<ConflictReason> set = this.findExtensions(s1);
            for (Reason reason : set) {
                this.computeMinimalConflictReasons(reason, result);
            }
            this.checked.add(s1);
        }
    }

    private boolean isMinReason(Span s1) {
        Pushout pushoutResult = this.getPushout(s1);
        boolean rule1EmbeddingIsDanglingFree = Utils.findDanglingEdgesOfRule1(this.rule1, pushoutResult.getRule1Mappings()).isEmpty();
        return rule1EmbeddingIsDanglingFree;
    }

    private Pushout getPushout(Span s1) {
        Pushout result = this.span2pushout.get(s1);
        if (result == null) {
            result = new Pushout(this.rule1, s1, this.rule2);
            this.span2pushout.put(s1, result);
        }
        return result;
    }

    public Set<Edge> findFixingEdges(Rule rule1, Rule rule2, Utils.DanglingEdge poDangling, CospanMappingToMaps comaps, Span s1) {
        SpanMappings maps = new SpanMappings(s1);
        Node poDanglingSource = poDangling.getEdge().getSource();
        Node poDanglingTarget = poDangling.getEdge().getTarget();
        Node r1DanglingSource = comaps.gToRule1.get(poDanglingSource);
        Node r1DanglingTarget = comaps.gToRule1.get(poDanglingTarget);
        if (poDangling.danglingCase == Utils.DanglingCase.sourceDangling) {
            HashSet r1Candidates = new HashSet(r1DanglingTarget.getIncoming(poDangling.getEdge().getType()));
            return r1Candidates.stream().filter(e -> spanMappings.rule1ToS1.get(e.getSource()) == null).collect(Collectors.toSet());
        }
        if (poDangling.danglingCase == Utils.DanglingCase.targetDangling) {
            HashSet c1Candidates = new HashSet(r1DanglingSource.getOutgoing(poDangling.getEdge().getType()));
            return c1Candidates.stream().filter(e -> spanMappings.rule1ToS1.get(e.getTarget()) == null).collect(Collectors.toSet());
        }
        if (poDangling.danglingCase == Utils.DanglingCase.unspecifiedEdge) {
            HashSet<Edge> result = new HashSet<Edge>();
            Edge e2 = r1DanglingSource.getOutgoing(poDangling.getEdge().getType(), r1DanglingTarget);
            if (e2 != null && maps.getEdgeMappingsRule1S1().get(e2) == null) {
                result.add(e2);
            }
            return result;
        }
        throw new RuntimeException("Invalid state: neither source nor target were dangling in L1!");
    }

    private Set<ConflictReason> findExtensions(Span s1) {
        Pushout pushoutResult = this.getPushout(s1);
        CospanMappingToMaps cospanMappings = new CospanMappingToMaps(pushoutResult.getRule1Mappings(), pushoutResult.getRule2Mappings());
        Set<Utils.DanglingEdge> danglingEdges = Utils.findDanglingEdgesOfRule1(this.rule1, pushoutResult.getRule1Mappings());
        HashMap<Utils.DanglingEdge, Set<Edge>> fixingEdgeMap = new HashMap<Utils.DanglingEdge, Set<Edge>>();
        for (Utils.DanglingEdge danglingEdge : danglingEdges) {
            Set<Edge> fixing = this.findFixingEdges(this.rule1, this.rule2, danglingEdge, cospanMappings, s1);
            if (!fixing.isEmpty()) {
                fixingEdgeMap.put(danglingEdge, fixing);
                continue;
            }
            return new HashSet<ConflictReason>();
        }
        HashSet<ConflictReason> extensions = new HashSet();
        extensions = this.enumerateExtensions(s1, fixingEdgeMap, cospanMappings);
        return extensions;
    }

    public Set<ConflictReason> enumerateExtensions(Span originalSpan, Map<Utils.DanglingEdge, Set<Edge>> fixingEdges, CospanMappingToMaps comaps) {
        HashSet<ConflictReason> extensions = new HashSet<ConflictReason>();
        for (Utils.DanglingEdge danglingEdge : fixingEdges.keySet()) {
            if (danglingEdge.getDanglingCase() == Utils.DanglingCase.sourceDangling || danglingEdge.getDanglingCase() == Utils.DanglingCase.targetDangling) {
                this.enumerateNodeExtensions(originalSpan, danglingEdge, fixingEdges, comaps, extensions);
                continue;
            }
            if (danglingEdge.getDanglingCase() != Utils.DanglingCase.unspecifiedEdge) continue;
            this.enumerateEdgeExtensions(originalSpan, danglingEdge, fixingEdges.get(danglingEdge), extensions);
        }
        return extensions;
    }

    private void enumerateEdgeExtensions(Span originalSpan, Utils.DanglingEdge danglingEdge, Set<Edge> set, Set<ConflictReason> extensions) {
        for (Edge fixingEdgeR1 : set) {
            ConflictReason mr = (ConflictReason)ReasonFactory.eINSTANCE.createMinimalReason(originalSpan);
            SpanMappings maps = new SpanMappings(mr);
            Node srcR1 = fixingEdgeR1.getSource();
            Node trgR1 = fixingEdgeR1.getTarget();
            Node srcS1 = maps.rule1ToS1.get(srcR1);
            Node trgS1 = maps.rule1ToS1.get(trgR1);
            Node srcR2 = maps.s1ToRule2.get(srcS1);
            Node trgR2 = maps.s1ToRule2.get(trgS1);
            Edge fixingR2 = srcR2.getOutgoing(fixingEdgeR1.getType(), trgR2);
            if (fixingR2 == null) continue;
            HenshinFactory.eINSTANCE.createEdge(srcS1, trgS1, fixingEdgeR1.getType());
            extensions.add(mr);
        }
    }

    private void enumerateNodeExtensions(Span originalSpan, Utils.DanglingEdge danglingEdge, Map<Utils.DanglingEdge, Set<Edge>> fixingEdges, CospanMappingToMaps comaps, Set<ConflictReason> extensions) {
        Edge danglingEdgePO = danglingEdge.getEdge();
        for (Edge fixingEdgeR1 : fixingEdges.get(danglingEdge)) {
            ConflictReason span1 = (ConflictReason)ReasonFactory.eINSTANCE.createMinimalReason(originalSpan);
            SpanMappings maps = new SpanMappings(span1);
            Node srcR1 = fixingEdgeR1.getSource();
            Node trgR1 = fixingEdgeR1.getTarget();
            Node srcR2 = comaps.gToRule2.get(danglingEdgePO.getSource());
            Node trgR2 = comaps.gToRule2.get(danglingEdgePO.getTarget());
            Node srcS1 = maps.rule1ToS1.get(srcR1);
            Node trgS1 = maps.rule1ToS1.get(trgR1);
            boolean sourceDangling = true;
            if (srcS1 == null) {
                srcS1 = henshinFactory.createNode(span1.getGraph(), this.commonSubClass(srcR1, srcR2), String.valueOf(srcR1.getName()) + "_" + srcR2.getName());
                span1.mappingsInRule1.add(henshinFactory.createMapping(srcS1, srcR1));
                span1.mappingsInRule2.add(henshinFactory.createMapping(srcS1, srcR2));
            } else if (trgS1 == null) {
                sourceDangling = false;
                trgS1 = henshinFactory.createNode(span1.getGraph(), this.commonSubClass(trgR1, trgR2), String.valueOf(trgR1.getName()) + "_" + trgR2.getName());
                span1.mappingsInRule1.add(henshinFactory.createMapping(trgS1, trgR1));
                span1.mappingsInRule2.add(henshinFactory.createMapping(trgS1, trgR2));
            }
            EList preserveNodes = this.rule1.getActionNodes(new Action(Action.Type.PRESERVE));
            if (preserveNodes.contains((Object)fixingEdgeR1.getSource()) && preserveNodes.contains((Object)fixingEdgeR1.getTarget())) {
                HashMap<Edge, Edge> entry = new HashMap<Edge, Edge>();
                entry.put(danglingEdgePO, fixingEdgeR1);
                this.createExtension(extensions, entry, span1);
                continue;
            }
            List<Map<Edge, Edge>> combinations = this.getFixingFamily(danglingEdgePO, sourceDangling, fixingEdges, span1, comaps);
            for (Map<Edge, Edge> combination : combinations) {
                this.createExtension(extensions, combination, span1);
            }
        }
    }

    private EClass commonSubClass(Node node1, Node node2) {
        if (node1.getType() == node2.getType()) {
            return node1.getType();
        }
        if (node1.getType().getEAllSuperTypes().contains((Object)node2.getType())) {
            return node1.getType();
        }
        if (node2.getType().getEAllSuperTypes().contains((Object)node1.getType())) {
            return node2.getType();
        }
        throw new RuntimeException("Incompatible types!");
    }

    private void createExtension(Set<ConflictReason> extensions, Map<Edge, Edge> combination, ConflictReason span) {
        SpanMappings maps = new SpanMappings(span);
        for (Edge fixingEdge : combination.values()) {
            Node src = maps.rule1ToS1.get(fixingEdge.getSource());
            Node trg = maps.rule1ToS1.get(fixingEdge.getTarget());
            boolean found = false;
            for (Edge edge : src.getGraph().getEdges()) {
                if (edge.getSource() != src || edge.getTarget() != trg) continue;
                found = true;
                break;
            }
            if (found) continue;
            henshinFactory.createEdge(src, trg, fixingEdge.getType());
        }
        extensions.add(span);
    }

    private List<Map<Edge, Edge>> getFixingFamily(Edge danglingEdgePO, boolean sourceDangling, Map<Utils.DanglingEdge, Set<Edge>> fixingEdges, Reason span1, CospanMappingToMaps comaps) {
        Map<Edge, Set<Edge>> theFixingEdges = this.flattenFixingSet(fixingEdges);
        SpanMappings maps = new SpanMappings(span1);
        List<Object> brotherEdges = new ArrayList();
        List<Object> sisterEdges = new ArrayList();
        Node srcPO = danglingEdgePO.getSource();
        Node trgPO = danglingEdgePO.getTarget();
        if (sourceDangling) {
            brotherEdges = trgPO.getIncoming().stream().filter(e -> e.getSource() == srcPO).collect(Collectors.toList());
            sisterEdges = trgPO.getOutgoing().stream().filter(e -> e.getTarget() == srcPO).collect(Collectors.toList());
        } else {
            brotherEdges = srcPO.getIncoming().stream().filter(e -> e.getSource() == trgPO).collect(Collectors.toList());
            sisterEdges = srcPO.getOutgoing().stream().filter(e -> e.getTarget() == trgPO).collect(Collectors.toList());
        }
        Set danglingFamilyPO = Stream.concat(brotherEdges.stream(), sisterEdges.stream()).collect(Collectors.toSet());
        HashMap result = new HashMap();
        for (Edge toFixPO : danglingFamilyPO) {
            Set<Edge> potentialFixes = theFixingEdges.get(toFixPO);
            HashSet<Edge> viable = new HashSet<Edge>();
            HashSet<Node> requiredMemberNodes = new HashSet<Node>();
            Node srcToFix = toFixPO.getSource();
            Node trgToFix = toFixPO.getTarget();
            requiredMemberNodes.add(maps.s1ToRule1.get(maps.rule2ToS1.get(comaps.gToRule2.get(srcToFix))));
            requiredMemberNodes.add(maps.s1ToRule1.get(maps.rule2ToS1.get(comaps.gToRule2.get(trgToFix))));
            for (Edge e2 : potentialFixes) {
                HashSet<Node> memberNodes = new HashSet<Node>();
                memberNodes.add(e2.getSource());
                memberNodes.add(e2.getTarget());
                if (!memberNodes.equals(requiredMemberNodes)) continue;
                viable.add(e2);
            }
            if (viable.isEmpty()) {
                return new LinkedList<Map<Edge, Edge>>();
            }
            result.put(toFixPO, viable);
        }
        LinkedList<Map<Edge, Edge>> list = new LinkedList<Map<Edge, Edge>>();
        MapOfLSetEnumerator.combinations(result, list);
        return list;
    }

    private Map<Edge, Set<Edge>> flattenFixingSet(Map<Utils.DanglingEdge, Set<Edge>> fixingEdges) {
        HashMap<Edge, Set<Edge>> result = new HashMap<Edge, Set<Edge>>();
        for (Map.Entry<Utils.DanglingEdge, Set<Edge>> entry : fixingEdges.entrySet()) {
            result.put(entry.getKey().getEdge(), entry.getValue());
        }
        return result;
    }
}

