/**
 * generated by Xtext 2.10.0
 */
package org.eclipse.emf.henshin.text.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.text.henshin_text.AndExpression;
import org.eclipse.emf.henshin.text.henshin_text.Attribute;
import org.eclipse.emf.henshin.text.henshin_text.Call;
import org.eclipse.emf.henshin.text.henshin_text.ComparisonExpression;
import org.eclipse.emf.henshin.text.henshin_text.ConditionEdge;
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraph;
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraphRef;
import org.eclipse.emf.henshin.text.henshin_text.ConditionNode;
import org.eclipse.emf.henshin.text.henshin_text.ConditionNodeTypes;
import org.eclipse.emf.henshin.text.henshin_text.ConditionReuseNode;
import org.eclipse.emf.henshin.text.henshin_text.ConditionalUnit;
import org.eclipse.emf.henshin.text.henshin_text.EPackageImport;
import org.eclipse.emf.henshin.text.henshin_text.Edge;
import org.eclipse.emf.henshin.text.henshin_text.Edges;
import org.eclipse.emf.henshin.text.henshin_text.EqualityExpression;
import org.eclipse.emf.henshin.text.henshin_text.Expression;
import org.eclipse.emf.henshin.text.henshin_text.Formula;
import org.eclipse.emf.henshin.text.henshin_text.Graph;
import org.eclipse.emf.henshin.text.henshin_text.Henshin_textPackage;
import org.eclipse.emf.henshin.text.henshin_text.IndependentUnit;
import org.eclipse.emf.henshin.text.henshin_text.IntegerValue;
import org.eclipse.emf.henshin.text.henshin_text.IteratedUnit;
import org.eclipse.emf.henshin.text.henshin_text.JavaAttributeValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaClassValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaImport;
import org.eclipse.emf.henshin.text.henshin_text.Logic;
import org.eclipse.emf.henshin.text.henshin_text.LoopUnit;
import org.eclipse.emf.henshin.text.henshin_text.Match;
import org.eclipse.emf.henshin.text.henshin_text.MinusExpression;
import org.eclipse.emf.henshin.text.henshin_text.Model;
import org.eclipse.emf.henshin.text.henshin_text.MulOrDivExpression;
import org.eclipse.emf.henshin.text.henshin_text.MultiRule;
import org.eclipse.emf.henshin.text.henshin_text.MultiRuleReuseNode;
import org.eclipse.emf.henshin.text.henshin_text.Node;
import org.eclipse.emf.henshin.text.henshin_text.NotExpression;
import org.eclipse.emf.henshin.text.henshin_text.NumberValue;
import org.eclipse.emf.henshin.text.henshin_text.OrExpression;
import org.eclipse.emf.henshin.text.henshin_text.Parameter;
import org.eclipse.emf.henshin.text.henshin_text.ParameterKind;
import org.eclipse.emf.henshin.text.henshin_text.ParameterValue;
import org.eclipse.emf.henshin.text.henshin_text.PlusExpression;
import org.eclipse.emf.henshin.text.henshin_text.PriorityUnit;
import org.eclipse.emf.henshin.text.henshin_text.Rule;
import org.eclipse.emf.henshin.text.henshin_text.RuleNodeTypes;
import org.eclipse.emf.henshin.text.henshin_text.Unit;
import org.eclipse.emf.henshin.text.henshin_text.UnitElement;
import org.eclipse.emf.henshin.text.henshin_text.impl.ANDImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.CheckDanglingImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.ConditionsImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.GraphImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.InjectiveMatchingImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.JavaImportImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.NotImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.ORorXORImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.RollbackImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.StrictImpl;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textTypeProvider;
import org.eclipse.emf.henshin.text.validation.AbstractHenshin_textValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class Henshin_textValidator extends AbstractHenshin_textValidator {
  @Inject
  @Extension
  private Henshin_textTypeProvider _henshin_textTypeProvider;
  
  /**
   * Check that the number and type of parameters match in a unit or rule call
   * This ignores VAR variables in the to-be-called unit / rule (call.elementCall) as they denote local variables
   * 
   * @param call to-be-checked call
   */
  @Check
  public void checkCallParameter(final Call call) {
    final Function1<Parameter, Boolean> _function = (Parameter it) -> {
      ParameterKind _kind = it.getKind();
      return Boolean.valueOf((!Objects.equal(_kind, ParameterKind.VAR)));
    };
    int _size = IterableExtensions.size(IterableExtensions.<Parameter>filter(call.getElementCall().getParameters(), _function));
    int _size_1 = call.getParameters().size();
    boolean _notEquals = (_size != _size_1);
    if (_notEquals) {
      this.error("Bad Parameter Count.\'", Henshin_textPackage.eINSTANCE.getCall_ElementCall());
    } else {
      for (int i = 0; (i < IterableExtensions.size(IterableExtensions.<Parameter>filter(call.getElementCall().getParameters(), ((Function1<Parameter, Boolean>) (Parameter it) -> {
        ParameterKind _kind = it.getKind();
        return Boolean.valueOf((!Objects.equal(_kind, ParameterKind.VAR)));
      })))); i++) {
        {
          final Parameter param = call.getElementCall().getParameters().get(i);
          Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(param.getType());
          Henshin_textType _typeFor_1 = this._henshin_textTypeProvider.typeFor(call.getParameters().get(i).getType());
          boolean _notEquals_1 = (!Objects.equal(_typeFor, _typeFor_1));
          if (_notEquals_1) {
            String _string = this._henshin_textTypeProvider.typeFor(param.getType()).toString();
            String _plus = ("Call expected " + _string);
            String _plus_1 = (_plus + " type, but was ");
            String _string_1 = this._henshin_textTypeProvider.typeFor(call.getParameters().get(i).getType()).toString();
            String _plus_2 = (_plus_1 + _string_1);
            String _plus_3 = (_plus_2 + ".\'");
            this.error(_plus_3, call, Henshin_textPackage.eINSTANCE.getCall_Parameters());
          }
        }
      }
    }
  }
  
  /**
   * Warning if a parameter has the parameter kind UNKNOWN which is deprecated.
   * 
   * @param param to be checked parameter
   */
  @Check
  public void checkParameterKind(final Parameter param) {
    ParameterKind _kind = param.getKind();
    boolean _equals = Objects.equal(_kind, ParameterKind.UNKNOWN);
    if (_equals) {
      String _name = param.getName();
      String _plus = ("Parameter " + _name);
      String _plus_1 = (_plus + " should have a parameter kind of IN, INOUT, OUR or VAR. Specifying no parameter kind is deprecated.");
      this.warning(_plus_1, param, Henshin_textPackage.Literals.PARAMETER__KIND);
    }
  }
  
  /**
   * Fehler wenn eine Kante definiert wurde, die im ecore-Modell nicht existiert
   * 
   * @param edge Zu überprüfende Kante
   */
  @Check
  public void ckeckExistingEdge(final Edge edge) {
    EClass sourceType = null;
    EClass targetType = null;
    RuleNodeTypes _source = edge.getSource();
    boolean _notEquals = (!Objects.equal(_source, null));
    if (_notEquals) {
      RuleNodeTypes _source_1 = edge.getSource();
      if ((_source_1 instanceof Node)) {
        RuleNodeTypes _source_2 = edge.getSource();
        sourceType = ((Node) _source_2).getNodetype();
      } else {
        try {
          RuleNodeTypes _source_3 = edge.getSource();
          sourceType = ((MultiRuleReuseNode) _source_3).getName().getNodetype();
        } catch (final Throwable _t) {
          if (_t instanceof ClassCastException) {
            sourceType = null;
          } else {
            throw Exceptions.sneakyThrow(_t);
          }
        }
      }
    }
    RuleNodeTypes _target = edge.getTarget();
    boolean _notEquals_1 = (!Objects.equal(_target, null));
    if (_notEquals_1) {
      RuleNodeTypes _target_1 = edge.getTarget();
      if ((_target_1 instanceof Node)) {
        RuleNodeTypes _target_2 = edge.getTarget();
        targetType = ((Node) _target_2).getNodetype();
      } else {
        try {
          RuleNodeTypes _target_3 = edge.getTarget();
          targetType = ((MultiRuleReuseNode) _target_3).getName().getNodetype();
        } catch (final Throwable _t) {
          if (_t instanceof ClassCastException) {
            targetType = null;
          } else {
            throw Exceptions.sneakyThrow(_t);
          }
        }
      }
    }
    if (((!Objects.equal(sourceType, null)) && (!Objects.equal(targetType, null)))) {
      boolean wrongType = true;
      EClass referenceType = null;
      EList<EReference> _eAllReferences = sourceType.getEAllReferences();
      for (final EReference reference : _eAllReferences) {
        String _name = edge.getType().getName();
        String _name_1 = reference.getName();
        boolean _equals = Objects.equal(_name, _name_1);
        if (_equals) {
          wrongType = false;
          referenceType = reference.getEReferenceType();
        }
      }
      if (wrongType) {
        String _name_2 = edge.getType().getName();
        String _plus = ("Edgetype " + _name_2);
        String _plus_1 = (_plus + " does not exist.\'");
        this.error(_plus_1, edge, Henshin_textPackage.eINSTANCE.getEdge_Type());
      }
      if (((!Objects.equal(referenceType, targetType)) && (!targetType.getEAllSuperTypes().contains(referenceType)))) {
        String _name_3 = sourceType.getName();
        String _plus_2 = ("Edge " + _name_3);
        String _plus_3 = (_plus_2 + "->");
        String _name_4 = targetType.getName();
        String _plus_4 = (_plus_3 + _name_4);
        String _plus_5 = (_plus_4 + ":");
        String _name_5 = edge.getType().getName();
        String _plus_6 = (_plus_5 + _name_5);
        String _plus_7 = (_plus_6 + " does not exist.\'");
        this.error(_plus_7, edge, Henshin_textPackage.eINSTANCE.getEdge_Type());
      }
    }
  }
  
  /**
   * Fehler wenn ein Knotentyp verwendet wurde, der nicht importiert wurde
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkNodeType(final Node node) {
    boolean isImported = false;
    List<EPackageImport> _ePackageImports = this.getEPackageImports(node);
    for (final EPackageImport ePackage : _ePackageImports) {
      boolean _contains = ePackage.getRef().getEClassifiers().contains(node.getNodetype());
      if (_contains) {
        isImported = true;
      }
    }
    if ((!isImported)) {
      String _name = node.getNodetype().getName();
      String _plus = ("Nodetype " + _name);
      String _plus_1 = (_plus + " is not imported.\'");
      this.error(_plus_1, node, Henshin_textPackage.eINSTANCE.getNode_Nodetype());
    }
  }
  
  /**
   * Holt alle importierten EPackages anhand eines beliebigen Objekts
   */
  private List<EPackageImport> getEPackageImports(final EObject startObject) {
    List<EPackageImport> listOfEPackageImport = new ArrayList<EPackageImport>();
    EObject container = startObject.eContainer();
    while ((!(container instanceof Model))) {
      container = container.eContainer();
    }
    if ((container instanceof Model)) {
      listOfEPackageImport.addAll(((Model) container).getEPackageimports());
    }
    return listOfEPackageImport;
  }
  
  /**
   * Fehler wenn ein Attribut in einem Knoten definiert wurde das so nicht im ecore-Modell existiert
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkNodeAttribute(final Node node) {
    EList<Attribute> _attribute = node.getAttribute();
    for (final Attribute attribute : _attribute) {
      {
        boolean superTypeAttribute = false;
        boolean _contains = node.getNodetype().getEAttributes().contains(attribute.getName());
        boolean _not = (!_contains);
        if (_not) {
          EList<EClass> _eAllSuperTypes = node.getNodetype().getEAllSuperTypes();
          for (final EClass supertype : _eAllSuperTypes) {
            boolean _contains_1 = supertype.getEAttributes().contains(attribute.getName());
            if (_contains_1) {
              superTypeAttribute = true;
            }
          }
          if ((!superTypeAttribute)) {
            String _name = node.getNodetype().getName();
            String _plus = (_name + " has no attribute \'");
            String _name_1 = attribute.getName().getName();
            String _plus_1 = (_plus + _name_1);
            String _plus_2 = (_plus_1 + "\'.\'");
            this.error(_plus_2, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Name());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn in einem Knoten das selbe Attribut mehrfach definiert wird
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkattributeOnlyOnce(final Node node) {
    for (int i = 0; (i < node.getAttribute().size()); i++) {
      {
        Attribute attribute = node.getAttribute().get(i);
        for (int j = (i + 1); (j < node.getAttribute().size()); j++) {
          if ((Objects.equal(attribute.getName(), node.getAttribute().get(j).getName()) && Objects.equal(attribute.getUpdate(), node.getAttribute().get(j).getUpdate()))) {
            String _name = attribute.getName().getName();
            String _plus = ("\'" + _name);
            String _plus_1 = (_plus + "\' can only be used once.\'");
            this.error(_plus_1, node.getAttribute().get(j), Henshin_textPackage.eINSTANCE.getAttribute_Name());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn der Typ eines create Knoten abstrakt ist
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkAbstractNode(final Node node) {
    if ((node.getNodetype().isAbstract() && Objects.equal(node.getActiontype(), "create"))) {
      this.error("Node of abstract type cannot be created.\'", node, Henshin_textPackage.eINSTANCE.getNode_Nodetype());
    }
  }
  
  /**
   * Fehler wenn mehrere set-Attribute für ein Match-Attribut dfiniert wurden
   * 
   * @param node Knoten dessen Attribute überprüft werden
   */
  @Check
  public void checkSetAttribute(final Node node) {
    if ((Objects.equal(node.getActiontype(), "preserve") || Objects.equal(node.getActiontype(), null))) {
      EList<Attribute> _attribute = node.getAttribute();
      for (final Attribute attribute : _attribute) {
        String _update = attribute.getUpdate();
        boolean _notEquals = (!Objects.equal(_update, null));
        if (_notEquals) {
          EList<Attribute> _attribute_1 = node.getAttribute();
          for (final Attribute checkAttribute : _attribute_1) {
            if ((((!Objects.equal(checkAttribute, attribute)) && Objects.equal(attribute.getName(), checkAttribute.getName())) && ((!Objects.equal(checkAttribute.getUpdate(), null)) || Objects.equal(checkAttribute.getActiontype(), "create")))) {
              this.error("Duplicate update.\'", attribute, Henshin_textPackage.eINSTANCE.getAttribute_Update());
              this.error("Duplicate update.\'", checkAttribute, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
            }
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn für ein set-Attribut kein Match-Attribut definiert wurde
   * 
   * @param node Knotendessen Attribute überprüft werden
   */
  @Check
  public void checkSetandMatchAttribute(final Node node) {
    if ((Objects.equal(node.getActiontype(), "preserve") || Objects.equal(node.getActiontype(), null))) {
      EList<Attribute> _attribute = node.getAttribute();
      for (final Attribute attribute : _attribute) {
        String _update = attribute.getUpdate();
        boolean _notEquals = (!Objects.equal(_update, null));
        if (_notEquals) {
          boolean matchExist = false;
          EList<Attribute> _attribute_1 = node.getAttribute();
          for (final Attribute checkAttribute : _attribute_1) {
            if ((((!Objects.equal(checkAttribute, attribute)) && Objects.equal(attribute.getName(), checkAttribute.getName())) && (Objects.equal(checkAttribute.getActiontype(), "preserve") || (Objects.equal(checkAttribute.getActiontype(), null) && (Objects.equal(node.getActiontype(), "preserve") || Objects.equal(node.getActiontype(), null)))))) {
              matchExist = true;
            }
          }
          if ((!matchExist)) {
            String _name = attribute.getName().getName();
            String _plus = ("Preserve-attribute " + _name);
            String _plus_1 = (_plus + " needed.\'");
            this.error(_plus_1, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Update());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn der ActionType eines Attributes nicht zu dem ActionType des Knoten passt
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkNodeAttributeAction(final Node node) {
    String _actiontype = node.getActiontype();
    boolean _equals = Objects.equal(_actiontype, "create");
    if (_equals) {
      EList<Attribute> _attribute = node.getAttribute();
      for (final Attribute attribute : _attribute) {
        {
          if (((((Objects.equal(attribute.getActiontype(), "preserve") && Objects.equal(attribute.getUpdate(), null)) || Objects.equal(attribute.getActiontype(), "delete")) || Objects.equal(attribute.getActiontype(), "forbid")) || Objects.equal(attribute.getActiontype(), "require"))) {
            String _actiontype_1 = attribute.getActiontype();
            String _plus = (_actiontype_1 + "-attributes are not allowed in ");
            String _actiontype_2 = node.getActiontype();
            String _plus_1 = (_plus + _actiontype_2);
            String _plus_2 = (_plus_1 + "-nodes.\'");
            this.error(_plus_2, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
          }
          String _update = attribute.getUpdate();
          boolean _notEquals = (!Objects.equal(_update, null));
          if (_notEquals) {
            String _actiontype_3 = node.getActiontype();
            String _plus_3 = ("set-attributes are not allowed in " + _actiontype_3);
            String _plus_4 = (_plus_3 + "-nodes. \'");
            this.error(_plus_4, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Update());
          }
        }
      }
    } else {
      String _actiontype_1 = node.getActiontype();
      boolean _equals_1 = Objects.equal(_actiontype_1, "delete");
      if (_equals_1) {
        EList<Attribute> _attribute_1 = node.getAttribute();
        for (final Attribute attribute_1 : _attribute_1) {
          {
            if (((Objects.equal(attribute_1.getActiontype(), "preserve") && Objects.equal(attribute_1.getUpdate(), null)) || Objects.equal(attribute_1.getActiontype(), "create"))) {
              String _actiontype_2 = attribute_1.getActiontype();
              String _plus = (_actiontype_2 + "-attributes are not allowed in ");
              String _actiontype_3 = node.getActiontype();
              String _plus_1 = (_plus + _actiontype_3);
              String _plus_2 = (_plus_1 + "-nodes.\'");
              this.error(_plus_2, attribute_1, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
            }
            String _update = attribute_1.getUpdate();
            boolean _notEquals = (!Objects.equal(_update, null));
            if (_notEquals) {
              String _actiontype_4 = node.getActiontype();
              String _plus_3 = ("set-attributes are not allowed in " + _actiontype_4);
              String _plus_4 = (_plus_3 + "-nodes.\'");
              this.error(_plus_4, attribute_1, Henshin_textPackage.eINSTANCE.getAttribute_Update());
            }
          }
        }
      } else {
        String _actiontype_2 = node.getActiontype();
        boolean _equals_2 = Objects.equal(_actiontype_2, "forbid");
        if (_equals_2) {
          EList<Attribute> _attribute_2 = node.getAttribute();
          for (final Attribute attribute_2 : _attribute_2) {
            {
              if (((((Objects.equal(attribute_2.getActiontype(), "preserve") && Objects.equal(attribute_2.getUpdate(), null)) || Objects.equal(attribute_2.getActiontype(), "delete")) || Objects.equal(attribute_2.getActiontype(), "create")) || Objects.equal(attribute_2.getActiontype(), "require"))) {
                String _actiontype_3 = attribute_2.getActiontype();
                String _plus = (_actiontype_3 + "-attributes are not allowed in ");
                String _actiontype_4 = node.getActiontype();
                String _plus_1 = (_plus + _actiontype_4);
                String _plus_2 = (_plus_1 + "-nodes.\'");
                this.error(_plus_2, attribute_2, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
              }
              String _update = attribute_2.getUpdate();
              boolean _notEquals = (!Objects.equal(_update, null));
              if (_notEquals) {
                String _actiontype_5 = node.getActiontype();
                String _plus_3 = ("set-attributes are not allowed in " + _actiontype_5);
                String _plus_4 = (_plus_3 + "-nodes.\'");
                this.error(_plus_4, attribute_2, Henshin_textPackage.eINSTANCE.getAttribute_Update());
              }
            }
          }
        } else {
          String _actiontype_3 = node.getActiontype();
          boolean _equals_3 = Objects.equal(_actiontype_3, "require");
          if (_equals_3) {
            EList<Attribute> _attribute_3 = node.getAttribute();
            for (final Attribute attribute_3 : _attribute_3) {
              {
                if (((((Objects.equal(attribute_3.getActiontype(), "preserve") && Objects.equal(attribute_3.getUpdate(), null)) || Objects.equal(attribute_3.getActiontype(), "delete")) || Objects.equal(attribute_3.getActiontype(), "create")) || Objects.equal(attribute_3.getActiontype(), "forbid"))) {
                  String _actiontype_4 = attribute_3.getActiontype();
                  String _plus = (_actiontype_4 + "-attributes are not allowed in ");
                  String _actiontype_5 = node.getActiontype();
                  String _plus_1 = (_plus + _actiontype_5);
                  String _plus_2 = (_plus_1 + "-nodes.\'");
                  this.error(_plus_2, attribute_3, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                }
                String _update = attribute_3.getUpdate();
                boolean _notEquals = (!Objects.equal(_update, null));
                if (_notEquals) {
                  String _actiontype_6 = node.getActiontype();
                  String _plus_3 = ("set-attributes are not allowed in " + _actiontype_6);
                  String _plus_4 = (_plus_3 + "-nodes.\'");
                  this.error(_plus_4, attribute_3, Henshin_textPackage.eINSTANCE.getAttribute_Update());
                }
              }
            }
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn der ActionType der Kante nicht zu dem ActionType der Knoten passt
   * 
   * @param edge Zu überprüfende Kante
   */
  @Check
  public void checkNodeEdgeAction(final Edge edge) {
    Node source = null;
    Node target = null;
    RuleNodeTypes _source = edge.getSource();
    if ((_source instanceof Node)) {
      RuleNodeTypes _source_1 = edge.getSource();
      source = ((Node) _source_1);
    } else {
      try {
        RuleNodeTypes _source_2 = edge.getSource();
        source = ((MultiRuleReuseNode) _source_2).getName();
      } catch (final Throwable _t) {
        if (_t instanceof ClassCastException) {
          target = null;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    RuleNodeTypes _target = edge.getTarget();
    if ((_target instanceof Node)) {
      RuleNodeTypes _target_1 = edge.getTarget();
      target = ((Node) _target_1);
    } else {
      try {
        RuleNodeTypes _target_2 = edge.getTarget();
        target = ((MultiRuleReuseNode) _target_2).getName();
      } catch (final Throwable _t) {
        if (_t instanceof ClassCastException) {
          target = null;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    if (((!Objects.equal(target, null)) && (!Objects.equal(source, null)))) {
      String edgetype = edge.getActiontype();
      boolean _equals = Objects.equal(edgetype, null);
      if (_equals) {
        edgetype = "preserve";
      }
      String sourcetype = source.getActiontype();
      boolean _equals_1 = Objects.equal(sourcetype, null);
      if (_equals_1) {
        sourcetype = "preserve";
      }
      String tagettype = target.getActiontype();
      boolean _equals_2 = Objects.equal(tagettype, null);
      if (_equals_2) {
        tagettype = "preserve";
      }
      if ((Objects.equal(edge.getActiontype(), "preserve") || Objects.equal(edge.getActiontype(), null))) {
        if (((Objects.equal(source.getActiontype(), "preserve") || Objects.equal(source.getActiontype(), null)) && ((!Objects.equal(target.getActiontype(), "preserve")) && (!Objects.equal(target.getActiontype(), null))))) {
          this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
        } else {
          if (((!Objects.equal(source.getActiontype(), "preserve")) && (!Objects.equal(source.getActiontype(), null)))) {
            this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
          }
        }
      } else {
        String _actiontype = edge.getActiontype();
        boolean _equals_3 = Objects.equal(_actiontype, "create");
        if (_equals_3) {
          if ((((Objects.equal(source.getActiontype(), null) || Objects.equal(source.getActiontype(), "preserve")) || Objects.equal(source.getActiontype(), "create")) && (((!Objects.equal(target.getActiontype(), null)) && (!Objects.equal(target.getActiontype(), "preserve"))) && (!Objects.equal(target.getActiontype(), "create"))))) {
            this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
          } else {
            if ((((!Objects.equal(source.getActiontype(), null)) && (!Objects.equal(source.getActiontype(), "preserve"))) && (!Objects.equal(source.getActiontype(), "create")))) {
              this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
            }
          }
        } else {
          String _actiontype_1 = edge.getActiontype();
          boolean _equals_4 = Objects.equal(_actiontype_1, "delete");
          if (_equals_4) {
            if ((((Objects.equal(source.getActiontype(), null) || Objects.equal(source.getActiontype(), "preserve")) || Objects.equal(source.getActiontype(), "delete")) && (((!Objects.equal(target.getActiontype(), null)) && (!Objects.equal(target.getActiontype(), "preserve"))) && (!Objects.equal(target.getActiontype(), "delete"))))) {
              this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
            } else {
              if ((((!Objects.equal(source.getActiontype(), null)) && (!Objects.equal(source.getActiontype(), "preserve"))) && (!Objects.equal(source.getActiontype(), "delete")))) {
                this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
              }
            }
          } else {
            String _actiontype_2 = edge.getActiontype();
            boolean _equals_5 = Objects.equal(_actiontype_2, "forbid");
            if (_equals_5) {
              if (((((Objects.equal(source.getActiontype(), null) || Objects.equal(source.getActiontype(), "preserve")) || Objects.equal(source.getActiontype(), "delete")) || Objects.equal(source.getActiontype(), "forbid")) && (Objects.equal(target.getActiontype(), "create") || Objects.equal(target.getActiontype(), "require")))) {
                this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
              } else {
                if ((Objects.equal(source.getActiontype(), "create") || Objects.equal(source.getActiontype(), "require"))) {
                  this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                }
              }
            } else {
              String _actiontype_3 = edge.getActiontype();
              boolean _equals_6 = Objects.equal(_actiontype_3, "require");
              if (_equals_6) {
                if (((((Objects.equal(source.getActiontype(), null) || Objects.equal(source.getActiontype(), "preserve")) || Objects.equal(source.getActiontype(), "delete")) || Objects.equal(source.getActiontype(), "require")) && (Objects.equal(target.getActiontype(), "create") || Objects.equal(target.getActiontype(), "forbid")))) {
                  this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                } else {
                  if ((Objects.equal(source.getActiontype(), "create") || Objects.equal(source.getActiontype(), "forbid"))) {
                    this.error((((((("A " + edgetype) + "-edge is not allowed between a ") + sourcetype) + "-node and a ") + tagettype) + "-node.\'"), edge, Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn nicht genau ein Graph in einer Regel definiert wurde
   * 
   * @param rule Zu überprüfende Regel
   */
  @Check
  public void checkCountGraph(final Rule rule) {
    Iterable<GraphImpl> iterableOfGraphImpl = Iterables.<GraphImpl>filter(rule.getRuleElements(), GraphImpl.class);
    int _size = IterableExtensions.size(iterableOfGraphImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final GraphImpl graph : iterableOfGraphImpl) {
        String _name = rule.getName();
        String _plus = ("Multiple graphs in rule " + _name);
        String _plus_1 = (_plus + ".\'");
        this.error(_plus_1, graph, Henshin_textPackage.Literals.GRAPH__GRAPH_ELEMENTS);
      }
    } else {
      int _size_1 = IterableExtensions.size(iterableOfGraphImpl);
      boolean _equals = (_size_1 == 0);
      if (_equals) {
        String _name_1 = rule.getName();
        String _plus_2 = ("No graph in rule " + _name_1);
        String _plus_3 = (_plus_2 + ".\'");
        this.error(_plus_3, rule, Henshin_textPackage.eINSTANCE.getRule_RuleElements());
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein CheckDangling-Element in einer Regel definiert wurde
   * 
   * @param rule Zu überprüfende Regel
   */
  @Check
  public void checkCountCheckDangling(final Rule rule) {
    Iterable<CheckDanglingImpl> iterableOfCheckDanglingImpl = Iterables.<CheckDanglingImpl>filter(rule.getRuleElements(), CheckDanglingImpl.class);
    int _size = IterableExtensions.size(iterableOfCheckDanglingImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final CheckDanglingImpl checkDangling : iterableOfCheckDanglingImpl) {
        this.error("CheckDangling can only be used once.\'", checkDangling, Henshin_textPackage.Literals.CHECK_DANGLING__CHECK_DANGLING);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein InjectiveMatching-Element in einer Regel definiert wurde
   * 
   * @param rule Zu überprüfende Regel
   */
  @Check
  public void checkCountInjectiveMatching(final Rule rule) {
    Iterable<InjectiveMatchingImpl> iterableOfInjectiveMatchingImpl = Iterables.<InjectiveMatchingImpl>filter(rule.getRuleElements(), InjectiveMatchingImpl.class);
    int _size = IterableExtensions.size(iterableOfInjectiveMatchingImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final InjectiveMatchingImpl injectiveMatching : iterableOfInjectiveMatchingImpl) {
        this.error("InjectiveMatching can only be used once.\'", injectiveMatching, Henshin_textPackage.Literals.INJECTIVE_MATCHING__INJECTIVE_MATCHING);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Conditions-Element in einer Regel definiert wurde
   * 
   * @param rule Zu überprüfende Regel
   */
  @Check
  public void checkCountCondition(final Rule rule) {
    Iterable<ConditionsImpl> iterableOfConditionsImpl = Iterables.<ConditionsImpl>filter(rule.getRuleElements(), ConditionsImpl.class);
    int _size = IterableExtensions.size(iterableOfConditionsImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final ConditionsImpl conditions : iterableOfConditionsImpl) {
        this.error("Conditions can only be used once.\'", conditions, Henshin_textPackage.Literals.CONDITIONS__ATTRIBUTE_CONDITIONS);
      }
    }
  }
  
  /**
   * Fehler wenn das in eine Regel importierte Java-Package nicht existiert
   * 
   * @param rule Zu überprüfende Regel
   */
  @Check
  public void checkJavaImport(final Rule rule) {
    Iterable<JavaImportImpl> iterableOfJavaImportImpl = Iterables.<JavaImportImpl>filter(rule.getRuleElements(), JavaImportImpl.class);
    for (final JavaImportImpl javaImport : iterableOfJavaImportImpl) {
      Package _package = Package.getPackage(javaImport.getPackagename());
      boolean _equals = Objects.equal(_package, null);
      if (_equals) {
        String _packagename = javaImport.getPackagename();
        String _plus = ("Package " + _packagename);
        String _plus_1 = (_plus + " doesn\'t exist.\'");
        this.error(_plus_1, javaImport, Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
      }
    }
  }
  
  /**
   * Warnt wenn Java-Packages mehrfach in Regel importiert wurden
   * 
   * @param rule Zu überprüfende Regel
   */
  @Check
  public void checkMultiJavaImport(final Rule rule) {
    Iterable<JavaImportImpl> iterableOfJavaImportImpl = Iterables.<JavaImportImpl>filter(rule.getRuleElements(), JavaImportImpl.class);
    for (int i = 0; (i < IterableExtensions.size(iterableOfJavaImportImpl)); i++) {
      {
        final Iterable<JavaImportImpl> _converted_iterableOfJavaImportImpl = (Iterable<JavaImportImpl>)iterableOfJavaImportImpl;
        JavaImportImpl javaImport = ((JavaImportImpl[])Conversions.unwrapArray(_converted_iterableOfJavaImportImpl, JavaImportImpl.class))[i];
        for (int j = (i + 1); (j < IterableExtensions.size(iterableOfJavaImportImpl)); j++) {
          final Iterable<JavaImportImpl> _converted_iterableOfJavaImportImpl_1 = (Iterable<JavaImportImpl>)iterableOfJavaImportImpl;
          String _packagename = (((JavaImportImpl[])Conversions.unwrapArray(_converted_iterableOfJavaImportImpl_1, JavaImportImpl.class))[j]).getPackagename();
          String _packagename_1 = javaImport.getPackagename();
          boolean _equals = Objects.equal(_packagename, _packagename_1);
          if (_equals) {
            String _packagename_2 = javaImport.getPackagename();
            String _plus = ("Package " + _packagename_2);
            String _plus_1 = (_plus + " is already imported.\'");
            final Iterable<JavaImportImpl> _converted_iterableOfJavaImportImpl_2 = (Iterable<JavaImportImpl>)iterableOfJavaImportImpl;
            this.warning(_plus_1, ((EObject[])Conversions.unwrapArray(_converted_iterableOfJavaImportImpl_2, EObject.class))[j], Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn das in eine MultiRegel importierte Java-Package nicht existiert
   * 
   * @param rule Zu überprüfende MultiRegel
   */
  @Check
  public void checkJavaImport(final MultiRule rule) {
    Iterable<JavaImportImpl> iterableOfJavaImportImpl = Iterables.<JavaImportImpl>filter(rule.getMultiruleElements(), JavaImportImpl.class);
    for (final JavaImportImpl javaImport : iterableOfJavaImportImpl) {
      Package _package = Package.getPackage(javaImport.getPackagename());
      boolean _equals = Objects.equal(_package, null);
      if (_equals) {
        String _packagename = javaImport.getPackagename();
        String _plus = ("Package " + _packagename);
        String _plus_1 = (_plus + " doesn\'t exist.\'");
        this.error(_plus_1, javaImport, Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
      }
    }
  }
  
  /**
   * Warnt wenn Java-Packages mehrfach in MultiRegel importiert wurden
   * 
   * @param rule Zu überprüfende MultiRegel
   */
  @Check
  public void checkMultiJavaImport(final MultiRule rule) {
    Iterable<JavaImportImpl> iterableOfJavaImportImpl = Iterables.<JavaImportImpl>filter(rule.getMultiruleElements(), JavaImportImpl.class);
    for (int i = 0; (i < IterableExtensions.size(iterableOfJavaImportImpl)); i++) {
      {
        final Iterable<JavaImportImpl> _converted_iterableOfJavaImportImpl = (Iterable<JavaImportImpl>)iterableOfJavaImportImpl;
        JavaImportImpl javaImport = ((JavaImportImpl[])Conversions.unwrapArray(_converted_iterableOfJavaImportImpl, JavaImportImpl.class))[i];
        for (int j = (i + 1); (j < IterableExtensions.size(iterableOfJavaImportImpl)); j++) {
          final Iterable<JavaImportImpl> _converted_iterableOfJavaImportImpl_1 = (Iterable<JavaImportImpl>)iterableOfJavaImportImpl;
          String _packagename = (((JavaImportImpl[])Conversions.unwrapArray(_converted_iterableOfJavaImportImpl_1, JavaImportImpl.class))[j]).getPackagename();
          String _packagename_1 = javaImport.getPackagename();
          boolean _equals = Objects.equal(_packagename, _packagename_1);
          if (_equals) {
            String _packagename_2 = javaImport.getPackagename();
            String _plus = ("Package " + _packagename_2);
            String _plus_1 = (_plus + " is already imported.\'");
            final Iterable<JavaImportImpl> _converted_iterableOfJavaImportImpl_2 = (Iterable<JavaImportImpl>)iterableOfJavaImportImpl;
            this.warning(_plus_1, ((EObject[])Conversions.unwrapArray(_converted_iterableOfJavaImportImpl_2, EObject.class))[j], Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Conditions-Element in einer MultiRegel definiert wurde
   * 
   * @param rule Zu überprüfende MultiRegel
   */
  @Check
  public void checkCountCondition(final MultiRule rule) {
    Iterable<ConditionsImpl> iterableOfConditionsImpl = Iterables.<ConditionsImpl>filter(rule.getMultiruleElements(), ConditionsImpl.class);
    int _size = IterableExtensions.size(iterableOfConditionsImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final ConditionsImpl conditions : iterableOfConditionsImpl) {
        this.error("Conditions can only be used once.\'", conditions, Henshin_textPackage.Literals.CONDITIONS__ATTRIBUTE_CONDITIONS);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein InjectiveMatching-Element in einer MultiRegel definiert wurde
   * 
   * @param rule Zu überprüfende MultiRegel
   */
  @Check
  public void checkCountInjectiveMatching(final MultiRule rule) {
    Iterable<InjectiveMatchingImpl> iterableOfInjectiveMatchingImpl = Iterables.<InjectiveMatchingImpl>filter(rule.getMultiruleElements(), InjectiveMatchingImpl.class);
    int _size = IterableExtensions.size(iterableOfInjectiveMatchingImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final InjectiveMatchingImpl injectiveMatching : iterableOfInjectiveMatchingImpl) {
        this.error("InjectiveMatching can only be used once.\'", injectiveMatching, Henshin_textPackage.Literals.INJECTIVE_MATCHING__INJECTIVE_MATCHING);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein CheckDangling-Element in einer MultiRegel definiert wurde
   * 
   * @param rule Zu überprüfende MultiRegel
   */
  @Check
  public void checkCountCheckDangling(final MultiRule rule) {
    Iterable<CheckDanglingImpl> iterableOfCheckDanglingImpl = Iterables.<CheckDanglingImpl>filter(rule.getMultiruleElements(), CheckDanglingImpl.class);
    int _size = IterableExtensions.size(iterableOfCheckDanglingImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final CheckDanglingImpl checkDangling : iterableOfCheckDanglingImpl) {
        this.error("CheckDangling can only be used once.\'", checkDangling, Henshin_textPackage.Literals.CHECK_DANGLING__CHECK_DANGLING);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Graph in einer MultiRegel definiert wurde
   * 
   * @param rule Zu überprüfende MultiRegel
   */
  @Check
  public void checkCountGraph(final MultiRule rule) {
    Iterable<GraphImpl> iterableOfGraphImpl = Iterables.<GraphImpl>filter(rule.getMultiruleElements(), GraphImpl.class);
    int _size = IterableExtensions.size(iterableOfGraphImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final GraphImpl graph : iterableOfGraphImpl) {
        String _name = rule.getName();
        String _plus = ("Multiple graphs in rule " + _name);
        String _plus_1 = (_plus + ".\'");
        this.error(_plus_1, graph, Henshin_textPackage.Literals.GRAPH__GRAPH_ELEMENTS);
      }
    }
  }
  
  /**
   * Fehler wenn ein Attribut in einem reuse-Knoten definiert wurde das so nicht im ecore-Modell existiert
   * 
   * @param node Zu überprüfender reuse-Knoten
   */
  @Check
  public void checkNodeAttribute(final MultiRuleReuseNode node) {
    EList<Attribute> _attribute = node.getAttribute();
    for (final Attribute attribute : _attribute) {
      {
        boolean superTypeAttribute = false;
        boolean _contains = node.getName().getNodetype().getEAttributes().contains(attribute.getName());
        boolean _not = (!_contains);
        if (_not) {
          EList<EClass> _eAllSuperTypes = node.getName().getNodetype().getEAllSuperTypes();
          for (final EClass supertype : _eAllSuperTypes) {
            boolean _contains_1 = supertype.getEAttributes().contains(attribute.getName());
            if (_contains_1) {
              superTypeAttribute = true;
            }
          }
          if ((!superTypeAttribute)) {
            String _name = node.getName().getNodetype().getName();
            String _plus = (_name + " has no attribute \'");
            String _name_1 = attribute.getName().getName();
            String _plus_1 = (_plus + _name_1);
            String _plus_2 = (_plus_1 + "\'.\'");
            this.error(_plus_2, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Name());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn in einem reuse-Knoten das selbe Attribut mehrfach definiert wird
   * 
   * @param node Zu überprüfender reuse-Knoten
   */
  @Check
  public void checkattributeOnlyOnce(final MultiRuleReuseNode node) {
    for (int i = 0; (i < node.getAttribute().size()); i++) {
      {
        Attribute attribute = node.getAttribute().get(i);
        for (int j = (i + 1); (j < node.getAttribute().size()); j++) {
          if ((Objects.equal(attribute.getName(), node.getAttribute().get(j).getName()) && Objects.equal(attribute.getUpdate(), node.getAttribute().get(j).getUpdate()))) {
            String _name = attribute.getName().getName();
            String _plus = ("\'" + _name);
            String _plus_1 = (_plus + "\' can only be used once.\'");
            this.error(_plus_1, node.getAttribute().get(j), Henshin_textPackage.eINSTANCE.getAttribute_Name());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein forbid- oder require-Knoten in einer Kanten einer MultiRegel wiederverwendet werden soll
   * 
   * @param conNodes Liste von forbid- und require-Knoten von darüberliegenden Graphen
   * @param graph Zu überprüfender Graph
   */
  private void checkEdgesInMultiRuleRekursive(final List<Node> conNodes, final Graph graph) {
    Iterable<Edges> _filter = Iterables.<Edges>filter(graph.getGraphElements(), Edges.class);
    for (final Edges edges : _filter) {
      EList<Edge> _edges = edges.getEdges();
      for (final Edge edge : _edges) {
        {
          Node testNode = null;
          RuleNodeTypes _source = edge.getSource();
          boolean _notEquals = (!Objects.equal(_source, null));
          if (_notEquals) {
            RuleNodeTypes _source_1 = edge.getSource();
            if ((_source_1 instanceof Node)) {
              RuleNodeTypes _source_2 = edge.getSource();
              testNode = ((Node) _source_2);
            } else {
              try {
                RuleNodeTypes _source_3 = edge.getSource();
                testNode = ((MultiRuleReuseNode) _source_3).getName();
              } catch (final Throwable _t) {
                if (_t instanceof ClassCastException) {
                  testNode = null;
                } else {
                  throw Exceptions.sneakyThrow(_t);
                }
              }
            }
          }
          for (final Node conNode : conNodes) {
            String _name = conNode.getName();
            String _name_1 = testNode.getName();
            boolean _equals = Objects.equal(_name, _name_1);
            if (_equals) {
              String _actiontype = testNode.getActiontype();
              String _plus = (_actiontype + "-nodes are not allowed to be reused in edges in MultiRuleReuseNodes.\'");
              this.error(_plus, edge, Henshin_textPackage.eINSTANCE.getEdge_Source());
            }
          }
          RuleNodeTypes _target = edge.getTarget();
          boolean _notEquals_1 = (!Objects.equal(_target, null));
          if (_notEquals_1) {
            RuleNodeTypes _target_1 = edge.getTarget();
            if ((_target_1 instanceof Node)) {
              RuleNodeTypes _target_2 = edge.getTarget();
              testNode = ((Node) _target_2);
            } else {
              RuleNodeTypes _target_3 = edge.getTarget();
              testNode = ((MultiRuleReuseNode) _target_3).getName();
            }
          }
          for (final Node conNode_1 : conNodes) {
            String _name_2 = conNode_1.getName();
            String _name_3 = testNode.getName();
            boolean _equals_1 = Objects.equal(_name_2, _name_3);
            if (_equals_1) {
              String _actiontype_1 = testNode.getActiontype();
              String _plus_1 = (_actiontype_1 + "-nodes are not allowed to be reused in edges in MultiRuleReuseNodes.\'");
              this.error(_plus_1, edge, Henshin_textPackage.eINSTANCE.getEdge_Target());
            }
          }
        }
      }
    }
    Iterable<MultiRule> multiRules = Iterables.<MultiRule>filter(graph.getGraphElements(), MultiRule.class);
    int _size = IterableExtensions.size(multiRules);
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      Iterable<Node> _filter_1 = Iterables.<Node>filter(graph.getGraphElements(), Node.class);
      for (final Node node : _filter_1) {
        if ((Objects.equal(node.getActiontype(), "forbid") || Objects.equal(node.getActiontype(), "require"))) {
          conNodes.add(node);
        }
      }
      for (final MultiRule multiRule : multiRules) {
        this.checkEdgesInMultiRuleRekursive(conNodes, ((Graph[])Conversions.unwrapArray(Iterables.<Graph>filter(multiRule.getMultiruleElements(), Graph.class), Graph.class))[0]);
      }
    }
  }
  
  /**
   * Fehler wenn ein forbid- oder require-Knoten in einer Kanten einer MultiRegel wiederverwendet werden soll
   * 
   * @paran rule Zu überprüfende Regel
   */
  @Check
  public void checkEdgesInMultiRule(final Rule rule) {
    Iterable<Graph> graph = Iterables.<Graph>filter(rule.getRuleElements(), Graph.class);
    int _size = IterableExtensions.size(graph);
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<Node> conNodes = new ArrayList<Node>();
      final Iterable<Graph> _converted_graph = (Iterable<Graph>)graph;
      Iterable<Node> _filter = Iterables.<Node>filter((((Graph[])Conversions.unwrapArray(_converted_graph, Graph.class))[0]).getGraphElements(), Node.class);
      for (final Node node : _filter) {
        if ((Objects.equal(node.getActiontype(), "forbid") || Objects.equal(node.getActiontype(), "require"))) {
          conNodes.add(node);
        }
      }
      final Iterable<Graph> _converted_graph_1 = (Iterable<Graph>)graph;
      Iterable<MultiRule> _filter_1 = Iterables.<MultiRule>filter((((Graph[])Conversions.unwrapArray(_converted_graph_1, Graph.class))[0]).getGraphElements(), MultiRule.class);
      for (final MultiRule multiRule : _filter_1) {
        int _size_1 = IterableExtensions.size(Iterables.<Graph>filter(multiRule.getMultiruleElements(), Graph.class));
        boolean _greaterThan_1 = (_size_1 > 0);
        if (_greaterThan_1) {
          this.checkEdgesInMultiRuleRekursive(conNodes, ((Graph[])Conversions.unwrapArray(Iterables.<Graph>filter(multiRule.getMultiruleElements(), Graph.class), Graph.class))[0]);
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Knoten mit ActionType require oder forbid reused wird
   * 
   * @parameter multiReuseNode Zu überprüfender reuse-Node
   */
  @Check
  public void checkMultiRuleReuseNodeActionType(final MultiRuleReuseNode multiReuseNode) {
    if ((Objects.equal(multiReuseNode.getName().getActiontype(), "require") || Objects.equal(multiReuseNode.getName().getActiontype(), "forbid"))) {
      String _actiontype = multiReuseNode.getName().getActiontype();
      String _plus = (_actiontype + "-Node \'");
      String _name = multiReuseNode.getName().getName();
      String _plus_1 = (_plus + _name);
      String _plus_2 = (_plus_1 + "\' is not allowed in MultiRules.\'");
      this.error(_plus_2, multiReuseNode, Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
    }
  }
  
  /**
   * Fehler wenn in einem reuse-Node ein set-Attribut definiert wurde
   * 
   * @param reuseNode Zu überprüfender reuse-Node
   */
  @Check
  public void checkMultiRuleReuseNodAttributeSet(final MultiRuleReuseNode reuseNode) {
    EList<Attribute> _attribute = reuseNode.getAttribute();
    for (final Attribute attribute : _attribute) {
      String _update = attribute.getUpdate();
      boolean _notEquals = (!Objects.equal(_update, null));
      if (_notEquals) {
        this.error("Set-attributes are not allowed in MultiRuleReuseNodes.\'", attribute, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
      }
    }
  }
  
  /**
   * Fehler wenn der ActionType der Attribute eines reuse-Nodes nicht zum ActionType des orginal Knoten passen
   * 
   * @param reuseNode Zu überprüfender reuse-Node
   */
  @Check
  public void checkMultiRuleReuseNodAttributeAction(final MultiRuleReuseNode reuseNode) {
    String reuseNodeType = reuseNode.getName().getActiontype();
    boolean _equals = Objects.equal(reuseNodeType, null);
    if (_equals) {
      reuseNodeType = "preserve";
    }
    String _actiontype = reuseNode.getName().getActiontype();
    boolean _equals_1 = Objects.equal(_actiontype, "create");
    if (_equals_1) {
      EList<Attribute> _attribute = reuseNode.getAttribute();
      for (final Attribute attribute : _attribute) {
        if (((!Objects.equal(attribute.getActiontype(), "create")) && (!Objects.equal(attribute.getActiontype(), null)))) {
          String _actiontype_1 = attribute.getActiontype();
          String _plus = (_actiontype_1 + "-attributes are not allowed in ");
          String _plus_1 = (_plus + reuseNodeType);
          String _plus_2 = (_plus_1 + "-reuseNodes. \'");
          this.error(_plus_2, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
        }
      }
    } else {
      String _actiontype_2 = reuseNode.getName().getActiontype();
      boolean _equals_2 = Objects.equal(_actiontype_2, "delete");
      if (_equals_2) {
        EList<Attribute> _attribute_1 = reuseNode.getAttribute();
        for (final Attribute attribute_1 : _attribute_1) {
          if (((!Objects.equal(attribute_1.getActiontype(), "delete")) && (!Objects.equal(attribute_1.getActiontype(), null)))) {
            String _actiontype_3 = attribute_1.getActiontype();
            String _plus_3 = (_actiontype_3 + "-attributes are not allowed in ");
            String _plus_4 = (_plus_3 + reuseNodeType);
            String _plus_5 = (_plus_4 + "-reuseNodes. \'");
            this.error(_plus_5, attribute_1, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
          }
        }
      } else {
        if ((Objects.equal(reuseNode.getName().getActiontype(), "preserve") || Objects.equal(reuseNode.getName().getActiontype(), null))) {
          EList<Attribute> _attribute_2 = reuseNode.getAttribute();
          for (final Attribute attribute_2 : _attribute_2) {
            if ((Objects.equal(attribute_2.getActiontype(), "forbid") || Objects.equal(attribute_2.getActiontype(), "require"))) {
              String _actiontype_4 = attribute_2.getActiontype();
              String _plus_6 = (_actiontype_4 + "-attributes are not allowed in ");
              String _plus_7 = (_plus_6 + reuseNodeType);
              String _plus_8 = (_plus_7 + "-reuseNodes. \'");
              this.error(_plus_8, attribute_2, Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
            }
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Graph der nicht zu einer MultiRegel gehört einen Knoten reused
   * 
   * @param rule Zu überprüfende Regel
   */
  @Check
  public void checkRuleReuseNodes(final Rule rule) {
    Iterable<Graph> graph = Iterables.<Graph>filter(rule.getRuleElements(), Graph.class);
    int _size = IterableExtensions.size(graph);
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final Iterable<Graph> _converted_graph = (Iterable<Graph>)graph;
      Iterable<MultiRuleReuseNode> reuseNodes = Iterables.<MultiRuleReuseNode>filter((((Graph[])Conversions.unwrapArray(_converted_graph, Graph.class))[0]).getGraphElements(), MultiRuleReuseNode.class);
      for (final MultiRuleReuseNode node : reuseNodes) {
        this.error("Reuse-Nodes are only allowed in multiRules.\'\'", node, Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
      }
    }
  }
  
  /**
   * Fehler wenn ein Knoten wie ein MultiRuleReuseNode benannt wurde
   * 
   * @param graph Zu überprüfender Graph
   */
  @Check
  public void checkMultiRuleGraphNodes(final Graph graph) {
    Iterable<MultiRuleReuseNode> _filter = Iterables.<MultiRuleReuseNode>filter(graph.getGraphElements(), MultiRuleReuseNode.class);
    for (final MultiRuleReuseNode reuse : _filter) {
      Iterable<Node> _filter_1 = Iterables.<Node>filter(graph.getGraphElements(), Node.class);
      for (final Node node : _filter_1) {
        String _name = reuse.getName().getName();
        String _name_1 = node.getName();
        boolean _equals = Objects.equal(_name, _name_1);
        if (_equals) {
          this.error("Graph cannot reuse its own nodes.\'", reuse, Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Knoten mehrfach reused wird in einem Graphen
   * 
   * @param graph Zu überprüfender Graph
   */
  @Check
  public void checkGraphMultiReuse(final Graph graph) {
    Iterable<MultiRuleReuseNode> reuseNodes = Iterables.<MultiRuleReuseNode>filter(graph.getGraphElements(), MultiRuleReuseNode.class);
    for (int i = 0; (i < IterableExtensions.size(reuseNodes)); i++) {
      for (int j = (i + 1); (j < IterableExtensions.size(reuseNodes)); j++) {
        final Iterable<MultiRuleReuseNode> _converted_reuseNodes = (Iterable<MultiRuleReuseNode>)reuseNodes;
        String _name = (((MultiRuleReuseNode[])Conversions.unwrapArray(_converted_reuseNodes, MultiRuleReuseNode.class))[i]).getName().getName();
        final Iterable<MultiRuleReuseNode> _converted_reuseNodes_1 = (Iterable<MultiRuleReuseNode>)reuseNodes;
        String _name_1 = (((MultiRuleReuseNode[])Conversions.unwrapArray(_converted_reuseNodes_1, MultiRuleReuseNode.class))[j]).getName().getName();
        boolean _equals = Objects.equal(_name, _name_1);
        if (_equals) {
          final Iterable<MultiRuleReuseNode> _converted_reuseNodes_2 = (Iterable<MultiRuleReuseNode>)reuseNodes;
          String _name_2 = (((MultiRuleReuseNode[])Conversions.unwrapArray(_converted_reuseNodes_2, MultiRuleReuseNode.class))[j]).getName().getName();
          String _plus = (_name_2 + " is already reused.\'");
          final Iterable<MultiRuleReuseNode> _converted_reuseNodes_3 = (Iterable<MultiRuleReuseNode>)reuseNodes;
          this.error(_plus, ((EObject[])Conversions.unwrapArray(_converted_reuseNodes_3, EObject.class))[j], Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Graph einer MultiRegel einen Knoten eines darüberliegenden Graphen überschreibt
   * 
   * @param graph Graph der rekursiv durchsucht wird
   */
  @Check
  public void checkOverrideNodeNamesinMultiRuleGraph(final Graph graph) {
    Iterable<MultiRule> multiRules = Iterables.<MultiRule>filter(graph.getGraphElements(), MultiRule.class);
    List<Node> topNodes = new ArrayList<Node>();
    for (final MultiRule rule : multiRules) {
      Iterable<Graph> _filter = Iterables.<Graph>filter(rule.getMultiruleElements(), Graph.class);
      for (final Graph multiGraph : _filter) {
        {
          Iterable<Node> _filter_1 = Iterables.<Node>filter(multiGraph.getGraphElements(), Node.class);
          for (final Node multiNode : _filter_1) {
            Iterable<Node> _filter_2 = Iterables.<Node>filter(graph.getGraphElements(), Node.class);
            for (final Node node : _filter_2) {
              {
                topNodes.add(node);
                String _name = multiNode.getName();
                String _name_1 = node.getName();
                boolean _equals = Objects.equal(_name, _name_1);
                if (_equals) {
                  String _name_2 = multiNode.getName();
                  String _plus = ("Duplicate Node \'" + _name_2);
                  String _plus_1 = (_plus + "\'.\'");
                  this.error(_plus_1, multiNode, Henshin_textPackage.eINSTANCE.getNode_Nodetype());
                }
              }
            }
          }
          int _size = IterableExtensions.size(Iterables.<MultiRule>filter(multiGraph.getGraphElements(), MultiRule.class));
          boolean _greaterThan = (_size > 0);
          if (_greaterThan) {
            this.checkRekursiveOverrideNodeNamesinMultiRuleGraph(topNodes, multiGraph);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Graph einer MultiRegel einen Knoten eines darüberliegenden Graphen überschreibt
   * 
   * @param topNodes Liste der darüberliegenden Graphknoten
   * @param graph Zu überprüfender Graph
   */
  private void checkRekursiveOverrideNodeNamesinMultiRuleGraph(final List<Node> topNodes, final Graph graph) {
    Iterable<MultiRule> multiRules = Iterables.<MultiRule>filter(graph.getGraphElements(), MultiRule.class);
    for (final MultiRule rule : multiRules) {
      Iterable<Graph> _filter = Iterables.<Graph>filter(rule.getMultiruleElements(), Graph.class);
      for (final Graph multiGraph : _filter) {
        {
          Iterable<Node> _filter_1 = Iterables.<Node>filter(multiGraph.getGraphElements(), Node.class);
          for (final Node multiNode : _filter_1) {
            {
              for (final Node node : topNodes) {
                String _name = multiNode.getName();
                String _name_1 = node.getName();
                boolean _equals = Objects.equal(_name, _name_1);
                if (_equals) {
                  String _name_2 = multiNode.getName();
                  String _plus = ("Duplicate Node \'" + _name_2);
                  String _plus_1 = (_plus + "\'.\'");
                  this.error(_plus_1, multiNode, Henshin_textPackage.eINSTANCE.getNode_Nodetype());
                }
              }
              Iterable<Node> _filter_2 = Iterables.<Node>filter(graph.getGraphElements(), Node.class);
              for (final Node node_1 : _filter_2) {
                {
                  topNodes.add(node_1);
                  String _name_3 = multiNode.getName();
                  String _name_4 = node_1.getName();
                  boolean _equals_1 = Objects.equal(_name_3, _name_4);
                  if (_equals_1) {
                    String _name_5 = multiNode.getName();
                    String _plus_2 = ("Duplicate Node \'" + _name_5);
                    String _plus_3 = (_plus_2 + "\'.\'");
                    this.error(_plus_3, multiNode, Henshin_textPackage.eINSTANCE.getNode_Nodetype());
                  }
                }
              }
            }
          }
          int _size = IterableExtensions.size(Iterables.<MultiRule>filter(multiGraph.getGraphElements(), MultiRule.class));
          boolean _greaterThan = (_size > 0);
          if (_greaterThan) {
            this.checkRekursiveOverrideNodeNamesinMultiRuleGraph(topNodes, multiGraph);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn eine Kante in einem ConditionGraph definiert wurde, die nicht im ecore-Modell existiert
   * 
   * @param edge Zu überprüfende Kante
   */
  @Check
  public void ckeckExistingEdge(final ConditionEdge edge) {
    EClass sourceType = null;
    EClass targetType = null;
    ConditionNodeTypes _source = edge.getSource();
    if ((_source instanceof Node)) {
      ConditionNodeTypes _source_1 = edge.getSource();
      sourceType = ((Node) _source_1).getNodetype();
    } else {
      try {
        ConditionNodeTypes _source_2 = edge.getSource();
        sourceType = ((ConditionNode) _source_2).getType();
      } catch (final Throwable _t) {
        if (_t instanceof ClassCastException) {
          sourceType = null;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    ConditionNodeTypes _target = edge.getTarget();
    if ((_target instanceof Node)) {
      ConditionNodeTypes _target_1 = edge.getTarget();
      targetType = ((Node) _target_1).getNodetype();
    } else {
      try {
        ConditionNodeTypes _target_2 = edge.getTarget();
        targetType = ((ConditionNode) _target_2).getType();
      } catch (final Throwable _t) {
        if (_t instanceof ClassCastException) {
          targetType = null;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    if (((!Objects.equal(sourceType, null)) && (!Objects.equal(targetType, null)))) {
      boolean wrongType = true;
      EClass referenceType = null;
      EList<EReference> _eAllReferences = sourceType.getEAllReferences();
      for (final EReference reference : _eAllReferences) {
        String _name = edge.getType().getName();
        String _name_1 = reference.getName();
        boolean _equals = Objects.equal(_name, _name_1);
        if (_equals) {
          wrongType = false;
          referenceType = reference.getEReferenceType();
        }
      }
      if (wrongType) {
        String _name_2 = edge.getType().getName();
        String _plus = ("Edgetype " + _name_2);
        String _plus_1 = (_plus + " does not exist.\'");
        this.error(_plus_1, edge, Henshin_textPackage.eINSTANCE.getConditionEdge_Type());
      }
      if (((!Objects.equal(referenceType, targetType)) && (!targetType.getEAllSuperTypes().contains(referenceType)))) {
        String _name_3 = sourceType.getName();
        String _plus_2 = ("Edge " + _name_3);
        String _plus_3 = (_plus_2 + "->");
        String _name_4 = targetType.getName();
        String _plus_4 = (_plus_3 + _name_4);
        String _plus_5 = (_plus_4 + ":");
        String _name_5 = edge.getType().getName();
        String _plus_6 = (_plus_5 + _name_5);
        String _plus_7 = (_plus_6 + " does not exist.\'");
        this.error(_plus_7, edge, Henshin_textPackage.eINSTANCE.getConditionEdge_Type());
      }
    }
  }
  
  /**
   * Fehler wenn ein Attribut in einem Knoten eines ConditionGraphen definiert wurde das so nicht im ecore-Modell existiert
   * 
   * @param node Zu überprüfender Knoten eines ConditionGraphen
   */
  @Check
  public void checkNodeAttribute(final ConditionNode node) {
    EList<Match> _attribute = node.getAttribute();
    for (final Match attribute : _attribute) {
      {
        boolean superTypeAttribute = false;
        boolean _contains = node.getType().getEAttributes().contains(attribute.getName());
        boolean _not = (!_contains);
        if (_not) {
          EList<EClass> _eAllSuperTypes = node.getType().getEAllSuperTypes();
          for (final EClass supertype : _eAllSuperTypes) {
            boolean _contains_1 = supertype.getEAttributes().contains(attribute.getName());
            if (_contains_1) {
              superTypeAttribute = true;
            }
          }
          if ((!superTypeAttribute)) {
            String _name = node.getType().getName();
            String _plus = (_name + " has no attribute \'");
            String _name_1 = attribute.getName().getName();
            String _plus_1 = (_plus + _name_1);
            String _plus_2 = (_plus_1 + "\'.\'");
            this.error(_plus_2, attribute, Henshin_textPackage.eINSTANCE.getMatch_Name());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Knotentyp verwendet wurde, der nicht importiert wurde
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkConditionNodeType(final ConditionNode node) {
    boolean isImported = false;
    List<EPackageImport> _ePackageImports = this.getEPackageImports(node);
    for (final EPackageImport ePackage : _ePackageImports) {
      boolean _contains = ePackage.getRef().getEClassifiers().contains(node.getType());
      if (_contains) {
        isImported = true;
      }
    }
    if ((!isImported)) {
      String _name = node.getType().getName();
      String _plus = ("Nodetype " + _name);
      String _plus_1 = (_plus + " is not imported.\'");
      this.error(_plus_1, node, Henshin_textPackage.eINSTANCE.getConditionNode_Type());
    }
  }
  
  /**
   * Fehler wenn ein Attribut in einem reuse-Knoten eines ConditionGraphen definiert wurde das so nicht im ecore-Modell existiert
   * 
   * @param node Zu überprüfender reuse-Knoten eines ConditionGraphen
   */
  @Check
  public void checkNodeAttribute(final ConditionReuseNode node) {
    EClass nodeType = null;
    ConditionNodeTypes _name = node.getName();
    if ((_name instanceof Node)) {
      ConditionNodeTypes _name_1 = node.getName();
      nodeType = ((Node) _name_1).getNodetype();
    } else {
      try {
        ConditionNodeTypes _name_2 = node.getName();
        nodeType = ((ConditionNode) _name_2).getType();
      } catch (final Throwable _t) {
        if (_t instanceof ClassCastException) {
          nodeType = null;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    boolean _notEquals = (!Objects.equal(nodeType, null));
    if (_notEquals) {
      EList<Match> _attribute = node.getAttribute();
      for (final Match attribute : _attribute) {
        {
          boolean superTypeAttribute = false;
          boolean _contains = nodeType.getEAttributes().contains(attribute.getName());
          boolean _not = (!_contains);
          if (_not) {
            EList<EClass> _eAllSuperTypes = nodeType.getEAllSuperTypes();
            for (final EClass supertype : _eAllSuperTypes) {
              boolean _contains_1 = supertype.getEAttributes().contains(attribute.getName());
              if (_contains_1) {
                superTypeAttribute = true;
              }
            }
            if ((!superTypeAttribute)) {
              String _name_2 = nodeType.getName();
              String _plus = (_name_2 + " has no attribute \'");
              String _name_3 = attribute.getName().getName();
              String _plus_1 = (_plus + _name_3);
              String _plus_2 = (_plus_1 + "\'.\'");
              this.error(_plus_2, attribute, Henshin_textPackage.eINSTANCE.getMatch_Name());
            }
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn in einem Knoten eines ConditionGraphen das selbe Attribut mehrfach definiert wird
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkattributeOnlyOnce(final ConditionNode node) {
    for (int i = 0; (i < node.getAttribute().size()); i++) {
      {
        Match match = node.getAttribute().get(i);
        for (int j = (i + 1); (j < node.getAttribute().size()); j++) {
          EAttribute _name = match.getName();
          EAttribute _name_1 = node.getAttribute().get(j).getName();
          boolean _equals = Objects.equal(_name, _name_1);
          if (_equals) {
            String _name_2 = match.getName().getName();
            String _plus = ("\'" + _name_2);
            String _plus_1 = (_plus + "\' can only be used once.\'");
            this.error(_plus_1, node.getAttribute().get(j), Henshin_textPackage.eINSTANCE.getMatch_Name());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn in einem reuse-Knoten eines ConditionGraphen das selbe Attribut mehrfach definiert wird
   * 
   * @param node Zu überprüfender Knoten
   */
  @Check
  public void checkattributeOnlyOnce(final ConditionReuseNode node) {
    for (int i = 0; (i < node.getAttribute().size()); i++) {
      {
        Match match = node.getAttribute().get(i);
        for (int j = (i + 1); (j < node.getAttribute().size()); j++) {
          EAttribute _name = match.getName();
          EAttribute _name_1 = node.getAttribute().get(j).getName();
          boolean _equals = Objects.equal(_name, _name_1);
          if (_equals) {
            String _name_2 = match.getName().getName();
            String _plus = ("\'" + _name_2);
            String _plus_1 = (_plus + "\' can only be used once.\'");
            this.error(_plus_1, node.getAttribute().get(j), Henshin_textPackage.eINSTANCE.getMatch_Name());
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Knoten in einem ConditionGraphen reused wird der nicht zur LHS gehört
   * 
   * @param conReuseNode Zu überprüfender reuse-Node
   */
  @Check
  public void checkConditionReuseNodeInLHS(final ConditionReuseNode conReuseNode) {
    ConditionNodeTypes _name = conReuseNode.getName();
    if ((_name instanceof Node)) {
      if ((((!Objects.equal(((Node) conReuseNode.getName()).getActiontype(), null)) && (!Objects.equal(((Node) conReuseNode.getName()).getActiontype(), "preserve"))) && (!Objects.equal(((Node) conReuseNode.getName()).getActiontype(), "delete")))) {
        ConditionNodeTypes _name_1 = conReuseNode.getName();
        String _name_2 = ((Node) _name_1).getName();
        String _plus = ("Node \'" + _name_2);
        String _plus_1 = (_plus + "\' is not in LHS.\'");
        this.error(_plus_1, conReuseNode, Henshin_textPackage.eINSTANCE.getConditionReuseNode_Name());
      }
    }
  }
  
  /**
   * Fehler wenn ein Knoten in einer Kante im ConditionGraph wiederverwendet wird der nicht zur LHS gehört
   * 
   * @param conEdge zu überprüfende Kante
   */
  @Check
  public void checkConditionEdgeInLHS(final ConditionEdge conEdge) {
    ConditionNodeTypes _source = conEdge.getSource();
    if ((_source instanceof Node)) {
      if ((((!Objects.equal(((Node) conEdge.getSource()).getActiontype(), null)) && (!Objects.equal(((Node) conEdge.getSource()).getActiontype(), "preserve"))) && (!Objects.equal(((Node) conEdge.getSource()).getActiontype(), "delete")))) {
        ConditionNodeTypes _source_1 = conEdge.getSource();
        String _name = ((Node) _source_1).getName();
        String _plus = ("Node \'" + _name);
        String _plus_1 = (_plus + "\' is not in LHS.\'");
        this.error(_plus_1, conEdge, Henshin_textPackage.eINSTANCE.getConditionEdge_Source());
      }
    }
    ConditionNodeTypes _target = conEdge.getTarget();
    if ((_target instanceof Node)) {
      if ((((!Objects.equal(((Node) conEdge.getTarget()).getActiontype(), null)) && (!Objects.equal(((Node) conEdge.getTarget()).getActiontype(), "preserve"))) && (!Objects.equal(((Node) conEdge.getTarget()).getActiontype(), "delete")))) {
        ConditionNodeTypes _target_1 = conEdge.getTarget();
        String _name_1 = ((Node) _target_1).getName();
        String _plus_2 = ("Node \'" + _name_1);
        String _plus_3 = (_plus_2 + "\' is not in LHS.\'");
        this.error(_plus_3, conEdge, Henshin_textPackage.eINSTANCE.getConditionEdge_Target());
      }
    }
  }
  
  /**
   * Fehler wenn in einem Graph mehrere matchingFormula-Elemente definiert wurden
   * 
   * @param graph Zu überprüfender Graph
   */
  @Check
  public void matchingFormulaOnce(final Graph graph) {
    Iterable<Formula> formulaList = Iterables.<Formula>filter(graph.getGraphElements(), Formula.class);
    int _size = IterableExtensions.size(formulaList);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final Formula formula : formulaList) {
        this.error("matchingFormula can only use once.\'", formula, Henshin_textPackage.Literals.FORMULA__FORMULA);
      }
    }
  }
  
  /**
   * Fehler wenn in einem ConditionGraph mehrere matchingFormula-Elemente definiert wurden
   * 
   * @param graph Zu überprüfender ConditionGraph
   */
  @Check
  public void matchingFormulaOnce(final ConditionGraph graph) {
    Iterable<Formula> formulaList = Iterables.<Formula>filter(graph.getConditionGraphElements(), Formula.class);
    int _size = IterableExtensions.size(formulaList);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final Formula formula : formulaList) {
        this.error("matchingFormula can only use once.\'", formula, Henshin_textPackage.Literals.FORMULA__FORMULA);
      }
    }
  }
  
  /**
   * Fehler wenn ein ConditionGraph einen Knoten eines darüberliegenden Graphen überschreibt
   * 
   * @param graph Graph der rekursiv durchsucht wird
   */
  @Check
  public void checkOverrideNodeNamesinConditionGraph(final Graph graph) {
    Iterable<Formula> formula = Iterables.<Formula>filter(graph.getGraphElements(), Formula.class);
    List<ConditionNode> topConNodes = new ArrayList<ConditionNode>();
    int _size = IterableExtensions.size(formula);
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final Iterable<Formula> _converted_formula = (Iterable<Formula>)formula;
      EList<ConditionGraph> _conditionGraphs = (((Formula[])Conversions.unwrapArray(_converted_formula, Formula.class))[0]).getConditionGraphs();
      for (final ConditionGraph conGraph : _conditionGraphs) {
        {
          Iterable<ConditionNode> _filter = Iterables.<ConditionNode>filter(conGraph.getConditionGraphElements(), ConditionNode.class);
          for (final ConditionNode conNode : _filter) {
            {
              Iterable<Node> _filter_1 = Iterables.<Node>filter(graph.getGraphElements(), Node.class);
              for (final Node node : _filter_1) {
                String _name = conNode.getName();
                String _name_1 = node.getName();
                boolean _equals = Objects.equal(_name, _name_1);
                if (_equals) {
                  String _name_2 = conNode.getName();
                  String _plus = ("Duplicate Node \'" + _name_2);
                  String _plus_1 = (_plus + "\'.\'");
                  this.error(_plus_1, conNode, Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                }
              }
              topConNodes.add(conNode);
            }
          }
          int _size_1 = IterableExtensions.size(Iterables.<Formula>filter(conGraph.getConditionGraphElements(), Formula.class));
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            this.checkRekursiveOverrideNodeNamesinConditionGraph(Iterables.<Node>filter(graph.getGraphElements(), Node.class), topConNodes, conGraph);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein ConditionGraph einen Knoten eines darüberliegenden Graphen überschreibt
   * 
   * @param topNodes Liste der darüberliegenden Graphknoten
   * @param topConNodes Liste der darüberliegenden ConditionGraphknoten
   * @param graph Zu überprüfender Graph
   */
  private void checkRekursiveOverrideNodeNamesinConditionGraph(final Iterable<Node> topNodes, final List<ConditionNode> topConNodes, final ConditionGraph graph) {
    Iterable<Formula> formula = Iterables.<Formula>filter(graph.getConditionGraphElements(), Formula.class);
    int _size = IterableExtensions.size(formula);
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final Iterable<Formula> _converted_formula = (Iterable<Formula>)formula;
      EList<ConditionGraph> _conditionGraphs = (((Formula[])Conversions.unwrapArray(_converted_formula, Formula.class))[0]).getConditionGraphs();
      for (final ConditionGraph conGraph : _conditionGraphs) {
        {
          Iterable<ConditionNode> _filter = Iterables.<ConditionNode>filter(conGraph.getConditionGraphElements(), ConditionNode.class);
          for (final ConditionNode conNode : _filter) {
            {
              Iterable<ConditionNode> _filter_1 = Iterables.<ConditionNode>filter(graph.getConditionGraphElements(), ConditionNode.class);
              for (final ConditionNode node : _filter_1) {
                String _name = conNode.getName();
                String _name_1 = node.getName();
                boolean _equals = Objects.equal(_name, _name_1);
                if (_equals) {
                  String _name_2 = conNode.getName();
                  String _plus = ("Duplicate Node \'" + _name_2);
                  String _plus_1 = (_plus + "\'.\'");
                  this.error(_plus_1, conNode, Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                }
              }
              for (final Node node_1 : topNodes) {
                String _name_3 = conNode.getName();
                String _name_4 = node_1.getName();
                boolean _equals_1 = Objects.equal(_name_3, _name_4);
                if (_equals_1) {
                  String _name_5 = conNode.getName();
                  String _plus_2 = ("Duplicate Node \'" + _name_5);
                  String _plus_3 = (_plus_2 + "\'.\'");
                  this.error(_plus_3, conNode, Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                }
              }
              for (final ConditionNode node_2 : topConNodes) {
                String _name_6 = conNode.getName();
                String _name_7 = node_2.getName();
                boolean _equals_2 = Objects.equal(_name_6, _name_7);
                if (_equals_2) {
                  String _name_8 = conNode.getName();
                  String _plus_4 = ("Duplicate Node \'" + _name_8);
                  String _plus_5 = (_plus_4 + "\'.\'");
                  this.error(_plus_5, conNode, Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                }
              }
              topConNodes.add(conNode);
            }
          }
          int _size_1 = IterableExtensions.size(Iterables.<Formula>filter(conGraph.getConditionGraphElements(), Formula.class));
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            this.checkRekursiveOverrideNodeNamesinConditionGraph(topNodes, topConNodes, conGraph);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn eine Formula auf einen übergeordneten ConditionGraph verweist
   * 
   * @param formula Zu überprüfende Formula
   */
  @Check
  public void checkFormulaConditionGraphLevel(final Formula formula) {
    Logic _formula = formula.getFormula();
    ArrayList<ConditionGraph> _arrayList = new ArrayList<ConditionGraph>();
    ArrayList<ConditionGraph> formulaGraphs = this.findDuplicate(_formula, _arrayList);
    for (final ConditionGraph graph : formulaGraphs) {
      boolean _contains = formula.getConditionGraphs().contains(graph);
      boolean _not = (!_contains);
      if (_not) {
        String _name = graph.getName();
        String _plus = ("ConditionGraph \'" + _name);
        String _plus_1 = (_plus + "\' does not exist.\'");
        this.error(_plus_1, formula, Henshin_textPackage.Literals.FORMULA__FORMULA);
      }
    }
  }
  
  /**
   * Durchsucht Formula nach ihren ConditionGraphen
   * 
   * @param formula Zu durchsuchende Formula
   */
  @Check
  public boolean checkConditionFormula(final Formula formula) {
    boolean _xblockexpression = false;
    {
      ArrayList<ConditionGraph> conditionGraphs = new ArrayList<ConditionGraph>();
      boolean _xifexpression = false;
      Logic _formula = formula.getFormula();
      if ((_formula instanceof ANDImpl)) {
        boolean _xblockexpression_1 = false;
        {
          Logic _formula_1 = formula.getFormula();
          conditionGraphs.addAll(this.findDuplicate(((ANDImpl) _formula_1).getLeft(), conditionGraphs));
          Logic _formula_2 = formula.getFormula();
          _xblockexpression_1 = conditionGraphs.addAll(this.findDuplicate(((ANDImpl) _formula_2).getRight(), conditionGraphs));
        }
        _xifexpression = _xblockexpression_1;
      } else {
        boolean _xifexpression_1 = false;
        Logic _formula_1 = formula.getFormula();
        if ((_formula_1 instanceof ORorXORImpl)) {
          boolean _xblockexpression_2 = false;
          {
            Logic _formula_2 = formula.getFormula();
            conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl) _formula_2).getLeft(), conditionGraphs));
            Logic _formula_3 = formula.getFormula();
            _xblockexpression_2 = conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl) _formula_3).getRight(), conditionGraphs));
          }
          _xifexpression_1 = _xblockexpression_2;
        } else {
          boolean _xifexpression_2 = false;
          Logic _formula_2 = formula.getFormula();
          if ((_formula_2 instanceof NotImpl)) {
            Logic _formula_3 = formula.getFormula();
            _xifexpression_2 = conditionGraphs.addAll(this.findDuplicate(((NotImpl) _formula_3).getNegation(), conditionGraphs));
          }
          _xifexpression_1 = _xifexpression_2;
        }
        _xifexpression = _xifexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  /**
   * Fehler wenn ein ConditionGraph mehrfach verwendet wurde
   * 
   * @param logic Zu untersuchender logischer Ausdruck
   * @param conditionGraphs List der bereits gefundenen ConditionGraphen
   * @return List der bereits gefundenen ConditionGraphen
   */
  private ArrayList<ConditionGraph> findDuplicate(final Logic logic, final ArrayList<ConditionGraph> conditionGraphs) {
    if ((logic instanceof ANDImpl)) {
      conditionGraphs.addAll(this.findDuplicate(((ANDImpl) logic).getLeft(), conditionGraphs));
      conditionGraphs.addAll(this.findDuplicate(((ANDImpl) logic).getRight(), conditionGraphs));
    } else {
      if ((logic instanceof ORorXORImpl)) {
        conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl) logic).getLeft(), conditionGraphs));
        conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl) logic).getRight(), conditionGraphs));
      } else {
        if ((logic instanceof NotImpl)) {
          conditionGraphs.addAll(this.findDuplicate(((NotImpl) logic).getNegation(), conditionGraphs));
        } else {
          if ((logic instanceof ConditionGraphRef)) {
            boolean _contains = conditionGraphs.contains(((ConditionGraphRef) logic).getConditionGraphRef());
            if (_contains) {
              String _name = ((ConditionGraphRef) logic).getConditionGraphRef().getName();
              String _plus = ("Duplicate ConditionGraph \'" + _name);
              String _plus_1 = (_plus + "\'.\'");
              this.error(_plus_1, ((ConditionGraphRef) logic), Henshin_textPackage.eINSTANCE.getConditionGraphRef_ConditionGraphRef());
            } else {
              conditionGraphs.add(((ConditionGraphRef) logic).getConditionGraphRef());
            }
          }
        }
      }
    }
    return conditionGraphs;
  }
  
  /**
   * Fehler wenn ein ConditionNode wie ein ConditionReuseNode benannt wurde
   * 
   * @param  graph Zu überprüfender ConditionGraph
   */
  @Check
  public void checkConditionGraphReuseOwnNodes(final ConditionGraph graph) {
    Iterable<ConditionReuseNode> _filter = Iterables.<ConditionReuseNode>filter(graph.getConditionGraphElements(), ConditionReuseNode.class);
    for (final ConditionReuseNode reuse : _filter) {
      Iterable<ConditionNode> _filter_1 = Iterables.<ConditionNode>filter(graph.getConditionGraphElements(), ConditionNode.class);
      for (final ConditionNode node : _filter_1) {
        String _name = reuse.getName().getName();
        String _name_1 = node.getName();
        boolean _equals = Objects.equal(_name, _name_1);
        if (_equals) {
          this.error("ConditionGraph cannot reuse its own nodes.\'", reuse, Henshin_textPackage.eINSTANCE.getConditionReuseNode_Name());
        }
      }
    }
  }
  
  /**
   * Fehler wenn ein Knoten mehrfach reused wird in einem Graphen
   * 
   * @param graph Zu überprüfender ConditionGraph
   */
  @Check
  public void checkConditionGraphMultiReuse(final ConditionGraph graph) {
    Iterable<ConditionReuseNode> reuseNodes = Iterables.<ConditionReuseNode>filter(graph.getConditionGraphElements(), ConditionReuseNode.class);
    for (int i = 0; (i < IterableExtensions.size(reuseNodes)); i++) {
      for (int j = (i + 1); (j < IterableExtensions.size(reuseNodes)); j++) {
        final Iterable<ConditionReuseNode> _converted_reuseNodes = (Iterable<ConditionReuseNode>)reuseNodes;
        String _name = (((ConditionReuseNode[])Conversions.unwrapArray(_converted_reuseNodes, ConditionReuseNode.class))[i]).getName().getName();
        final Iterable<ConditionReuseNode> _converted_reuseNodes_1 = (Iterable<ConditionReuseNode>)reuseNodes;
        String _name_1 = (((ConditionReuseNode[])Conversions.unwrapArray(_converted_reuseNodes_1, ConditionReuseNode.class))[j]).getName().getName();
        boolean _equals = Objects.equal(_name, _name_1);
        if (_equals) {
          final Iterable<ConditionReuseNode> _converted_reuseNodes_2 = (Iterable<ConditionReuseNode>)reuseNodes;
          String _name_2 = (((ConditionReuseNode[])Conversions.unwrapArray(_converted_reuseNodes_2, ConditionReuseNode.class))[j]).getName().getName();
          String _plus = (_name_2 + " is already reused in ConditionGraph ");
          String _name_3 = graph.getName();
          String _plus_1 = (_plus + _name_3);
          String _plus_2 = (_plus_1 + ".\'");
          final Iterable<ConditionReuseNode> _converted_reuseNodes_3 = (Iterable<ConditionReuseNode>)reuseNodes;
          this.error(_plus_2, ((EObject[])Conversions.unwrapArray(_converted_reuseNodes_3, EObject.class))[j], Henshin_textPackage.eINSTANCE.getConditionReuseNode_Name());
        }
      }
    }
  }
  
  /**
   * Fehler bei einer negativen Anzahl an Iterationen
   * 
   * @param unit IteratedUnit die überprüft werden soll
   */
  @Check
  public void checkIterationUnitIterationsNegative(final IteratedUnit unit) {
    Expression _iterations = unit.getIterations();
    if ((_iterations instanceof NumberValue)) {
      Expression _iterations_1 = unit.getIterations();
      boolean _contains = ((NumberValue) _iterations_1).getValue().contains("-");
      if (_contains) {
        this.error("Negative values are not allowed.\'", unit, Henshin_textPackage.eINSTANCE.getIteratedUnit_Iterations());
      }
    } else {
      Expression _iterations_2 = unit.getIterations();
      if ((_iterations_2 instanceof IntegerValue)) {
        Expression _iterations_3 = unit.getIterations();
        boolean _contains_1 = ((IntegerValue) _iterations_3).getValue().contains("-");
        if (_contains_1) {
          this.error("Negative values are not allowed.\'", unit, Henshin_textPackage.eINSTANCE.getIteratedUnit_Iterations());
        }
      }
    }
  }
  
  /**
   * Fehler bei einem nicht-numerischen Parametertyp für Iterationen
   * 
   * @param unit IteratedUnit die überprüft werden soll
   */
  @Check
  public void checkIterationUnitIterationsType(final IteratedUnit unit) {
    Expression _iterations = unit.getIterations();
    boolean _notEquals = (!Objects.equal(_iterations, null));
    if (_notEquals) {
      String _string = this._henshin_textTypeProvider.typeFor(unit.getIterations()).toString();
      boolean _notEquals_1 = (!Objects.equal(_string, "number"));
      if (_notEquals_1) {
        Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(unit.getIterations());
        String _plus = ("IteratedUnit expected number type, but was " + _typeFor);
        String _plus_1 = (_plus + ".\'");
        this.error(_plus_1, unit, Henshin_textPackage.eINSTANCE.getIteratedUnit_Iterations());
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Strict-Element in einer Unit-Definition definiert wurde
   * 
   * @param unit Zu überprüfende Unit
   */
  @Check
  public void checkCountStrict(final Unit unit) {
    Iterable<StrictImpl> iterableOfStrictImpl = Iterables.<StrictImpl>filter(unit.getUnitElements(), StrictImpl.class);
    int _size = IterableExtensions.size(iterableOfStrictImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final StrictImpl strict : iterableOfStrictImpl) {
        this.error("Strict can only be used once.\'", strict, Henshin_textPackage.Literals.STRICT__STRICT);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Strict-Element in einer SubSequenz definiert wurde
   * 
   * @param unit Zu überprüfende SubSequenz
   */
  @Check
  public void checkCountStrictSubSequence(final UnitElement unit) {
    Iterable<StrictImpl> iterableOfStrictImpl = Iterables.<StrictImpl>filter(unit.getSubSequence(), StrictImpl.class);
    int _size = IterableExtensions.size(iterableOfStrictImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final StrictImpl strict : iterableOfStrictImpl) {
        this.error("Strict can only be used once.\'", strict, Henshin_textPackage.Literals.STRICT__STRICT);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Strict-Element in einer IndependentUnit definiert wurde
   * 
   * @param unit Zu überprüfende IndependentUnit
   */
  @Check
  public void checkCountStrictIndependentUnit(final IndependentUnit unit) {
    EList<org.eclipse.emf.henshin.text.henshin_text.List> _listOfLists = unit.getListOfLists();
    for (final org.eclipse.emf.henshin.text.henshin_text.List e : _listOfLists) {
      {
        Iterable<StrictImpl> iterableOfStrictImpl = Iterables.<StrictImpl>filter(e.getSubElements(), StrictImpl.class);
        int _size = IterableExtensions.size(iterableOfStrictImpl);
        boolean _greaterThan = (_size > 1);
        if (_greaterThan) {
          for (final StrictImpl strict : iterableOfStrictImpl) {
            this.error("Strict can only be used once.\'", strict, Henshin_textPackage.Literals.STRICT__STRICT);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Strict-Element in einer ConditionalUnit definiert wurde
   * 
   * @param unit Zu überprüfende ConditionalUnit
   */
  @Check
  public void checkCountStrictConditionalUnit(final ConditionalUnit unit) {
    Iterable<StrictImpl> iterableOfStrictImplIF = Iterables.<StrictImpl>filter(unit.getIf(), StrictImpl.class);
    Iterable<StrictImpl> iterableOfStrictImplTHEN = Iterables.<StrictImpl>filter(unit.getThen(), StrictImpl.class);
    Iterable<StrictImpl> iterableOfStrictImplELSE = Iterables.<StrictImpl>filter(unit.getElse(), StrictImpl.class);
    int _size = IterableExtensions.size(iterableOfStrictImplIF);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final StrictImpl strict : iterableOfStrictImplIF) {
        this.error("Strict can only be used once.\'", strict, Henshin_textPackage.Literals.STRICT__STRICT);
      }
    }
    int _size_1 = IterableExtensions.size(iterableOfStrictImplTHEN);
    boolean _greaterThan_1 = (_size_1 > 1);
    if (_greaterThan_1) {
      for (final StrictImpl strict_1 : iterableOfStrictImplTHEN) {
        this.error("Strict can only be used once.\'", strict_1, Henshin_textPackage.Literals.STRICT__STRICT);
      }
    }
    int _size_2 = IterableExtensions.size(iterableOfStrictImplELSE);
    boolean _greaterThan_2 = (_size_2 > 1);
    if (_greaterThan_2) {
      for (final StrictImpl strict_2 : iterableOfStrictImplELSE) {
        this.error("Strict can only be used once.\'", strict_2, Henshin_textPackage.Literals.STRICT__STRICT);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Strict-Element in einer PriorityUnit definiert wurde
   * 
   * @param unit Zu überprüfende PriorityUnit
   */
  @Check
  public void checkCountStrictPriorityUnit(final PriorityUnit unit) {
    EList<org.eclipse.emf.henshin.text.henshin_text.List> _listOfLists = unit.getListOfLists();
    for (final org.eclipse.emf.henshin.text.henshin_text.List e : _listOfLists) {
      {
        Iterable<StrictImpl> iterableOfStrictImpl = Iterables.<StrictImpl>filter(e.getSubElements(), StrictImpl.class);
        int _size = IterableExtensions.size(iterableOfStrictImpl);
        boolean _greaterThan = (_size > 1);
        if (_greaterThan) {
          for (final StrictImpl strict : iterableOfStrictImpl) {
            this.error("Strict can only be used once.\'", strict, Henshin_textPackage.Literals.STRICT__STRICT);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Strict-Element in einer IteratedUnit definiert wurde
   * 
   * @param unit Zu überprüfende IteratedUnit
   */
  @Check
  public void checkCountStrictIteratedUnit(final IteratedUnit unit) {
    Iterable<StrictImpl> iterableOfStrictImpl = Iterables.<StrictImpl>filter(unit.getSubElement(), StrictImpl.class);
    int _size = IterableExtensions.size(iterableOfStrictImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final StrictImpl strict : iterableOfStrictImpl) {
        this.error("Strict can only be used once.\'", strict, Henshin_textPackage.Literals.STRICT__STRICT);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Strict-Element in einer LoopUnit definiert wurde
   * 
   * @param unit Zu überprüfende LoopUnit
   */
  @Check
  public void checkCountStrictLoopUnit(final LoopUnit unit) {
    Iterable<StrictImpl> iterableOfStrictImpl = Iterables.<StrictImpl>filter(unit.getSubElement(), StrictImpl.class);
    int _size = IterableExtensions.size(iterableOfStrictImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final StrictImpl strict : iterableOfStrictImpl) {
        this.error("Strict can only be used once.\'", strict, Henshin_textPackage.Literals.STRICT__STRICT);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Rollback-Element in einer Unit-Definition definiert wurde
   * 
   * @param unit Zu überprüfende Unit
   */
  @Check
  public void checkCountRollback(final Unit unit) {
    Iterable<RollbackImpl> iterableOfRollbackImpl = Iterables.<RollbackImpl>filter(unit.getUnitElements(), RollbackImpl.class);
    int _size = IterableExtensions.size(iterableOfRollbackImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final RollbackImpl rollback : iterableOfRollbackImpl) {
        this.error("Rollback can only be used once.\'", rollback, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Rollback-Element in einer SubSequenz definiert wurde
   * 
   * @param unit Zu überprüfende SupSequenz
   */
  @Check
  public void checkCountRollbackSubSequence(final UnitElement unit) {
    Iterable<RollbackImpl> iterableOfRollbackImpl = Iterables.<RollbackImpl>filter(unit.getSubSequence(), RollbackImpl.class);
    int _size = IterableExtensions.size(iterableOfRollbackImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final RollbackImpl rollback : iterableOfRollbackImpl) {
        this.error("Rollback can only be used once.\'", rollback, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Rollback-Element in einer IndependentUnit definiert wurde
   * 
   * @param unit Zu überprüfende IndependentUnit
   */
  @Check
  public void checkCountRollbackIndependentUnit(final IndependentUnit unit) {
    EList<org.eclipse.emf.henshin.text.henshin_text.List> _listOfLists = unit.getListOfLists();
    for (final org.eclipse.emf.henshin.text.henshin_text.List e : _listOfLists) {
      {
        Iterable<RollbackImpl> iterableOfRollbackImpl = Iterables.<RollbackImpl>filter(e.getSubElements(), RollbackImpl.class);
        int _size = IterableExtensions.size(iterableOfRollbackImpl);
        boolean _greaterThan = (_size > 1);
        if (_greaterThan) {
          for (final RollbackImpl rollback : iterableOfRollbackImpl) {
            this.error("Rollback can only be used once.\'", rollback, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Rollback-Element in einer ConditionalUnit definiert wurde
   * 
   * @param unit Zu überprüfende ConditionalUnit
   */
  @Check
  public void checkCountRollbackConditionalUnit(final ConditionalUnit unit) {
    Iterable<RollbackImpl> iterableOfRollbackImplIF = Iterables.<RollbackImpl>filter(unit.getIf(), RollbackImpl.class);
    Iterable<RollbackImpl> iterableOfRollbackImplTHEN = Iterables.<RollbackImpl>filter(unit.getThen(), RollbackImpl.class);
    Iterable<RollbackImpl> iterableOfRollbackImplELSE = Iterables.<RollbackImpl>filter(unit.getElse(), RollbackImpl.class);
    int _size = IterableExtensions.size(iterableOfRollbackImplIF);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final RollbackImpl rollback : iterableOfRollbackImplIF) {
        this.error("Strict can only be used once.\'", rollback, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
      }
    }
    int _size_1 = IterableExtensions.size(iterableOfRollbackImplTHEN);
    boolean _greaterThan_1 = (_size_1 > 1);
    if (_greaterThan_1) {
      for (final RollbackImpl rollback_1 : iterableOfRollbackImplTHEN) {
        this.error("Strict can only be used once.\'", rollback_1, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
      }
    }
    int _size_2 = IterableExtensions.size(iterableOfRollbackImplELSE);
    boolean _greaterThan_2 = (_size_2 > 1);
    if (_greaterThan_2) {
      for (final RollbackImpl rollback_2 : iterableOfRollbackImplELSE) {
        this.error("Strict can only be used once.\'", rollback_2, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Rollback-Element in einer PriorityUnit definiert wurde
   * 
   * @param unit Zu überprüfende PriorityUnit
   */
  @Check
  public void checkCountRollbackPriorityUnit(final PriorityUnit unit) {
    EList<org.eclipse.emf.henshin.text.henshin_text.List> _listOfLists = unit.getListOfLists();
    for (final org.eclipse.emf.henshin.text.henshin_text.List e : _listOfLists) {
      {
        Iterable<RollbackImpl> iterableOfRollbackImpl = Iterables.<RollbackImpl>filter(e.getSubElements(), RollbackImpl.class);
        int _size = IterableExtensions.size(iterableOfRollbackImpl);
        boolean _greaterThan = (_size > 1);
        if (_greaterThan) {
          for (final RollbackImpl rollback : iterableOfRollbackImpl) {
            this.error("Rollback can only be used once.\'", rollback, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
          }
        }
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Rollback-Element in einer IteratedUnit definiert wurde
   * 
   * @param unit Zu überprüfende IteratedUnit
   */
  @Check
  public void checkCountRollbackIteratedUnit(final IteratedUnit unit) {
    Iterable<RollbackImpl> iterableOfRollbackImpl = Iterables.<RollbackImpl>filter(unit.getSubElement(), RollbackImpl.class);
    int _size = IterableExtensions.size(iterableOfRollbackImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final RollbackImpl rollback : iterableOfRollbackImpl) {
        this.error("Rollback can only be used once.\'", rollback, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
      }
    }
  }
  
  /**
   * Fehler wenn mehr als ein Rollback-Element in einer LoopUnit definiert wurde
   * 
   * @param unit Zu überprüfende LoopUnit
   */
  @Check
  public void checkCountRollbackLoopUnit(final LoopUnit unit) {
    Iterable<RollbackImpl> iterableOfRollbackImpl = Iterables.<RollbackImpl>filter(unit.getSubElement(), RollbackImpl.class);
    int _size = IterableExtensions.size(iterableOfRollbackImpl);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      for (final RollbackImpl rollback : iterableOfRollbackImpl) {
        this.error("Rollback can only be used once.\'", rollback, Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
      }
    }
  }
  
  /**
   * Fehler wenn NOT auf einen anderen Wert als vom Typ Boolean angewendet wird
   * 
   * @param not Zu überprüfender NOT-Ausdruck
   */
  @Check
  public void checkTypeNot(final NotExpression not) {
    this.checkExpectedType(not.getExpression(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.NOT_EXPRESSION__EXPRESSION);
  }
  
  /**
   * Fehler wenn keine Zahlenwerte in einem Multiplikations-/Divisions-Ausdruck verwendet werden
   * 
   * @param plus Zu überprüfender Multiplikations-/Divisions-Ausdruck
   */
  @Check
  public void checkTypeMulOrDiv(final MulOrDivExpression mulOrDiv) {
    this.checkExpectedType(mulOrDiv.getLeft(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MUL_OR_DIV_EXPRESSION__LEFT);
    this.checkExpectedType(mulOrDiv.getRight(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MUL_OR_DIV_EXPRESSION__RIGHT);
  }
  
  /**
   * Fehler wenn keine Zahlenwerte in einem Subtraktions-Ausdruck verwendet werden
   * 
   * @param plus Zu überprüfender Subtraktions-Ausdruck
   */
  @Check
  public void checkTypeMinus(final MinusExpression minus) {
    this.checkExpectedType(minus.getLeft(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MINUS_EXPRESSION__LEFT);
    this.checkExpectedType(minus.getRight(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MINUS_EXPRESSION__RIGHT);
  }
  
  /**
   * Fehler wenn keine Zahlenwerte miteinander addiert werden sollen
   * 
   * @param plus Zu überprüfender Additions-Ausdruck
   */
  @Check
  public void checkTypePlus(final PlusExpression plus) {
    this.checkExpectedType(plus.getLeft(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.PLUS_EXPRESSION__LEFT);
    this.checkExpectedType(plus.getRight(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.PLUS_EXPRESSION__RIGHT);
  }
  
  /**
   * Fehler wenn keine Boolean-Werte in einem AND-Ausdruck verwendet werden
   * 
   * @param and Zu überprüfender AND-Ausdruck
   */
  @Check
  public void checkTypeAnd(final AndExpression and) {
    this.checkExpectedType(and.getLeft(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.AND_EXPRESSION__LEFT);
    this.checkExpectedType(and.getRight(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.AND_EXPRESSION__RIGHT);
  }
  
  /**
   * Fehler wenn keine Boolean-Werte in einem OR-Ausdruck verwendet werden
   * 
   * @param or Zu überprüfender OR-Ausdruck
   */
  @Check
  public void checkTypeOr(final OrExpression or) {
    this.checkExpectedType(or.getLeft(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.OR_EXPRESSION__LEFT);
    this.checkExpectedType(or.getRight(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.OR_EXPRESSION__RIGHT);
  }
  
  /**
   * Fehler wenn Werte unterschiedlicher Typen auf Un-/Gleichheit geprüft werden
   * 
   * @param equality Zu überprüfender Un-/Gleichheits-Ausdruck
   */
  @Check
  public void checkTypeEquality(final EqualityExpression equality) {
    final Henshin_textType leftType = this.getTypeAndCheckNotNull(equality.getLeft(), Henshin_textPackage.Literals.EQUALITY_EXPRESSION__LEFT);
    final Henshin_textType rightType = this.getTypeAndCheckNotNull(equality.getRight(), Henshin_textPackage.Literals.EQUALITY_EXPRESSION__RIGHT);
    if ((((!Objects.equal(leftType, rightType)) && (!Objects.equal(leftType, null))) && (!Objects.equal(rightType, null)))) {
      this.error((((("Expression expected the same type, but was " + leftType) + " and ") + rightType) + ".\'"), Henshin_textPackage.Literals.EQUALITY_EXPRESSION.getEIDAttribute(), "");
    }
  }
  
  /**
   * Fehler wenn bei einem Verleich unterschiedliche Typen oder Boolean-Werte miteinander verglichen werden
   * 
   * @param comparison Zu überprüfender Vergleichs-Ausdruck
   */
  @Check
  public void checkTypeComparison(final ComparisonExpression comparison) {
    final Henshin_textType leftType = this.getTypeAndCheckNotNull(comparison.getLeft(), Henshin_textPackage.Literals.COMPARISON_EXPRESSION__LEFT);
    final Henshin_textType rightType = this.getTypeAndCheckNotNull(comparison.getRight(), Henshin_textPackage.Literals.COMPARISON_EXPRESSION__RIGHT);
    if ((((!Objects.equal(leftType, rightType)) && (!Objects.equal(leftType, null))) && (!Objects.equal(rightType, null)))) {
      this.error((((("Expression expected the same type, but was " + leftType) + " and ") + rightType) + ".\'"), Henshin_textPackage.Literals.COMPARISON_EXPRESSION.getEIDAttribute(), "");
    }
    if ((Objects.equal(leftType, Henshin_textTypeProvider.boolType) || Objects.equal(leftType, Henshin_textTypeProvider.complexType))) {
      this.error("Value cannot be compared.\'", Henshin_textPackage.Literals.COMPARISON_EXPRESSION__LEFT, "");
    }
    if ((Objects.equal(rightType, Henshin_textTypeProvider.boolType) || Objects.equal(leftType, Henshin_textTypeProvider.complexType))) {
      this.error("Value cannot be compared.\'", Henshin_textPackage.Literals.COMPARISON_EXPRESSION__RIGHT, "");
    }
  }
  
  /**
   * Fehler wenn der tatsächliche Typ eines Ausdrucks nicht zur erwarteten Typart passt.
   * 
   * @param expression Zu überprüfender Ausdruck
   * @param expectedType Erwarteter Typ
   * @param reference Referenz zum zu überprüfenden Ausdrucks
   */
  private void checkExpectedType(final Expression expression, final Henshin_textType expectedType, final EReference reference) {
    final Henshin_textType actualType = this.getTypeAndCheckNotNull(expression, reference);
    boolean _notEquals = (!Objects.equal(actualType, expectedType));
    if (_notEquals) {
      this.error((((("Expression expected " + expectedType) + " type, but was ") + actualType) + ".\'"), reference, "");
    }
  }
  
  /**
   * Liefert die Typart eines Ausdrucks zurück. Fehler wenn keine passende Typart gefunden wurde.
   * 
   * @param expression Zu überprüfender Ausdruck
   * @param refrence Referenz zum zu überprüfenden Ausdrucks
   * 
   * @return Typart des Ausdrucks
   */
  private Henshin_textType getTypeAndCheckNotNull(final Expression expression, final EReference reference) {
    Henshin_textType type = null;
    boolean _notEquals = (!Objects.equal(expression, null));
    if (_notEquals) {
      type = this._henshin_textTypeProvider.typeFor(expression);
    }
    boolean _equals = Objects.equal(type, null);
    if (_equals) {
      this.error("Null type.\'", reference, "");
    }
    return type;
  }
  
  /**
   * Fehler wenn ein Ausdruck einem Attribut zugewiesen wird der den falschen Typ hat
   * 
   * @param attribute Zu überprüfendes Attribut
   */
  @Check
  public void checkAttributeType(final Attribute attribute) {
    Expression _value = attribute.getValue();
    if ((_value instanceof ParameterValue)) {
      if (((!Objects.equal(((ParameterValue) attribute.getValue()).getValue().getType().getType(), null)) && (!Objects.equal(attribute.getName().getEAttributeType().getName(), ((ParameterValue) attribute.getValue()).getValue().getType().getType().getName())))) {
        String _name = attribute.getName().getEAttributeType().getName();
        String _plus = ("Attribute expected " + _name);
        String _plus_1 = (_plus + " type, but was ");
        Expression _value_1 = attribute.getValue();
        String _name_1 = ((ParameterValue) _value_1).getValue().getType().getType().getName();
        String _plus_2 = (_plus_1 + _name_1);
        String _plus_3 = (_plus_2 + ".\'");
        this.error(_plus_3, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Value());
      } else {
        if (((!Objects.equal(this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()).toString(), "string")) && (!Objects.equal(this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()), this._henshin_textTypeProvider.typeFor(((ParameterValue) attribute.getValue()).getValue().getType().getEnumType().getLiteral()))))) {
          String _name_2 = attribute.getName().getEAttributeType().getName();
          String _plus_4 = ("Attribute expected " + _name_2);
          String _plus_5 = (_plus_4 + " type, but was ");
          Expression _value_2 = attribute.getValue();
          String _literal = ((ParameterValue) _value_2).getValue().getType().getEnumType().getLiteral();
          String _plus_6 = (_plus_5 + _literal);
          String _plus_7 = (_plus_6 + ".\'");
          this.error(_plus_7, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Value());
        }
      }
    } else {
      if (((!Objects.equal(this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()).toString(), "string")) && (!Objects.equal(this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()), this._henshin_textTypeProvider.typeFor(attribute.getValue()))))) {
        String _name_3 = attribute.getName().getEAttributeType().getName();
        String _plus_8 = ("Attribute expected " + _name_3);
        String _plus_9 = (_plus_8 + " type, but was ");
        Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(attribute.getValue());
        String _plus_10 = (_plus_9 + _typeFor);
        String _plus_11 = (_plus_10 + ".\'");
        this.error(_plus_11, attribute, Henshin_textPackage.eINSTANCE.getAttribute_Value());
      }
    }
  }
  
  /**
   * Fehler wenn ein Ausdruck einem Match zugewiesen wird der den falschen Typ hat
   * 
   * @param match Zu überprüfender Match-Ausdruck
   */
  @Check
  public void checkMatchType(final Match match) {
    Expression _value = match.getValue();
    if ((_value instanceof ParameterValue)) {
      if (((!Objects.equal(((ParameterValue) match.getValue()).getValue().getType().getType(), null)) && (!Objects.equal(match.getName().getEAttributeType().getName(), ((ParameterValue) match.getValue()).getValue().getType().getType().getName())))) {
        String _name = match.getName().getEAttributeType().getName();
        String _plus = ("Attribute expected " + _name);
        String _plus_1 = (_plus + " type, but was ");
        Expression _value_1 = match.getValue();
        String _name_1 = ((ParameterValue) _value_1).getValue().getType().getType().getName();
        String _plus_2 = (_plus_1 + _name_1);
        String _plus_3 = (_plus_2 + ".\'");
        this.error(_plus_3, match, Henshin_textPackage.eINSTANCE.getMatch_Value());
      } else {
        if (((!Objects.equal(this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()).toString(), "string")) && (!Objects.equal(this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()), this._henshin_textTypeProvider.typeFor(((ParameterValue) match.getValue()).getValue().getType().getEnumType().getLiteral()))))) {
          String _name_2 = match.getName().getEAttributeType().getName();
          String _plus_4 = ("Attribute expected " + _name_2);
          String _plus_5 = (_plus_4 + " type, but was ");
          Expression _value_2 = match.getValue();
          String _literal = ((ParameterValue) _value_2).getValue().getType().getEnumType().getLiteral();
          String _plus_6 = (_plus_5 + _literal);
          String _plus_7 = (_plus_6 + ".\'");
          this.error(_plus_7, match, Henshin_textPackage.eINSTANCE.getMatch_Value());
        }
      }
    } else {
      if (((!Objects.equal(this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()).toString(), "string")) && (!Objects.equal(this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()), this._henshin_textTypeProvider.typeFor(match.getValue()))))) {
        String _name_3 = match.getName().getEAttributeType().getName();
        String _plus_8 = ("Attribute expected " + _name_3);
        String _plus_9 = (_plus_8 + " type, but was ");
        Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(match.getValue());
        String _plus_10 = (_plus_9 + _typeFor);
        String _plus_11 = (_plus_10 + ".\'");
        this.error(_plus_11, match, Henshin_textPackage.eINSTANCE.getMatch_Value());
      }
    }
  }
  
  /**
   * Fehler wenn das Java-Attribut nicht existiert
   * 
   * @param attribute Zu überprüfenders Java-Attribute
   */
  @Check
  public void checkJavaAttribute(final JavaAttributeValue attribute) {
    Iterable<JavaImport> iterableOfJavaImportImpl = this.getImportList(attribute);
    Field javaAttribute = null;
    for (final JavaImport imports : iterableOfJavaImportImpl) {
      try {
        String _packagename = imports.getPackagename();
        String _plus = (_packagename + ".");
        String _get = attribute.getValue().split("\\.")[0];
        String _plus_1 = (_plus + _get);
        Class<?> calledClass = Class.forName(_plus_1);
        Field[] _declaredFields = calledClass.getDeclaredFields();
        for (final Field atrib : _declaredFields) {
          String _name = atrib.getName();
          Object _get_1 = attribute.getValue().split("\\.")[1];
          boolean _equals = Objects.equal(_name, _get_1);
          if (_equals) {
            javaAttribute = atrib;
          }
        }
      } catch (final Throwable _t) {
        if (_t instanceof ClassNotFoundException) {
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    boolean _equals = Objects.equal(javaAttribute, null);
    if (_equals) {
      String _value = attribute.getValue();
      String _plus = (_value + " doesn\'t exist.\'");
      this.error(_plus, attribute, Henshin_textPackage.eINSTANCE.getJavaAttributeValue_Value());
    }
  }
  
  /**
   * Fehler wenn die aufgerufene Java-Methode nicht existiert oder der Aufruf fehlerhaft ist
   * 
   * @param classCall Javamethodenaufruf der überprüft werden soll
   */
  @Check
  public void checkJavaCall(final JavaClassValue classCall) {
    Iterable<JavaImport> iterableOfJavaImportImpl = this.getImportList(classCall);
    List<Method> methods = new ArrayList<Method>();
    for (final JavaImport imports : iterableOfJavaImportImpl) {
      try {
        String _packagename = imports.getPackagename();
        String _plus = (_packagename + ".");
        String _get = classCall.getValue().split("\\.")[0];
        String _plus_1 = (_plus + _get);
        Class<?> calledClass = Class.forName(_plus_1);
        Method[] _methods = calledClass.getMethods();
        for (final Method method : _methods) {
          String _name = method.getName();
          Object _get_1 = classCall.getValue().split("\\.")[1];
          boolean _equals = Objects.equal(_name, _get_1);
          if (_equals) {
            methods.add(method);
          }
        }
      } catch (final Throwable _t) {
        if (_t instanceof ClassNotFoundException) {
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    int _size = methods.size();
    boolean _lessEqualsThan = (_size <= 0);
    if (_lessEqualsThan) {
      String _value = classCall.getValue();
      String _plus = (_value + " doesn\'t exist.\'");
      this.error(_plus, classCall, Henshin_textPackage.eINSTANCE.getJavaClassValue_Value());
    } else {
      boolean badParametercount = true;
      boolean wrongParameterType = false;
      boolean methodExist = false;
      for (final Method method : methods) {
        if ((!methodExist)) {
          int _size_1 = ((List<Class<?>>)Conversions.doWrapArray(method.getParameterTypes())).size();
          int _size_2 = classCall.getJavaParameter().size();
          boolean _equals = (_size_1 == _size_2);
          if (_equals) {
            badParametercount = false;
            for (int i = 0; (i < classCall.getJavaParameter().size()); i++) {
              Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(classCall.getJavaParameter().get(i));
              Henshin_textType _typeForJavaType = this._henshin_textTypeProvider.typeForJavaType((method.getParameterTypes()[i]).getName());
              boolean _notEquals = (!Objects.equal(_typeFor, _typeForJavaType));
              if (_notEquals) {
                wrongParameterType = true;
              }
            }
          }
          if (((!badParametercount) && (!wrongParameterType))) {
            methodExist = true;
          } else {
            badParametercount = true;
            wrongParameterType = false;
          }
        }
      }
      if ((!methodExist)) {
        int _size_3 = ((List<Class<?>>)Conversions.doWrapArray(methods.get(0).getParameterTypes())).size();
        int _size_4 = classCall.getJavaParameter().size();
        boolean _notEquals = (_size_3 != _size_4);
        if (_notEquals) {
          this.error("Bad Parameter Count.\'", classCall, Henshin_textPackage.eINSTANCE.getJavaClassValue_Value());
        } else {
          for (int i = 0; (i < classCall.getJavaParameter().size()); i++) {
            Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(classCall.getJavaParameter().get(i));
            Henshin_textType _typeForJavaType = this._henshin_textTypeProvider.typeForJavaType((methods.get(0).getParameterTypes()[i]).getName());
            boolean _notEquals_1 = (!Objects.equal(_typeFor, _typeForJavaType));
            if (_notEquals_1) {
              String _name = (methods.get(0).getParameterTypes()[i]).getName();
              String _plus_1 = ("Methode expected " + _name);
              String _plus_2 = (_plus_1 + " type, but was ");
              Henshin_textType _typeFor_1 = this._henshin_textTypeProvider.typeFor(classCall.getJavaParameter().get(i));
              String _plus_3 = (_plus_2 + _typeFor_1);
              String _plus_4 = (_plus_3 + ".\'");
              this.error(_plus_4, classCall.getJavaParameter().get(i), Henshin_textPackage.eINSTANCE.getJavaClassValue_JavaParameter());
            }
          }
        }
      }
    }
  }
  
  /**
   * Liefert Liste der importierten JavaPackages oberhalb des übergebenen Objekts
   * 
   * @param startObject Object für das alle JavaPackages gefunden werden soll
   * 
   * @return List<JavaImport> Liste der importierten JavaPackages
   */
  private List<JavaImport> getImportList(final EObject startObject) {
    List<JavaImport> iterableOfJavaImportImpl = new ArrayList<JavaImport>();
    EObject container = startObject.eContainer();
    while (((!(container instanceof Rule)) && (!(container instanceof MultiRule)))) {
      container = container.eContainer();
    }
    if ((container instanceof Rule)) {
      Iterables.<JavaImport>addAll(iterableOfJavaImportImpl, Iterables.<JavaImport>filter(((Rule) container).getRuleElements(), JavaImport.class));
    } else {
      Iterables.<JavaImport>addAll(iterableOfJavaImportImpl, Iterables.<JavaImport>filter(((MultiRule) container).getMultiruleElements(), JavaImport.class));
    }
    EObject _eContainer = container.eContainer();
    boolean _not = (!(_eContainer instanceof Model));
    if (_not) {
      iterableOfJavaImportImpl.addAll(this.getImportList(container));
    }
    return iterableOfJavaImportImpl;
  }
}
