/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.StateExplorer;
import org.eclipse.emf.henshin.statespace.impl.StateImpl;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceIndexImpl;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;
import org.eclipse.emf.henshin.statespace.util.StateDistanceMonitor;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;

public class BasicStateSpaceManager
extends StateSpaceIndexImpl
implements StateSpaceManager {
    protected final Stack<StateExplorer> explorers = new Stack();
    protected final Object stateSpaceLock = new Object();
    protected StateDistanceMonitor stateDistanceMonitor;
    protected int maxStateDistance;
    protected boolean ignoreDuplicateTransitions;

    public BasicStateSpaceManager(StateSpace stateSpace) {
        super(stateSpace);
        this.refreshHelpers();
    }

    protected void refreshHelpers() {
        this.getStateSpace().updateEqualityHelper();
        String ign = (String)this.getStateSpace().getProperties().get((Object)"ignoreDuplicateTransitions");
        this.ignoreDuplicateTransitions = ign != null && (ign.trim().equalsIgnoreCase("true") || ign.trim().equalsIgnoreCase("yes"));
        this.maxStateDistance = this.getStateSpace().getMaxStateDistance();
        this.stateDistanceMonitor = this.maxStateDistance >= 0 ? new StateDistanceMonitor(this.getStateSpace()) : null;
        this.clearCache();
    }

    protected boolean isOpen(State state) throws StateSpaceException {
        StateExplorer explorer = this.acquireExplorer();
        List<Transition> transitions = explorer.doExplore(state);
        HashSet<Transition> matched = new HashSet<Transition>();
        for (Transition current : transitions) {
            State generated = current.getTarget();
            State target = this.getState(generated.getModel(), generated.getHashCode());
            if (target == null) {
                this.releaseExplorer(explorer);
                return true;
            }
            Transition transition = state.getOutgoing(target, current.getRule(), current.getMatch(), current.getParameterKeys());
            if (transition == null) {
                this.releaseExplorer(explorer);
                return true;
            }
            matched.add(transition);
        }
        this.releaseExplorer(explorer);
        if (!matched.containsAll((Collection<?>)state.getOutgoing())) {
            throw new StateSpaceException("Illegal transition in state " + state.getIndex());
        }
        return false;
    }

    protected final State createOpenState(Model model, int hash, State derivedFrom, int[] location) {
        StateImpl state = new StateImpl();
        state.setIndex(this.getStateSpace().getStates().size());
        state.setHashCode(hash);
        state.setDerivedFrom(derivedFrom != null ? derivedFrom.getIndex() : -1);
        state.setModel(model);
        state.setOpen(true);
        if (location != null) {
            state.setLocation(location);
        }
        if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
            int[] objectKeys = model.getObjectKeys();
            state.setObjectKeys(objectKeys);
            state.setObjectCount(objectKeys.length);
        }
        this.getStateSpace().getStates().add((Object)state);
        this.getStateSpace().getOpenStates().add(state);
        if (this.stateDistanceMonitor != null) {
            this.stateDistanceMonitor.updateDistance(state);
        }
        this.addToIndex(state);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final State createInitialState(Model model) throws StateSpaceException {
        int hash;
        State state;
        Resource resource = model.getResource();
        if (resource == null || resource.getURI() == null) {
            throw new IllegalArgumentException("Model is not persisted");
        }
        EcoreUtil.resolveAll((EObject)model);
        if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
            model.updateObjectKeys(this.getStateSpace().getEqualityHelper().getIdentityTypes());
        }
        if ((state = this.getState(model, hash = this.getStateSpace().getEqualityHelper().hashCode(model))) != null) {
            return state;
        }
        State initial = this.createOpenState(model, hash, null, null);
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.getStateSpace().getInitialStates().add((Object)initial);
            if (this.stateDistanceMonitor != null) {
                this.stateDistanceMonitor.updateDistance(state);
            }
        }
        return initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<State> removeState(State state) throws StateSpaceException {
        ArrayList<State> removed = new ArrayList<State>();
        Object object = this.stateSpaceLock;
        synchronized (object) {
            if (this.getStateSpace().removeState(state)) {
                removed.addAll(StateSpaceSearch.removeUnreachableStates(this.getStateSpace()));
                removed.add(state);
            }
            HashSet<Transition> transitions = new HashSet<Transition>();
            for (State current : removed) {
                this.removeFromIndex(current);
                transitions.addAll((Collection<Transition>)current.getOutgoing());
                transitions.addAll((Collection<Transition>)current.getIncoming());
            }
            int number = this.getStateSpace().getTransitionCount() - transitions.size();
            this.getStateSpace().setTransitionCount(number);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<State> mergeTerminalStates() throws StateSpaceException {
        ArrayList<State> removed = new ArrayList<State>();
        Object object = this.stateSpaceLock;
        synchronized (object) {
            EList<State> states = this.getStateSpace().getStates();
            State goal = null;
            State pruned = null;
            State deadlock = null;
            int i = 0;
            while (i < states.size()) {
                State state = (State)states.get(i);
                state.setIndex(i);
                if (!state.isOpen() && state.getOutgoing().isEmpty()) {
                    if (state.isGoal()) {
                        goal = this.mergeTerminalStates(goal, state);
                    } else if (state.isPruned()) {
                        pruned = this.mergeTerminalStates(pruned, state);
                    } else {
                        deadlock = this.mergeTerminalStates(deadlock, state);
                    }
                    if (i >= states.size() || states.get(i) != state) {
                        --i;
                    }
                }
                ++i;
            }
        }
        return removed;
    }

    private State mergeTerminalStates(State base, State state) {
        if (base == null) {
            return state;
        }
        if (!state.isInitial()) {
            base.getIncoming().addAll(state.getIncoming());
            this.getStateSpace().removeState(state);
            this.removeFromIndex(state);
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resetStateSpace(boolean removeInitial) throws StateSpaceException {
        Object object = this.stateSpaceLock;
        synchronized (object) {
            StateSpace stateSpace = this.getStateSpace();
            stateSpace.getStates().clear();
            stateSpace.getOpenStates().clear();
            if (removeInitial) {
                stateSpace.getInitialStates().clear();
            } else {
                stateSpace.getStates().addAll(stateSpace.getInitialStates());
            }
            this.refreshHelpers();
            this.resetIndex();
            EqualityHelper equalityHelper = stateSpace.getEqualityHelper();
            int stateIndex = 0;
            for (State state : stateSpace.getStates()) {
                state.setIndex(stateIndex++);
                state.getOutgoing().clear();
                state.getIncoming().clear();
                state.setOpen(true);
                state.setPruned(false);
                state.setGoal(false);
                state.setDerivedFrom(-1);
                Model model = state.getModel();
                model.setObjectKeys(StorageImpl.EMPTY_DATA);
                if (!equalityHelper.getIdentityTypes().isEmpty()) {
                    model.updateObjectKeys(equalityHelper.getIdentityTypes());
                }
                state.setObjectKeys(model.getObjectKeys());
                state.setObjectCount(model.getEGraph().size());
                int hash = equalityHelper.hashCode(model);
                if (this.getState(model, hash) != null) {
                    throw new StateSpaceException("Duplicate state: " + state.getIndex());
                }
                state.setHashCode(hash);
                this.addToIndex(state);
            }
            stateSpace.setTransitionCount(0);
        }
    }

    protected State findState(Model model, int hashCode, Collection<State> states) throws StateSpaceException {
        for (State state : states) {
            if (hashCode != state.getHashCode() || !this.getStateSpace().getEqualityHelper().equals(model, this.getModel(state))) continue;
            return state;
        }
        return null;
    }

    @Override
    public int getStateDistance(State state) {
        if (this.stateDistanceMonitor != null) {
            return this.stateDistanceMonitor.getDistance(state);
        }
        return -1;
    }

    @Override
    protected Model deriveModel(State state, boolean fromInitial) throws StateSpaceException {
        StateExplorer explorer = this.acquireExplorer();
        Model model = explorer.deriveModel(state, fromInitial);
        this.releaseExplorer(explorer);
        return model;
    }

    @Override
    public List<State> exploreStates(List<State> states, boolean generateLocation) throws StateSpaceException {
        ArrayList<State> result = new ArrayList<State>();
        try {
            for (State state : states) {
                result.addAll(this.exploreState(state, generateLocation));
            }
        }
        catch (Throwable t) {
            if (t instanceof StateSpaceException) {
                throw (StateSpaceException)t;
            }
            throw new StateSpaceException(t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<State> exploreState(State state, boolean generateLocation) throws StateSpaceException {
        if (this.maxStateDistance >= 0 && this.getStateDistance(state) >= this.maxStateDistance) {
            Object object = this.stateSpaceLock;
            synchronized (object) {
                state.setOpen(false);
                state.setPruned(true);
            }
            return Collections.emptyList();
        }
        StateExplorer explorer = this.acquireExplorer();
        if (explorer.isGoalState(state)) {
            Object object = this.stateSpaceLock;
            synchronized (object) {
                state.setOpen(false);
                state.setPruned(true);
                state.setGoal(true);
            }
            return Collections.emptyList();
        }
        List<Transition> transitions = explorer.doExplore(state);
        if (transitions.isEmpty()) {
            this.releaseExplorer(explorer);
            Object object = this.stateSpaceLock;
            synchronized (object) {
                state.setOpen(false);
            }
            return Collections.emptyList();
        }
        int newStates = 0;
        ArrayList<State> result = new ArrayList<State>(transitions.size());
        int count = transitions.size();
        int i = 0;
        while (i < count) {
            State target;
            Transition t = transitions.get(i);
            Rule rule = t.getRule();
            int match = t.getMatch();
            int[] parameters = t.getParameterKeys();
            int hashCode = t.getTarget().getHashCode();
            Model transformed = t.getTarget().getModel();
            boolean newState = false;
            int[] location = generateLocation ? BasicStateSpaceManager.shiftedLocation(state, newStates++) : null;
            try {
                target = this.getState(transformed, hashCode);
            }
            catch (Throwable throwable) {
                target = null;
            }
            Object object = this.stateSpaceLock;
            synchronized (object) {
                int m;
                if (target == null) {
                    target = this.getState(transformed, hashCode);
                } else if (target.getStateSpace() == null) {
                    target = null;
                }
                if (target == null) {
                    target = this.createOpenState(transformed, hashCode, state, location);
                    newState = true;
                }
                int n = m = this.ignoreDuplicateTransitions ? -1 : match;
                if (newState || state.getOutgoing(target, rule, m, parameters) == null) {
                    t.setSource(state);
                    t.setTarget(target);
                    this.getStateSpace().incTransitionCount();
                    if (this.stateDistanceMonitor != null) {
                        this.stateDistanceMonitor.updateDistance(target);
                    }
                }
                if (newState) {
                    this.addToCache(target, transformed);
                    result.add(target);
                }
                if (i == count - 1) {
                    state.setOpen(false);
                }
            }
            ++i;
        }
        this.releaseExplorer(explorer);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateExplorer acquireExplorer() {
        Stack<StateExplorer> stack = this.explorers;
        synchronized (stack) {
            try {
                return this.explorers.pop();
            }
            catch (Throwable throwable) {
                return new StateExplorer(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseExplorer(StateExplorer explorer) {
        Stack<StateExplorer> stack = this.explorers;
        synchronized (stack) {
            this.explorers.push(explorer);
        }
    }

    protected static int[] shiftedLocation(State base, int index) {
        int[] location = base.getLocation();
        double angle = Math.PI * (double)index * 0.17;
        location[0] = (int)((double)location[0] + 60.0 * Math.cos(angle));
        location[1] = (int)((double)location[1] + 60.0 * Math.sin(angle));
        return location;
    }

    @Override
    public int getNumThreads() {
        return 1;
    }

    @Override
    public void shutdown() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Stack<StateExplorer> stack = this.explorers;
        synchronized (stack) {
            this.explorers.clear();
        }
        System.gc();
    }
}

