/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.rulegen.ui.handlers;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.rulegen.RuleGenerationFacade;
import org.eclipse.emf.henshin.rulegen.ui.dialog.RadioButtonSelectionDialog;
import org.eclipse.emf.henshin.rulegen.ui.util.EMFHandlerUtil;
import org.eclipse.emf.henshin.rulegen.ui.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateRuleByExampleHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Resource resourceA = null;
        Resource resourceB = null;
        String nameA = "";
        String nameB = "";
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 2) {
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                Object oA = iterator.next();
                Object oB = iterator.next();
                if (!(oA instanceof IResource) || !(oB instanceof IResource)) continue;
                nameA = ((IResource)oA).getName();
                nameB = ((IResource)oB).getName();
                ResourceSetImpl rssA = new ResourceSetImpl();
                URI uriA = EMFHandlerUtil.getURI((IResource)oA);
                try {
                    resourceA = rssA.getResource(uriA, true);
                }
                catch (Exception exception) {}
                ResourceSetImpl rssB = new ResourceSetImpl();
                URI uriB = EMFHandlerUtil.getURI((IResource)oB);
                try {
                    resourceB = rssB.getResource(uriB, true);
                }
                catch (Exception exception) {}
            }
        }
        if (resourceA != null && resourceB != null) {
            Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            List<Resource> lhs_rhs_order = this.openSelectDialog(parent, resourceA, nameA, resourceB, nameB);
            if (lhs_rhs_order != null) {
                Resource original = lhs_rhs_order.get(0);
                Resource changed = lhs_rhs_order.get(1);
                if (((EObject)original.getContents().get(0)).eClass().getEPackage() == ((EObject)changed.getContents().get(0)).eClass().getEPackage()) {
                    Module module = RuleGenerationFacade.createRuleByExample((Resource)original, (Resource)changed);
                    if (module != null) {
                        URI eoURI = original.getURI().trimSegments(1).appendSegment(module.getName()).appendFileExtension("henshin");
                        Resource eoRes = new ResourceSetImpl().createResource(eoURI);
                        eoRes.getContents().add((Object)module);
                        try {
                            eoRes.save(Collections.emptyMap());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                    UIUtil.showError("Could not generate a transformation rule from this example.");
                    return null;
                }
                UIUtil.showError("Please select two models of the same type.");
                return null;
            }
            return null;
        }
        UIUtil.showError("Please select two models.");
        return null;
    }

    private List<Resource> openSelectDialog(Shell parent, Resource resourceA, String nameA, Resource resourceB, String nameB) {
        Object[] selection;
        ArrayList<Resource> result = new ArrayList<Resource>();
        String title = "Henshin Rule Generation";
        String message = "Please select the model that represents the left-hand side of the rule.";
        ArrayList<Map.Entry<String, String>> buttonList = new ArrayList<Map.Entry<String, String>>();
        buttonList.add(new AbstractMap.SimpleEntry<String, String>("buttonA", nameA));
        buttonList.add(new AbstractMap.SimpleEntry<String, String>("buttonB", nameB));
        RadioButtonSelectionDialog dialog = new RadioButtonSelectionDialog(parent);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setButtonList(buttonList);
        int returnCode = dialog.open();
        if (returnCode == 0 && (selection = dialog.getResult()) != null) {
            String selectedButton = (String)selection[0];
            if (selectedButton.equals("buttonA")) {
                result.add(resourceA);
                result.add(resourceB);
                return result;
            }
            if (selectedButton.equals("buttonB")) {
                result.add(resourceB);
                result.add(resourceA);
                return result;
            }
        }
        return null;
    }
}

