/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrEvent;
import agg.attribute.AttrInstance;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Graph;
import agg.xt_basis.Type;
import java.util.Vector;

public abstract class GraphObject
implements XMLObject,
AttrObserver {
    protected String name = "";
    protected Graph itsContext = null;
    protected Type itsType = null;
    protected AttrInstance itsAttr = null;
    protected int itsContextUsage;
    protected boolean critical = false;
    protected boolean visible = true;

    public final void createAttributeInstance() {
        if (this.itsType.getAttrType() == null) {
            this.itsType.createAttributeType();
        }
        if (this.itsType.getAttrType() != null) {
            if (this.itsAttr == null) {
                this.itsAttr = AttrTupleManager.getDefaultManager().newInstance(this.itsType.getAttrType(), this.itsContext.getAttrContext());
                this.itsAttr.addObserver(this);
                this.itsContext.attributed = true;
            } else if (this.itsAttr.getType() != this.itsType.getAttrType()) {
                this.itsAttr.removeObserver(this);
                ((ValueTuple)this.itsAttr).dispose();
                this.itsAttr = AttrTupleManager.getDefaultManager().newInstance(this.itsType.getAttrType(), this.itsContext.getAttrContext());
                this.itsAttr.addObserver(this);
            }
        }
    }

    public void disposeAttributeInstance() {
        if (this.itsAttr != null) {
            this.itsAttr.removeObserver(this);
            ((ValueTuple)this.itsAttr).dispose();
            this.itsAttr = null;
        }
    }

    public final void setObjectName(String n) {
        this.name = n != null ? n : "";
    }

    public final String getObjectName() {
        return this.name;
    }

    public final int getContextUsage() {
        return this.itsContextUsage;
    }

    public final void setContextUsage(int aContextUsage) {
        this.itsContextUsage = aContextUsage;
    }

    public final Graph getContext() {
        return this.itsContext;
    }

    public final void setCritical(boolean b) {
        this.critical = b;
    }

    public final boolean isCritical() {
        return this.critical;
    }

    public final void setVisible(boolean b) {
        this.visible = b;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final Type getType() {
        return this.itsType;
    }

    public final void setType(Type type) {
        this.itsType = type;
    }

    public abstract String convertToKey();

    public abstract String resetTypeKey();

    public final AttrInstance getAttribute() {
        return this.itsAttr;
    }

    public final boolean attrExists() {
        return this.itsAttr != null && this.itsAttr.getNumberOfEntries() > 0;
    }

    public final int getNumberOfAttributes() {
        return this.itsAttr == null ? 0 : this.itsAttr.getNumberOfEntries();
    }

    public final Vector<String> getVariableNamesOfAttribute() {
        return this.itsAttr == null ? new Vector(0) : ((ValueTuple)this.itsAttr).getAllVariableNames();
    }

    public synchronized void copyAttributes(GraphObject orig) {
        if (orig.getAttribute() != null) {
            if (this.itsAttr == null) {
                this.createAttributeInstance();
            }
            this.itsAttr.copyEntries(orig.getAttribute());
        }
    }

    @Override
    public void attributeChanged(AttrEvent ev) {
    }

    public String attributeToString() {
        String result = "\nAttributes of : " + this.getType().getName() + " {\n";
        int i = 0;
        while (i < this.itsAttr.getNumberOfEntries()) {
            ValueMember mem = (ValueMember)this.itsAttr.getMemberAt(i);
            result = String.valueOf(result) + "name: " + mem.getName() + "   value: " + mem.getExpr() + "\n";
            ++i;
        }
        result = String.valueOf(result) + " }\n";
        return result;
    }

    public int getNumberOfIncomingArcs() {
        return 0;
    }

    public int getNumberOfOutgoingArcs() {
        return 0;
    }

    public int getNumberOfInOutArcs() {
        return 0;
    }

    public boolean doesChangeAttr(GraphObject go) {
        if (this.attrExists() && go.attrExists()) {
            int i = 0;
            while (i < this.itsAttr.getNumberOfEntries()) {
                ValueMember vm = (ValueMember)this.itsAttr.getMemberAt(i);
                ValueMember vm2 = ((ValueTuple)go.getAttribute()).getEntryAt(vm.getName());
                if (vm2 != null && vm.getDeclaration().getTypeName().equals(vm2.getDeclaration().getTypeName()) && vm.isSet() && (!vm2.isSet() || !vm.getExprAsText().equals(vm2.getExprAsText()))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isAttrMemValDifferent(GraphObject go) {
        if (this.attrExists() && go.attrExists()) {
            int i = 0;
            while (i < this.itsAttr.getNumberOfEntries()) {
                ValueMember vm = (ValueMember)this.itsAttr.getMemberAt(i);
                ValueMember vm2 = ((ValueTuple)go.getAttribute()).getEntryAt(vm.getName());
                if (vm2 != null && vm.getDeclaration().getTypeName().equals(vm2.getDeclaration().getTypeName()) && vm.isSet() && vm2.isSet() && !vm.getExprAsText().equals(vm2.getExprAsText())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isAttrMemConstantValDifferent(GraphObject go) {
        if (this.attrExists() && go.attrExists()) {
            int i = 0;
            while (i < this.itsAttr.getNumberOfEntries()) {
                ValueMember vm = (ValueMember)this.itsAttr.getMemberAt(i);
                ValueMember vm2 = ((ValueTuple)go.getAttribute()).getEntryAt(vm.getName());
                if (vm.isSet() && vm.getExpr().isConstant() && vm2 != null && vm2.isSet() && vm2.getExpr().isConstant() && !vm.getExprAsText().equals(vm2.getExprAsText())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isAttrMemConstantValDifferent(GraphObject go1, GraphObject go2) {
        if (this.attrExists() && go1.attrExists() && go2.attrExists()) {
            int i = 0;
            while (i < this.itsAttr.getNumberOfEntries()) {
                ValueMember vm = (ValueMember)this.itsAttr.getMemberAt(i);
                ValueMember vm2 = ((ValueTuple)go1.getAttribute()).getEntryAt(vm.getName());
                if (vm.isSet() && vm.getExpr().isConstant()) {
                    if (vm2 != null && vm2.isSet() && vm2.getExpr().isConstant() && !vm.getExprAsText().equals(vm2.getExprAsText())) {
                        return true;
                    }
                    vm2 = ((ValueTuple)go2.getAttribute()).getEntryAt(vm.getName());
                    if (vm2 != null && vm2.isSet() && vm2.getExpr().isConstant() && !vm.getExprAsText().equals(vm2.getExprAsText())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public abstract boolean isArc();

    public abstract boolean isNode();

    public abstract boolean compareTo(GraphObject var1);

    @Override
    public abstract void XwriteObject(XMLHelper var1);

    @Override
    public abstract void XreadObject(XMLHelper var1);

    @Override
    public boolean isPersistentFor(AttrTuple at) {
        return false;
    }
}

