/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.impl.javaExpr.JexExpr;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.parser.javaExpr.ASTId;
import agg.attribute.parser.javaExpr.ASTPrimaryExpression;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.cons.AtomConstraint;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.ruleappl.ApplicabilityChecker;
import agg.ruleappl.ObjectFlow;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.util.Triple;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.ConcurrentRule;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.ParallelRule;
import agg.xt_basis.Rule;
import agg.xt_basis.StaticStep;
import agg.xt_basis.TestStep;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.UndirectedGraph;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import agg.xt_basis.agt.RuleScheme;
import agg.xt_basis.csp.Completion_InheritCSP;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class BaseFactory {
    private final List<GraGra> itsGraGras = new Vector<GraGra>();
    protected static BaseFactory theBaseFactory;

    public static BaseFactory theFactory() {
        if (theBaseFactory != null) {
            return theBaseFactory;
        }
        theBaseFactory = new BaseFactory();
        return theBaseFactory;
    }

    public GraGra createGraGra() {
        GraGra gg = new GraGra(new TypeSet());
        this.itsGraGras.add(gg);
        return gg;
    }

    public GraGra createGraGra(boolean withGraph) {
        GraGra gg = new GraGra(withGraph);
        this.itsGraGras.add(gg);
        return gg;
    }

    public GraGra createGraGra(boolean withGraph, boolean directedArcs, boolean parallelArcs) {
        GraGra gg = new GraGra(new TypeSet(directedArcs, parallelArcs), withGraph);
        this.itsGraGras.add(gg);
        return gg;
    }

    public void destroyGraGra(GraGra gg) {
        if (this.itsGraGras.contains(gg)) {
            this.itsGraGras.remove(gg);
            gg.dispose();
        }
    }

    public void removeGraGra(GraGra gg) {
        if (this.itsGraGras.contains(gg)) {
            this.itsGraGras.remove(gg);
        }
    }

    public Enumeration<GraGra> getGraGras() {
        return ((Vector)this.itsGraGras).elements();
    }

    public int getCountOfGraGras() {
        return this.itsGraGras.size();
    }

    public void notify(GraGra gg) {
        if (!this.isElement(gg)) {
            this.itsGraGras.add(gg);
        }
    }

    private boolean isElement(GraGra gg) {
        return this.itsGraGras.contains(gg);
    }

    public GraTra createGraTra() {
        return new DefaultGraTraImpl();
    }

    public final Graph createGraph() {
        return new Graph();
    }

    public final Graph createGraph(TypeSet types) {
        return types.isArcDirected() ? new Graph(types) : new UndirectedGraph(types);
    }

    public final Graph createGraph(TypeSet types, boolean complete) {
        return types.isArcDirected() ? new Graph(types, complete) : new UndirectedGraph(types, complete);
    }

    public final TypeSet createTypeSet() {
        return new TypeSet();
    }

    public final void destroyGraph(Graph graph) {
        graph.dispose();
    }

    public final Pair<OrdinaryMorphism, OrdinaryMorphism> makePO(OrdinaryMorphism r, OrdinaryMorphism m, boolean allowAttrVarsInGraph, boolean wrtEqualAttrVarName) {
        try {
            Pair<OrdinaryMorphism, OrdinaryMorphism> PO = StaticStep.executeColim(r, m, allowAttrVarsInGraph, wrtEqualAttrVarName);
            return PO;
        }
        catch (TypeException typeException) {
            return null;
        }
    }

    public final Pair<OrdinaryMorphism, OrdinaryMorphism> makePOComplement(OrdinaryMorphism l, OrdinaryMorphism g) {
        Graph K = l.getSource();
        Graph L = l.getTarget();
        Graph G = g.getTarget();
        OrdinaryMorphism c = G.inverseIsoCopy();
        if (c == null) {
            return null;
        }
        Graph C = c.getSource();
        OrdinaryMorphism k = new OrdinaryMorphism(K, C, g.getAttrManager().newContext(0));
        Vector<Node> del = new Vector<Node>();
        for (Node nL : L.getNodesCollection()) {
            Node nC = (Node)c.getInverseImage(g.getImage(nL)).nextElement();
            if (l.getInverseImage(nL).hasMoreElements()) {
                Node nK = (Node)l.getInverseImage(nL).nextElement();
                try {
                    k.addMapping(nK, nC);
                    continue;
                }
                catch (BadMappingException ex) {
                    System.out.println("BF.makePOComplement: " + ex.getMessage());
                    return null;
                }
            }
            del.add(nC);
        }
        for (Arc aL : L.getArcsCollection()) {
            Arc aC = (Arc)c.getInverseImage(g.getImage(aL)).nextElement();
            if (l.getInverseImage(aL).hasMoreElements()) {
                Arc aK = (Arc)l.getInverseImage(aL).nextElement();
                try {
                    k.addMapping(aK, aC);
                    continue;
                }
                catch (BadMappingException ex) {
                    System.out.println("BF.makePOComplement: " + ex.getMessage());
                    return null;
                }
            }
            try {
                c.removeMapping(aC);
            }
            catch (BadMappingException ex) {
                System.out.println("BF.makePOComplement: " + ex.getMessage());
                return null;
            }
            try {
                C.destroyArc(aC, false, true);
            }
            catch (TypeException ex) {
                System.out.println("BF.makePOComplement: " + ex.getMessage());
                return null;
            }
        }
        int i = 0;
        while (i < del.size()) {
            try {
                c.removeMapping((GraphObject)del.get(i));
            }
            catch (BadMappingException ex) {
                System.out.println("BF.makePOComplement: " + ex.getMessage());
                return null;
            }
            try {
                C.destroyNode((Node)del.get(i), false, true);
            }
            catch (TypeException ex) {
                System.out.println("BF.makePOComplement: " + ex.getMessage());
                return null;
            }
            ++i;
        }
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(c, k);
    }

    private boolean checkDelDueToMerge(OrdinaryMorphism t, OrdinaryMorphism l, OrdinaryMorphism g) {
        Graph G = g.getTarget();
        for (Arc aG : G.getArcsCollection()) {
            GraphObject sL;
            GraphObject sG = aG.getSource();
            GraphObject tG = aG.getTarget();
            if (!(g.getInverseImage(sG).hasMoreElements() && !t.getInverseImage(g.getInverseImage(sG).nextElement()).hasMoreElements() ? !l.getInverseImage(sL = g.getInverseImage(sG).nextElement()).hasMoreElements() : g.getInverseImage(tG).hasMoreElements() && !l.getInverseImage(sL = g.getInverseImage(tG).nextElement()).hasMoreElements())) continue;
            return false;
        }
        return true;
    }

    public final Pair<OrdinaryMorphism, OrdinaryMorphism> makePB(OrdinaryMorphism f, OrdinaryMorphism g) {
        Graph L = BaseFactory.theFactory().createGraph(f.getTarget().getTypeSet());
        Graph R = g.getSource();
        Graph G = f.getSource();
        Graph H = f.getTarget();
        OrdinaryMorphism r = new OrdinaryMorphism(L, R, g.getAttrManager().newContext(0));
        OrdinaryMorphism m = new OrdinaryMorphism(L, G, f.getAttrManager().newContext(0));
        Hashtable<Node, Node> n2n = new Hashtable<Node, Node>();
        for (Node n : H.getNodesCollection()) {
            if (!g.getInverseImage(n).hasMoreElements() || !f.getInverseImage(n).hasMoreElements()) continue;
            Node n_f = (Node)f.getInverseImage(n).nextElement();
            Node n_g = (Node)g.getInverseImage(n).nextElement();
            try {
                Node nn = L.createNode(n.getType());
                try {
                    r.addMapping(nn, n_g);
                    m.addMapping(nn, n_f);
                    n2n.put(n_g, nn);
                }
                catch (BadMappingException badMappingException) {}
            }
            catch (TypeException nn) {
                // empty catch block
            }
        }
        for (Arc a : H.getArcsCollection()) {
            if (!g.getInverseImage(a).hasMoreElements() || !f.getInverseImage(a).hasMoreElements()) continue;
            Arc a_f = (Arc)f.getInverseImage(a).nextElement();
            Arc a_g = (Arc)g.getInverseImage(a).nextElement();
            Node src = (Node)n2n.get(a_g.getSource());
            Node tar = (Node)n2n.get(a_g.getTarget());
            try {
                Arc na = L.createArc(a.getType(), src, tar);
                try {
                    r.addMapping(na, a_g);
                    m.addMapping(na, a_f);
                }
                catch (BadMappingException badMappingException) {}
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(r, m);
    }

    public final Triple<OrdinaryMorphism, OrdinaryMorphism, OrdinaryMorphism> makeIPO(OrdinaryMorphism g) {
        Graph B = BaseFactory.theFactory().createGraph(g.getTarget().getTypeSet());
        Graph D = g.getSource();
        Graph L = BaseFactory.theFactory().createGraph(g.getTarget().getTypeSet());
        Graph G = g.getTarget();
        OrdinaryMorphism b1 = new OrdinaryMorphism(B, D, g.getAttrManager().newContext(0));
        OrdinaryMorphism b2 = new OrdinaryMorphism(B, L, g.getAttrManager().newContext(0));
        OrdinaryMorphism b3 = new OrdinaryMorphism(L, G, g.getAttrManager().newContext(0));
        Hashtable<GraphObject, GraphObject> n2n_L = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, Node> n2n_B = new Hashtable<GraphObject, Node>();
        for (Arc a : G.getArcsCollection()) {
            if (!g.getInverseImage(a).hasMoreElements()) {
                try {
                    Node s_L = n2n_L.get(a.getSource()) == null || !(n2n_L.get(a.getSource()) instanceof Node) ? L.createNode(a.getSourceType()) : (Node)n2n_L.get(a.getSource());
                    Node t_L = n2n_L.get(a.getTarget()) == null || !(n2n_L.get(a.getTarget()) instanceof Node) ? L.createNode(a.getTargetType()) : (Node)n2n_L.get(a.getTarget());
                    Arc a_L = L.createArc(a.getType(), s_L, t_L);
                    n2n_L.put(a.getSource(), s_L);
                    n2n_L.put(a.getTarget(), t_L);
                    try {
                        b3.addMapping(s_L, a.getSource());
                        b3.addMapping(t_L, a.getTarget());
                        b3.addMapping(a_L, a);
                    }
                    catch (BadMappingException badMappingException) {
                        // empty catch block
                    }
                    if (g.getInverseImage(a.getSource()).hasMoreElements() && n2n_B.get(a.getSource()) == null) {
                        Node s_B = B.createNode(a.getSourceType());
                        n2n_B.put(a.getSource(), s_B);
                        try {
                            b1.addMapping(s_B, g.getInverseImage(a.getSource()).nextElement());
                            b2.addMapping(s_B, s_L);
                        }
                        catch (BadMappingException badMappingException) {
                            // empty catch block
                        }
                    }
                    if (!g.getInverseImage(a.getTarget()).hasMoreElements() || n2n_B.get(a.getTarget()) != null) continue;
                    Node t_B = B.createNode(a.getTargetType());
                    n2n_B.put(a.getTarget(), t_B);
                    try {
                        b1.addMapping(t_B, g.getInverseImage(a.getTarget()).nextElement());
                        b2.addMapping(t_B, t_L);
                    }
                    catch (BadMappingException badMappingException) {
                    }
                }
                catch (TypeException s_L) {}
                continue;
            }
            if (n2n_L.get(a.getSource()) == null) {
                n2n_L.put(a.getSource(), a);
            }
            if (n2n_L.get(a.getTarget()) != null) continue;
            n2n_L.put(a.getTarget(), a);
        }
        for (Node n : G.getNodesCollection()) {
            if (n2n_L.get(n) != null || g.getInverseImage(n).hasMoreElements()) continue;
            try {
                Node n_L = L.createNode(n.getType());
                try {
                    b3.addMapping(n_L, n);
                }
                catch (BadMappingException badMappingException) {}
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return new Triple<OrdinaryMorphism, OrdinaryMorphism, OrdinaryMorphism>(b1, b2, b3);
    }

    public final Pair<OrdinaryMorphism, OrdinaryMorphism> makeSpan(OrdinaryMorphism t) {
        Graph D = BaseFactory.theFactory().createGraph(t.getTarget().getTypeSet());
        Graph G = t.getSource();
        Graph H = t.getTarget();
        OrdinaryMorphism g = new OrdinaryMorphism(D, G, t.getAttrManager().newContext(0));
        OrdinaryMorphism f = new OrdinaryMorphism(D, H, t.getAttrManager().newContext(0));
        Hashtable<Node, Node> n2n = new Hashtable<Node, Node>();
        for (Node n : G.getNodesCollection()) {
            if (t.getImage(n) == null) continue;
            try {
                Node nn = D.createNode(n.getType());
                try {
                    f.addMapping(nn, t.getImage(n));
                    g.addMapping(nn, n);
                    n2n.put(n, nn);
                }
                catch (BadMappingException badMappingException) {}
            }
            catch (TypeException nn) {
                // empty catch block
            }
        }
        for (Arc a : G.getArcsCollection()) {
            if (t.getImage(a) == null) continue;
            Node src = (Node)n2n.get(a.getSource());
            Node tar = (Node)n2n.get(a.getTarget());
            try {
                Arc na = D.createArc(a.getType(), src, tar);
                try {
                    f.addMapping(na, t.getImage(a));
                    g.addMapping(na, a);
                }
                catch (BadMappingException badMappingException) {}
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(g, f);
    }

    public final Rule makeMinimalRule(OrdinaryMorphism t) {
        Rule r;
        OrdinaryMorphism mKD;
        Pair<OrdinaryMorphism, OrdinaryMorphism> span = this.makeSpan(t);
        Triple<OrdinaryMorphism, OrdinaryMorphism, OrdinaryMorphism> IPO1 = this.makeIPO((OrdinaryMorphism)span.first);
        Triple<OrdinaryMorphism, OrdinaryMorphism, OrdinaryMorphism> IPO2 = this.makeIPO((OrdinaryMorphism)span.second);
        Pair<OrdinaryMorphism, OrdinaryMorphism> PB = this.makePB((OrdinaryMorphism)IPO1.first, (OrdinaryMorphism)IPO2.first);
        Pair<OrdinaryMorphism, OrdinaryMorphism> PO4 = this.makePO((OrdinaryMorphism)PB.first, (OrdinaryMorphism)PB.second, true, false);
        Pair<OrdinaryMorphism, OrdinaryMorphism> PO3 = null;
        Pair<OrdinaryMorphism, OrdinaryMorphism> PO5 = null;
        if (((OrdinaryMorphism)IPO1.second).getSource() == ((OrdinaryMorphism)PO4.first).getSource()) {
            PO3 = this.makePO((OrdinaryMorphism)IPO1.second, (OrdinaryMorphism)PO4.first, true, false);
            PO5 = this.makePO((OrdinaryMorphism)IPO2.second, (OrdinaryMorphism)PO4.second, true, false);
        } else if (((OrdinaryMorphism)IPO1.second).getSource() == ((OrdinaryMorphism)PO4.second).getSource()) {
            PO3 = this.makePO((OrdinaryMorphism)IPO1.second, (OrdinaryMorphism)PO4.second, true, false);
            PO5 = this.makePO((OrdinaryMorphism)IPO2.second, (OrdinaryMorphism)PO4.first, true, false);
        }
        if (PO3 != null && PO5 != null && (mKD = new OrdinaryMorphism(((OrdinaryMorphism)PO4.first).getTarget(), ((OrdinaryMorphism)IPO1.first).getTarget(), t.getAttrManager().newContext(0))).makeDiagram((OrdinaryMorphism)PO4.first, (OrdinaryMorphism)IPO1.first) && mKD.makeDiagram((OrdinaryMorphism)PO4.second, (OrdinaryMorphism)IPO2.first) && (r = new Rule(((OrdinaryMorphism)PO3.first).getTarget(), ((OrdinaryMorphism)PO5.first).getTarget())).makeDiagram((OrdinaryMorphism)PO3.first, (OrdinaryMorphism)PO5.first)) {
            OrdinaryMorphism mL = new OrdinaryMorphism(r.getLeft(), t.getSource(), t.getAttrManager().newContext(0));
            OrdinaryMorphism mR = new OrdinaryMorphism(r.getRight(), t.getTarget(), t.getAttrManager().newContext(0));
            if (mL.makeDiagram((OrdinaryMorphism)PO3.first, mKD, (OrdinaryMorphism)span.first) && mR.makeDiagram((OrdinaryMorphism)PO5.first, mKD, (OrdinaryMorphism)span.second)) {
                this.changedAttr2Var(r, t, mL, mR);
                Match m = this.createMatch(r, t.getSource());
                if (m.makeDiagram((OrdinaryMorphism)PO3.first, mKD, (OrdinaryMorphism)span.first) && m.makeDiagram((OrdinaryMorphism)PO3.second, (OrdinaryMorphism)IPO1.third)) {
                    r.setMatch(m);
                    return r;
                }
            }
        }
        return null;
    }

    public final Pair<OrdinaryMorphism, OrdinaryMorphism> makeMerge(OrdinaryMorphism t1, OrdinaryMorphism t2) {
        if (t1.getSource() != t2.getSource()) {
            return null;
        }
        Pair<OrdinaryMorphism, OrdinaryMorphism> span1 = this.makeSpan(t1);
        Pair<OrdinaryMorphism, OrdinaryMorphism> span2 = this.makeSpan(t2);
        Pair<OrdinaryMorphism, OrdinaryMorphism> pb = this.makePB((OrdinaryMorphism)span1.first, (OrdinaryMorphism)span2.first);
        if (pb != null && this.checkDelDueToMerge(t1, (OrdinaryMorphism)pb.second, (OrdinaryMorphism)span1.second) && this.checkDelDueToMerge(t2, (OrdinaryMorphism)pb.first, (OrdinaryMorphism)span2.second)) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> po3;
            Pair<OrdinaryMorphism, OrdinaryMorphism> poc1 = this.makePOComplement((OrdinaryMorphism)pb.second, (OrdinaryMorphism)span1.second);
            Pair<OrdinaryMorphism, OrdinaryMorphism> poc2 = this.makePOComplement((OrdinaryMorphism)pb.first, (OrdinaryMorphism)span2.second);
            if (poc1 != null && poc2 != null && (po3 = this.makePO((OrdinaryMorphism)poc2.second, (OrdinaryMorphism)poc1.second, false, false)) != null) {
                OrdinaryMorphism d = ((OrdinaryMorphism)pb.second).compose((OrdinaryMorphism)span1.first);
                OrdinaryMorphism x = ((OrdinaryMorphism)poc1.second).compose((OrdinaryMorphism)po3.second);
                if (d != null && x != null) {
                    return new Pair<OrdinaryMorphism, OrdinaryMorphism>(d, x);
                }
            }
        }
        return null;
    }

    private void changedAttr2Var(Rule r, OrdinaryMorphism t, OrdinaryMorphism mL, OrdinaryMorphism mR) {
        int indx = 1;
        Enumeration<GraphObject> dom = r.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject goL = dom.nextElement();
            GraphObject goR = r.getImage(goL);
            GraphObject goG = mL.getImage(goL);
            GraphObject goH = mR.getImage(goR);
            if (goG == null || goH == null) continue;
            ValueTuple vtL = (ValueTuple)goL.getAttribute();
            ValueTuple vtR = (ValueTuple)goR.getAttribute();
            ValueTuple vtH = (ValueTuple)goH.getAttribute();
            ValueTuple vtG = (ValueTuple)goG.getAttribute();
            int i = 0;
            while (i < vtG.getSize()) {
                ValueMember vmG = vtG.getValueMemberAt(i);
                ValueMember vmH = vtH.getValueMemberAt(vmG.getName());
                if (vmG.isSet() && vmH.isSet() && !vmG.getExprAsText().equals(vmH.getExprAsText())) {
                    ValueMember vmL = vtL.getValueMemberAt(vmG.getName());
                    vmL.setExprAsText("x".concat(String.valueOf(indx)));
                    ValueMember vmR = vtR.getValueMemberAt(vmG.getName());
                    vmR.setExprAsText("x".concat(String.valueOf(indx)));
                    ++indx;
                }
                ++i;
            }
        }
    }

    public Rule constructRuleFromMorph(OrdinaryMorphism h) {
        return this.constructRuleFromMorph(h, null);
    }

    public Rule constructRuleFromMorph(OrdinaryMorphism h, AttrContext attrCntx) {
        Rule rule = attrCntx == null ? new Rule(h.getOriginal(), h.getImage()) : new Rule(h.getOriginal(), h.getImage(), attrCntx);
        Enumeration<GraphObject> dom = h.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            try {
                rule.addMapping(obj, h.getImage(obj));
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        VarTuple vars = (VarTuple)rule.getAttrContext().getVariables();
        this.declareVar(rule.getLeft(), vars, (ContextView)rule.getAttrContext());
        this.declareVar(rule.getRight(), vars, (ContextView)rule.getAttrContext());
        VarTuple varsMorph = (VarTuple)h.getAttrContext().getVariables();
        int j = 0;
        while (j < varsMorph.getSize()) {
            VarMember vm = varsMorph.getVarMemberAt(j);
            DeclMember dm = (DeclMember)vm.getDeclaration();
            if (dm.getTypeName() != null && dm.getName() != null && !vars.isDeclared(dm.getTypeName(), dm.getName())) {
                vars.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
                vars.getVarMemberAt(dm.getName()).setInputParameter(vm.isInputParameter());
            }
            ++j;
        }
        CondTuple condsMorph = (CondTuple)h.getAttrContext().getConditions();
        CondTuple conds = (CondTuple)rule.getAttrContext().getConditions();
        int j2 = 0;
        while (j2 < condsMorph.getSize()) {
            CondMember cm = condsMorph.getCondMemberAt(j2);
            if (!cm.getExprAsText().equals("")) {
                conds.addCondition(cm.getExprAsText());
            }
            ++j2;
        }
        String exprMsg = "";
        vars = (VarTuple)rule.getAttrContext().getVariables();
        String mark = "r";
        this.setEmptyRHSAttrs(rule, mark, vars, rule.getRight().getNodesSet().iterator());
        this.setEmptyRHSAttrs(rule, mark, vars, rule.getRight().getArcsSet().iterator());
        String warning = rule.getErrorMsg();
        if (!exprMsg.equals("")) {
            warning = warning.concat(exprMsg).concat(" ;  ");
        }
        rule.setErrorMsg(warning);
        return rule;
    }

    private void setEmptyRHSAttrs(Rule rule, String mark, VarTuple vars, Iterator<?> objs) {
        String exprMsg = "";
        int count = vars.getSize();
        while (objs.hasNext()) {
            Enumeration<GraphObject> inverseImg;
            GraphObject o = (GraphObject)objs.next();
            if (o.getAttribute() == null || (inverseImg = rule.getInverseImage(o)).hasMoreElements()) continue;
            ValueTuple value = (ValueTuple)o.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                ValueMember vm = value.getValueMemberAt(i);
                if (!vm.isSet()) {
                    exprMsg = "attribute member:  ".concat(vm.getName());
                    String t = String.valueOf(vm.getName()) + String.valueOf(count) + mark;
                    ++count;
                    vm.setExprAsText(t);
                    vm.setTransient(true);
                    exprMsg = exprMsg.concat("  set by a new variable:  ").concat(t).concat(" ;  ");
                }
                ++i;
            }
        }
    }

    public Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> constructIsomorphicRule(OrdinaryMorphism h) {
        return this.constructIsomorphicRule(h, true, false);
    }

    public Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> constructIsomorphicRule(OrdinaryMorphism h, boolean replaceExpressionByVar, boolean replaceConstantByVar) {
        OrdinaryMorphism isoL = h.getSource().isomorphicCopy();
        if (isoL == null) {
            return null;
        }
        OrdinaryMorphism isoR = h.getTarget().isomorphicCopy();
        if (isoR == null) {
            isoL.dispose(false, true);
            return null;
        }
        Rule rule = new Rule(isoL.getTarget(), isoR.getTarget());
        Enumeration<GraphObject> dom = h.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            GraphObject img = h.getImage(obj);
            try {
                rule.addMapping(isoL.getImage(obj), isoR.getImage(img));
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = new Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>>(rule, new Pair<OrdinaryMorphism, OrdinaryMorphism>(isoL, isoR));
        rule.putVarToAttrContext();
        VarTuple vars = (VarTuple)rule.getAttrContext().getVariables();
        VarTuple varsMorph = (VarTuple)h.getAttrContext().getVariables();
        int j = 0;
        while (j < varsMorph.getSize()) {
            VarMember vm = varsMorph.getVarMemberAt(j);
            DeclMember dm = (DeclMember)vm.getDeclaration();
            if (!vars.isDeclared(dm.getTypeName(), dm.getName())) {
                vars.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
            }
            ++j;
        }
        CondTuple condsMorph = (CondTuple)h.getAttrContext().getConditions();
        CondTuple conds = (CondTuple)rule.getAttrContext().getConditions();
        int j2 = 0;
        while (j2 < condsMorph.getSize()) {
            CondMember cm = condsMorph.getCondMemberAt(j2);
            if (!cm.getExprAsText().equals("")) {
                conds.addCondition(cm.getExprAsText());
            }
            ++j2;
        }
        int count = 1;
        count = this.doCheckAndFillUnsetAttrs(rule, vars, count, replaceExpressionByVar, rule.getRight().getNodesSet().iterator());
        count = this.doCheckAndFillUnsetAttrs(rule, vars, count, replaceExpressionByVar, rule.getRight().getArcsSet().iterator());
        return p;
    }

    private int doCheckAndFillUnsetAttrs(Rule rule, VarTuple vars, int startCount, boolean replaceExpressionByVar, Iterator<?> elems) {
        int count = startCount;
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            boolean inverseImageExists = rule.getInverseImage(o).hasMoreElements();
            if (o.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)o.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                String t;
                ValueMember vm = value.getValueMemberAt(i);
                if (!vm.isSet()) {
                    if (!inverseImageExists) {
                        t = String.valueOf(vm.getName()) + count;
                        vm.setExprAsText(t);
                        vm.setTransient(true);
                        ++count;
                    }
                } else if (vm.getExpr().isComplex() && replaceExpressionByVar) {
                    t = "expr" + count;
                    vm.setExprAsText(t);
                    vm.setTransient(true);
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    public Rule constructRule(OrdinaryMorphism h) {
        String t;
        ValueMember vm;
        int i;
        ValueTuple value;
        Enumeration<GraphObject> inverseImg;
        Rule rule = new Rule(h.getOriginal().getTypeSet());
        Graph lgraph = h.getOriginal();
        Graph rgraph = h.getImage();
        Graph left = rule.getLeft();
        Graph right = rule.getRight();
        Hashtable<GraphObject, GraphObject> ltable = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, GraphObject> rtable = new Hashtable<GraphObject, GraphObject>();
        for (Node rNode : rgraph.getNodesSet()) {
            Node itsRNode = null;
            try {
                itsRNode = right.copyNode(rNode);
                itsRNode.setContextUsage(rNode.getContextUsage());
                rtable.put(rNode, itsRNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        for (Node lNode : lgraph.getNodesSet()) {
            Node itsLNode = null;
            try {
                itsLNode = left.copyNode(lNode);
                itsLNode.setContextUsage(lNode.getContextUsage());
                ltable.put(lNode, itsLNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            GraphObject rn = h.getImage(lNode);
            if (rn == null) continue;
            try {
                rule.addMapping(itsLNode, (GraphObject)rtable.get(rn));
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        for (Arc rArc : rgraph.getArcsSet()) {
            Node itsRSource = (Node)rtable.get(rArc.getSource());
            Node itsRTarget = (Node)rtable.get(rArc.getTarget());
            Arc itsRArc = null;
            try {
                itsRArc = right.copyArc(rArc, itsRSource, itsRTarget);
                itsRArc.setContextUsage(rArc.getContextUsage());
                rtable.put(rArc, itsRArc);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        for (Arc lArc : lgraph.getArcsSet()) {
            Node itsLSource = (Node)ltable.get(lArc.getSource());
            Node itsLTarget = (Node)ltable.get(lArc.getTarget());
            Arc itsLArc = null;
            try {
                itsLArc = left.copyArc(lArc, itsLSource, itsLTarget);
                itsLArc.setContextUsage(lArc.getContextUsage());
                ltable.put(lArc, itsLArc);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            GraphObject graphObject = h.getImage(lArc);
            if (graphObject == null) continue;
            try {
                rule.addMapping(itsLArc, (GraphObject)rtable.get(graphObject));
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        VarTuple vars = (VarTuple)rule.getAttrContext().getVariables();
        int count = vars.getSize();
        String mark = "r";
        for (GraphObject graphObject : right.getNodesSet()) {
            inverseImg = rule.getInverseImage(graphObject);
            if (inverseImg.hasMoreElements() || graphObject.getAttribute() == null) continue;
            value = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < value.getSize()) {
                vm = value.getValueMemberAt(i);
                if (!vm.isSet()) {
                    t = String.valueOf(vm.getName()) + String.valueOf(count) + mark;
                    ++count;
                    vm.setExprAsText(t);
                    vm.setTransient(true);
                }
                ++i;
            }
        }
        for (GraphObject graphObject : right.getArcsSet()) {
            inverseImg = rule.getInverseImage(graphObject);
            if (inverseImg.hasMoreElements() || graphObject.getAttribute() == null) continue;
            value = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < value.getSize()) {
                vm = value.getValueMemberAt(i);
                if (!vm.isSet()) {
                    t = String.valueOf(vm.getName()) + String.valueOf(count) + mark;
                    ++count;
                    vm.setExprAsText(t);
                    vm.setTransient(true);
                }
                ++i;
            }
        }
        ltable.clear();
        ltable = null;
        rtable.clear();
        rtable = null;
        return rule;
    }

    public Pair<OrdinaryMorphism, Pair<OrdinaryMorphism, OrdinaryMorphism>> reverseMorphism(OrdinaryMorphism morph) {
        Graph right;
        if (!morph.isInjective()) {
            return null;
        }
        String warning = "";
        OrdinaryMorphism isoRight = morph.getTarget().isomorphicCopy();
        OrdinaryMorphism isoLeft = morph.getSource().isomorphicCopy();
        if (isoRight == null || isoLeft == null) {
            return null;
        }
        Graph left = isoRight.getTarget();
        OrdinaryMorphism inverseMorph = this.createMorphism(left, right = isoLeft.getTarget());
        VarTuple vars = (VarTuple)inverseMorph.getAttrContext().getVariables();
        String warning1 = this.replaceAttrExpressionByVariable(vars, left.getNodesSet().iterator(), true, null);
        if (!warning1.equals("")) {
            warning = warning.concat(warning1);
        }
        if (!(warning1 = this.replaceAttrExpressionByVariable(vars, left.getArcsSet().iterator(), true, null)).equals("")) {
            warning = warning.concat(warning1);
        }
        Enumeration<GraphObject> dom = morph.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            GraphObject img = morph.getImage(obj);
            GraphObject img1 = isoLeft.getImage(obj);
            GraphObject obj1 = isoRight.getImage(img);
            try {
                inverseMorph.addMapping(obj1, img1);
                this.replaceExprOf3ByVarOf1(obj, img, obj1);
            }
            catch (BadMappingException ex) {
                warning = warning.concat(ex.getMessage()).concat(" ;  ");
            }
            if (obj1.getAttribute() == null || img1.getAttribute() == null) continue;
            ValueTuple valueLeft = (ValueTuple)obj1.getAttribute();
            ValueTuple valueRight = (ValueTuple)img1.getAttribute();
            int i = 0;
            while (i < valueLeft.getSize()) {
                ValueMember mLeft = valueLeft.getValueMemberAt(i);
                ValueMember mRight = valueRight.getValueMemberAt(mLeft.getName());
                if (!mLeft.isSet() && mRight.isSet()) {
                    mLeft.setExprAsText(mRight.getExprAsText());
                    mLeft.setTransient(mRight.isTransient());
                }
                ++i;
            }
        }
        warning1 = this.replaceEmptyAttrByVariable(vars, right.getNodesSet().iterator(), inverseMorph);
        if (!warning1.equals("")) {
            warning = warning.concat(warning1);
        }
        if (!(warning1 = this.replaceEmptyAttrByVariable(vars, right.getArcsSet().iterator(), inverseMorph)).equals("")) {
            warning = warning.concat(warning1);
        }
        inverseMorph.setErrorMsg(warning);
        return new Pair<OrdinaryMorphism, Pair<OrdinaryMorphism, OrdinaryMorphism>>(inverseMorph, new Pair<OrdinaryMorphism, OrdinaryMorphism>(isoLeft, isoRight));
    }

    private void replaceExprOf3ByVarOf1(GraphObject obj, GraphObject img, GraphObject obj1) {
        if (obj.getAttribute() != null && img.getAttribute() != null && obj1.getAttribute() != null) {
            ValueTuple vObj = (ValueTuple)obj.getAttribute();
            ValueTuple vImg = (ValueTuple)img.getAttribute();
            ValueTuple vObj1 = (ValueTuple)obj1.getAttribute();
            int i = 0;
            while (i < vImg.getSize()) {
                ValueMember mImg = vImg.getValueMemberAt(i);
                ValueMember mObj = vObj.getValueMemberAt(i);
                ValueMember mObj1 = vObj1.getValueMemberAt(i);
                if (mImg.isSet() && mImg.getExpr().isComplex() && mObj.isSet() && mObj.getExpr().isVariable()) {
                    mObj1.setTransient(false);
                }
                ++i;
            }
        }
    }

    private boolean reverseMorphismInto(OrdinaryMorphism srcMorph, OrdinaryMorphism tarMorph, Hashtable<GraphObject, GraphObject> table) {
        VarTuple vars;
        String warning1;
        if (!srcMorph.isInjective()) {
            return false;
        }
        String warning = "";
        Graph left = null;
        Graph right = null;
        if (tarMorph == null) {
            left = srcMorph.getTarget().copy(table);
        } else {
            this.copyGraph(srcMorph.getTarget(), tarMorph.getSource(), table);
            left = tarMorph.getSource();
        }
        if (tarMorph == null) {
            right = srcMorph.getSource().copy(table);
        } else {
            this.copyGraph(srcMorph.getSource(), tarMorph.getTarget(), table);
            right = tarMorph.getTarget();
        }
        if (left == null || right == null) {
            return false;
        }
        if (tarMorph == null) {
            tarMorph = this.createMorphism(left, right);
        }
        if (!(warning1 = this.replaceAttrExpressionByVariable(vars = (VarTuple)tarMorph.getAttrContext().getVariables(), left.getNodesSet().iterator(), true, null)).equals("")) {
            warning = warning.concat(warning1);
        }
        if (!(warning1 = this.replaceAttrExpressionByVariable(vars, left.getArcsSet().iterator(), true, null)).equals("")) {
            warning = warning.concat(warning1);
        }
        Enumeration<GraphObject> dom = srcMorph.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            GraphObject img = srcMorph.getImage(obj);
            GraphObject img1 = table.get(obj);
            GraphObject obj1 = table.get(img);
            try {
                tarMorph.addMapping(obj1, img1);
            }
            catch (BadMappingException ex) {
                warning = warning.concat(ex.getMessage()).concat(" ;  ");
            }
            if (obj1.getAttribute() == null || img1.getAttribute() == null) continue;
            ValueTuple valueLeft = (ValueTuple)obj1.getAttribute();
            ValueTuple valueRight = (ValueTuple)img1.getAttribute();
            int i = 0;
            while (i < valueLeft.getSize()) {
                ValueMember mLeft = valueLeft.getValueMemberAt(i);
                ValueMember mRight = valueRight.getValueMemberAt(mLeft.getName());
                if (!mLeft.isSet() && mRight.isSet()) {
                    mLeft.setExprAsText(mRight.getExprAsText());
                    mLeft.setTransient(mRight.isTransient());
                }
                ++i;
            }
        }
        warning1 = this.replaceEmptyAttrByVariable(vars, right.getNodesSet().iterator(), tarMorph);
        if (!warning1.equals("")) {
            warning = warning.concat(warning1);
        }
        if (!(warning1 = this.replaceEmptyAttrByVariable(vars, right.getArcsSet().iterator(), tarMorph)).equals("")) {
            warning = warning.concat(warning1);
        }
        tarMorph.setErrorMsg(warning);
        return true;
    }

    public Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> makeAbstractInverseRule(Rule r) {
        Pair<OrdinaryMorphism, Pair<OrdinaryMorphism, OrdinaryMorphism>> pair = this.reverseMorphism(r);
        if (pair != null) {
            Rule absInverseRule = BaseFactory.theFactory().constructRuleFromMorph((OrdinaryMorphism)pair.first);
            absInverseRule.setName(String.valueOf(r.getName()) + "_INV");
            this.reflectInputParameter(r, absInverseRule);
            String warning = ((OrdinaryMorphism)pair.first).getErrorMsg().concat(absInverseRule.getErrorMsg());
            if (!warning.isEmpty()) {
                absInverseRule.setErrorMsg(warning);
            }
            if (!(r.getNACs().hasMoreElements() || r.getPACs().hasMoreElements() || r.getNestedACs().hasMoreElements() || r.getAttrContext().getConditions().getNumberOfEntries() != 0)) {
                return new Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>>(new Pair<Rule, Boolean>(absInverseRule, Boolean.TRUE), (Pair)pair.second);
            }
            return new Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>>(new Pair<Rule, Boolean>(absInverseRule, Boolean.FALSE), (Pair)pair.second);
        }
        return null;
    }

    public Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> reverseRule(Rule r) {
        boolean failed = false;
        Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> result = this.makeAbstractInverseRule(r);
        if (result != null) {
            boolean needExtend;
            Rule inverseRule = (Rule)((Pair)result.first).first;
            boolean bl = needExtend = (Boolean)((Pair)result.first).second == false;
            if (needExtend) {
                OrdinaryMorphism isoRight = (OrdinaryMorphism)((Pair)result.second).second;
                if (this.convertPACsLeft2Right(r, inverseRule, isoRight)) {
                    if (this.convertRuleGACsLeft2Right(r, inverseRule, isoRight)) {
                        this.convertNACsLeft2Right(r, inverseRule, isoRight);
                        this.convertAttrConditionLeft2Right(r, inverseRule);
                        ((Pair)result.first).second = Boolean.TRUE;
                    }
                } else {
                    failed = true;
                }
            }
            if (failed) {
                ((Rule)((Pair)result.first).first).dispose();
                ((OrdinaryMorphism)((Pair)result.second).first).dispose();
                ((OrdinaryMorphism)((Pair)result.second).second).dispose();
                result.first = null;
                result.second = null;
                result = null;
            } else {
                inverseRule.removeUnusedVariableOfAttrContext();
                inverseRule.isReadyToTransform();
            }
        }
        return result;
    }

    public void replaceExprByVarInApplConds(Rule r, Hashtable<ValueMember, Pair<String, String>> storeMap) {
        VarTuple vars;
        OrdinaryMorphism morph;
        Enumeration<OrdinaryMorphism> applConds = r.getNACs();
        while (applConds.hasMoreElements()) {
            morph = applConds.nextElement();
            vars = (VarTuple)morph.getAttrContext().getVariables();
            this.replaceAttrExpressionByVariable(vars, morph.getTarget().getNodesSet().iterator(), true, storeMap);
            this.replaceAttrExpressionByVariable(vars, morph.getTarget().getArcsSet().iterator(), true, storeMap);
        }
        applConds = r.getPACs();
        while (applConds.hasMoreElements()) {
            morph = applConds.nextElement();
            vars = (VarTuple)morph.getAttrContext().getVariables();
            this.replaceAttrExpressionByVariable(vars, morph.getTarget().getNodesSet().iterator(), true, storeMap);
            this.replaceAttrExpressionByVariable(vars, morph.getTarget().getArcsSet().iterator(), true, storeMap);
        }
    }

    public void replaceExprByVarInApplConds(List<Rule> rules, Hashtable<ValueMember, Pair<String, String>> storeMap) {
        int i = 0;
        while (i < rules.size()) {
            Rule r = rules.get(i);
            this.replaceExprByVarInApplConds(r, storeMap);
            ++i;
        }
    }

    public String replaceAttrExpressionByVariable(VarTuple vars, Iterator<?> elems, boolean setTransient, Hashtable<ValueMember, Pair<String, String>> storeMap) {
        int nn = -1;
        String exprMsg = "";
        while (elems.hasNext()) {
            GraphObject grob = (GraphObject)elems.next();
            ++nn;
            if (grob.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)grob.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                String nm = i == 0 ? "" : "" + i;
                ValueMember val = value.getValueMemberAt(i);
                if (val.isSet()) {
                    String varname;
                    if (val.getExpr().isComplex()) {
                        exprMsg = "Attr. expression   ".concat(val.getExprAsText());
                        varname = "expr" + nn + nm;
                        if (storeMap != null) {
                            storeMap.put(val, new Pair<String, String>(varname, val.getExprAsText()));
                        }
                        val.setExpr(null);
                        vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
                        vars.getEntryAt(varname).setTransient(setTransient);
                        val.setExprAsText(varname);
                        val.setTransient(setTransient);
                        exprMsg = exprMsg.concat("   replaced by a new variable   ").concat(varname).concat(" ;  ");
                    } else if (val.getExpr().isVariable() && vars.getVarMemberAt(val.getExprAsText()) == null) {
                        varname = val.getExprAsText();
                        vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
                        vars.getEntryAt(varname).setTransient(true);
                        val.setTransient(setTransient);
                    }
                }
                ++i;
            }
        }
        return exprMsg;
    }

    public void restoreExprByVarInApplConds(Rule r, Hashtable<ValueMember, Pair<String, String>> storeMap) {
        VarTuple vars;
        OrdinaryMorphism morph;
        Enumeration<OrdinaryMorphism> applConds = r.getNACs();
        while (applConds.hasMoreElements()) {
            morph = applConds.nextElement();
            vars = (VarTuple)morph.getAttrContext().getVariables();
            this.restoreAttrExpressionReplacedByVariable(vars, morph.getTarget().getNodesSet().iterator(), storeMap);
            this.restoreAttrExpressionReplacedByVariable(vars, morph.getTarget().getArcsSet().iterator(), storeMap);
        }
        applConds = r.getPACs();
        while (applConds.hasMoreElements()) {
            morph = applConds.nextElement();
            vars = (VarTuple)morph.getAttrContext().getVariables();
            this.restoreAttrExpressionReplacedByVariable(vars, morph.getTarget().getNodesSet().iterator(), storeMap);
            this.restoreAttrExpressionReplacedByVariable(vars, morph.getTarget().getArcsSet().iterator(), storeMap);
        }
    }

    public void restoreExprByVarInApplConds(List<Rule> rules, Hashtable<ValueMember, Pair<String, String>> storeMap) {
        if (storeMap == null || storeMap.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < rules.size()) {
            Rule r = rules.get(i);
            this.restoreExprByVarInApplConds(r, storeMap);
            ++i;
        }
    }

    private void restoreAttrExpressionReplacedByVariable(VarTuple vars, Iterator<?> elems, Hashtable<ValueMember, Pair<String, String>> storeMap) {
        while (elems.hasNext()) {
            GraphObject grob = (GraphObject)elems.next();
            if (grob.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)grob.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                ValueMember val = value.getValueMemberAt(i);
                Pair<String, String> p = storeMap.get(val);
                if (p != null) {
                    String var = (String)p.first;
                    String expr = (String)p.second;
                    val.setExprAsText(expr);
                    val.setTransient(false);
                    vars.getTupleType().deleteMemberAt(var);
                }
                ++i;
            }
        }
    }

    public Rule checkApplCondsOfRules(List<Rule> rules) {
        int i = 0;
        while (i < rules.size()) {
            if (!rules.get(i).areApplCondsValid()) {
                return rules.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean checkWeakParallelMatches(Match m1, Match m2) {
        if (m1 != null && m1.isValid() && m2 != null && m2.isValid()) {
            Enumeration<GraphObject> dom1 = m1.getDomain();
            while (dom1.hasMoreElements()) {
                GraphObject go1 = dom1.nextElement();
                GraphObject go = m1.getImage(go1);
                if (!m2.hasInverseImage(go)) continue;
                GraphObject go2 = m2.getInverseImage(go).nextElement();
                if (m2.getRule().getImage(go2) == null) {
                    return false;
                }
                if (m1.getRule().getImage(go1) == null) {
                    return false;
                }
                GraphObject img1 = m1.getRule().getImage(go1);
                GraphObject img2 = m2.getRule().getImage(go2);
                if (img1.getAttribute() == null || img2.getAttribute() == null) continue;
                ValueTuple vt1l = (ValueTuple)go1.getAttribute();
                ValueTuple vt2l = (ValueTuple)go2.getAttribute();
                ValueTuple vt1r = (ValueTuple)img1.getAttribute();
                ValueTuple vt2r = (ValueTuple)img2.getAttribute();
                int i = 0;
                while (i < vt1r.getNumberOfEntries()) {
                    ValueMember vm1r = vt1r.getEntryAt(i);
                    ValueMember vm1l = vt1l.getEntryAt(vm1r.getName());
                    if (!(!vm1r.isSet() || vm1l.isSet() && vm1r.getExprAsText().equals(vm1l.getExprAsText()))) {
                        return false;
                    }
                    ValueMember vm2r = vt2r.getEntryAt(vm1r.getName());
                    ValueMember vm2l = vt2l.getEntryAt(vm1r.getName());
                    if (!(!vm2r.isSet() || vm2l.isSet() && vm2r.getExprAsText().equals(vm2l.getExprAsText()))) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public ParallelRule makeParallelRule(TypeSet types, List<Rule> rules) {
        if (rules.size() == 2) {
            return new ParallelRule(types, rules.get(0), rules.get(1));
        }
        return null;
    }

    private ConcurrentRule makeConcurrentRuleByDisjointUnion(Rule r1, Rule r2) {
        Hashtable<String, String> storeNewName2OldName = new Hashtable<String, String>();
        if (r1 != r2) {
            BaseFactory.theFactory().renameSimilarVariable(r2, r1, "r1_", storeNewName2OldName);
        }
        ConcurrentRule cr = new ConcurrentRule(r1, r2);
        if (!storeNewName2OldName.isEmpty()) {
            BaseFactory.theFactory().restoreVariableNameOfRule(r1, storeNewName2OldName);
        }
        return cr;
    }

    private ConcurrentRule makeConcurrentRuleByObjectFlow(Rule r1, Rule r2, Hashtable<Object, Object> objFlow) {
        if (objFlow.isEmpty()) {
            return this.makeConcurrentRuleByDisjointUnion(r1, r2);
        }
        ConcurrentRule cr = null;
        Hashtable<String, String> storeNewName2OldName = new Hashtable<String, String>();
        if (r1 != r2) {
            BaseFactory.theFactory().renameSimilarVariable(r2, r1, "r1_", storeNewName2OldName);
        }
        Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> inverseRulePair = BaseFactory.theFactory().reverseRule(r1);
        Rule inverseRule1 = (Rule)((Pair)inverseRulePair.first).first;
        int maxsize = r2.getLeft().getSize();
        if (!objFlow.isEmpty()) {
            maxsize = objFlow.size();
        }
        if (maxsize > 0) {
            long freeM = Runtime.getRuntime().freeMemory();
            Hashtable<Object, Object> inversematchmap = new Hashtable<Object, Object>();
            Enumeration<Object> keys = objFlow.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                inversematchmap.put(objFlow.get(key), ((OrdinaryMorphism)((Pair)inverseRulePair.second).second).getImage((GraphObject)key));
            }
            Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> enums = BaseFactory.theFactory().getOverlappingByPredefinedIntersection(r2.getLeft(), inverseRule1.getLeft(), inversematchmap);
            if (enums != null && enums.hasMoreElements()) {
                Pair<OrdinaryMorphism, OrdinaryMorphism> overlapping = enums.nextElement();
                cr = new ConcurrentRule(r1, (Rule)((Pair)inverseRulePair.first).first, r2, (OrdinaryMorphism)((Pair)inverseRulePair.second).first, (OrdinaryMorphism)((Pair)inverseRulePair.second).second, (OrdinaryMorphism)overlapping.second, (OrdinaryMorphism)overlapping.first);
                if (cr.getRule() != null) {
                    System.out.println("=== >>>  Concurrent rule: " + cr.getRule().getName() + "  has NACs: " + cr.getRule().getNACs().hasMoreElements() + ", has PACs: " + cr.getRule().getPACs().hasMoreElements());
                    cr.usedM = freeM - Runtime.getRuntime().freeMemory();
                }
            }
        }
        if (!storeNewName2OldName.isEmpty()) {
            BaseFactory.theFactory().restoreVariableNameOfRule(r1, storeNewName2OldName);
        }
        return cr;
    }

    public ConcurrentRule makeConcurrentRuleOfRuleSeqBackwards(RuleSequence sequence, boolean byObjectFlow) {
        long freeM = 0L;
        ConcurrentRule cr = null;
        boolean ok = true;
        if (byObjectFlow) {
            sequence.makeFlatSequence();
            sequence.tryCompleteObjFlowTransClosure();
        }
        RuleSequence rs = sequence.getCopy();
        int size = rs.getSize();
        int i2 = -1;
        int i1 = -1;
        while (size > 1 && ok) {
            ObjectFlow objFlow_r1r2;
            i2 = size - 1;
            i1 = i2 - 1;
            Rule r1 = rs.getRule(i1);
            Rule r2 = rs.getRule(i2);
            cr = byObjectFlow ? ((objFlow_r1r2 = rs.getObjFlowForRules(r1, i1, r2, i2)) != null && !objFlow_r1r2.isEmpty() ? this.makeConcurrentRuleByObjectFlow(r1, r2, objFlow_r1r2.getMapping()) : this.makeConcurrentRuleByDisjointUnion(r1, r2)) : this.makeConcurrentRuleByDisjointUnion(r1, r2);
            if (cr == null || cr.getRule() == null) {
                ok = false;
                continue;
            }
            freeM = Runtime.getRuntime().freeMemory();
            cr.setIndexOfFirstSourceRule(i1);
            cr.setIndexOfSecondSourceRule(i2);
            Vector<ObjectFlow> newObjFlows = new Vector<ObjectFlow>();
            if (byObjectFlow) {
                Hashtable<Object, Object> gOutIn;
                List<ObjectFlow> r1ObjFlow = rs.getObjFlowForRule(r1, i1);
                List<ObjectFlow> r2ObjFlow = rs.getObjFlowForRule(r2, i2);
                cr.reflectObjectFlow(r1ObjFlow);
                cr.reflectObjectFlow(r2ObjFlow);
                int j = 0;
                while (j < i1) {
                    Hashtable<Object, Object> rjOutIn;
                    Rule rj = rs.getRule(j);
                    List<ObjectFlow> rjObjFlow = rs.getObjFlowFromRule(rj, j);
                    if (!rjObjFlow.isEmpty() && !(rjOutIn = new Hashtable<Object, Object>(cr.getReflectedInputObjectFlowFromRule(rj, rjObjFlow))).isEmpty()) {
                        int indx1 = j;
                        int indx2 = i1;
                        if (rs.getGraph() != null) {
                            ++indx1;
                            ++indx2;
                        }
                        ObjectFlow objFlow = new ObjectFlow(rj, cr.getRule(), indx1, indx2, rjOutIn);
                        newObjFlows.add(objFlow);
                    }
                    ++j;
                }
                List<ObjectFlow> gObjFlow = rs.getObjFlowFromGraph();
                if (!gObjFlow.isEmpty() && !(gOutIn = new Hashtable<Object, Object>(cr.getReflectedInputObjectFlowFromGraph(rs.getGraph(), gObjFlow))).isEmpty()) {
                    int indx2 = i1;
                    if (rs.getGraph() != null) {
                        ++indx2;
                    }
                    ObjectFlow objFlow = new ObjectFlow(rs.getGraph(), cr.getRule(), 0, indx2, gOutIn);
                    newObjFlows.add(objFlow);
                }
            }
            rs.removeRule(i2);
            rs.removeRule(i1);
            rs.addRule(cr.getRule());
            int l = 0;
            while (l < newObjFlows.size()) {
                rs.addObjFlow((ObjectFlow)newObjFlows.get(l));
                ++l;
            }
            rs.tryCompleteObjFlowTransClosure();
            size = rs.getSize();
        }
        if (cr != null && rs.getSize() == 1 && cr.getRule() == rs.getRule(0)) {
            List<ObjectFlow> gOF = rs.getObjFlowFromGraph();
            if (gOF != null) {
                Match m = this.createMatch(cr.getRule(), rs.getGraph());
                cr.getRule().setMatch(m);
                int i = 0;
                while (i < gOF.size()) {
                    GraphObject go;
                    ObjectFlow of = gOF.get(i);
                    List<Object> inpts = of.getInputs();
                    int j = 0;
                    while (j < inpts.size()) {
                        go = (GraphObject)inpts.get(j);
                        if (go.isNode() && go.getContext() == cr.getRule().getLeft()) {
                            try {
                                m.addMapping(go, (GraphObject)of.getOutput(go));
                            }
                            catch (BadMappingException badMappingException) {
                                // empty catch block
                            }
                        }
                        ++j;
                    }
                    inpts = of.getInputs();
                    j = 0;
                    while (j < inpts.size()) {
                        go = (GraphObject)inpts.get(j);
                        if (go.isArc() && go.getContext() == cr.getRule().getLeft()) {
                            try {
                                m.addMapping(go, (GraphObject)of.getOutput(go));
                            }
                            catch (BadMappingException badMappingException) {
                                // empty catch block
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            cr.usedM = cr.usedM + freeM - Runtime.getRuntime().freeMemory();
        }
        return cr;
    }

    public List<ConcurrentRule> makeConcurrentRuleOfRuleSeqForward(RuleSequence sequence, GraGra gra, boolean completeConcurrency) {
        RuleSequence rs = sequence.getCopy();
        ApplicabilityChecker applChecker = new ApplicabilityChecker(rs, gra);
        applChecker.setCompleteConcurrency(completeConcurrency);
        List<ConcurrentRule> crs = applChecker.buildPlainConcurrentRule(rs.getRules(), null);
        int i = 0;
        while (i < crs.size()) {
            ConcurrentRule concurrentRule = crs.get(i);
            Rule r = concurrentRule.getRule();
            this.checkAttrContext(r);
            ++i;
        }
        return crs;
    }

    private void checkAttrContext(Rule r) {
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        for (Node n : r.getRight().getNodesSet()) {
            if (n.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)n.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                String errm;
                VarMember v;
                ValueMember vm = (ValueMember)vt.getMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable() && (v = (VarMember)vars.getMemberAt(vm.getExprAsText())) != null && !(errm = vm.getErrorMsg()).isEmpty()) {
                    vm.removeErrorMsg();
                    vm.setExprAsText(v.getName());
                }
                ++i;
            }
        }
    }

    private String replaceEmptyAttrByVariable(VarTuple vars, Iterator<?> e, OrdinaryMorphism morph) {
        String exprMsg = "";
        while (e.hasNext()) {
            GraphObject grob = (GraphObject)e.next();
            if (grob.getAttribute() == null || morph.getInverseImage(grob).hasMoreElements()) continue;
            ValueTuple value = (ValueTuple)grob.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                String varname;
                ValueMember val = value.getValueMemberAt(i);
                if (!val.isSet()) {
                    exprMsg = "attribute member:  ".concat(val.getName());
                    varname = "r" + i;
                    vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
                    val.setExprAsText(varname);
                    val.setTransient(true);
                    vars.getEntryAt(varname).setTransient(true);
                    exprMsg = exprMsg.concat("  set by a new variable:  ").concat(varname).concat(" ;  ");
                } else if (val.getExpr().isVariable() && vars.getVarMemberAt(val.getExprAsText()) == null) {
                    varname = val.getExprAsText();
                    vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
                    vars.getEntryAt(varname).setTransient(true);
                }
                ++i;
            }
        }
        return exprMsg;
    }

    public void replaceTransientTarVarBySrcVar(OrdinaryMorphism morph) {
        this.replaceTransTarVarBySrcVar(morph.getTarget().getNodesCollection().iterator(), morph, (VarTuple)morph.getAttrContext().getVariables());
        this.replaceTransTarVarBySrcVar(morph.getTarget().getArcsCollection().iterator(), morph, (VarTuple)morph.getAttrContext().getVariables());
    }

    private void replaceTransTarVarBySrcVar(Iterator<?> e, OrdinaryMorphism morph, VarTuple vars) {
        while (e.hasNext()) {
            GraphObject src;
            GraphObject tar = (GraphObject)e.next();
            if (!tar.attrExists() || !morph.getInverseImage(tar).hasMoreElements() || !(src = morph.getInverseImage(tar).nextElement()).attrExists()) continue;
            ValueTuple srcVal = (ValueTuple)src.getAttribute();
            ValueTuple tarVal = (ValueTuple)tar.getAttribute();
            int i = 0;
            while (i < tarVal.getSize()) {
                VarMember v;
                ValueMember srcM;
                ValueMember tarM = tarVal.getValueMemberAt(i);
                if (tarM.isSet() && tarM.isTransient() && (srcM = srcVal.getValueMemberAt(tarM.getName())) != null && srcM.isSet() && srcM.getExpr().isVariable() && (v = vars.getVarMemberAt(srcM.getExprAsText())) != null && !v.isTransient()) {
                    tarM.setExprAsText(v.getName());
                    tarM.setTransient(false);
                }
                ++i;
            }
        }
    }

    public void reflectInputParameter(Rule r, Rule absInvertRule) {
        VarTuple varsOfInvertRule = (VarTuple)absInvertRule.getAttrContext().getVariables();
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember vmOfInvertRule;
            VarMember vm = vars.getVarMemberAt(i);
            if (vm.isInputParameter() && (vmOfInvertRule = varsOfInvertRule.getVarMemberAt(vm.getName())) != null) {
                vmOfInvertRule.setInputParameter(true);
            }
            ++i;
        }
    }

    private void convertAttrConditionLeft2Right(Rule r, Rule inverseR) {
        CondTuple conds = (CondTuple)r.getAttrContext().getConditions();
        if (conds.isEmpty()) {
            return;
        }
        CondTuple condsOfInverseR = (CondTuple)inverseR.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getNumberOfEntries()) {
            CondMember cond = conds.getCondMemberAt(i);
            condsOfInverseR.addCondition(cond.getExprAsText());
            ++i;
        }
    }

    public Pair<OrdinaryMorphism, OrdinaryMorphism> extendRightGraphByNAC(Rule r, OrdinaryMorphism nacL) {
        OrdinaryMorphism isoLHS = r.getLeft().isomorphicCopy();
        if (isoLHS == null) {
            return null;
        }
        OrdinaryMorphism extLeft = this.extendTargetGraph1ByTargetGraph2(isoLHS, nacL);
        if (extLeft == null) {
            return null;
        }
        Graph extLeftGraph = extLeft.getTarget();
        Match m = BaseFactory.theFactory().createMatch(r, extLeftGraph, true, "1");
        m.getTarget().setCompleteGraph(false);
        for (Node n : r.getLeft().getNodesSet()) {
            Node img = (Node)isoLHS.getImage(n);
            if (img == null) continue;
            try {
                m.addMapping(n, img);
            }
            catch (BadMappingException ex) {
                System.out.println("BaseFactory.extendRightGraphByNAC:  " + n + "  " + ex);
                return null;
            }
        }
        for (Arc a : r.getLeft().getArcsSet()) {
            Arc img = (Arc)isoLHS.getImage(a);
            if (img == null) continue;
            try {
                m.addMapping(a, img);
            }
            catch (BadMappingException ex) {
                System.out.println("extendRightGraphByNAC:  " + a + "  " + ex);
                return null;
            }
        }
        if (m.isTotal()) {
            if (!m.isDanglingSatisfied()) {
                System.out.println("extendRightGraphByNAC:  isDanglingConditionSatisfied  FAILED!");
                return null;
            }
            try {
                OrdinaryMorphism R2R_NAC = (OrdinaryMorphism)TestStep.execute(m, true);
                R2R_NAC.setName("RHS_" + nacL.getName());
                return new Pair<OrdinaryMorphism, OrdinaryMorphism>(R2R_NAC, extLeft);
            }
            catch (TypeException tex) {
                System.out.println("extendRightGraphByNAC:  s.execute:  " + tex);
                return null;
            }
        }
        System.out.println("extendRightGraphByNAC:  m  is NOT TOTAL! FAILED!");
        return null;
    }

    private void convertNACsLeft2Right(Rule r, Rule inverseRule, OrdinaryMorphism isoRHS) {
        List<OrdinaryMorphism> nacs = r.getNACsList();
        int i = 0;
        while (i < nacs.size()) {
            OrdinaryMorphism ac;
            OrdinaryMorphism acL = nacs.get(i);
            OrdinaryMorphism acR = null;
            if (r.isACShiftPossible(acL)) {
                int tglevelcheck = r.getTypeSet().getLevelOfTypeGraphCheck();
                r.getTypeSet().setLevelOfTypeGraph(10);
                acR = this.convertACLeft2Right(r, acL);
                if (acR != null) {
                    r.getTypeSet().setLevelOfTypeGraph(tglevelcheck);
                    Collection<TypeError> error = r.getTypeSet().checkType(acR.getTarget());
                    if (error != null && !error.isEmpty()) {
                        acR.dispose(false, true);
                        acR = null;
                    }
                }
            }
            boolean ok = false;
            if (!(acR == null || !(ok = acR.completeDiagram(isoRHS, ac = BaseFactory.theFactory().createMorphism(inverseRule.getLeft(), acR.getTarget()))) || ac.isRightTotal() && ac.doesIgnoreAttrs())) {
                this.unsetAllTransientAttrValues(ac);
                ac.setAttrContext(inverseRule.getLeft().getAttrContext());
                this.declareVariable(ac.getTarget(), (VarTuple)inverseRule.getAttrContext().getVariables());
                this.adjustAttributeValueAlongMorphismMapping(ac);
                ac.setName(acR.getName());
                ac.setEnabled(acL.isEnabled());
                inverseRule.addNAC(ac);
            }
            if (!ok) {
                String warning = inverseRule.getErrorMsg();
                String warning1 = "NAC: ".concat(acL.getName()).concat("  could not be converted");
                warning = warning.concat(warning1).concat(" ;  ");
                inverseRule.setErrorMsg(warning);
            }
            ++i;
        }
    }

    private boolean convertNACsLeft2Right(Rule r, Rule inverseRule, Hashtable<GraphObject, GraphObject> isoRight) {
        List<OrdinaryMorphism> acs = r.getNACsList();
        int i = 0;
        while (i < acs.size()) {
            OrdinaryMorphism ac;
            OrdinaryMorphism acL = acs.get(i);
            OrdinaryMorphism acR = null;
            if (r.isACShiftPossible(acL)) {
                int tglevelcheck = r.getTypeSet().getLevelOfTypeGraphCheck();
                r.getTypeSet().setLevelOfTypeGraph(10);
                acR = this.convertACLeft2Right(r, acL);
                r.getTypeSet().setLevelOfTypeGraph(tglevelcheck);
                Collection<TypeError> error = r.getTypeSet().checkType(acR.getTarget());
                if (error != null && !error.isEmpty()) {
                    acR.dispose(false, true);
                    acR = null;
                }
            }
            boolean ok = false;
            if (!(acR == null || !(ok = (ac = BaseFactory.theFactory().createMorphism(inverseRule.getLeft(), acR.getTarget())).completeDiagram(isoRight, acR)) || ac.isRightTotal() && ac.doesIgnoreAttrs())) {
                this.unsetAllTransientAttrValues(ac);
                ac.setAttrContext(inverseRule.getLeft().getAttrContext());
                this.declareVariable(ac.getTarget(), (VarTuple)inverseRule.getAttrContext().getVariables());
                this.adjustAttributeValueAlongMorphismMapping(ac);
                ac.setEnabled(acL.isEnabled());
                ac.setName(acR.getName());
                inverseRule.addNAC(ac);
            }
            if (!ok) {
                String warning = inverseRule.getErrorMsg();
                String warning1 = "NAC: ".concat(acL.getName()).concat("  could not be shifted from left to right");
                warning = warning.concat(warning1).concat(" ;  ");
                inverseRule.setErrorMsg(warning);
            }
            ++i;
        }
        return true;
    }

    private boolean convertRuleGACsLeft2Right(Rule r, Rule inverseRule, OrdinaryMorphism isoRight) {
        boolean failed = false;
        List<OrdinaryMorphism> acs = r.getNestedACsList();
        int i = 0;
        while (i < acs.size() && !failed) {
            NestedApplCond acL = (NestedApplCond)acs.get(i);
            OrdinaryMorphism acR = null;
            Pair<OrdinaryMorphism, OrdinaryMorphism> pairPO = null;
            if (r.isACShiftPossible(acL)) {
                int tglevelcheck = r.getTypeSet().getLevelOfTypeGraphCheck();
                r.getTypeSet().setLevelOfTypeGraph(10);
                pairPO = this.convertNestedACLeft2Right(r, acL);
                r.getTypeSet().setLevelOfTypeGraph(tglevelcheck);
                if (pairPO != null) {
                    acR = (OrdinaryMorphism)pairPO.second;
                    Collection<TypeError> error = r.getTypeSet().checkType(acR.getTarget());
                    if (error != null && !error.isEmpty()) {
                        acR.dispose(false, true);
                        acR = null;
                    }
                }
            }
            if (acR != null) {
                NestedApplCond ac = new NestedApplCond(inverseRule.getLeft(), acR.getTarget(), inverseRule.getRight().getAttrContext());
                ac.completeDiagram2(isoRight, acR);
                this.unsetAllTransientAttrValues(ac);
                ac.getTarget().setAttrContext(ac.getAttrContext());
                this.declareVariable(ac.getTarget(), (VarTuple)inverseRule.getAttrContext().getVariables());
                this.adjustAttributeValueAlongMorphismMapping(ac);
                ac.setName(acL.getName());
                inverseRule.addNestedAC(ac);
                if (!acL.getNestedACs().isEmpty()) {
                    this.convertNestedACsLeft2Right((OrdinaryMorphism)pairPO.first, acL, acR, ac, inverseRule);
                }
            } else {
                String warning = inverseRule.getErrorMsg();
                String warning1 = "General AC: ".concat(acL.getName()).concat("  could not be converted");
                warning = warning.concat(warning1).concat(" ;  ");
                inverseRule.setErrorMsg(warning);
                failed = true;
            }
            ++i;
        }
        if (!failed) {
            inverseRule.setFormula(r.getFormulaStr());
        }
        return !failed;
    }

    private boolean convertGACsLeft2Right(Rule r, Rule inverseRule, Hashtable<GraphObject, GraphObject> isoRight) {
        boolean failed = false;
        List<OrdinaryMorphism> acs = r.getNestedACsList();
        int i = 0;
        while (i < acs.size() && !failed) {
            NestedApplCond acL = (NestedApplCond)acs.get(i);
            OrdinaryMorphism acR = null;
            Pair<OrdinaryMorphism, OrdinaryMorphism> pairPO = this.convertNestedACLeft2Right(r, acL);
            if (pairPO != null) {
                acR = (OrdinaryMorphism)pairPO.second;
                NestedApplCond ac = new NestedApplCond(inverseRule.getLeft(), acR.getTarget(), AttrTupleManager.getDefaultManager().newContext(0));
                ac.completeDiagram(isoRight, acR);
                this.unsetAllTransientAttrValues(ac);
                ac.setAttrContext(inverseRule.getLeft().getAttrContext());
                this.declareVariable(ac.getTarget(), (VarTuple)inverseRule.getAttrContext().getVariables());
                this.adjustAttributeValueAlongMorphismMapping(ac);
                ac.setName(acL.getName());
                inverseRule.addNestedAC(ac);
                if (!acL.getNestedACs().isEmpty()) {
                    this.convertNestedACsLeft2Right((OrdinaryMorphism)pairPO.first, acL, acR, ac, inverseRule);
                }
            } else {
                String warning = inverseRule.getErrorMsg();
                String warning1 = "General AC: ".concat(acL.getName()).concat("  could not be converted");
                warning = warning.concat(warning1).concat(" ;  ");
                inverseRule.setErrorMsg(warning);
                failed = true;
            }
            ++i;
        }
        if (!failed) {
            inverseRule.setFormula(r.getFormulaStr());
        }
        return !failed;
    }

    private boolean convertNestedACsLeft2Right(OrdinaryMorphism rm, NestedApplCond acL, OrdinaryMorphism acR, NestedApplCond ac, Rule inverseRule) {
        boolean failed = false;
        int i = 0;
        while (i < acL.getNestedACs().size()) {
            NestedApplCond ncL = acL.getNestedACs().get(i);
            Pair<OrdinaryMorphism, OrdinaryMorphism> pairPO = this.convertNestedACLeft2Right(rm, ncL);
            if (pairPO != null) {
                OrdinaryMorphism ncR = (OrdinaryMorphism)pairPO.second;
                NestedApplCond nc = new NestedApplCond(ncR.getSource(), ncR.getTarget(), ncR.getAttrContext());
                nc.getDomainObjects().addAll(ncR.getDomainObjects());
                nc.getCodomainObjects().addAll(ncR.getCodomainObjects());
                this.unsetAllTransientAttrValues(nc);
                nc.getTarget().setAttrContext(nc.getAttrContext());
                this.declareVariable(nc.getTarget(), (VarTuple)ncL.getAttrContext().getVariables());
                this.adjustAttributeValueAlongMorphismMapping(nc);
                nc.setName(ncL.getName());
                ac.addNestedAC(nc);
                if (!ncL.getNestedACs().isEmpty()) {
                    this.convertNestedACsLeft2Right((OrdinaryMorphism)pairPO.first, ncL, ncR, nc, inverseRule);
                }
            } else {
                String warning = inverseRule.getErrorMsg();
                String warning1 = "Nested AC: ".concat(acL.getName()).concat("  could not be converted");
                warning = warning.concat(warning1).concat(" ;  ");
                inverseRule.setErrorMsg(warning);
                failed = true;
            }
            ++i;
        }
        if (!failed) {
            ac.setFormula(acL.getFormulaStr());
        }
        return !failed;
    }

    public Pair<OrdinaryMorphism, OrdinaryMorphism> convertNestedACLeft2Right(OrdinaryMorphism rm, NestedApplCond ncL) {
        boolean needHelp;
        OrdinaryMorphism ncR = null;
        OrdinaryMorphism extLeft = null;
        OrdinaryMorphism ncL1 = null;
        Pair<OrdinaryMorphism, OrdinaryMorphism> pairPO = null;
        boolean bl = needHelp = !ncL.isTotal();
        if (needHelp) {
            ncL1 = rm.getSource().isomorphicCopy();
            if (ncL1 == null) {
                return null;
            }
            extLeft = this.extendTargetGraph1ByTargetGraph2(ncL1, ncL);
            if (extLeft == null) {
                ncL1.dispose();
                return null;
            }
            if (ncL1.isTotal()) {
                if (rm instanceof Rule) {
                    if (this.isDanglingSatisfied(ncL1, rm)) {
                        pairPO = this.makePO(rm, ncL1, true, false);
                    }
                } else {
                    pairPO = this.makePO(rm, ncL1, true, false);
                }
            }
        } else if (rm instanceof Rule) {
            if (this.isDanglingSatisfied(ncL, rm)) {
                pairPO = this.makePO(rm, ncL, true, false);
            }
        } else {
            pairPO = this.makePO(rm, ncL, true, false);
        }
        if (pairPO != null) {
            OrdinaryMorphism rStar = null;
            if (needHelp) {
                ncR = (OrdinaryMorphism)pairPO.second;
                rStar = extLeft.compose((OrdinaryMorphism)pairPO.first);
                if (rStar != null && this.filterObjectsOfRightCondition(rm, ncL, ncR)) {
                    return new Pair<OrdinaryMorphism, OrdinaryMorphism>(rStar, ncR);
                }
            } else {
                return pairPO;
            }
        }
        return null;
    }

    private boolean convertPACsLeft2Right(Rule r, Rule inverseRule, Hashtable<GraphObject, GraphObject> isoRight) {
        List<OrdinaryMorphism> acs = r.getPACsList();
        int i = 0;
        while (i < acs.size()) {
            OrdinaryMorphism ac;
            OrdinaryMorphism acL = acs.get(i);
            OrdinaryMorphism acR = null;
            if (r.isACShiftPossible(acL)) {
                int tglevelcheck = r.getTypeSet().getLevelOfTypeGraphCheck();
                r.getTypeSet().setLevelOfTypeGraph(10);
                acR = this.convertACLeft2Right(r, acL);
                r.getTypeSet().setLevelOfTypeGraph(tglevelcheck);
                Collection<TypeError> error = r.getTypeSet().checkType(acR.getTarget());
                if (error != null && !error.isEmpty()) {
                    acR.dispose(false, true);
                    acR = null;
                }
            }
            boolean ok = false;
            if (!(acR == null || !(ok = (ac = BaseFactory.theFactory().createMorphism(inverseRule.getLeft(), acR.getTarget())).completeDiagram(isoRight, acR)) || ac.isRightTotal() && ac.doesIgnoreAttrs())) {
                this.unsetAllTransientAttrValues(ac);
                ac.setAttrContext(inverseRule.getLeft().getAttrContext());
                this.declareVariable(ac.getTarget(), (VarTuple)inverseRule.getAttrContext().getVariables());
                this.adjustAttributeValueAlongMorphismMapping(ac);
                ac.setEnabled(acL.isEnabled());
                ac.setName(acR.getName());
                inverseRule.addPAC(ac);
            }
            if (!ok) {
                String warning = inverseRule.getErrorMsg();
                String warning1 = "AC: ".concat(acL.getName()).concat("  could not be converted");
                warning = warning.concat(warning1).concat(" ;  ");
                inverseRule.setErrorMsg(warning);
                return false;
            }
            ++i;
        }
        return true;
    }

    public void adjustAttributeValueAlongMorphismMapping(OrdinaryMorphism morph) {
        Enumeration<GraphObject> dom = morph.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject img;
            GraphObject obj = dom.nextElement();
            if (obj.getAttribute() == null || (img = morph.getImage(obj)).getAttribute() == null) continue;
            ValueTuple vt_obj = (ValueTuple)obj.getAttribute();
            ValueTuple vt_img = (ValueTuple)img.getAttribute();
            int i = 0;
            while (i < vt_obj.getNumberOfEntries()) {
                ValueMember vm_obj = vt_obj.getValueMemberAt(i);
                ValueMember vm_img = vt_img.getValueMemberAt(vm_obj.getName());
                if (vm_obj.isSet() && vm_img != null && vm_img.isSet() && !vm_img.getExprAsText().equals(vm_obj.getExprAsText())) {
                    vm_img.setExprAsText(vm_obj.getExprAsText());
                }
                ++i;
            }
        }
    }

    private OrdinaryMorphism convertACLeft2Right(Rule r, OrdinaryMorphism acL) {
        OrdinaryMorphism isoLHS = r.getLeft().isomorphicCopy();
        if (isoLHS == null) {
            return null;
        }
        OrdinaryMorphism extLeft = this.extendTargetGraph1ByTargetGraph2(isoLHS, acL);
        if (extLeft == null) {
            isoLHS.dispose();
            return null;
        }
        boolean ok = false;
        OrdinaryMorphism acR = null;
        Match m = BaseFactory.theFactory().createMatch(r, extLeft.getTarget(), true, "1");
        m.getTarget().setCompleteGraph(false);
        m.setCompletionStrategy(new Completion_InjCSP(), true);
        if (this.setMappingAlongMorphism(m, isoLHS) && m.isTotal() && this.isDanglingSatisfied(m, r)) {
            try {
                int levelOfTypeGraphCheck = r.getTypeSet().getLevelOfTypeGraphCheck();
                r.getTypeSet().setLevelOfTypeGraph(10);
                acR = (OrdinaryMorphism)TestStep.execute(m, true);
                r.getTypeSet().setLevelOfTypeGraph(levelOfTypeGraphCheck);
                this.adjustVariablesInAttributeOfRightRuleCondition(r, acL, acR);
                ok = this.filterObjectsOfRightCondition(r, acL, acR);
                if (ok) {
                    acR.setName(acL.getName());
                } else {
                    acR.dispose();
                }
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        r.setMatch(null);
        extLeft.dispose();
        isoLHS.dispose();
        return acR;
    }

    public boolean isDanglingSatisfied(OrdinaryMorphism m, OrdinaryMorphism rm) {
        for (Node x : rm.getSource().getNodesSet()) {
            Node y;
            if (rm.getImage(x) != null || (y = (Node)m.getImage(x)) == null || x.getNumberOfArcs() == y.getNumberOfArcs()) continue;
            System.out.println("BF.isDanglingSatisfied::  " + rm.getName() + "  x: " + x + "  !=   y: " + y);
            return false;
        }
        return true;
    }

    private boolean setMappingAlongMorphism(OrdinaryMorphism f, OrdinaryMorphism g) {
        for (Node n : g.getSource().getNodesSet()) {
            Node img = (Node)g.getImage(n);
            if (img == null) continue;
            try {
                if (n.getType().isParentOf(img.getType())) {
                    f.addMapping(n, img);
                    continue;
                }
                if (!n.getType().isChildOf(img.getType())) continue;
                f.addChild2ParentMapping(n, img);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        for (Arc a : g.getSource().getArcsSet()) {
            Arc img = (Arc)g.getImage(a);
            if (img == null) continue;
            try {
                f.addMapping(a, img);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        return true;
    }

    private void adjustVariablesInAttributeOfRightRuleCondition(Rule r, OrdinaryMorphism condL, OrdinaryMorphism condR) {
        Enumeration<GraphObject> nacLCoDom = condL.getCodomain();
        while (nacLCoDom.hasMoreElements()) {
            GraphObject condRObj;
            GraphObject lhsObj;
            GraphObject rhsObj;
            GraphObject condObj = nacLCoDom.nextElement();
            if (condObj.getAttribute() == null || (rhsObj = r.getImage(lhsObj = condL.getInverseImage(condObj).nextElement())) == null || (condRObj = condR.getImage(rhsObj)) == null) continue;
            ValueTuple lhsVal = (ValueTuple)lhsObj.getAttribute();
            ValueTuple condLVal = (ValueTuple)condObj.getAttribute();
            ValueTuple rhsVal = (ValueTuple)rhsObj.getAttribute();
            ValueTuple condRVal = (ValueTuple)condRObj.getAttribute();
            int i = 0;
            while (i < lhsVal.getNumberOfEntries()) {
                ValueMember vm = lhsVal.getEntryAt(i);
                if (vm.isSet()) {
                    ValueMember vmcondL = condLVal.getEntryAt(vm.getName());
                    ValueMember vmcondR = condRVal.getEntryAt(vm.getName());
                    if (vmcondL.isSet()) {
                        ValueMember vmRHS;
                        if (vm.getExprAsText().equals(vmcondL.getExprAsText()) && (vmRHS = rhsVal.getEntryAt(vm.getName())).isSet() && vmcondR != null) {
                            vmcondR.setExprAsText(vmRHS.getExprAsText());
                        }
                    } else if (vmcondR != null && vmcondR.isSet()) {
                        vmcondR.setExpr(null);
                    }
                }
                ++i;
            }
        }
    }

    private boolean filterObjectsOfRightCondition(OrdinaryMorphism r, OrdinaryMorphism condL, OrdinaryMorphism condR) {
        boolean ok = true;
        Iterator<Arc> rhsArcs = r.getTarget().getArcsSet().iterator();
        while (rhsArcs.hasNext() && ok) {
            Arc a = rhsArcs.next();
            Arc aImg = (Arc)condR.getImage(a);
            if (r.getInverseImage(a).hasMoreElements() && condL.getImage(r.getInverseImage(a).nextElement()) != null) continue;
            try {
                condR.getTarget().destroyArc(aImg, false, false);
            }
            catch (TypeException tex) {
                ok = false;
            }
        }
        Iterator<Node> rhsNodes = r.getTarget().getNodesSet().iterator();
        while (rhsNodes.hasNext() && ok) {
            Node n = rhsNodes.next();
            Node nImg = (Node)condR.getImage(n);
            if (r.getInverseImage(n).hasMoreElements() && condL.getImage(r.getInverseImage(n).nextElement()) != null) continue;
            try {
                condR.getTarget().destroyNode(nImg, false, false);
            }
            catch (TypeException tex) {
                ok = false;
            }
        }
        return ok;
    }

    protected boolean convertPACsLeft2Right(Rule r, Rule inverseRule, OrdinaryMorphism isoRHS) {
        List<OrdinaryMorphism> pacs = r.getPACsList();
        int i = 0;
        while (i < pacs.size()) {
            OrdinaryMorphism ac;
            OrdinaryMorphism acL = pacs.get(i);
            OrdinaryMorphism acR = null;
            if (r.isACShiftPossible(acL)) {
                int tglevelcheck = r.getTypeSet().getLevelOfTypeGraphCheck();
                r.getTypeSet().setLevelOfTypeGraph(10);
                acR = this.convertACLeft2Right(r, acL);
                r.getTypeSet().setLevelOfTypeGraph(tglevelcheck);
                Collection<TypeError> error = r.getTypeSet().checkType(acR.getTarget());
                if (error != null && !error.isEmpty()) {
                    acR.dispose(false, true);
                    acR = null;
                }
            }
            boolean ok = false;
            if (!(acR == null || !(ok = acR.completeDiagram(isoRHS, ac = BaseFactory.theFactory().createMorphism(inverseRule.getLeft(), acR.getTarget()))) || ac.isRightTotal() && ac.doesIgnoreAttrs())) {
                this.unsetAllTransientAttrValues(ac);
                ac.setAttrContext(inverseRule.getLeft().getAttrContext());
                this.declareVariable(ac.getTarget(), (VarTuple)inverseRule.getAttrContext().getVariables());
                this.adjustAttributeValueAlongMorphismMapping(ac);
                ac.setEnabled(acL.isEnabled());
                ac.setName(acR.getName());
                inverseRule.addPAC(ac);
            }
            if (!ok) {
                String warning = inverseRule.getErrorMsg();
                String warning1 = "PAC: ".concat(acL.getName()).concat("  could not be converted");
                warning = warning.concat(warning1).concat(" ;  ");
                inverseRule.setErrorMsg(warning);
                return false;
            }
            ++i;
        }
        return true;
    }

    private void adjustAttributesFromTo(GraphObject from, GraphObject to) {
        if (to != null && from.getAttribute() != null && to.getAttribute() != null) {
            ValueTuple vt_from = (ValueTuple)from.getAttribute();
            ValueTuple vt_to = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < vt_from.getNumberOfEntries()) {
                ValueMember vm = vt_from.getValueMemberAt(i);
                ValueMember vm_to = vt_to.getValueMemberAt(vm.getName());
                if (vm.isSet() && vm_to != null) {
                    vm_to.setExprAsText(vm.getExprAsText());
                    vm_to.setTransient(vm.isTransient());
                }
                ++i;
            }
        }
    }

    private void setEmptyAttrsByDummyHC(GraphObject go) {
        if (go != null && go.getAttribute() != null) {
            ValueTuple vt = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(i);
                if (!vm.isSet()) {
                    vm.setExprAsText(String.valueOf(vm.hashCode()));
                    vm.setTransient(true);
                }
                ++i;
            }
        }
    }

    public Pair<OrdinaryMorphism, OrdinaryMorphism> extendLeftGraphByNAC(Rule r, OrdinaryMorphism nac) {
        OrdinaryMorphism L2L_NAC = r.getLeft().isomorphicCopy();
        if (L2L_NAC == null) {
            return null;
        }
        OrdinaryMorphism NAC2L_NAC = this.extendTargetGraph1ByTargetGraph2(L2L_NAC, nac);
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(L2L_NAC, NAC2L_NAC);
    }

    public OrdinaryMorphism extendTargetGraph1ByTargetGraph2(OrdinaryMorphism morph1, OrdinaryMorphism morph2) {
        if (morph1 == null || morph2 == null) {
            return null;
        }
        Graph extLeft = morph1.getTarget();
        OrdinaryMorphism morph = BaseFactory.theFactory().createMorphism(morph2.getTarget(), extLeft);
        ((ContextView)morph.getAttrContext()).changeAllowedMapping(1);
        Hashtable<Node, Node> tmp = new Hashtable<Node, Node>(5);
        for (GraphObject graphObject : morph2.getTarget().getNodesSet()) {
            Node n;
            if (!morph2.getInverseImage(graphObject).hasMoreElements()) {
                try {
                    n = extLeft.copyNode((Node)graphObject);
                    this.setEmptyAttrsByDummyHC(n);
                    n.setContextUsage(graphObject.hashCode());
                    tmp.put((Node)graphObject, n);
                    try {
                        morph.addPlainMapping(graphObject, n);
                    }
                    catch (BadMappingException exc) {
                        System.out.println("BF.extendTargetGraph1ByTargetGraph2:  copyNode: " + exc.getLocalizedMessage());
                    }
                }
                catch (TypeException ex) {
                    System.out.println(ex.getLocalizedMessage());
                }
                continue;
            }
            if (morph1.getImage(morph2.getInverseImage(graphObject).nextElement()) == null) continue;
            n = (Node)morph1.getImage(morph2.getInverseImage(graphObject).nextElement());
            n.setContextUsage(graphObject.hashCode());
            n.setObjectName(graphObject.getObjectName());
            this.adjustAttributesFromTo(graphObject, n);
            this.setEmptyAttrsByDummyHC(n);
            try {
                if (graphObject.getType().isParentOf(n.getType())) {
                    morph.addMapping(graphObject, n);
                    continue;
                }
                if (!graphObject.getType().isChildOf(n.getType())) continue;
                morph.addChild2ParentMapping(graphObject, n);
            }
            catch (BadMappingException exc) {
                System.out.println("BF.extendTargetGraph1ByTargetGraph2:  " + exc.getLocalizedMessage());
            }
        }
        for (GraphObject graphObject : morph2.getTarget().getArcsSet()) {
            if (!morph2.getInverseImage(graphObject).hasMoreElements()) {
                Node tar;
                Node src = (Node)tmp.get(((Arc)graphObject).getSource());
                if (src == null) {
                    src = (Node)morph1.getImage(morph2.getInverseImage(((Arc)graphObject).getSource()).nextElement());
                }
                if ((tar = (Node)tmp.get(((Arc)graphObject).getTarget())) == null) {
                    tar = (Node)morph1.getImage(morph2.getInverseImage(((Arc)graphObject).getTarget()).nextElement());
                }
                try {
                    Arc a = extLeft.copyArc((Arc)graphObject, src, tar);
                    this.setEmptyAttrsByDummyHC(a);
                    a.setContextUsage(graphObject.hashCode());
                    try {
                        morph.addPlainMapping(graphObject, a);
                    }
                    catch (BadMappingException exc) {
                        System.out.println("BF.extendTargetGraph1ByTargetGraph2:  copyArc: " + exc.getLocalizedMessage());
                    }
                }
                catch (TypeException typeException) {}
                continue;
            }
            if (morph1.getImage(morph2.getInverseImage(graphObject).nextElement()) == null) continue;
            Arc a = (Arc)morph1.getImage(morph2.getInverseImage(graphObject).nextElement());
            a.setContextUsage(graphObject.hashCode());
            a.setObjectName(graphObject.getObjectName());
            this.adjustAttributesFromTo(graphObject, a);
            this.setEmptyAttrsByDummyHC(a);
            try {
                morph.addMapping(graphObject, morph1.getImage(morph2.getInverseImage(graphObject).nextElement()));
            }
            catch (BadMappingException exc) {
                System.out.println("BF.extendTargetGraph1ByTargetGraph2: " + exc.getLocalizedMessage());
            }
        }
        this.replaceParentByChild(morph, morph1);
        return morph;
    }

    public void unsetTransientAttrValue(VarTuple vars, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject obj = (GraphObject)elems.next();
            if (obj.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < value.getNumberOfEntries()) {
                ValueMember valuem = value.getValueMemberAt(i);
                if (valuem.getExpr() != null && valuem.isTransient()) {
                    String tmpname;
                    if (valuem.getExpr().isVariable() && vars.getMemberAt(tmpname = valuem.getExprAsText()) != null) {
                        vars.getTupleType().deleteMemberAt(tmpname);
                    }
                    valuem.setExpr(null);
                    valuem.setTransient(false);
                }
                ++i;
            }
        }
    }

    public void unsetAllTransientAttrValues(OrdinaryMorphism morph) {
        VarTuple vars = (VarTuple)morph.getAttrContext().getVariables();
        if (morph.getSource().isAttributed()) {
            Iterator<GraphObject> elems = morph.getSource().getNodesSet().iterator();
            this.unsetTransientAttrValue(vars, elems);
            elems = morph.getSource().getArcsSet().iterator();
            this.unsetTransientAttrValue(vars, elems);
        }
        if (morph.getTarget().isAttributed()) {
            Iterator<GraphObject> elems1 = morph.getTarget().getNodesSet().iterator();
            this.unsetTransientAttrValue(vars, elems1);
            elems1 = morph.getTarget().getArcsSet().iterator();
            this.unsetTransientAttrValue(vars, elems1);
        }
    }

    public void unsetAllTransientAttrValuesOfRule(Rule r) {
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        this.unsetAllTransientAttrValues(r);
        List<OrdinaryMorphism> nacs = r.getNACsList();
        int j = 0;
        while (j < nacs.size()) {
            OrdinaryMorphism nac = nacs.get(j);
            if (nac.getTarget().isAttributed()) {
                Iterator<GraphObject> e1 = nac.getTarget().getNodesSet().iterator();
                this.unsetTransientAttrValue(vars, e1);
                e1 = nac.getTarget().getArcsSet().iterator();
                this.unsetTransientAttrValue(vars, e1);
            }
            ++j;
        }
        List<OrdinaryMorphism> pacs = r.getPACsList();
        int j2 = 0;
        while (j2 < pacs.size()) {
            OrdinaryMorphism pac = pacs.get(j2);
            if (pac.getTarget().isAttributed()) {
                Iterator<GraphObject> e1 = pac.getTarget().getNodesSet().iterator();
                this.unsetTransientAttrValue(vars, e1);
                e1 = pac.getTarget().getArcsSet().iterator();
                this.unsetTransientAttrValue(vars, e1);
            }
            ++j2;
        }
    }

    public Graph cloneGraph(Graph graph) {
        return graph.copy();
    }

    private KernelRule copyKernelRule(Rule rule, TypeSet types, Hashtable<GraphObject, GraphObject> table) {
        KernelRule kr = new KernelRule(types);
        this.copyRule(rule, kr, table, true);
        kr.setName(rule.getName());
        return kr;
    }

    public RuleScheme cloneRuleScheme(RuleScheme ruleScheme) {
        return this.cloneRuleScheme(ruleScheme, ruleScheme.getKernelRule().getTypeSet());
    }

    public RuleScheme cloneRuleScheme(RuleScheme ruleScheme, TypeSet types) {
        Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
        RuleScheme rs = new RuleScheme(ruleScheme.getName(), this.copyKernelRule(ruleScheme.getKernelRule(), types, table));
        int i = 0;
        while (i < ruleScheme.getMultiRules().size()) {
            MultiRule mr = (MultiRule)ruleScheme.getMultiRules().get(i);
            MultiRule mrule = rs.createMultiRule(mr.getName());
            this.copyMultiRule(mr, mrule, table);
            ++i;
        }
        rs.setLayer(ruleScheme.getLayer());
        rs.setPriority(ruleScheme.getPriority());
        rs.setParallelKernelMatch(ruleScheme.parallelKernelMatch());
        rs.setCheckDeleteUseConflictRequired(ruleScheme.checkDeleteUseConflictRequired());
        rs.setDisjointMultiMatches(ruleScheme.disjointMultiMatches());
        rs.setAtLeastOneMultiMatchRequired(ruleScheme.atLeastOneMultiMatchRequired());
        table.clear();
        return rs;
    }

    public RuleScheme makeRuleScheme(Rule r) {
        KernelRule kr = new KernelRule(r.getTypeSet());
        if (this.cloneRule(r, kr)) {
            kr.setName(r.getName());
            RuleScheme rs = new RuleScheme(String.valueOf(kr.getName()) + "_RS", kr);
            rs.setLayer(r.getLayer());
            rs.setPriority(r.getPriority());
            return rs;
        }
        kr.dispose(true, true);
        return null;
    }

    private KernelRule reverseKernelRule(KernelRule kern, Hashtable<GraphObject, GraphObject> table) {
        KernelRule invKern = new KernelRule(kern.getTypeSet());
        this.reverseMorphismInto(kern, invKern, table);
        this.reflectInputParameter(kern, invKern);
        if (this.convertPACsLeft2Right((Rule)kern, (Rule)invKern, table)) {
            this.convertNACsLeft2Right((Rule)kern, (Rule)invKern, table);
            this.convertGACsLeft2Right(kern, invKern, table);
            this.convertAttrConditionLeft2Right(kern, invKern);
            invKern.setName(kern.getName());
            return invKern;
        }
        invKern = null;
        return null;
    }

    public RuleScheme reverseRuleScheme(RuleScheme ruleScheme) {
        Hashtable<GraphObject, GraphObject> kernTable = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
        KernelRule invKern = this.reverseKernelRule((KernelRule)ruleScheme.getKernelRule(), kernTable);
        if (invKern != null) {
            RuleScheme rs = new RuleScheme(ruleScheme.getName().concat("_INV"), invKern);
            if (!"".equals(invKern.getErrorMsg())) {
                rs.setErrorMsg(invKern.getErrorMsg());
            }
            if (!invKern.isReadyToTransform()) {
                System.out.println(String.valueOf(this.getClass().getName()) + "    " + invKern.getName() + "  ::  " + invKern.getErrorMsg());
            }
            int i = 0;
            while (i < ruleScheme.getMultiRules().size()) {
                table.putAll(kernTable);
                MultiRule multi = (MultiRule)ruleScheme.getMultiRules().get(i);
                MultiRule invMulti = rs.createMultiRule(multi.getName());
                if (this.reverseMultiRule(multi, invMulti, table)) {
                    invMulti.setName(multi.getName());
                    if (!"".equals(invMulti.getErrorMsg())) {
                        rs.setErrorMsg(rs.getErrorMsg().concat(" ;  ").concat(invMulti.getErrorMsg()));
                    }
                    if (!invMulti.isReadyToTransform()) {
                        System.out.println(String.valueOf(this.getClass().getName()) + "    " + invMulti.getName() + "  ::  " + invMulti.getErrorMsg());
                    }
                } else {
                    ruleScheme.getMultiRules().remove(i);
                    --i;
                    invMulti = null;
                }
                table.clear();
                ++i;
            }
            rs.setLayer(ruleScheme.getLayer());
            rs.setPriority(ruleScheme.getPriority());
            rs.setParallelKernelMatch(ruleScheme.parallelKernelMatch());
            rs.setCheckDeleteUseConflictRequired(ruleScheme.checkDeleteUseConflictRequired());
            rs.setDisjointMultiMatches(ruleScheme.disjointMultiMatches());
            rs.setAtLeastOneMultiMatchRequired(ruleScheme.atLeastOneMultiMatchRequired());
            kernTable.clear();
            kernTable = null;
            table = null;
            return rs;
        }
        kernTable.clear();
        kernTable = null;
        table.clear();
        table = null;
        return null;
    }

    public Rule makeMinimalOfRule(Rule r) {
        Rule minRule = new Rule(r.getOriginal().getTypeSet());
        Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
        this.copyRule(r, minRule, table, false);
        minRule.setLayer(r.getLayer());
        minRule.setPriority(r.getPriority());
        table.clear();
        this.removePreservedUnchangedObjs(minRule);
        return minRule;
    }

    public boolean removePreservedUnchangedObjs(Rule r) {
        GraphObject img;
        GraphObject obj;
        GraphObject img2;
        boolean removed = false;
        Vector<GraphObject> del = new Vector<GraphObject>();
        Enumeration<GraphObject> dom = r.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj2 = dom.nextElement();
            img2 = r.getImage(obj2);
            if (!obj2.isArc() || (obj2.getAttribute() != null || img2.getAttribute() != null) && (obj2.getAttribute() == null || img2.getAttribute() == null || !obj2.getAttribute().compareTo(img2.getAttribute()))) continue;
            del.add(obj2);
            del.add(img2);
        }
        int i = 0;
        while (i < del.size() - 1) {
            obj = (GraphObject)del.get(i);
            img = (GraphObject)del.get(i + 1);
            if (obj.isArc()) {
                r.removeMapping((Arc)obj, (Arc)img);
                try {
                    r.getLeft().destroyArc((Arc)obj);
                    r.getRight().destroyArc((Arc)img);
                    removed = true;
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            i += 2;
        }
        del.clear();
        dom = r.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj3 = dom.nextElement();
            img2 = r.getImage(obj3);
            if (!obj3.isNode() || ((Node)obj3).getNumberOfArcs() != 0 || ((Node)img2).getNumberOfArcs() != 0 || (obj3.getAttribute() != null || img2.getAttribute() != null) && (obj3.getAttribute() == null || img2.getAttribute() == null || !obj3.getAttribute().compareTo(img2.getAttribute()))) continue;
            del.add(obj3);
            del.add(img2);
        }
        i = 0;
        while (i < del.size() - 1) {
            obj = (GraphObject)del.get(i);
            img = (GraphObject)del.get(i + 1);
            if (obj.isNode()) {
                r.removeMapping((Node)obj, (Node)img);
                try {
                    r.getLeft().destroyNode((Node)obj);
                    r.getRight().destroyNode((Node)img);
                    removed = true;
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            i += 2;
        }
        return removed;
    }

    public Rule cloneRule(Rule rule) {
        Rule ruleClone = new Rule(rule.getOriginal().getTypeSet());
        Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
        this.copyRule(rule, ruleClone, table, true);
        ruleClone.setLayer(rule.getLayer());
        ruleClone.setPriority(rule.getPriority());
        table.clear();
        return ruleClone;
    }

    public boolean cloneRule(Rule from, Rule to) {
        Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
        this.copyRule(from, to, table, true);
        table.clear();
        return true;
    }

    public Rule cloneRule(Rule rule, TypeSet types, boolean withApplConds) {
        Rule ruleClone = new Rule(types);
        Hashtable ltable = new Hashtable();
        Hashtable rtable = new Hashtable();
        Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
        this.copyRule(rule, ruleClone, table, withApplConds);
        ruleClone.setLayer(rule.getLayer());
        ruleClone.setPriority(rule.getPriority());
        ltable.clear();
        rtable.clear();
        return ruleClone;
    }

    private Rule copyRule(Rule rule, Rule ruleClone, Hashtable<GraphObject, GraphObject> table, boolean withApplConds) {
        ruleClone.setName(rule.getName());
        this.copyAttrContextFromTo(rule.getAttrContext(), ruleClone.getAttrContext());
        this.copyGraph(rule.getLeft(), ruleClone.getLeft(), table);
        this.copyGraph(rule.getRight(), ruleClone.getRight(), table);
        this.copyMorph(rule, ruleClone, table);
        if (withApplConds) {
            OrdinaryMorphism acClone;
            OrdinaryMorphism ac;
            int i = 0;
            while (i < rule.getNestedACsList().size()) {
                ac = (NestedApplCond)rule.getNestedACsList().get(i);
                acClone = ruleClone.createNestedAC();
                acClone.getImage().setName(ac.getImage().getName());
                ((NestedApplCond)acClone).setName(((NestedApplCond)ac).getName());
                this.copyGraph(ac.getImage(), acClone.getImage(), table);
                this.copyMorph(ac, acClone, table);
                this.copyNestedAC((NestedApplCond)ac, (NestedApplCond)acClone, table);
                ++i;
            }
            ruleClone.setFormula(rule.getFormulaStr());
            i = 0;
            while (i < rule.getNACsList().size()) {
                ac = rule.getNACsList().get(i);
                acClone = ruleClone.createNAC();
                acClone.getImage().setName(ac.getImage().getName());
                acClone.setName(ac.getName());
                this.copyGraph(ac.getImage(), acClone.getImage(), table);
                this.copyMorph(ac, acClone, table);
                ++i;
            }
            i = 0;
            while (i < rule.getPACsList().size()) {
                ac = rule.getPACsList().get(i);
                acClone = ruleClone.createPAC();
                acClone.getImage().setName(ac.getImage().getName());
                acClone.setName(ac.getName());
                this.copyGraph(ac.getImage(), acClone.getImage(), table);
                this.copyMorph(ac, acClone, table);
                ++i;
            }
        }
        return ruleClone;
    }

    public void copyGraph(Graph from, Graph to, Hashtable<GraphObject, GraphObject> table) {
        for (Node bn1 : from.getNodesSet()) {
            Node bn2 = null;
            try {
                bn2 = to.copyNode(bn1);
                bn2.setContextUsage(bn1.getContextUsage());
                table.put(bn1, bn2);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        for (Arc ba1 : from.getArcsSet()) {
            Node src = (Node)table.get(ba1.getSource());
            Node tar = (Node)table.get(ba1.getTarget());
            Arc ba2 = null;
            try {
                ba2 = to.copyArc(ba1, src, tar);
                ba2.setContextUsage(ba1.getContextUsage());
                table.put(ba1, ba2);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
    }

    public void copyMorph(OrdinaryMorphism from, OrdinaryMorphism to, Hashtable<GraphObject, GraphObject> table) {
        for (GraphObject lgo : from.getDomainObjects()) {
            GraphObject rgo = from.getImage(lgo);
            GraphObject lgo1 = table.get(lgo);
            GraphObject rgo1 = table.get(rgo);
            try {
                to.addMapping(lgo1, rgo1);
            }
            catch (BadMappingException e) {
                e.printStackTrace();
            }
        }
    }

    public AtomConstraint cloneAtomConstraint(AtomConstraint ac, TypeSet types) {
        Hashtable<GraphObject, GraphObject> commonTable = new Hashtable<GraphObject, GraphObject>();
        Graph g1 = BaseFactory.theFactory().createGraph(types);
        g1.setKind("PREMISE");
        Graph g2 = BaseFactory.theFactory().createGraph(types);
        g2.setKind("CONCLUSION");
        AtomConstraint atom = new AtomConstraint(g1, g2, AttrTupleManager.getDefaultManager().newContext(0), ac.getAtomicName());
        this.copyAttrContextFromTo(ac.getConclusion(0).getAttrContext(), atom.getConclusion(0).getAttrContext());
        this.copyGraph(ac.getSource(), g1, commonTable);
        this.copyGraph(ac.getConclusion(0).getTarget(), g2, commonTable);
        this.copyMorph(ac.getConclusion(0), atom.getConclusion(0), commonTable);
        atom.getConclusion(0).setName(ac.getConclusion(0).getName());
        int i = 1;
        while (i < ac.getConclusionsSize()) {
            AtomConstraint from = ac.getConclusion(i);
            Graph g = BaseFactory.theFactory().createGraph(types);
            g.setKind("CONCLUSION");
            AtomConstraint to = atom.createNextConclusion(g);
            to.setName(from.getName());
            this.copyAttrContextFromTo(from.getAttrContext(), to.getAttrContext());
            this.copyGraph(from.getTarget(), g, commonTable);
            this.copyMorph(from, to, commonTable);
            ++i;
        }
        return atom;
    }

    public void copyNestedAC(NestedApplCond from, NestedApplCond to, Hashtable<GraphObject, GraphObject> table) {
        int i = 0;
        while (i < from.getNestedACs().size()) {
            NestedApplCond ac = from.getNestedACs().get(i);
            NestedApplCond acClone = to.createNestedAC();
            acClone.getImage().setName(ac.getImage().getName());
            acClone.setName(ac.getName());
            this.copyGraph(ac.getImage(), acClone.getImage(), table);
            this.copyMorph(ac, acClone, table);
            this.copyNestedAC(ac, acClone, table);
            ++i;
        }
        to.setFormula(from.getFormulaStr());
    }

    private MultiRule copyMultiRule(MultiRule rule, MultiRule ruleClone, Hashtable<GraphObject, GraphObject> table) {
        ruleClone.setName(rule.getName());
        this.copyAttrContextFromTo(rule.getAttrContext(), ruleClone.getAttrContext());
        Graph lgraph = rule.getLeft();
        Graph rgraph = rule.getRight();
        Graph left = ruleClone.getLeft();
        Graph right = ruleClone.getRight();
        for (Node rNode : rgraph.getNodesSet()) {
            Node itsRNode = null;
            if (!rule.isTargetOfEmbeddingRight(rNode)) {
                try {
                    itsRNode = right.copyNode(rNode);
                    table.put(rNode, itsRNode);
                }
                catch (TypeException e) {
                    e.getLocalizedMessage();
                }
                continue;
            }
            Node n = (Node)table.get(rule.getEmbeddingRight().getInverseImage(rNode).nextElement());
            itsRNode = (Node)ruleClone.getEmbeddingRight().getImage(n);
            table.put(rNode, itsRNode);
        }
        for (Node lNode : lgraph.getNodesSet()) {
            Node itsLNode = null;
            if (!rule.isTargetOfEmbeddingLeft(lNode)) {
                try {
                    itsLNode = left.copyNode(lNode);
                    table.put(lNode, itsLNode);
                }
                catch (TypeException e) {
                    e.getLocalizedMessage();
                }
                GraphObject rn = rule.getImage(lNode);
                if (rn == null) continue;
                try {
                    ruleClone.addMapping(itsLNode, table.get(rn));
                }
                catch (BadMappingException ex) {
                    System.out.println(ex.getMessage());
                }
                continue;
            }
            Node n = (Node)table.get(rule.getEmbeddingLeft().getInverseImage(lNode).nextElement());
            itsLNode = (Node)ruleClone.getEmbeddingLeft().getImage(n);
            table.put(lNode, itsLNode);
        }
        for (Arc rArc : rgraph.getArcsSet()) {
            Arc itsRArc = null;
            if (!rule.isTargetOfEmbeddingRight(rArc)) {
                Node itsRSource = (Node)table.get(rArc.getSource());
                Node itsRTarget = (Node)table.get(rArc.getTarget());
                try {
                    itsRArc = right.copyArc(rArc, itsRSource, itsRTarget);
                    table.put(rArc, itsRArc);
                }
                catch (TypeException e) {
                    e.getLocalizedMessage();
                }
                continue;
            }
            Arc a = (Arc)table.get(rule.getEmbeddingRight().getInverseImage(rArc).nextElement());
            itsRArc = (Arc)ruleClone.getEmbeddingRight().getImage(a);
            table.put(rArc, itsRArc);
        }
        for (Arc lArc : lgraph.getArcsSet()) {
            Arc itsLArc = null;
            if (!rule.isTargetOfEmbeddingLeft(lArc)) {
                Node itsLSource = (Node)table.get(lArc.getSource());
                Node itsLTarget = (Node)table.get(lArc.getTarget());
                try {
                    itsLArc = left.copyArc(lArc, itsLSource, itsLTarget);
                    table.put(lArc, itsLArc);
                }
                catch (TypeException e) {
                    e.getLocalizedMessage();
                }
                GraphObject ra = rule.getImage(lArc);
                if (ra == null) continue;
                try {
                    ruleClone.addMapping(itsLArc, table.get(ra));
                }
                catch (BadMappingException ex) {
                    System.out.println(ex.getMessage());
                }
                continue;
            }
            Arc a = (Arc)table.get(rule.getEmbeddingLeft().getInverseImage(lArc).nextElement());
            itsLArc = (Arc)ruleClone.getEmbeddingLeft().getImage(a);
            table.put(lArc, itsLArc);
        }
        int i = 0;
        while (i < rule.getNestedACsList().size()) {
            NestedApplCond ac = (NestedApplCond)rule.getNestedACsList().get(i);
            NestedApplCond acClone = ruleClone.createNestedAC();
            acClone.getImage().setName(ac.getImage().getName());
            acClone.setName(ac.getName());
            this.copyGraph(ac.getImage(), acClone.getImage(), table);
            this.copyMorph(ac, acClone, table);
            this.copyNestedAC(ac, acClone, table);
            ++i;
        }
        ruleClone.setFormula(rule.getFormulaStr());
        List<OrdinaryMorphism> nacs = rule.getNACsList();
        int i2 = 0;
        while (i2 < nacs.size()) {
            OrdinaryMorphism ac = nacs.get(i2);
            OrdinaryMorphism acClone = ruleClone.createNAC();
            acClone.getImage().setName(ac.getImage().getName());
            acClone.setName(ac.getName());
            this.copyGraph(ac.getImage(), acClone.getImage(), table);
            this.copyMorph(ac, acClone, table);
            ++i2;
        }
        List<OrdinaryMorphism> pacs = rule.getPACsList();
        int i3 = 0;
        while (i3 < pacs.size()) {
            OrdinaryMorphism ac = pacs.get(i3);
            OrdinaryMorphism acClone = ruleClone.createPAC();
            acClone.getImage().setName(ac.getImage().getName());
            acClone.setName(ac.getName());
            this.copyGraph(ac.getImage(), acClone.getImage(), table);
            this.copyMorph(ac, acClone, table);
            ++i3;
        }
        return ruleClone;
    }

    private boolean reverseMultiRule(MultiRule rule, MultiRule invRule, Hashtable<GraphObject, GraphObject> table) {
        this.copyAttrContextFromTo(rule.getAttrContext(), invRule.getAttrContext());
        Graph left = rule.getLeft();
        Graph right = rule.getRight();
        Graph invLeft = invRule.getLeft();
        Graph invRight = invRule.getRight();
        for (Node lNode : left.getNodesSet()) {
            Node invRNode = null;
            if (!rule.isTargetOfEmbeddingLeft(lNode)) {
                try {
                    invRNode = invRight.copyNode(lNode);
                    table.put(lNode, invRNode);
                }
                catch (TypeException e) {
                    e.getLocalizedMessage();
                }
                continue;
            }
            Node n = (Node)table.get(rule.getEmbeddingLeft().getInverseImage(lNode).nextElement());
            invRNode = (Node)invRule.getEmbeddingRight().getImage(n);
            table.put(lNode, invRNode);
        }
        for (Node rNode : right.getNodesSet()) {
            Node invLNode = null;
            if (!rule.isTargetOfEmbeddingRight(rNode)) {
                try {
                    invLNode = invLeft.copyNode(rNode);
                    table.put(rNode, invLNode);
                }
                catch (TypeException e) {
                    e.getLocalizedMessage();
                }
                Enumeration<GraphObject> en = rule.getInverseImage(rNode);
                if (!en.hasMoreElements()) continue;
                GraphObject ln = en.nextElement();
                try {
                    invRule.addMapping(invLNode, table.get(ln));
                }
                catch (BadMappingException ex) {
                    System.out.println(ex.getMessage());
                }
                continue;
            }
            Node n = (Node)table.get(rule.getEmbeddingRight().getInverseImage(rNode).nextElement());
            invLNode = (Node)invRule.getEmbeddingLeft().getImage(n);
            table.put(rNode, invLNode);
        }
        for (Arc lArc : left.getArcsSet()) {
            Arc invRArc = null;
            if (!rule.isTargetOfEmbeddingLeft(lArc)) {
                Node itsRSource = (Node)table.get(lArc.getSource());
                Node itsRTarget = (Node)table.get(lArc.getTarget());
                try {
                    if (itsRSource == null || itsRTarget == null) continue;
                    invRArc = invRight.copyArc(lArc, itsRSource, itsRTarget);
                    table.put(lArc, invRArc);
                }
                catch (TypeException e) {
                    System.out.println(e.getLocalizedMessage());
                }
                continue;
            }
            Arc a = (Arc)table.get(rule.getEmbeddingLeft().getInverseImage(lArc).nextElement());
            invRArc = (Arc)invRule.getEmbeddingRight().getImage(a);
            table.put(lArc, invRArc);
        }
        for (Arc rArc : right.getArcsSet()) {
            Arc invLArc = null;
            if (!rule.isTargetOfEmbeddingRight(rArc)) {
                Node itsLSource = (Node)table.get(rArc.getSource());
                Node itsLTarget = (Node)table.get(rArc.getTarget());
                try {
                    invLArc = invLeft.copyArc(rArc, itsLSource, itsLTarget);
                    table.put(rArc, invLArc);
                }
                catch (TypeException e) {
                    e.getLocalizedMessage();
                }
                Enumeration<GraphObject> en = rule.getInverseImage(rArc);
                if (!en.hasMoreElements()) continue;
                GraphObject la = en.nextElement();
                try {
                    invRule.addMapping(invLArc, table.get(la));
                }
                catch (BadMappingException ex) {
                    System.out.println(ex.getMessage());
                }
                continue;
            }
            Arc a = (Arc)table.get(rule.getEmbeddingRight().getInverseImage(rArc).nextElement());
            invLArc = (Arc)invRule.getEmbeddingLeft().getImage(a);
            table.put(rArc, invLArc);
        }
        boolean ok = true;
        if (this.convertPACsLeft2Right((Rule)rule, (Rule)invRule, table)) {
            this.convertNACsLeft2Right((Rule)rule, (Rule)invRule, table);
            this.convertGACsLeft2Right(rule, invRule, table);
            this.convertAttrConditionLeft2Right(rule, invRule);
        } else {
            ok = false;
        }
        return ok;
    }

    private void copyAttrContextFromTo(AttrContext from, AttrContext to) {
        VarTuple avt = (VarTuple)to.getVariables();
        VarTuple avtOther = (VarTuple)from.getVariables();
        int i = 0;
        while (i < avtOther.getSize()) {
            VarMember varOther = avtOther.getVarMemberAt(i);
            VarMember var = avt.getVarMemberAt(varOther.getName());
            if (var == null) {
                avt.declare(DefaultInformationFacade.self().getJavaHandler(), varOther.getDeclaration().getTypeName(), varOther.getDeclaration().getName());
                var = avt.getVarMemberAt(varOther.getName());
            }
            if (var != null) {
                var.setMark(varOther.getMark());
                var.setInputParameter(varOther.isInputParameter());
            }
            ++i;
        }
        CondTuple act = (CondTuple)to.getConditions();
        CondTuple actOther = (CondTuple)from.getConditions();
        int i2 = 0;
        while (i2 < actOther.getSize()) {
            CondMember condOther = actOther.getCondMemberAt(i2);
            CondMember cond = (CondMember)act.addCondition(condOther.getExprAsText());
            cond.setMark(condOther.getMark());
            ++i2;
        }
    }

    public OrdinaryMorphism extendGraphByGraph(Graph gToExtend, Graph g) throws Exception {
        OrdinaryMorphism g2extendedg = this.createMorphism(g, gToExtend);
        for (Node elem : g.getNodesSet()) {
            try {
                Node copy = gToExtend.copyNode(elem);
                g2extendedg.addMapping(elem, copy);
            }
            catch (TypeException ex) {
                throw ex;
            }
            catch (BadMappingException e) {
                throw e;
            }
        }
        for (Arc elem : g.getArcsSet()) {
            try {
                Node s = (Node)g2extendedg.getImage(elem.getSource());
                Node t = (Node)g2extendedg.getImage(elem.getTarget());
                Arc copy = gToExtend.copyArc(elem, s, t);
                g2extendedg.addMapping(elem, copy);
            }
            catch (TypeException ex) {
                throw ex;
            }
            catch (BadMappingException e) {
                throw e;
            }
        }
        return g2extendedg;
    }

    public final AtomConstraint createAtomic(TypeSet types, String name) {
        Graph g1 = this.createGraph(types);
        g1.setKind("PREMISE");
        Graph g2 = this.createGraph(types);
        g2.setKind("CONCLUSION");
        return new AtomConstraint(g1, g2, AttrTupleManager.getDefaultManager().newContext(0), name);
    }

    public final OrdinaryMorphism createMorphism(Graph orig, Graph img) {
        AttrContext context = AttrTupleManager.getDefaultManager().newContext(0);
        OrdinaryMorphism output = new OrdinaryMorphism(orig, img, context);
        this.declareVariable(output.getSource(), (VarTuple)output.getAttrContext().getVariables());
        this.declareVariable(output.getTarget(), (VarTuple)output.getAttrContext().getVariables());
        return output;
    }

    public final NestedApplCond createGeneralMorphism(Graph orig, Graph img) {
        AttrContext context = AttrTupleManager.getDefaultManager().newContext(0);
        AttrContext aLeftContext = AttrTupleManager.getDefaultManager().newLeftContext(context);
        AttrContext aRightContext = AttrTupleManager.getDefaultManager().newRightContext(context);
        NestedApplCond output = new NestedApplCond(orig, img, context);
        output.getSource().setAttrContext(aLeftContext);
        output.getTarget().setAttrContext(aRightContext);
        this.declareVariable(output.getSource(), (VarTuple)output.getAttrContext().getVariables());
        this.declareVariable(output.getTarget(), (VarTuple)output.getAttrContext().getVariables());
        return output;
    }

    public final OrdinaryMorphism createMorphism(Graph orig, Graph img, boolean implicit) {
        return this.createMorphism(orig, img, implicit, "");
    }

    public final OrdinaryMorphism createMorphism(Graph orig, Graph img, boolean implicit, String helpMarkOfVars) {
        OrdinaryMorphism m = this.createMorphism(orig, img);
        int count = m.getAttrContext().getVariables().getSize();
        if (implicit) {
            String t;
            ValueMember vm;
            int i;
            ValueTuple values;
            AttrInstance attrs;
            String mark = "_" + helpMarkOfVars;
            for (GraphObject graphObject : img.getNodesSet()) {
                if (graphObject.getAttribute() == null) continue;
                attrs = graphObject.getAttribute();
                values = (ValueTuple)attrs;
                i = 0;
                while (i < values.getNumberOfEntries()) {
                    vm = values.getValueMemberAt(i);
                    if (!vm.isSet()) {
                        t = String.valueOf(vm.getName()) + String.valueOf(count) + mark;
                        vm.setExprAsText(t);
                        vm.setTransient(true);
                        ++count;
                    }
                    ++i;
                }
            }
            for (GraphObject graphObject : img.getArcsSet()) {
                if (graphObject.getAttribute() == null) continue;
                attrs = graphObject.getAttribute();
                values = (ValueTuple)attrs;
                i = 0;
                while (i < values.getNumberOfEntries()) {
                    vm = values.getValueMemberAt(i);
                    if (!vm.isSet()) {
                        t = String.valueOf(vm.getName()) + String.valueOf(count) + mark;
                        vm.setExprAsText(t);
                        vm.setTransient(true);
                        ++count;
                    }
                    ++i;
                }
            }
        }
        return m;
    }

    public VarMember declareVariable(AttrHandler attrHandler, String typeName, String name, VarTuple tuple) {
        VarMember var = tuple.getVarMemberAt(name);
        if (var == null) {
            tuple.declare(attrHandler, typeName, name);
            var = (VarMember)tuple.getEntryAt(name);
        } else if (!var.getDeclaration().getTypeName().equals(typeName)) {
            String name1 = name.concat(String.valueOf(tuple.getNumberOfEntries()));
            tuple.declare(attrHandler, typeName, name1);
            var = tuple.getVarMemberAt(name1);
        }
        return var;
    }

    public void declareVariable(Graph g, VarTuple tuple) {
        ValueMember vm;
        int i;
        ValueTuple values;
        AttrInstance attrs;
        for (GraphObject graphObject : g.getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            attrs = graphObject.getAttribute();
            values = (ValueTuple)attrs;
            i = 0;
            while (i < values.getNumberOfEntries()) {
                vm = values.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), vm.getExprAsText(), tuple);
                }
                ++i;
            }
        }
        for (GraphObject graphObject : g.getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            attrs = graphObject.getAttribute();
            values = (ValueTuple)attrs;
            i = 0;
            while (i < values.getNumberOfEntries()) {
                vm = values.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), vm.getExprAsText(), tuple);
                }
                ++i;
            }
        }
    }

    private void declareVar(Graph g, VarTuple tuple, ContextView conview) {
        ValueMember vm;
        int i;
        ValueTuple vt;
        AttrInstance attrs;
        for (GraphObject graphObject : g.getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            attrs = graphObject.getAttribute();
            vt = (ValueTuple)attrs;
            i = 0;
            while (i < vt.getNumberOfEntries()) {
                vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), vm.getExprAsText(), tuple);
                }
                ++i;
            }
            vt.resetContextView(conview);
        }
        for (GraphObject graphObject : g.getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            attrs = graphObject.getAttribute();
            vt = (ValueTuple)attrs;
            i = 0;
            while (i < vt.getNumberOfEntries()) {
                vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), vm.getExprAsText(), tuple);
                }
                ++i;
            }
            vt.resetContextView(conview);
        }
    }

    public final OrdinaryMorphism createMatchfromMorph(OrdinaryMorphism base, AttrContext base_context) {
        GraphObject i;
        OrdinaryMorphism match = new OrdinaryMorphism(base.getOriginal(), base.getImage(), base.getAttrManager().newContext(1, base_context));
        this.declareVariable(match.getOriginal(), (VarTuple)match.getAttrContext().getVariables());
        this.declareVariable(match.getImage(), (VarTuple)match.getAttrContext().getVariables());
        for (GraphObject graphObject : match.getOriginal().getNodesSet()) {
            i = base.getImage(graphObject);
            if (i == null) continue;
            try {
                match.addMapping(graphObject, i);
            }
            catch (BadMappingException ex) {
                System.out.println(ex.getMessage());
            }
        }
        for (GraphObject graphObject : match.getOriginal().getArcsSet()) {
            i = base.getImage(graphObject);
            if (i == null) continue;
            try {
                match.addMapping(graphObject, i);
            }
            catch (BadMappingException ex) {
                System.out.println(ex.getMessage());
            }
        }
        return match;
    }

    public final boolean createMatchfromMorph(OrdinaryMorphism baseMorph, OrdinaryMorphism targetMatch, AttrContext base_context) {
        GraphObject i;
        targetMatch.setSource(baseMorph.getOriginal());
        targetMatch.setTarget(baseMorph.getImage());
        targetMatch.setAttrContext(baseMorph.getAttrManager().newContext(1, base_context));
        this.declareVariable(targetMatch.getOriginal(), (VarTuple)targetMatch.getAttrContext().getVariables());
        this.declareVariable(targetMatch.getImage(), (VarTuple)targetMatch.getAttrContext().getVariables());
        for (GraphObject graphObject : targetMatch.getOriginal().getNodesSet()) {
            i = baseMorph.getImage(graphObject);
            if (i == null) continue;
            try {
                targetMatch.addMapping(graphObject, i);
            }
            catch (BadMappingException ex) {
                targetMatch.clear();
                return false;
            }
        }
        for (GraphObject graphObject : targetMatch.getOriginal().getArcsSet()) {
            i = baseMorph.getImage(graphObject);
            if (i == null) continue;
            try {
                targetMatch.addMapping(graphObject, i);
            }
            catch (BadMappingException ex) {
                targetMatch.clear();
                return false;
            }
        }
        return true;
    }

    public final OrdinaryMorphism createMorphfromMorph(OrdinaryMorphism base, AttrContext base_context) {
        GraphObject i;
        OrdinaryMorphism match = new OrdinaryMorphism(base.getOriginal(), base.getImage(), base.getAttrManager().newContext(0, base_context));
        for (GraphObject graphObject : match.getOriginal().getNodesSet()) {
            i = base.getImage(graphObject);
            if (i == null) continue;
            try {
                match.addMapping(graphObject, i);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        for (GraphObject graphObject : match.getOriginal().getArcsSet()) {
            i = base.getImage(graphObject);
            if (i == null) continue;
            try {
                match.addMapping(graphObject, i);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        return match;
    }

    public final void destroyMorphism(OrdinaryMorphism morph) {
        if (morph != null) {
            morph.dispose();
        }
    }

    public final Match createMatch(Rule rule, Graph graph) {
        Match match = new Match(rule, graph);
        if (match.getImage().getVariableNamesOfAttributes().size() != 0) {
            ((ContextView)match.getAttrContext()).setVariableContext(true);
        }
        return match;
    }

    public final Match createMatch(Rule rule, Graph graph, boolean implicit) {
        return this.createMatch(rule, graph, implicit, "");
    }

    public final Match createMatch(Rule rule, Graph graph, boolean implicit, String helpMarkOfVars) {
        Match match = this.createMatch(rule, graph);
        int count = match.getAttrContext().getVariables().getSize();
        VarTuple vars = (VarTuple)match.getAttrContext().getVariables();
        if (implicit) {
            String mark = "_" + helpMarkOfVars;
            for (GraphObject graphObject : graph.getNodesSet()) {
                if (graphObject.getAttribute() == null) continue;
                ValueTuple valueTuple = (ValueTuple)graphObject.getAttribute();
                int i = 0;
                while (i < valueTuple.getNumberOfEntries()) {
                    ValueMember vm = valueTuple.getValueMemberAt(i);
                    if (!vm.isSet()) {
                        String t = String.valueOf(vm.getName()) + String.valueOf(count) + mark;
                        VarMember var = this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), t, vars);
                        var.setTransient(true);
                        ++count;
                        vm.setTransient(true);
                        vm.setExprAsText(var.getName());
                    }
                    ++i;
                }
            }
            for (GraphObject graphObject : graph.getArcsSet()) {
                if (graphObject.getAttribute() == null) continue;
                ValueTuple values = (ValueTuple)graphObject.getAttribute();
                int i = 0;
                while (i < values.getNumberOfEntries()) {
                    ValueMember vm = values.getValueMemberAt(i);
                    if (!vm.isSet()) {
                        String t = String.valueOf(vm.getName()) + String.valueOf(count) + mark;
                        VarMember var = this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), t, vars);
                        var.setTransient(true);
                        ++count;
                        vm.setTransient(true);
                        vm.setExprAsText(var.getName());
                    }
                    ++i;
                }
            }
        }
        return match;
    }

    public Match makeMatch(Rule rule, OrdinaryMorphism morph) {
        return this.makeMatch(rule, morph, "");
    }

    public Match makeMatch(Rule rule, OrdinaryMorphism morph, String helpMarkOfVars) {
        String mark = "";
        if (!helpMarkOfVars.equals("")) {
            mark = "_" + helpMarkOfVars;
        }
        Match m = this.createMatch(rule, morph.getImage(), true);
        boolean variableContext = false;
        if (m.getImage().getVariableNamesOfAttributes().size() != 0 || ((ContextView)morph.getAttrContext()).isVariableContext()) {
            ((ContextView)m.getAttrContext()).setVariableContext(true);
            variableContext = true;
        }
        VarTuple vars = (VarTuple)m.getAttrContext().getVariables();
        int count = vars.getSize();
        Enumeration<GraphObject> elements = morph.getDomain();
        while (elements.hasMoreElements()) {
            GraphObject obj = elements.nextElement();
            GraphObject img = morph.getImage(obj);
            if (img == null) continue;
            if (obj.getAttribute() == null && img.getAttribute() == null) {
                try {
                    m.addMapping(obj, img);
                    continue;
                }
                catch (BadMappingException e) {
                    this.destroyMatch(m);
                    m = null;
                    return null;
                }
            }
            if (variableContext && obj.getAttribute() != null && img.getAttribute() != null) {
                AttrInstance objAttrs = obj.getAttribute();
                ValueTuple objValues = (ValueTuple)objAttrs;
                AttrInstance imgAttrs = img.getAttribute();
                ValueTuple imgValues = (ValueTuple)imgAttrs;
                int i = 0;
                while (i < imgValues.getNumberOfEntries()) {
                    ValueMember imgvm = imgValues.getValueMemberAt(i);
                    ValueMember objvm = objValues.getValueMemberAt(imgvm.getName());
                    if (objvm != null) {
                        String t;
                        if (objvm.isSet()) {
                            if (!imgvm.isSet()) {
                                if (objvm.getExpr().isVariable()) {
                                    t = String.valueOf(imgvm.getName()) + String.valueOf(count) + mark;
                                    this.declareVariable(imgvm.getDeclaration().getHandler(), imgvm.getDeclaration().getTypeName(), t, vars);
                                    ++count;
                                    imgvm.setExprAsText(t);
                                    imgvm.setTransient(true);
                                } else if (objvm.getExpr().isConstant()) {
                                    imgvm.setExprAsObject(objvm.getExpr().getCopy());
                                    imgvm.setTransient(true);
                                }
                            }
                        } else if (!imgvm.isSet()) {
                            t = String.valueOf(imgvm.getName()) + String.valueOf(count) + mark;
                            this.declareVariable(imgvm.getDeclaration().getHandler(), imgvm.getDeclaration().getTypeName(), t, vars);
                            ++count;
                            imgvm.setExprAsText(t);
                            imgvm.setTransient(true);
                        }
                    }
                    ++i;
                }
            }
            try {
                m.addMapping(obj, img);
            }
            catch (BadMappingException e) {
                this.destroyMatch(m);
                m = null;
                return null;
            }
        }
        return m;
    }

    public final void destroyMatch(OrdinaryMorphism match) {
        if (match != null) {
            match.dispose();
        }
    }

    public OrdinaryMorphism shiftApplCondRight(OrdinaryMorphism cond, OrdinaryMorphism morph) {
        if (cond.getSource() == morph.getSource()) {
            GraphObject isoImg;
            GraphObject morphImg;
            GraphObject condImg;
            GraphObject go;
            OrdinaryMorphism condIso = cond.getTarget().isomorphicCopy();
            if (condIso == null) {
                return null;
            }
            OrdinaryMorphism shiftCond = cond instanceof NestedApplCond ? BaseFactory.theFactory().createGeneralMorphism(morph.getTarget(), condIso.getTarget()) : BaseFactory.theFactory().createMorphism(morph.getTarget(), condIso.getTarget());
            Enumeration<GraphObject> condDom = cond.getDomain();
            while (condDom.hasMoreElements()) {
                go = condDom.nextElement();
                if (!go.isNode() || (condImg = cond.getImage(go)) == null) continue;
                morphImg = morph.getImage(go);
                isoImg = condIso.getImage(condImg);
                if (morphImg == null || isoImg == null) continue;
                try {
                    shiftCond.addMapping(morphImg, isoImg);
                }
                catch (BadMappingException badMappingException) {
                    // empty catch block
                }
            }
            condDom = cond.getDomain();
            while (condDom.hasMoreElements()) {
                go = condDom.nextElement();
                if (!go.isArc() || (condImg = cond.getImage(go)) == null) continue;
                morphImg = morph.getImage(go);
                isoImg = condIso.getImage(condImg);
                if (morphImg != null) {
                    if (isoImg == null) continue;
                    try {
                        shiftCond.addMapping(morphImg, isoImg);
                    }
                    catch (BadMappingException badMappingException) {}
                    continue;
                }
                try {
                    shiftCond.getTarget().destroyArc((Arc)isoImg);
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            condDom = cond.getDomain();
            while (condDom.hasMoreElements()) {
                go = condDom.nextElement();
                if (!go.isNode() || (condImg = cond.getImage(go)) == null) continue;
                morphImg = morph.getImage(go);
                isoImg = condIso.getImage(condImg);
                if (morphImg != null || isoImg == null) continue;
                try {
                    shiftCond.getTarget().destroyNode((Node)isoImg);
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            return shiftCond;
        }
        return null;
    }

    public OrdinaryMorphism shiftApplCondLeft(OrdinaryMorphism cond, OrdinaryMorphism morph) {
        if (cond.getSource() == morph.getTarget()) {
            OrdinaryMorphism shiftCond;
            OrdinaryMorphism ordinaryMorphism = shiftCond = cond instanceof NestedApplCond ? BaseFactory.theFactory().createGeneralMorphism(morph.getSource(), cond.getTarget()) : BaseFactory.theFactory().createMorphism(morph.getSource(), cond.getTarget());
            if (shiftCond.completeDiagram3(morph, cond)) {
                return shiftCond;
            }
            shiftCond.dispose();
            Object var3_3 = null;
        }
        return null;
    }

    public Formula replacePACsByGACs(List<OrdinaryMorphism> list) {
        Vector<Evaluable> shiftEvals = new Vector<Evaluable>(list.size());
        int k = 0;
        while (k < list.size()) {
            OrdinaryMorphism c = list.get(k);
            NestedApplCond nc = theBaseFactory.createGeneralMorphism(c.getSource(), c.getTarget());
            nc.getDomainObjects().addAll(c.getDomainObjects());
            nc.getCodomainObjects().addAll(c.getCodomainObjects());
            theBaseFactory.unsetAllTransientAttrValues(nc);
            theBaseFactory.declareVariable(nc.getTarget(), (VarTuple)nc.getAttrContext().getVariables());
            theBaseFactory.adjustAttributeValueAlongMorphismMapping(nc);
            nc.setEnabled(c.isEnabled());
            nc.setName(c.getName());
            if (nc.isEnabled()) {
                shiftEvals.add(nc);
            }
            list.remove(k);
            list.add(k, nc);
            c.dispose();
            ++k;
        }
        Formula f = new Formula(shiftEvals, 5);
        return f;
    }

    public Formula replaceNACsByGACs(List<OrdinaryMorphism> list) {
        Vector<Evaluable> shiftEvals = new Vector<Evaluable>(list.size());
        int k = 0;
        while (k < list.size()) {
            OrdinaryMorphism c = list.get(k);
            NestedApplCond nc = theBaseFactory.createGeneralMorphism(c.getSource(), c.getTarget());
            nc.getDomainObjects().addAll(c.getDomainObjects());
            nc.getCodomainObjects().addAll(c.getCodomainObjects());
            theBaseFactory.unsetAllTransientAttrValues(nc);
            theBaseFactory.declareVariable(nc.getTarget(), (VarTuple)nc.getAttrContext().getVariables());
            theBaseFactory.adjustAttributeValueAlongMorphismMapping(nc);
            nc.setEnabled(c.isEnabled());
            nc.setName(c.getName());
            if (nc.isEnabled()) {
                shiftEvals.add(nc);
            }
            list.remove(k);
            list.add(k, nc);
            c.dispose();
            ++k;
        }
        Formula f = new Formula(3, new Formula(shiftEvals, 5), null);
        return f;
    }

    public void extendAttrContextVariableByPrefix(Rule rule, String prefix, String oppositePrefix) {
        VarTuple varsm = (VarTuple)rule.getAttrContext().getVariables();
        int i = 0;
        while (i < varsm.getSize()) {
            VarMember vm = varsm.getVarMemberAt(i);
            String from = vm.getName();
            if (!from.startsWith(prefix) && !from.startsWith(oppositePrefix)) {
                String to = String.valueOf(prefix) + from;
                vm.getDeclaration().setName(to);
                this.setAttributeVariable(rule.getSource(), from, to, rule.getAttrContext(), varsm);
                this.setAttributeVariable(rule.getTarget(), from, to, rule.getAttrContext(), varsm);
                CondTuple conds = (CondTuple)rule.getAttrContext().getConditions();
                this.renameVariableOfCondition(rule.getAttrContext(), conds, from, to);
                List<OrdinaryMorphism> nacs = rule.getNACsList();
                int j = 0;
                while (j < nacs.size()) {
                    OrdinaryMorphism nac = nacs.get(j);
                    this.setAttributeVariable(nac.getTarget(), from, to, rule.getAttrContext(), varsm);
                    ++j;
                }
                List<OrdinaryMorphism> pacs = rule.getPACsList();
                int j2 = 0;
                while (j2 < pacs.size()) {
                    OrdinaryMorphism pac = pacs.get(j2);
                    this.setAttributeVariable(pac.getTarget(), from, to, rule.getAttrContext(), varsm);
                    ++j2;
                }
            }
            ++i;
        }
    }

    public void trimAttrContextVariableByPrefix(Rule rule, String prefix, String oppositePrefix) {
        VarTuple varsm = (VarTuple)rule.getAttrContext().getVariables();
        int i = 0;
        while (i < varsm.getSize()) {
            VarMember vm = varsm.getVarMemberAt(i);
            String from = vm.getName();
            if (from.startsWith(prefix) || from.startsWith(oppositePrefix)) {
                String to = from.substring(prefix.length());
                vm.getDeclaration().setName(to);
                this.setAttributeVariable(rule.getSource(), from, to, rule.getAttrContext(), varsm);
                this.setAttributeVariable(rule.getTarget(), from, to, rule.getAttrContext(), varsm);
                CondTuple conds = (CondTuple)rule.getAttrContext().getConditions();
                this.renameVariableOfCondition(rule.getAttrContext(), conds, from, to);
                List<OrdinaryMorphism> nacs = rule.getNACsList();
                int j = 0;
                while (j < nacs.size()) {
                    OrdinaryMorphism nac = nacs.get(j);
                    this.setAttributeVariable(nac.getTarget(), from, to, rule.getAttrContext(), varsm);
                    ++j;
                }
                List<OrdinaryMorphism> pacs = rule.getPACsList();
                int j2 = 0;
                while (j2 < pacs.size()) {
                    OrdinaryMorphism pac = pacs.get(j2);
                    this.setAttributeVariable(pac.getTarget(), from, to, rule.getAttrContext(), varsm);
                    ++j2;
                }
            }
            ++i;
        }
    }

    public void renameSimilarVariable(Rule r1, Rule r2, String prefix, Hashtable<String, String> storeNewName2OldName) {
        int index = 1;
        String mark = String.valueOf(index);
        VarTuple varsm1 = (VarTuple)r1.getAttrContext().getVariables();
        VarTuple varsm2 = (VarTuple)r2.getAttrContext().getVariables();
        int i = 0;
        while (i < varsm1.getSize()) {
            VarMember vm1 = varsm1.getVarMemberAt(i);
            VarMember vm2 = varsm2.getVarMemberAt(vm1.getName());
            if (vm2 != null) {
                String from = vm2.getName();
                String to = prefix.concat(vm2.getName());
                while (varsm2.getVarMemberAt(to) != null || varsm1.getVarMemberAt(to) != null) {
                    to = prefix.concat(vm2.getName()).concat(mark);
                    mark = String.valueOf(index++);
                }
                if (storeNewName2OldName != null) {
                    storeNewName2OldName.put(to, from);
                }
                vm2.getDeclaration().setName(to);
                this.setAttributeVariable(r2.getSource(), from, to, r2.getAttrContext(), varsm2);
                this.setAttributeVariable(r2.getTarget(), from, to, r2.getAttrContext(), varsm2);
                List<OrdinaryMorphism> nacs = r2.getNACsList();
                int j = 0;
                while (j < nacs.size()) {
                    OrdinaryMorphism nac = nacs.get(j);
                    this.setAttributeVariable(nac.getTarget(), from, to, r2.getAttrContext(), varsm2);
                    ++j;
                }
                List<OrdinaryMorphism> pacs = r2.getPACsList();
                int j2 = 0;
                while (j2 < pacs.size()) {
                    OrdinaryMorphism pac = pacs.get(j2);
                    this.setAttributeVariable(pac.getTarget(), from, to, r2.getAttrContext(), varsm2);
                    ++j2;
                }
                CondTuple conds = (CondTuple)r2.getAttrContext().getConditions();
                this.renameVariableOfCondition(r2.getAttrContext(), conds, from, to);
            }
            ++i;
        }
    }

    public void restoreVariableNameOfRule(Rule r, Hashtable<String, String> storeNewName2OldName) {
        VarTuple varsm2 = (VarTuple)r.getAttrContext().getVariables();
        int i = 0;
        while (i < varsm2.getSize()) {
            VarMember vm2 = varsm2.getVarMemberAt(i);
            String from = vm2.getName();
            String to = storeNewName2OldName.get(from);
            if (to != null) {
                vm2.getDeclaration().setName(to);
                this.setAttributeVariable(r.getSource(), from, to, r.getAttrContext(), varsm2);
                this.setAttributeVariable(r.getTarget(), from, to, r.getAttrContext(), varsm2);
                List<OrdinaryMorphism> nacs = r.getNACsList();
                int j = 0;
                while (j < nacs.size()) {
                    OrdinaryMorphism nac = nacs.get(j);
                    this.setAttributeVariable(nac.getTarget(), from, to, r.getAttrContext(), varsm2);
                    ++j;
                }
                List<OrdinaryMorphism> pacs = r.getPACsList();
                int j2 = 0;
                while (j2 < pacs.size()) {
                    OrdinaryMorphism pac = pacs.get(j2);
                    this.setAttributeVariable(pac.getTarget(), from, to, r.getAttrContext(), varsm2);
                    ++j2;
                }
                CondTuple conds = (CondTuple)r.getAttrContext().getConditions();
                this.renameVariableOfCondition(r.getAttrContext(), conds, from, to);
            }
            ++i;
        }
    }

    public void renameSimilarVariable(Rule r1, Rule r2) {
        int index = 1;
        String mark = String.valueOf(index);
        VarTuple varsm1 = (VarTuple)r1.getAttrContext().getVariables();
        VarTuple varsm2 = (VarTuple)r2.getAttrContext().getVariables();
        int i = 0;
        while (i < varsm1.getSize()) {
            VarMember vm1 = varsm1.getVarMemberAt(i);
            VarMember vm2 = varsm2.getVarMemberAt(vm1.getName());
            if (vm2 != null) {
                String from = vm2.getName();
                String to = String.valueOf(vm2.getName()) + mark;
                while (varsm2.getVarMemberAt(to) != null) {
                    mark = String.valueOf(index++);
                    to = String.valueOf(vm2.getName()) + mark;
                }
                vm2.getDeclaration().setName(to);
                this.setAttributeVariable(r2.getSource(), from, to, r2.getAttrContext(), varsm2);
                this.setAttributeVariable(r2.getTarget(), from, to, r2.getAttrContext(), varsm2);
                CondTuple conds = (CondTuple)r2.getAttrContext().getConditions();
                this.renameVariableOfCondition(r2.getAttrContext(), conds, from, to);
                List<OrdinaryMorphism> nacs = r2.getNACsList();
                int j = 0;
                while (j < nacs.size()) {
                    OrdinaryMorphism nac = nacs.get(j);
                    this.setAttributeVariable(nac.getTarget(), from, to, r2.getAttrContext(), varsm2);
                    ++j;
                }
                List<OrdinaryMorphism> pacs = r2.getPACsList();
                int j2 = 0;
                while (j2 < pacs.size()) {
                    OrdinaryMorphism pac = pacs.get(j2);
                    this.setAttributeVariable(pac.getTarget(), from, to, r2.getAttrContext(), varsm2);
                    ++j2;
                }
            }
            ++i;
        }
    }

    public void renameSimilarVariable(OrdinaryMorphism m1, OrdinaryMorphism m2) {
        int index = 1;
        String mark = String.valueOf(index);
        VarTuple varsm1 = (VarTuple)m1.getAttrContext().getVariables();
        VarTuple varsm2 = (VarTuple)m2.getAttrContext().getVariables();
        int i = 0;
        while (i < varsm1.getSize()) {
            VarMember vm1 = varsm1.getVarMemberAt(i);
            VarMember vm2 = varsm2.getVarMemberAt(vm1.getName());
            if (vm2 != null && vm1.getDeclaration().getTypeName().equals(vm2.getDeclaration().getTypeName())) {
                String from = vm2.getName();
                String to = vm2.getName().concat(mark);
                while (varsm2.getVarMemberAt(to) != null) {
                    mark = String.valueOf(index++);
                    to = vm2.getName().concat(mark);
                }
                vm2.getDeclaration().setName(to);
                this.setAttributeVariable(m2.getSource(), from, to, m2.getAttrContext(), varsm2);
                this.setAttributeVariable(m2.getTarget(), from, to, m2.getAttrContext(), varsm2);
                CondTuple conds = (CondTuple)m2.getAttrContext().getConditions();
                this.renameVariableOfCondition(m2.getAttrContext(), conds, from, to);
            }
            ++i;
        }
    }

    public void renameVariableOfCondition(AttrContext ac, CondTuple conds, String from, String to) {
        int j = 0;
        while (j < conds.getSize()) {
            CondMember cm = conds.getCondMemberAt(j);
            Vector<String> v1 = cm.getAllVariables();
            if (v1.contains(from)) {
                JexExpr oldExpr = (JexExpr)cm.getExpr();
                this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, ac, null);
            }
            ++j;
        }
    }

    public void renameVariableOfExpression(AttrContext ac, ValueTuple value, String from, String to) {
        int j = 0;
        while (j < value.getSize()) {
            ValueMember vm = value.getValueMemberAt(j);
            Vector<String> v1 = vm.getAllVariableNamesOfExpression();
            if (v1.contains(from)) {
                JexExpr oldExpr = (JexExpr)vm.getExpr();
                this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, ac, null);
            }
            ++j;
        }
    }

    protected void setAttributeVariable(Graph g, String from, String to, AttrContext ac, VarTuple vars) {
        Vector<String> variables;
        JexExpr oldExpr;
        ValueMember fromVM;
        int i;
        ValueTuple fromObj;
        for (GraphObject graphObject : g.getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            fromObj = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < fromObj.getSize()) {
                fromVM = fromObj.getValueMemberAt(i);
                if (fromVM.isSet()) {
                    if (fromVM.getExpr().isVariable()) {
                        if (fromVM.getExprAsText().equals(from) && vars.getVarMemberAt(to) != null) {
                            fromVM.setExprAsText(to);
                            if (!fromVM.isTransient()) {
                                fromVM.setTransient(vars.getVarMemberAt(to).isTransient());
                            }
                        }
                    } else if (fromVM.getExpr().isComplex()) {
                        oldExpr = (JexExpr)fromVM.getExpr();
                        variables = new Vector<String>();
                        oldExpr.getAllVariables(variables);
                        this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, ac, vars);
                        fromVM.setTransient(true);
                    }
                }
                ++i;
            }
        }
        for (GraphObject graphObject : g.getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            fromObj = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < fromObj.getSize()) {
                fromVM = fromObj.getValueMemberAt(i);
                if (fromVM.isSet()) {
                    if (fromVM.getExpr().isVariable()) {
                        if (fromVM.getExprAsText().equals(from) && vars.getVarMemberAt(to) != null) {
                            fromVM.setExprAsText(to);
                        }
                    } else if (fromVM.getExpr().isComplex()) {
                        oldExpr = (JexExpr)fromVM.getExpr();
                        variables = new Vector();
                        oldExpr.getAllVariables(variables);
                        this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, ac, vars);
                    }
                }
                ++i;
            }
        }
    }

    private void findPrimaryAndReplace(SimpleNode node, String from, String to, AttrContext ac, VarTuple vars) {
        AttrContext symbs = ac;
        int j = 0;
        while (j < node.jjtGetNumChildren()) {
            SimpleNode n = (SimpleNode)node.jjtGetChild(j);
            if (n instanceof ASTPrimaryExpression || n instanceof ASTId) {
                if (n.getString().equals(from)) {
                    SimpleNode test;
                    HandlerExpr expression2;
                    HandlerType t;
                    VarMember vm;
                    boolean to_found = false;
                    ContextView context = (ContextView)symbs;
                    VarTuple vt = (VarTuple)context.getVariables();
                    int i = 0;
                    while (i < vt.getSize()) {
                        vm = vt.getVarMemberAt(i);
                        if (vm.getName().equals(to)) {
                            to_found = true;
                            t = vm.getDeclaration().getType();
                            try {
                                expression2 = vm.getHandler().newHandlerExpr(t, to);
                                test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                node.replaceChild(n, test);
                            }
                            catch (AttrHandlerException expression2) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                    if (!to_found) {
                        i = 0;
                        while (i < vars.getSize()) {
                            vm = vars.getVarMemberAt(i);
                            if (vm.getName().equals(to)) {
                                to_found = true;
                                t = vm.getDeclaration().getType();
                                try {
                                    expression2 = vm.getHandler().newHandlerExpr(t, to);
                                    test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                    node.replaceChild(n, test);
                                }
                                catch (AttrHandlerException attrHandlerException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                    }
                } else if (n.getString().contains(from)) {
                    this.findPrimaryAndReplace(n, from, to, ac, vars);
                }
            } else {
                this.findPrimaryAndReplace(n, from, to, ac, vars);
            }
            ++j;
        }
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlappingSet(Graph thisGraph, Graph g, int sizeOfInclusion, boolean union, boolean withIsomorphic) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        Vector<OrdinaryMorphism> subs = new Vector<OrdinaryMorphism>();
        Enumeration<GraphObject> itsGOs = thisGraph.getElements();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        int size = 0;
        int minGraphSize = union ? 0 : 1;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement(itsGOs.nextElement());
            ++size;
        }
        if (sizeOfInclusion == -1) {
            int i = minGraphSize;
            while (i <= size) {
                subs = this.generateAllSubgraphsWithInclusionsOfSize(thisGraph, i, itsGOSet, subs, withIsomorphic, null, false);
                ++i;
            }
        } else if (sizeOfInclusion >= minGraphSize) {
            subs = this.generateAllSubgraphsWithInclusionsOfSize(thisGraph, sizeOfInclusion, itsGOSet, subs, withIsomorphic, null, false);
        } else {
            return oSet.elements();
        }
        this.makeOverlappingPairs(thisGraph, g, subs, oSet);
        subs.clear();
        return oSet.elements();
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlappingSet(Graph thisGraph, Graph g, int sizeOfInclusion, Hashtable<Object, Object> objectMap, boolean union, boolean withIsomorphic) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        Vector<OrdinaryMorphism> subs = new Vector<OrdinaryMorphism>();
        Enumeration<GraphObject> itsGOs = thisGraph.getElements();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        int size = 0;
        int minGraphSize = union ? 0 : 1;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement(itsGOs.nextElement());
            ++size;
        }
        Vector<Object> requiredInsideSubgraphs = null;
        if (objectMap != null && !objectMap.isEmpty()) {
            requiredInsideSubgraphs = new Vector<Object>(objectMap.keySet());
        }
        if (sizeOfInclusion == -1) {
            int i = minGraphSize;
            while (i <= size) {
                subs = this.generateAllSubgraphsWithInclusionsOfSize(thisGraph, i, itsGOSet, subs, withIsomorphic, requiredInsideSubgraphs, true);
                ++i;
            }
        } else if (sizeOfInclusion >= minGraphSize) {
            subs = this.generateAllSubgraphsWithInclusionsOfSize(thisGraph, sizeOfInclusion, itsGOSet, subs, withIsomorphic, requiredInsideSubgraphs, true);
        } else {
            return oSet.elements();
        }
        this.makeOverlappingPairs(thisGraph, g, subs, oSet, objectMap);
        subs.clear();
        return oSet.elements();
    }

    private void makeOverlappingPairs(Graph thisGraph, Graph g, Vector<OrdinaryMorphism> subs, Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet, Hashtable<Object, Object> objectMap) {
        if (objectMap == null || objectMap.isEmpty()) {
            this.makeOverlappingPairs(thisGraph, g, subs, oSet);
            return;
        }
        MorphCompletionStrategy strategy = thisGraph.getTypeSet().hasInheritance() ? new Completion_InheritCSP() : new Completion_InjCSP();
        int i = 0;
        while (i < subs.size()) {
            OrdinaryMorphism h = subs.elementAt(i);
            Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> rulePair = BaseFactory.theFactory().constructIsomorphicRule(h, true, false);
            if (rulePair != null) {
                Match match = BaseFactory.theFactory().createMatch((Rule)rulePair.first, g, true);
                match.setCompletionStrategy(strategy, true);
                while (match.nextCompletion()) {
                    Match m;
                    block12: {
                        OrdinaryMorphism rStar;
                        boolean allOfObjectFlow = true;
                        int count = 0;
                        Enumeration<GraphObject> dom = match.getDomain();
                        while (dom.hasMoreElements()) {
                            GraphObject obj = dom.nextElement();
                            if (((OrdinaryMorphism)((Pair)rulePair.second).first).getInverseImage(obj).hasMoreElements()) {
                                GraphObject objR1;
                                GraphObject obj1 = ((OrdinaryMorphism)((Pair)rulePair.second).first).getInverseImage(obj).nextElement();
                                GraphObject objL2 = h.getImage(obj1);
                                GraphObject obj2 = (GraphObject)objectMap.get(objL2);
                                if (obj2 == null || obj2 != (objR1 = match.getImage(obj))) continue;
                                ++count;
                                continue;
                            }
                            allOfObjectFlow = false;
                            break;
                        }
                        boolean bl = allOfObjectFlow = allOfObjectFlow && count == objectMap.size();
                        if (!allOfObjectFlow || !match.isValid(true) || (rStar = g.isomorphicCopy()) == null) continue;
                        m = BaseFactory.theFactory().createMatch((Rule)rulePair.first, rStar.getImage(), true);
                        if (m.doCompose(match, rStar)) {
                            try {
                                OrdinaryMorphism ms = (OrdinaryMorphism)TestStep.execute(m, true);
                                if (ms != null) {
                                    OrdinaryMorphism mStar = ((OrdinaryMorphism)((Pair)rulePair.second).second).compose(ms);
                                    if (mStar != null) {
                                        Pair<OrdinaryMorphism, OrdinaryMorphism> p = new Pair<OrdinaryMorphism, OrdinaryMorphism>(mStar, rStar);
                                        oSet.addElement(p);
                                    }
                                    ms.dispose();
                                    ms = null;
                                    break block12;
                                }
                                rStar.dispose();
                                rStar = null;
                            }
                            catch (TypeException typeException) {}
                        } else {
                            rStar.dispose();
                            rStar = null;
                        }
                    }
                    m.dispose();
                    m = null;
                }
                match.dispose();
                ((OrdinaryMorphism)((Pair)rulePair.second).first).dispose();
                ((OrdinaryMorphism)((Pair)rulePair.second).second).dispose();
                ((Rule)rulePair.first).disposeSuper();
                h.dispose(true, false);
                rulePair.first = null;
                h = null;
                ((Pair)rulePair.second).first = null;
                ((Pair)rulePair.second).second = null;
                rulePair = null;
            }
            ++i;
        }
    }

    private void makeOverlappingPairs(Graph thisGraph, Graph g, Vector<OrdinaryMorphism> subs, Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet) {
        MorphCompletionStrategy strategy = thisGraph.getTypeSet().hasInheritance() ? new Completion_InheritCSP() : new Completion_InjCSP();
        int i = 0;
        while (i < subs.size()) {
            OrdinaryMorphism h = subs.elementAt(i);
            this.makeOverlappingPair(thisGraph, g, h, strategy, oSet);
            h.dispose(true, false);
            h = null;
            ++i;
        }
    }

    private void makeOverlappingPair(Graph thisGraph, Graph g, OrdinaryMorphism inclusion, MorphCompletionStrategy strategy, Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet) {
        Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> rulePair = BaseFactory.theFactory().constructIsomorphicRule(inclusion, true, false);
        if (rulePair == null) {
            return;
        }
        Match match = BaseFactory.theFactory().createMatch((Rule)rulePair.first, g, true);
        match.setCompletionStrategy(strategy, true);
        if (match.getCompletionStrategy() instanceof Completion_InheritCSP) {
            ((Completion_InheritCSP)match.getCompletionStrategy()).initialize(match);
            match.getTarget().getTypeObjectsMap().clear();
            match.getCompletionStrategy().resetTypeMap(g);
        }
        boolean nextMatch = true;
        while (nextMatch) {
            nextMatch = match.nextCompletion();
            if (!nextMatch || !match.isValid(true)) continue;
            OrdinaryMorphism rStar = g.isomorphicCopy();
            if (rStar == null) break;
            Match m = BaseFactory.theFactory().createMatch((Rule)rulePair.first, rStar.getTarget(), true);
            boolean compose = false;
            compose = match.getCompletionStrategy() instanceof Completion_InheritCSP ? m.doComposeInherit(match, rStar) : m.doCompose(match, rStar);
            if (compose) {
                if (!(match.getCompletionStrategy() instanceof Completion_InheritCSP) || BaseFactory.theFactory().replaceParentByChild((OrdinaryMorphism)rulePair.first, m, rStar)) {
                    try {
                        OrdinaryMorphism ms = (OrdinaryMorphism)TestStep.execute(m, true);
                        if (ms != null) {
                            OrdinaryMorphism mStar = ((OrdinaryMorphism)((Pair)rulePair.second).second).compose(ms);
                            if (mStar != null) {
                                Pair<OrdinaryMorphism, OrdinaryMorphism> p = new Pair<OrdinaryMorphism, OrdinaryMorphism>(mStar, rStar);
                                oSet.addElement(p);
                            } else {
                                rStar.dispose();
                                rStar = null;
                            }
                            ms.dispose();
                            ms = null;
                        }
                    }
                    catch (TypeException typeException) {}
                }
            } else {
                rStar.dispose();
                rStar = null;
            }
            m.dispose();
            m = null;
        }
        match.dispose();
        ((OrdinaryMorphism)((Pair)rulePair.second).first).dispose();
        ((OrdinaryMorphism)((Pair)rulePair.second).second).dispose();
        ((Rule)rulePair.first).disposeSuper();
        ((Pair)rulePair.second).first = null;
        ((Pair)rulePair.second).second = null;
        rulePair.first = null;
        rulePair = null;
    }

    private void makeOverlappingPairByPredefinedIntersection(Graph thisGraph, Graph g, Hashtable<Object, Object> intersection, OrdinaryMorphism inclusion, MorphCompletionStrategy strategy, Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet) {
        OrdinaryMorphism rStar;
        GraphObject lhs_obj;
        GraphObject sub_obj;
        Object g_obj;
        Object thisGraph_obj;
        Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> rulePair = BaseFactory.theFactory().constructIsomorphicRule(inclusion, true, false);
        if (rulePair == null) {
            return;
        }
        Match match = BaseFactory.theFactory().createMatch((Rule)rulePair.first, g, true);
        match.setCompletionStrategy(strategy, true);
        boolean mappingOK = true;
        Enumeration<Object> keys = intersection.keys();
        while (keys.hasMoreElements() && mappingOK) {
            thisGraph_obj = keys.nextElement();
            if (!(thisGraph_obj instanceof Node)) continue;
            g_obj = intersection.get(thisGraph_obj);
            if (inclusion.getInverseImage((GraphObject)thisGraph_obj).hasMoreElements()) {
                sub_obj = inclusion.getInverseImage((GraphObject)thisGraph_obj).nextElement();
                lhs_obj = ((OrdinaryMorphism)((Pair)rulePair.second).first).getImage(sub_obj);
                if (lhs_obj != null && g_obj != null) {
                    try {
                        match.addChild2ParentMapping(lhs_obj, (GraphObject)g_obj);
                    }
                    catch (BadMappingException ex) {
                        mappingOK = false;
                    }
                    continue;
                }
                mappingOK = false;
                continue;
            }
            mappingOK = false;
        }
        keys = intersection.keys();
        while (keys.hasMoreElements() && mappingOK) {
            thisGraph_obj = keys.nextElement();
            if (!(thisGraph_obj instanceof Arc)) continue;
            g_obj = intersection.get(thisGraph_obj);
            if (inclusion.getInverseImage((GraphObject)thisGraph_obj).hasMoreElements()) {
                sub_obj = inclusion.getInverseImage((GraphObject)thisGraph_obj).nextElement();
                lhs_obj = ((OrdinaryMorphism)((Pair)rulePair.second).first).getImage(sub_obj);
                if (lhs_obj != null && g_obj != null) {
                    try {
                        match.addMapping(lhs_obj, (GraphObject)g_obj);
                    }
                    catch (BadMappingException ex) {
                        mappingOK = false;
                    }
                    continue;
                }
                mappingOK = false;
                continue;
            }
            mappingOK = false;
        }
        if (match.isTotal() && match.isValid(true) && (rStar = g.isomorphicCopy()) != null) {
            Match m = BaseFactory.theFactory().createMatch((Rule)rulePair.first, rStar.getTarget(), true);
            boolean compose = false;
            compose = match.getCompletionStrategy() instanceof Completion_InheritCSP ? m.doComposeInherit(match, rStar) : m.doCompose(match, rStar);
            if (compose) {
                if (!(match.getCompletionStrategy() instanceof Completion_InheritCSP) || BaseFactory.theFactory().replaceParentByChild((OrdinaryMorphism)rulePair.first, m, rStar)) {
                    try {
                        OrdinaryMorphism ms = (OrdinaryMorphism)TestStep.execute(m, true);
                        if (ms != null) {
                            OrdinaryMorphism mStar = ((OrdinaryMorphism)((Pair)rulePair.second).second).compose(ms);
                            if (mStar != null) {
                                Pair<OrdinaryMorphism, OrdinaryMorphism> p = new Pair<OrdinaryMorphism, OrdinaryMorphism>(mStar, rStar);
                                oSet.addElement(p);
                            }
                            ms.dispose();
                            ms = null;
                        }
                    }
                    catch (TypeException typeException) {}
                }
            } else {
                rStar.dispose();
                rStar = null;
            }
        }
        match.dispose();
        ((OrdinaryMorphism)((Pair)rulePair.second).first).dispose();
        ((OrdinaryMorphism)((Pair)rulePair.second).second).dispose();
        ((Rule)rulePair.first).disposeSuper();
        ((Pair)rulePair.second).first = null;
        ((Pair)rulePair.second).second = null;
        rulePair.first = null;
        rulePair = null;
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlapSet(Graph thisGraph, Graph g, boolean withIsomorphic) {
        return this.overlappingSet(thisGraph, g, -1, false, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlapSet(Graph thisGraph, Graph g, boolean union, boolean withIsomorphic) {
        return this.overlappingSet(thisGraph, g, -1, union, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph thisGraph, Graph g, boolean withIsomorphic) {
        return this.getOverlappings(thisGraph, g, false, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph thisGraph, Graph g, boolean disjunion, boolean withIsomorphic) {
        return this.overlapSet(thisGraph, g, disjunion, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph thisGraph, Graph g, int sizeOfInclusion, boolean withIsomorphic) {
        return this.overlappingSet(thisGraph, g, sizeOfInclusion, false, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph thisGraph, Graph g, int sizeOfInclusions, boolean disjunion, boolean withIsomorphic) {
        return this.overlappingSet(thisGraph, g, sizeOfInclusions, disjunion, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph thisGraph, Graph g, int sizeOfInclusion, Hashtable<Object, Object> objectMap, boolean disjunion, boolean withIsomorphic) {
        return this.overlappingSet(thisGraph, g, sizeOfInclusion, objectMap, disjunion, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappingByPredefinedIntersection(Graph thisGraph, Graph g, Hashtable<Object, Object> intersection) {
        if (intersection != null && !intersection.isEmpty()) {
            Set<Object> intersectionOfThisGraph = intersection.keySet();
            Vector<GraphObject> goSet = new Vector<GraphObject>();
            for (Object obj : intersectionOfThisGraph) {
                if (obj instanceof Node) {
                    goSet.add(0, (GraphObject)obj);
                    continue;
                }
                goSet.add((GraphObject)obj);
            }
            OrdinaryMorphism inclusion = this.makeInclusion(thisGraph, goSet);
            if (inclusion != null) {
                MorphCompletionStrategy strategy = null;
                strategy = thisGraph.getTypeSet().hasInheritance() ? new Completion_InheritCSP() : new Completion_InjCSP();
                Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>(1);
                this.makeOverlappingPairByPredefinedIntersection(thisGraph, g, intersection, inclusion, strategy, oSet);
                if (!oSet.isEmpty()) {
                    return oSet.elements();
                }
            }
        }
        return null;
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappingByPartialPredefinedIntersection(Graph thisGraph, Graph g, List<Object> requiredInsideSubgraphs, Hashtable<Object, Object> partialIntersection, boolean onlyRequiredObjectsInsideSubgraphs) {
        int mins;
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> oSet = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        Vector<OrdinaryMorphism> subs = new Vector<OrdinaryMorphism>();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        Enumeration<GraphObject> itsGOs = thisGraph.getElements();
        int size = 0;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement(itsGOs.nextElement());
        }
        size = itsGOSet.size() <= g.getSize() ? itsGOSet.size() : g.getSize();
        int i = mins = requiredInsideSubgraphs.size() > 1 ? requiredInsideSubgraphs.size() : 1;
        while (i <= size) {
            subs = this.generateAllSubgraphsWithInclusionsOfSize(thisGraph, i, itsGOSet, subs, false, requiredInsideSubgraphs, onlyRequiredObjectsInsideSubgraphs);
            ++i;
        }
        this.makeOverlappingPairs(thisGraph, g, subs, oSet, partialIntersection);
        subs.clear();
        return oSet.elements();
    }

    public Vector<OrdinaryMorphism> generateAllSubgraphs(Graph thisGraph, int sizeOfInclusions, boolean union, boolean withIsomorphic) {
        Vector<OrdinaryMorphism> subs = new Vector<OrdinaryMorphism>(0);
        Enumeration<GraphObject> itsGOs = thisGraph.getElements();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        int size = 0;
        int minGraphSize = union ? 0 : 1;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement(itsGOs.nextElement());
            ++size;
        }
        if (sizeOfInclusions == -1) {
            int i = minGraphSize;
            while (i <= size) {
                subs = this.generateAllSubgraphsWithInclusionsOfSize(thisGraph, i, itsGOSet, subs, withIsomorphic, null, false);
                ++i;
            }
        } else if (sizeOfInclusions >= minGraphSize) {
            subs = this.generateAllSubgraphsWithInclusionsOfSize(thisGraph, sizeOfInclusions, itsGOSet, subs, withIsomorphic, null, false);
        }
        return subs;
    }

    public Vector<OrdinaryMorphism> generateAllSubgraphsWithInclusionsOfSize(Graph thisGraph, int i, Vector<GraphObject> itsGOSet, Vector<OrdinaryMorphism> inclusions, boolean withIsomorphic, List<Object> requiredObjectsInsideSubgraphs, boolean onlyRequiredObjectsInsideSubgraphs) {
        if (i == 0) {
            return this.putInclusion(thisGraph, new Vector<GraphObject>(), inclusions);
        }
        Vector<Integer> select = new Vector<Integer>();
        if (i <= itsGOSet.size()) {
            int j = 1;
            while (j <= i) {
                select.addElement(j - 1);
                ++j;
            }
            this.computeSelection(thisGraph, 1, itsGOSet, select, inclusions, requiredObjectsInsideSubgraphs, onlyRequiredObjectsInsideSubgraphs);
        }
        if (!withIsomorphic) {
            this.checkIsomorphicInclusions(inclusions);
        }
        return inclusions;
    }

    private Vector<OrdinaryMorphism> computeSelection(Graph thisGraph, int s, Vector<GraphObject> itsGOSet, Vector<Integer> select, Vector<OrdinaryMorphism> inclusions, List<Object> requiredObjectsInsideSubgraph, boolean onlyRequiredObjectsInsideSubgraphs) {
        int max = itsGOSet.size();
        int selSize = select.size();
        if (s <= selSize && s >= 1) {
            try {
                int v = select.elementAt(s - 1);
                while (v < max - selSize + s) {
                    Vector<GraphObject> goSet;
                    inclusions = this.computeSelection(thisGraph, s + 1, itsGOSet, select, inclusions, requiredObjectsInsideSubgraph, onlyRequiredObjectsInsideSubgraphs);
                    if (s == selSize && !(goSet = this.makeGraphObjectSet(select, itsGOSet, requiredObjectsInsideSubgraph, onlyRequiredObjectsInsideSubgraphs)).isEmpty() && thisGraph.isGraph(goSet)) {
                        inclusions = this.putInclusion(thisGraph, goSet, inclusions);
                    }
                    select.setElementAt(v + 1, s - 1);
                    v = select.elementAt(s - 1);
                }
                if (s > 1 && (v = select.elementAt(s - 2).intValue()) < max - selSize + s + 1) {
                    select.setElementAt(v + 1, s - 2);
                    int j = 1;
                    while (j <= selSize - s + 1) {
                        select.setElementAt(v + 1 + j, s + j - 2);
                        ++j;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return inclusions;
    }

    private Vector<GraphObject> makeGraphObjectSet(Vector<Integer> select, Vector<GraphObject> itsGOSet, List<Object> requiredObjectsInsideSubgraph, boolean onlyRequiredObjectsInsideSubgraphs) {
        Vector<GraphObject> tmp = new Vector<GraphObject>();
        if (requiredObjectsInsideSubgraph == null || requiredObjectsInsideSubgraph.isEmpty()) {
            int i = 0;
            while (i < select.size()) {
                int v = select.elementAt(i);
                tmp.addElement(itsGOSet.elementAt(v));
                ++i;
            }
        } else if (onlyRequiredObjectsInsideSubgraphs && select.size() == requiredObjectsInsideSubgraph.size()) {
            int found = 0;
            int i = 0;
            while (i < select.size()) {
                int v = select.elementAt(i);
                GraphObject go = itsGOSet.elementAt(v);
                if (requiredObjectsInsideSubgraph.contains(go)) {
                    ++found;
                    tmp.addElement(go);
                }
                ++i;
            }
            if (found != requiredObjectsInsideSubgraph.size()) {
                tmp.clear();
            }
        } else {
            int found = 0;
            int i = 0;
            while (i < select.size()) {
                int v = select.elementAt(i);
                GraphObject go = itsGOSet.elementAt(v);
                if (requiredObjectsInsideSubgraph.contains(go)) {
                    ++found;
                }
                tmp.addElement(go);
                ++i;
            }
            if (found < requiredObjectsInsideSubgraph.size()) {
                tmp.clear();
            }
        }
        return tmp;
    }

    private Vector<OrdinaryMorphism> putInclusion(Graph thisGraph, Vector<GraphObject> goSet, Vector<OrdinaryMorphism> inclusions) {
        GraphObject go;
        Node source = null;
        Node target = null;
        Graph subGraph = BaseFactory.theFactory().createGraph(thisGraph.getTypeSet());
        OrdinaryMorphism inclusion = BaseFactory.theFactory().createMorphism(subGraph, thisGraph);
        int i = 1;
        while (i <= goSet.size()) {
            go = goSet.elementAt(i - 1);
            if (go.isNode()) {
                Node n = null;
                try {
                    n = subGraph.copyNode((Node)go);
                    n.setContextUsage(((Node)go).getContextUsage());
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
                try {
                    inclusion.addMapping(n, go);
                }
                catch (BadMappingException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        i = 1;
        while (i <= goSet.size()) {
            Enumeration<GraphObject> sources;
            go = goSet.elementAt(i - 1);
            if (go.isArc() && (sources = inclusion.getInverseImage(((Arc)go).getSource())).hasMoreElements()) {
                source = (Node)sources.nextElement();
                Enumeration<GraphObject> targets = inclusion.getInverseImage(((Arc)go).getTarget());
                if (targets.hasMoreElements()) {
                    target = (Node)targets.nextElement();
                    Arc a = null;
                    try {
                        a = subGraph.copyArc((Arc)go, source, target);
                        a.setContextUsage(((Arc)go).getContextUsage());
                    }
                    catch (TypeException e) {
                        System.out.println(e);
                    }
                    try {
                        inclusion.addMapping(a, go);
                    }
                    catch (BadMappingException e) {
                        System.out.println(e);
                    }
                }
            }
            ++i;
        }
        inclusions.addElement(inclusion);
        return inclusions;
    }

    private OrdinaryMorphism makeInclusion(Graph thisGraph, List<GraphObject> goSet) {
        GraphObject go;
        Node source = null;
        Node target = null;
        Graph subGraph = BaseFactory.theFactory().createGraph(thisGraph.getTypeSet());
        OrdinaryMorphism inclusion = BaseFactory.theFactory().createMorphism(subGraph, thisGraph);
        int i = 0;
        while (i < goSet.size()) {
            go = goSet.get(i);
            if (go.isNode()) {
                Node n = null;
                try {
                    n = subGraph.copyNode((Node)go);
                    n.setContextUsage(((Node)go).getContextUsage());
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
                try {
                    inclusion.addMapping(n, go);
                }
                catch (BadMappingException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        i = 0;
        while (i < goSet.size()) {
            Enumeration<GraphObject> sources;
            go = goSet.get(i);
            if (go.isArc() && (sources = inclusion.getInverseImage(((Arc)go).getSource())).hasMoreElements()) {
                source = (Node)sources.nextElement();
                Enumeration<GraphObject> targets = inclusion.getInverseImage(((Arc)go).getTarget());
                if (targets.hasMoreElements()) {
                    target = (Node)targets.nextElement();
                    Arc a = null;
                    try {
                        a = subGraph.copyArc((Arc)go, source, target);
                        a.setContextUsage(((Arc)go).getContextUsage());
                    }
                    catch (TypeException e) {
                        System.out.println(e);
                    }
                    try {
                        inclusion.addMapping(a, go);
                    }
                    catch (BadMappingException e) {
                        System.out.println(e);
                    }
                }
            }
            ++i;
        }
        return inclusion;
    }

    protected void checkIsomorphicInclusions(Vector<OrdinaryMorphism> inclusions) {
        int size = inclusions.size();
        int i = 0;
        while (i < size) {
            OrdinaryMorphism inclusion = inclusions.elementAt(i);
            int j = i + 1;
            while (j < size) {
                OrdinaryMorphism inc = inclusions.elementAt(j);
                if (inclusion.getSource().isIsomorphicTo(inc.getSource())) {
                    inclusions.removeElement(inc);
                    --j;
                    size = inclusions.size();
                    BaseFactory.theFactory().destroyMorphism(inc);
                    inc = null;
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean replaceParentByChild(OrdinaryMorphism ruleMorph, OrdinaryMorphism matchMorph, OrdinaryMorphism isoMorph) {
        Hashtable<Arc, Arc> img2origInArc = new Hashtable<Arc, Arc>();
        Hashtable<Arc, Arc> img2origOutArc = new Hashtable<Arc, Arc>();
        Hashtable<Arc, Arc> orig2img_isoMorph = new Hashtable<Arc, Arc>();
        Iterator<Node> en = matchMorph.getSource().getNodesSet().iterator();
        while (en.hasNext()) {
            Enumeration<GraphObject> orig;
            Arc img;
            img2origInArc.clear();
            img2origOutArc.clear();
            orig2img_isoMorph.clear();
            Node go = en.next();
            Node img1 = (Node)ruleMorph.getImage(go);
            Node img2 = (Node)matchMorph.getImage(go);
            if (img1 == null || img2 == null || !go.getType().isChildOf(img2.getType())) continue;
            Node child = go;
            Node parent = img2;
            Node orig_rStar = (Node)isoMorph.getInverseImage(parent).nextElement();
            for (Arc a : orig_rStar.getOutgoingArcsSet()) {
                img = (Arc)isoMorph.getImage(a);
                orig2img_isoMorph.put(a, img);
            }
            for (Arc a : orig_rStar.getIncomingArcsSet()) {
                img = (Arc)isoMorph.getImage(a);
                orig2img_isoMorph.put(a, img);
            }
            isoMorph.removeMapping(orig_rStar);
            for (Arc a : parent.getOutgoingArcsSet()) {
                orig = matchMorph.getInverseImage(a);
                if (orig.hasMoreElements()) {
                    img2origOutArc.put(a, (Arc)orig.nextElement());
                    continue;
                }
                img2origOutArc.put(a, a);
            }
            for (Arc a : parent.getIncomingArcsSet()) {
                orig = matchMorph.getInverseImage(a);
                if (orig.hasMoreElements()) {
                    img2origInArc.put(a, (Arc)orig.nextElement());
                    continue;
                }
                img2origInArc.put(a, a);
            }
            Type childT = child.getType();
            try {
                Node childNode = matchMorph.getTarget().createNode(childT);
                if (parent.getAttribute() != null) {
                    int i = 0;
                    while (i < parent.getAttribute().getNumberOfEntries()) {
                        ValueMember pvm = (ValueMember)parent.getAttribute().getMemberAt(i);
                        ValueMember vm = (ValueMember)childNode.getAttribute().getMemberAt(pvm.getName());
                        if (pvm.isSet()) {
                            vm.setExprAsText(pvm.getExprAsText());
                            if (!vm.isTransient()) {
                                vm.setTransient(pvm.isTransient());
                            }
                        } else {
                            vm.setExprAsText("vm_" + i);
                            vm.setTransient(true);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < childNode.getAttribute().getNumberOfEntries()) {
                        ValueMember vm = (ValueMember)childNode.getAttribute().getMemberAt(i);
                        if (!vm.isSet()) {
                            vm.setExprAsText("vm_" + i);
                            vm.setTransient(true);
                        }
                        ++i;
                    }
                }
                try {
                    Arc orig2;
                    Arc img3;
                    matchMorph.removeMapping(child);
                    matchMorph.addMapping(child, childNode);
                    Enumeration keys = img2origOutArc.keys();
                    while (keys.hasMoreElements()) {
                        img3 = (Arc)keys.nextElement();
                        orig2 = (Arc)img2origOutArc.get(img3);
                        if (img3.getSource() == img3.getTarget()) continue;
                        img3.setSource(childNode);
                        if (orig2 == img3) continue;
                        try {
                            matchMorph.addMapping(orig2, img3);
                        }
                        catch (BadMappingException e) {
                            return false;
                        }
                    }
                    keys = img2origInArc.keys();
                    while (keys.hasMoreElements()) {
                        img3 = (Arc)keys.nextElement();
                        orig2 = (Arc)img2origInArc.get(img3);
                        if (img3.getSource() == img3.getTarget()) {
                            img3.setSource(childNode);
                        }
                        img3.setTarget(childNode);
                        if (orig2 == img3) continue;
                        try {
                            matchMorph.addMapping(orig2, img3);
                        }
                        catch (BadMappingException e) {
                            return false;
                        }
                    }
                    if (parent.getNumberOfInOutArcs() != 0) {
                        return false;
                    }
                    isoMorph.addMapping(orig_rStar, childNode);
                    keys = orig2img_isoMorph.keys();
                    while (keys.hasMoreElements()) {
                        Arc a = (Arc)keys.nextElement();
                        Arc img4 = (Arc)orig2img_isoMorph.get(a);
                        try {
                            isoMorph.addMapping(a, img4);
                        }
                        catch (BadMappingException e) {
                            return false;
                        }
                    }
                    matchMorph.getTarget().destroyNode(parent, true, false);
                }
                catch (BadMappingException ex1) {
                    return false;
                }
            }
            catch (TypeException ex) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean replaceParentByChild(OrdinaryMorphism morph1, OrdinaryMorphism morph2) {
        Hashtable<Arc, Arc> img2origInArc = new Hashtable<Arc, Arc>();
        Hashtable<Arc, Arc> img2origOutArc = new Hashtable<Arc, Arc>();
        Hashtable<Arc, Arc> orig2img_isoMorph = new Hashtable<Arc, Arc>();
        Iterator<Node> en = morph1.getSource().getNodesSet().iterator();
        while (en.hasNext()) {
            Enumeration<GraphObject> orig;
            Arc img;
            img2origInArc.clear();
            img2origOutArc.clear();
            orig2img_isoMorph.clear();
            Node go = en.next();
            Node img2 = (Node)morph1.getImage(go);
            if (img2 == null || !go.getType().isChildOf(img2.getType())) continue;
            Node child = go;
            Node parent = img2;
            Node orig_rStar = (Node)morph2.getInverseImage(parent).nextElement();
            for (Arc a : orig_rStar.getOutgoingArcsSet()) {
                img = (Arc)morph2.getImage(a);
                orig2img_isoMorph.put(a, img);
            }
            for (Arc a : orig_rStar.getIncomingArcsSet()) {
                img = (Arc)morph2.getImage(a);
                orig2img_isoMorph.put(a, img);
            }
            morph2.removeMapping(orig_rStar);
            for (Arc a : parent.getOutgoingArcsSet()) {
                orig = morph1.getInverseImage(a);
                if (orig.hasMoreElements()) {
                    img2origOutArc.put(a, (Arc)orig.nextElement());
                    continue;
                }
                img2origOutArc.put(a, a);
            }
            for (Arc a : parent.getIncomingArcsSet()) {
                orig = morph1.getInverseImage(a);
                if (orig.hasMoreElements()) {
                    img2origInArc.put(a, (Arc)orig.nextElement());
                    continue;
                }
                img2origInArc.put(a, a);
            }
            Type childT = child.getType();
            try {
                Node childNode = morph1.getTarget().createNode(childT);
                if (parent.getAttribute() != null) {
                    int i = 0;
                    while (i < parent.getAttribute().getNumberOfEntries()) {
                        ValueMember pvm = (ValueMember)parent.getAttribute().getMemberAt(i);
                        ValueMember vm = (ValueMember)childNode.getAttribute().getMemberAt(pvm.getName());
                        if (!vm.isSet() && pvm.isSet()) {
                            vm.setExprAsText(pvm.getExprAsText());
                            if (!vm.isTransient()) {
                                vm.setTransient(pvm.isTransient());
                            }
                        } else {
                            vm.setExprAsText("vm_" + i);
                            vm.setTransient(true);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < childNode.getAttribute().getNumberOfEntries()) {
                        ValueMember vm = (ValueMember)childNode.getAttribute().getMemberAt(i);
                        if (!vm.isSet()) {
                            vm.setExprAsText("vm_" + i);
                            vm.setTransient(true);
                        }
                        ++i;
                    }
                }
                try {
                    Arc orig2;
                    Arc img3;
                    morph1.removeMapping(child);
                    morph1.addMapping(child, childNode);
                    Enumeration keys = img2origOutArc.keys();
                    while (keys.hasMoreElements()) {
                        img3 = (Arc)keys.nextElement();
                        orig2 = (Arc)img2origOutArc.get(img3);
                        if (img3.getSource() == img3.getTarget()) continue;
                        img3.setSource(childNode);
                        if (orig2 == img3) continue;
                        try {
                            morph1.addMapping(orig2, img3);
                        }
                        catch (BadMappingException e) {
                            return false;
                        }
                    }
                    keys = img2origInArc.keys();
                    while (keys.hasMoreElements()) {
                        img3 = (Arc)keys.nextElement();
                        orig2 = (Arc)img2origInArc.get(img3);
                        if (img3.getSource() == img3.getTarget()) {
                            img3.setSource(childNode);
                        }
                        img3.setTarget(childNode);
                        if (orig2 == img3) continue;
                        try {
                            morph1.addMapping(orig2, img3);
                        }
                        catch (BadMappingException e) {
                            return false;
                        }
                    }
                    if (parent.getNumberOfInOutArcs() != 0) {
                        return false;
                    }
                    morph2.addMapping(orig_rStar, childNode);
                    keys = orig2img_isoMorph.keys();
                    while (keys.hasMoreElements()) {
                        Arc a = (Arc)keys.nextElement();
                        Arc img4 = (Arc)orig2img_isoMorph.get(a);
                        try {
                            morph2.addMapping(a, img4);
                        }
                        catch (BadMappingException e) {
                            return false;
                        }
                    }
                    morph1.getTarget().destroyNode(parent, true, false);
                }
                catch (BadMappingException ex1) {
                    System.out.println("replaceParentByChild:BadMappingException:Node " + ex1.getStackTrace());
                    return false;
                }
            }
            catch (TypeException ex) {
                System.out.println("replaceParentByChild:TypeException " + ex.getStackTrace());
                return false;
            }
        }
        return true;
    }
}

