/*
 * Decompiled with CFR 0.152.
 */
package agg.util.colim;

import agg.util.colim.Container;
import agg.util.colim.ForwardIterator;
import agg.util.colim.IntBuffer;
import agg.util.colim.IntIterator;
import java.util.Enumeration;

public class IntArray
implements Container {
    static final int DEFAULT_SIZE = 10;
    static final int THRESHOLD = 2000;
    static final int MULTIPLIER = 2;
    static final int HASH_SIZE = 16;
    int[] array;

    public IntArray() {
        this(new int[0]);
    }

    public IntArray(IntArray array) {
        this(array.array);
    }

    public IntArray(IntBuffer buffer) {
        this(buffer.get());
    }

    public IntArray(int[] array) {
        this.array = array;
    }

    @Override
    public synchronized Object clone() {
        return new IntArray(this);
    }

    @Override
    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer("int[]");
        buffer.append("(");
        boolean first = true;
        IntIterator iter = this.begin();
        while (iter.hasMoreElements()) {
            if (first) {
                buffer.append(" ");
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(iter.nextElement());
        }
        if (first) {
            buffer.append(")");
        } else {
            buffer.append(" )");
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IntArray && this.equals((IntArray)object) || object instanceof IntBuffer && this.equals((IntBuffer)object);
    }

    public boolean equals(IntArray object) {
        return this.equals(object.array);
    }

    public boolean equals(IntBuffer buffer) {
        return this.equals(buffer.storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean equals(int[] array) {
        int[] nArray = array;
        synchronized (array) {
            if (this.array.length != array.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= array.length) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                if (this.array[i] != array[i]) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                ++i;
            }
        }
    }

    public int[] get() {
        return this.array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public int maxSize() {
        return this.array.length;
    }

    @Override
    public Enumeration elements() {
        return new IntIterator(this, 0);
    }

    @Override
    public synchronized IntIterator begin() {
        return new IntIterator(this, 0);
    }

    @Override
    public synchronized IntIterator end() {
        return new IntIterator(this, this.array.length);
    }

    public Object at(int index) {
        return new Integer(this.intAt(index));
    }

    public synchronized int intAt(int index) {
        return this.array[index];
    }

    public int indexOf(Object object) {
        return this.indexOf(0, this.size() - 1, object);
    }

    public synchronized int indexOf(int first, int last, Object object) {
        int i = first;
        while (i <= last) {
            if (this.at(i).equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized int count(int first, int last, Object object) {
        int count = 0;
        int i = first;
        while (i <= last) {
            if (this.at(i).equals(object)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int replace(Object oldValue, Object newValue) {
        return this.replace(0, this.size() - 1, oldValue, newValue);
    }

    public synchronized int replace(int first, int last, Object oldValue, Object newValue) {
        int count = 0;
        int i = first;
        while (i <= last) {
            if (this.at(i).equals(oldValue)) {
                this.put(i, newValue);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public void put(int index, Object object) {
        this.put(index, ((Number)object).intValue());
    }

    public synchronized void put(int index, int object) {
        this.array[index] = object;
    }

    public synchronized int hashCode() {
        return IntArray.orderedHash(this.begin(), this.size());
    }

    static final int orderedHash(ForwardIterator iter, int length) {
        int h = 0;
        int position = 0;
        int skip = 1;
        if (length >= 16) {
            skip = length / 16;
            iter.advance(length % 16);
        }
        while (iter.hasMoreElements()) {
            if (iter.get() != null) {
                h ^= iter.get().hashCode() / (position % 16 + 1);
            }
            ++position;
            iter.advance(skip);
        }
        return h;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int count(Object object) {
        return this.count(0, this.size() - 1, object);
    }

    protected static final void checkIndex(int i, int size) {
        if (i < 0 || i >= size) {
            throw new IndexOutOfBoundsException("Attempt to access index " + i + "; valid range is 0.." + (size - 1));
        }
    }

    protected static final void checkRange(int lo, int hi, int size) {
        IntArray.checkIndex(lo, size);
        IntArray.checkIndex(hi, size);
    }

    static final int getNextSize(int cursize) {
        int newSize = cursize > 2000 ? cursize + 2000 : cursize * 2;
        return Math.max(1, newSize);
    }

    @Override
    public void clear() {
        throw new RuntimeException("cannot execute clear() on a native array");
    }

    @Override
    public Object add(Object object) {
        throw new RuntimeException("cannot execute add() on a native array");
    }
}

